package com.ejianc.foundation.share.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.share.bean.ProsubItemEntity;
import com.ejianc.foundation.share.service.IProsubCategoryService;
import com.ejianc.foundation.share.service.IProsubItemService;
import com.ejianc.foundation.share.vo.ProsubCategoryVO;
import com.ejianc.foundation.share.vo.ProsubItemVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping("/api/shareProsubApi/")
public class ProsubApi {

    @Autowired
    private IProsubCategoryService prosubCategoryService;

    @Autowired
    private IProsubItemService prosubItemService;

    /**
     * @Author xuannl
     * @Date 2022/04/18 根据id查询
     * @Param [id]
     * @Return
     */
    @GetMapping(value = "queryProsubItemByIds")
    CommonResponse<List<ProsubItemVO>> queryProsubItemById(@RequestParam(value = "ids") List<Long> ids){
        QueryWrapper<ProsubItemEntity> wrapper = new QueryWrapper<>();
        wrapper.in("id",ids);
        List<ProsubItemEntity> entitys = prosubItemService.list(wrapper);
        if(null != entitys && entitys.size() > 0){
            return CommonResponse.success(BeanMapper.mapList(entitys, ProsubItemVO.class));
        }
        return CommonResponse.error("查询失败,未查到相关数据。");
    }

    @GetMapping("queryCategoryListByIds")
    public CommonResponse<List<ProsubCategoryVO>> queryCategoryListByIds(@RequestParam(value = "ids", required = false) List<Long> ids) {
        List<ProsubCategoryVO> list = prosubCategoryService.queryCategoryListByIds(ids);
        return CommonResponse.success("查询成功！", list);
    }

    /**
     * 根据编码集合查询档案列表
     * @Author zhangwx
     * @param codeList
     * @return
     */
    @GetMapping("queryItemListByCodes")
    public CommonResponse<List<ProsubItemVO>> queryItemListByCodes(@RequestParam(value = "codeList") List<String> codeList) {
        QueryWrapper<ProsubItemEntity> wrapper = new QueryWrapper<>();
        wrapper.in("trawling_code", codeList);
        List<ProsubItemEntity> entitys = prosubItemService.list(wrapper);
        if(null != entitys && entitys.size() > 0){
            return CommonResponse.success(BeanMapper.mapList(entitys, ProsubItemVO.class));
        }
        return CommonResponse.error("查询失败,未查到相关数据。");
    }
}
