package com.ejianc.foundation.share.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.share.bean.CustomerCategoryEntity;
import com.ejianc.foundation.share.bean.CustomerEntity;
import com.ejianc.foundation.share.service.ICustomerCategoryService;
import com.ejianc.foundation.share.service.ICustomerService;
import com.ejianc.foundation.share.vo.CustomerCategoryVO;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.foundation.share.vo.ShareCustomerVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("/api/shareCustomerApi/")
public class CustomerApi {

    @Autowired
    private ICustomerService customerService;
    @Autowired
    private ICustomerCategoryService customerCategoryService;

    @GetMapping("findOneByName")
    public CommonResponse<CustomerVO> findOneByName(@RequestParam(value = "name") String name,
                                                    @RequestParam(value = "tenantId") Long tenantId) {
        CustomerVO vo = null;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("name", new Parameter(QueryParam.EQ, name));
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));

        List<CustomerEntity> list = customerService.queryList(queryParam, false);
        if(CollectionUtils.isNotEmpty(list)) {
            vo = BeanMapper.map(list.get(0), CustomerVO.class);
        }

        return CommonResponse.success("查询成功！", vo);
    }

    /**
     * 根据客户Id查询客户信息
     *
     * @param id
     * @return
     */
    @GetMapping("queryById")
    CommonResponse<CustomerVO> detailById(@RequestParam(value = "id") Long id) {
        CustomerVO vo = customerService.queryDetail(id);
        return CommonResponse.success("查询成功！", vo);
    }

    @GetMapping("queryListByIds")
    CommonResponse<List<ShareCustomerVO>> detailsByIds(@RequestParam List<Long> ids) {
        QueryWrapper<CustomerEntity> query = new QueryWrapper<>();
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.in("id", ids);

        List<CustomerEntity> list = customerService.list(query);
        List<ShareCustomerVO> voList =BeanMapper.mapList(list, ShareCustomerVO.class);
        return CommonResponse.success("查询成功！", voList);
    }

    /**
     * 查询客户档案分类
     * @param tenantId
     * @return
     */
    @GetMapping("queryCategoryList")
    CommonResponse<List<CustomerCategoryVO>> queryCategoryList(@RequestParam(value = "tenantId") Long tenantId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));

        List<CustomerCategoryEntity> list = customerCategoryService.queryList(queryParam);
        List<CustomerCategoryVO> voList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(list)) {
            voList = BeanMapper.mapList(list,CustomerCategoryVO.class);
        }
        return CommonResponse.success("查询成功！", voList);
    }

}
