/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.share.bean.ProjectSetPoolEntity;
import com.ejianc.foundation.share.controller.param.YnsbjMaterialAndEquipCategoryParam;
import com.ejianc.foundation.share.controller.param.YnsbjMaterialAndEquipParam;
import com.ejianc.foundation.share.controller.param.YnsbjProjectParam;
import com.ejianc.foundation.share.controller.resp.YnsbjDataInfo;
import com.ejianc.foundation.share.controller.resp.YnsbjDataInfos;
import com.ejianc.foundation.share.controller.resp.YnsbjResponse;
import com.ejianc.foundation.share.service.IMaterialService;
import com.ejianc.foundation.share.service.IProjectSetService;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ynsbj/mdm/"})
public class YnsbjMdmController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMaterialService materialService;
    @Autowired
    private IProjectSetService projectSetService;

    @RequestMapping(value={"/project/deptId/sync"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> projectDeptIdSync(@RequestBody(required=true) String paramStr) {
        if (StringUtils.isBlank((CharSequence)paramStr)) {
            return CommonResponse.error((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.logger.info("\u66f4\u65b0\u9879\u76ee\u6c60\u65bd\u5de5\u9879\u76ee\u90e8\u4fe1\u606f\uff0c{}", (Object)paramStr);
        JSONObject jsonObject = JSON.parseObject((String)paramStr);
        JSONObject pOrg = jsonObject.getJSONObject("pOrg");
        JSONObject org = jsonObject.getJSONObject("org");
        QueryParam param = new QueryParam();
        if (StringUtils.isEmpty((CharSequence)org.getString("projectCode"))) {
            this.logger.info("projectCode\uff0c\u4e3a\u7a7a\uff0c{}", (Object)paramStr);
            return CommonResponse.error((String)"projectCode\u4e3a\u7a7a");
        }
        param.getParams().put("code", new Parameter("eq", (Object)org.getString("projectCode")));
        List list = this.projectSetService.queryList(param);
        if (ListUtil.isNotEmpty((List)list)) {
            ProjectSetPoolEntity entity = (ProjectSetPoolEntity)((Object)list.get(0));
            entity.setProjectDepartmentId(org.getLong("id"));
            entity.setProjectDepartmentName(org.getString("name"));
            entity.setOrgId(pOrg.getLong("id"));
            entity.setOrgName(pOrg.getString("name"));
            this.projectSetService.saveOrUpdateNoES((Object)entity);
        }
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/project/receive/prod"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> receiveProjectsProd(@RequestBody(required=true) String paramStr) {
        return this.receiveProjects(paramStr);
    }

    @RequestMapping(value={"/project/receive"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> receiveProjects(@RequestBody(required=true) String paramStr) {
        YnsbjResponse response = new YnsbjResponse();
        response.setCode("0");
        if (StringUtils.isBlank((CharSequence)paramStr)) {
            response.setCode("1");
            response.setDesc("\u9879\u76ee\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return YnsbjResponse.packageResp(response);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.logger.info(dateFormat.format(new Date()) + "\uff1a\u9879\u76ee\u63a5\u6536\u6570\u636e\u683c\u5f0f\u4e3a" + paramStr);
        try {
            JSONObject jsonObject = JSON.parseObject((String)paramStr);
            JSONObject dataJson = jsonObject.getJSONObject("DATA");
            String uuid = dataJson.getString("UUID");
            JSONArray dataInfoList = dataJson.getJSONArray("DATAINFOS");
            if (dataInfoList != null && dataInfoList.size() > 0) {
                YnsbjDataInfos ynsbjDataInfos = new YnsbjDataInfos();
                ynsbjDataInfos.setUuid(uuid);
                for (int i = 0; i < dataInfoList.size(); ++i) {
                    YnsbjProjectParam projectParam = YnsbjProjectParam.packageYnsbjProjectParam(dataInfoList.getJSONObject(i));
                    YnsbjDataInfo dataInfo = this.projectSetService.saveOrUpdateYnsbjProject(projectParam);
                    ynsbjDataInfos.addYnsbjDataInfo(dataInfo);
                }
                response.setData(ynsbjDataInfos);
            }
        }
        catch (Exception e) {
            response.setCode("1");
            response.setDesc("\u9879\u76ee\u53c2\u6570\u6570\u636e\u683c\u5f0f\u9519\u8bef");
            this.logger.error("\u9879\u76ee\u53c2\u6570\u6570\u636e\u683c\u5f0f\u9519\u8bef----->", (Throwable)e);
        }
        Map<String, Object> resultMap = YnsbjResponse.packageResp(response);
        this.logger.info(dateFormat.format(new Date()) + "\uff1a\u9879\u76ee\u54cd\u5e94\u6570\u636e\u683c\u5f0f\u4e3a" + resultMap);
        return resultMap;
    }

    @RequestMapping(value={"/materialAndEquipment/category/receive/prod"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> receiveMaterialAndEquipmentCategoryProd(@RequestBody(required=false) String paramStr) {
        return this.receiveMaterialAndEquipmentCategory(paramStr);
    }

    @RequestMapping(value={"/materialAndEquipment/category/receive"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> receiveMaterialAndEquipmentCategory(@RequestBody(required=false) String paramStr) {
        YnsbjResponse response = new YnsbjResponse();
        response.setCode("0");
        if (StringUtils.isBlank((CharSequence)paramStr)) {
            response.setCode("1");
            response.setDesc("\u5206\u7c7b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return YnsbjResponse.packageResp(response);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.logger.info(dateFormat.format(new Date()) + "\uff1a\u7269\u6599\u3001\u8bbe\u5907\u5206\u7c7b\u63a5\u6536\u6570\u636e\u683c\u5f0f\u4e3a" + paramStr);
        try {
            JSONObject jsonObject = JSON.parseObject((String)paramStr);
            JSONObject dataJson = jsonObject.getJSONObject("DATA");
            String uuid = dataJson.getString("UUID");
            JSONArray dataInfoList = dataJson.getJSONArray("DATAINFOS");
            if (dataInfoList != null && dataInfoList.size() > 0) {
                YnsbjDataInfos ynsbjDataInfos = new YnsbjDataInfos();
                ynsbjDataInfos.setUuid(uuid);
                for (int i = 0; i < dataInfoList.size(); ++i) {
                    YnsbjMaterialAndEquipCategoryParam categoryParam = YnsbjMaterialAndEquipCategoryParam.packageYnsbjMaterialAndEquipCategoryParam(dataInfoList.getJSONObject(i));
                    YnsbjDataInfo dataInfo = this.materialService.saveOrUpdateYnsbjMaterialAndEquipCategory(categoryParam);
                    ynsbjDataInfos.addYnsbjDataInfo(dataInfo);
                }
                response.setData(ynsbjDataInfos);
            }
        }
        catch (Exception e) {
            response.setCode("1");
            response.setDesc("\u5206\u7c7b\u53c2\u6570\u6570\u636e\u683c\u5f0f\u9519\u8bef");
            this.logger.error("\u5206\u7c7b\u53c2\u6570\u6570\u636e\u683c\u5f0f\u9519\u8bef----->", (Throwable)e);
        }
        Map<String, Object> resultMap = YnsbjResponse.packageResp(response);
        this.logger.info(dateFormat.format(new Date()) + "\uff1a\u7269\u6599\u3001\u8bbe\u5907\u5206\u7c7b\u54cd\u5e94\u6570\u636e\u683c\u5f0f\u4e3a" + resultMap);
        return resultMap;
    }

    @RequestMapping(value={"/materialAndEquipment/receive/prod"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> receiveMaterialAndEquipmentProd(@RequestBody(required=false) String paramStr) {
        return this.receiveMaterialAndEquipment(paramStr);
    }

    @RequestMapping(value={"/materialAndEquipment/receive"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> receiveMaterialAndEquipment(@RequestBody(required=false) String paramStr) {
        YnsbjResponse response = new YnsbjResponse();
        response.setCode("0");
        if (StringUtils.isBlank((CharSequence)paramStr)) {
            response.setCode("1");
            response.setDesc("\u7269\u6599\u3001\u8bbe\u5907\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return YnsbjResponse.packageResp(response);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.logger.info(dateFormat.format(new Date()) + "\uff1a\u7269\u6599\u3001\u8bbe\u5907\u63a5\u6536\u6570\u636e\u683c\u5f0f\u4e3a" + paramStr);
        try {
            JSONObject jsonObject = JSON.parseObject((String)paramStr);
            JSONObject dataJson = jsonObject.getJSONObject("DATA");
            String uuid = dataJson.getString("UUID");
            JSONArray dataInfoList = dataJson.getJSONArray("DATAINFOS");
            if (dataInfoList != null && dataInfoList.size() > 0) {
                YnsbjDataInfos ynsbjDataInfos = new YnsbjDataInfos();
                ynsbjDataInfos.setUuid(uuid);
                for (int i = 0; i < dataInfoList.size(); ++i) {
                    YnsbjMaterialAndEquipParam ynsbjMaterialAndEquipParam = YnsbjMaterialAndEquipParam.packageYnsbjMaterialAndEquipParam(dataInfoList.getJSONObject(i));
                    YnsbjDataInfo dataInfo = this.materialService.saveOrUpdateYnsbjMaterialAndEquip(ynsbjMaterialAndEquipParam);
                    ynsbjDataInfos.addYnsbjDataInfo(dataInfo);
                }
                response.setData(ynsbjDataInfos);
            }
        }
        catch (Exception e) {
            response.setCode("1");
            response.setDesc("\u7269\u6599\u3001\u8bbe\u5907\u53c2\u6570\u6570\u636e\u683c\u5f0f\u9519\u8bef");
            this.logger.error("\u7269\u6599\u3001\u8bbe\u5907\u53c2\u6570\u6570\u636e\u683c\u5f0f\u9519\u8bef----->", (Throwable)e);
        }
        Map<String, Object> resultMap = YnsbjResponse.packageResp(response);
        this.logger.info(dateFormat.format(new Date()) + "\uff1a\u7269\u6599\u3001\u8bbe\u5907\u54cd\u5e94\u6570\u636e\u683c\u5f0f\u4e3a" + resultMap);
        return resultMap;
    }

    @RequestMapping(value={"/projectJT/receive/prod"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> receiveJTProjectsProd(@RequestBody String paramStr) {
        YnsbjResponse response = new YnsbjResponse();
        response.setCode("0");
        if (StringUtils.isBlank((CharSequence)paramStr)) {
            response.setCode("1");
            response.setDesc("\u9879\u76ee\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return YnsbjResponse.packageResp(response);
        }
        this.logger.info("\u96c6\u56e2 \u9879\u76ee \u63a5\u6536\u6570\u636e \u4e3a" + paramStr);
        try {
            JSONObject jsonObject = JSON.parseObject((String)paramStr);
            JSONObject dataJson = jsonObject.getJSONObject("DATA");
            String uuid = dataJson.getString("UUID");
            JSONArray dataInfoList = dataJson.getJSONArray("DATAINFOS");
            if (dataInfoList != null && dataInfoList.size() > 0) {
                YnsbjDataInfos ynsbjDataInfos = new YnsbjDataInfos();
                ynsbjDataInfos.setUuid(uuid);
                for (int i = 0; i < dataInfoList.size(); ++i) {
                    YnsbjProjectParam projectParam = YnsbjProjectParam.packageYnsbjProjectParam(dataInfoList.getJSONObject(i));
                    YnsbjDataInfo dataInfo = this.projectSetService.saveOrUpdateYnsbjJTProject(projectParam);
                    ynsbjDataInfos.addYnsbjDataInfo(dataInfo);
                }
                response.setData(ynsbjDataInfos);
            }
        }
        catch (Exception e) {
            response.setCode("1");
            response.setDesc("\u9879\u76ee\u53c2\u6570\u6570\u636e\u683c\u5f0f\u9519\u8bef");
            this.logger.error("\u9879\u76ee\u53c2\u6570\u6570\u636e\u683c\u5f0f\u9519\u8bef----->", (Throwable)e);
        }
        Map<String, Object> resultMap = YnsbjResponse.packageResp(response);
        this.logger.info("\u96c6\u56e2 \u9879\u76ee \u54cd\u5e94\u6570\u636e \u4e3a" + JSONObject.toJSONString(resultMap));
        return resultMap;
    }
}

