package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.foundation.share.bean.CommonMsgSendEntity;
import com.ejianc.foundation.share.service.ICommonMsgSendService;
import com.ejianc.foundation.share.vo.CommonMsgSendVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.util.DateUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 定时消息发送主实体
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("commonMsgSend")
public class CommonMsgSendController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IRoleApi roleApi;

    private static final String BILL_CODE = "COMMON_MSG_SEND_RULE";

    @Autowired
    private ICommonMsgSendService service;

    @Value("${common.env.base-host}")
    private String BaseHost;

    @Value("${weChat.cgdd-agentid:#{NULL}}")
    private String cgddAgentid;

    @Value("${weChat.cgdd-secret:#{NULL}}")
    private String cgddSecret;

    @Autowired
    private IPushMessageApi pushMessageApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    public CommonResponse<CommonMsgSendVO> saveOrUpdate(@RequestBody CommonMsgSendVO saveOrUpdateVO) {
    	CommonMsgSendEntity entity = BeanMapper.map(saveOrUpdateVO, CommonMsgSendEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	CommonMsgSendVO vo = BeanMapper.map(entity, CommonMsgSendVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    public CommonResponse<CommonMsgSendVO> queryDetail(Long id) {
    	CommonMsgSendEntity entity = service.selectById(id);
    	CommonMsgSendVO vo = BeanMapper.map(entity, CommonMsgSendVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    public CommonResponse<String> delete(@RequestBody List<CommonMsgSendVO> vos) {
        service.removeByIds(vos.stream().map(CommonMsgSendVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    @PostMapping(value = "/autoSendMsg")
    public CommonResponse<String> autoSendMsg() {
        logger.info("定时发送消息任务启动----------START---------------");

        //1、获取待发送消息列表
        QueryWrapper<CommonMsgSendEntity> query = new QueryWrapper<>();
        query.eq("enable_status", 1);
        query.eq("dr", 0);

        List<CommonMsgSendEntity> sendMsgList = service.list(query);
        if(CollectionUtils.isNotEmpty(sendMsgList)) {
            logger.info("定时发送消息任务结束----------END---------------任务执行成功，待发送消息列表为空！");
            return CommonResponse.success("任务执行成功，待发送消息列表为空！");
        }

        List<Long> roleIds = new ArrayList<>();
        List<CommonMsgSendEntity> waitSendMsgList = getCanSendList(sendMsgList, roleIds);
        if(CollectionUtils.isNotEmpty(waitSendMsgList)) {
            logger.info("定时发送消息任务结束----------END---------------任务执行成功，待发送消息列表为空！");
            return CommonResponse.success("任务执行成功，待发送消息列表为空！");
        }

        if(CollectionUtils.isEmpty(roleIds)) {
            logger.info("定时发送消息任务结束----------END---------------任务执行成功，接收消息角色列表为空！");
            return CommonResponse.success("任务执行成功，接收消息角色列表为空！");
        }

        //2、消息发送前参数准备

        //查询角色对应用户列表
        CommonResponse<List<RoleUserRelationVO>> rolesReps = roleApi.getRoleUser(roleIds, null);
        if(!rolesReps.isSuccess()) {
            logger.info("定时发送消息任务结束----------END---------------任务执行成功，接收消息角色列表为空！");
            return CommonResponse.success("任务执行失败，获取消息接收角色列表失败, {}", JSONObject.toJSONString(rolesReps));
        }

        //根据角色Id进行分组
        Map<Long, Set<Long>> roleUserMap = rolesReps.getData().stream().collect(Collectors.groupingBy(RoleUserRelationVO::getRoleId, Collectors.mapping(RoleUserRelationVO::getUserId, Collectors.toSet())));

        PushMsgParameter tmp = null;
        Set<Long> userIds = new HashSet<>();
        for(CommonMsgSendEntity item : waitSendMsgList) {
            userIds.clear();
            tmp = new PushMsgParameter();
            tmp.setChannel(item.getSendChannel().split(","));
            tmp.setSaveFlag(true);
            tmp.setSendUserId(303581417601122400L); //系统管理员
            tmp.setMsgType("notice");
            tmp.setTenantId(item.getTenantId().toString());
            tmp.setSubject(item.getContent());
            tmp.setContent(item.getContent());
            tmp.setPcUrl(item.getPcUrl());
            tmp.setMobileUrl(item.getMobileUrl());

            if(item.getSendChannel().contains(PushMsgParameter.CHANNEL_TYPE_WEXINEE)) {
                if(StringUtils.isNotBlank(cgddAgentid) && StringUtils.isNotBlank(cgddSecret)) {
                    JSONObject weixineeParams = new JSONObject();
                    weixineeParams.put("agentid", cgddAgentid);
                    weixineeParams.put("secret", cgddSecret);
                    weixineeParams.put("msgtype", "textcard");
                    weixineeParams.put("title", "消息提醒");
                    weixineeParams.put("description", tmp.getMobileContent());
                    weixineeParams.put("url", tmp.getMobileUrl()+"&userid={userid}");
                    weixineeParams.put("btntxt", "点击查看");
                    tmp.setWeixineeParams(weixineeParams);
                } else {
                    logger.info("cgddAgentid-{} 或者 cgddSecret-{}为空，跳过发送企业微信消息！", cgddAgentid, cgddSecret);
                }
            }

            for(String roleId : item.getRecRoleIds().split(",")) {
                userIds.addAll(roleUserMap.get(Long.valueOf(roleId)));
            }

            tmp.setReceivers(userIds.toArray(new String[userIds.size()]));

            CommonResponse<String> msgSendResp = pushMessageApi.pushMessage(tmp);
            if(msgSendResp.isSuccess()) {
                logger.info("定时消息-{}发送成功！", item.getId());
            } else {
                logger.error("定时消息-{}发送失败, {}", item.getId(), JSONObject.toJSONString(msgSendResp));
            }
        }
        logger.info("定时发送消息任务结束----------END---------------");

        return CommonResponse.success("定时发送消息任务成功！");
    }

    private List<CommonMsgSendEntity> getCanSendList(List<CommonMsgSendEntity> msgSendInfoList, List<Long> roleIds) {

        String curDay = DateUtil.getCurrentDay("yyyy-MM-dd");
        String[] dateArr = curDay.split("-");

        List<String> tmp = new ArrayList<>();

        return msgSendInfoList.stream().filter(msgSendInfo -> {
            tmp.clear();
            tmp.addAll(Arrays.asList(msgSendInfo.getSendMonthOfYear().split(",")));
            switch (msgSendInfo.getSendperiodtype()) {
                case "byMonth":
                    //判断月份
                    if(!"all".equals(msgSendInfo.getSendMonthOfYear()) && !tmp.contains(dateArr[1])) {
                        return false;
                    }
                    //判断月发送日
                    tmp.clear();
                    tmp.addAll(Arrays.asList(msgSendInfo.getSendDayOfMonth().split(",")));
                    if(!"all".equals(msgSendInfo.getSendDayOfMonth()) && !tmp.contains(dateArr[2])) {
                        return false;
                    }
                    roleIds.addAll(Arrays.stream(msgSendInfo.getRecRoleIds().split(",")).map(item -> Long.valueOf(item)).collect(Collectors.toList()));
                    return true;
                default:
                    return false;
            }
        }).collect(Collectors.toList());
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    public CommonResponse<IPage<CommonMsgSendVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("title");
        fuzzyFields.add("recRoleNames");
        fuzzyFields.add("content");
        fuzzyFields.add("billCode");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<CommonMsgSendEntity> page = service.queryPage(param,false);
        IPage<CommonMsgSendVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), CommonMsgSendVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refCommonMsgSendData", method = RequestMethod.GET)
    public CommonResponse<IPage<CommonMsgSendVO>> refCommonMsgSendData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<CommonMsgSendEntity> page = service.queryPage(param,false);
        IPage<CommonMsgSendVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CommonMsgSendVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
