package com.ejianc.foundation.supplier.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.share.bean.SubleadersEntity;
import com.ejianc.foundation.share.service.ISubleadersService;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.share.vo.SubleadersVO;
import com.ejianc.foundation.share.vo.dto.SubleadersDTO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;


@RestController
@RequestMapping("/api/shareSubleadersApi/")
public class SubleadersApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISubleadersService subleadersService;

    @Autowired
    private ISupplierService supplierService;

    /**
     * 供应商 评级更新供应商库
     * @param subleaderId 分包负责人id
     * @param gradeId 评定等级id
     * @param gradeName 评定等级名称
     */
    @GetMapping(value = "upGradeSubleader")
    public CommonResponse<String> upGradeSubleader(@RequestParam("subleaderId") Long subleaderId,
                                                  @RequestParam("gradeId") Long gradeId,
                                                  @RequestParam("gradeName") String gradeName) {
        logger.info("评级更新分包负责人库");
        logger.info(subleaderId.toString());
        logger.info(gradeId.toString());
        logger.info(gradeName);
        SubleadersEntity subleadersEntity = subleadersService.selectById(subleaderId);
        if(subleadersEntity == null){
            return CommonResponse.error("分包负责人不存在！");
        }
        subleadersEntity.setGrade(gradeId);
        subleadersEntity.setGradeName(gradeName);

        subleadersService.saveOrUpdate(subleadersEntity,false);
        return CommonResponse.success("分包负责人评级设置成功！");
    }

    /**
     * 根据修改时间查询分包负责人信息
     *
     * @return
     */
    @GetMapping("selectByUpDateSubLeaders")
    public CommonResponse<List<SubleadersDTO>> selectByUpDateSubLeaders(@RequestParam(value = "upDate") String upDate) {
        List<SubleadersDTO> vos = supplierService.selectByUpDateSubLeaders(upDate);
        return CommonResponse.success(vos);
    }

    @PostMapping(value = "getSubleaderList")
    public CommonResponse<List<SubleadersVO>> getSubleaderList(@RequestBody Map<String,List<Long>> idsMap){
        logger.info("接收到请求参数:"+ JSONObject.toJSONString(idsMap));
        List<Long> ids = idsMap.get("ids");
        QueryWrapper<SubleadersEntity> wrapper = new QueryWrapper<>();
        wrapper.in("id",ids);
        List<SubleadersEntity> list = subleadersService.list(wrapper);
        List<SubleadersVO> subleadersVOS = BeanMapper.mapList(list, SubleadersVO.class);
        logger.info("查询结果:"+JSONObject.toJSONString(subleadersVOS));
        return CommonResponse.success("查询成功！！！！",subleadersVOS);
    }
}
