/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.share.bean.CertsEntity;
import com.ejianc.foundation.share.bean.EjcCloudSystemEntity;
import com.ejianc.foundation.share.bean.SubleadersEntity;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.service.IEjcCloudSystemService;
import com.ejianc.foundation.share.service.ISubleadersService;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.share.vo.PunishVO;
import com.ejianc.foundation.share.vo.SubleadersPushVO;
import com.ejianc.foundation.share.vo.SubleadersVO;
import com.ejianc.foundation.share.vo.SupplierProVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.supplier.vo.SX2JSyncSupplierVO;
import com.ejianc.foundation.support.bean.BankAccountEntity;
import com.ejianc.foundation.support.bean.BankEntity;
import com.ejianc.foundation.support.service.IBankAccountService;
import com.ejianc.foundation.support.service.IBankService;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/shareSupplierApi/"})
public class SupplierApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISupplierService supplierService;
    @Autowired
    private IEjcCloudSystemService ejcCloudSystemService;
    @Autowired
    private ISubleadersService subleadersService;
    @Autowired
    private IBankAccountService bankAccountService;
    @Autowired
    private IBankService bankService;
    @Value(value="${SX2J.supplier.accessHosts\uff1a#{NULL}}")
    private String accessHosts;

    @GetMapping(value={"queryById"})
    public CommonResponse<SupplierDTO> queryById(@RequestParam(value="id") Long id) {
        SupplierVO vo = this.supplierService.queryDetail(id);
        SupplierDTO dto = (SupplierDTO)BeanMapper.map((Object)vo, SupplierDTO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01\uff01\uff01\uff01", (Object)dto);
    }

    @GetMapping(value={"selectById"})
    public CommonResponse<SupplierDTO> selectById(@RequestParam(value="id") Long id) {
        this.logger.info("id:" + id);
        SupplierEntity supplierEntity = (SupplierEntity)((Object)this.supplierService.selectById(id));
        if (supplierEntity == null) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25");
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"supplier_id", (Object)id);
        List list = this.bankAccountService.list((Wrapper)wrapper);
        List supplyBankEntities = BeanMapper.mapList((Iterable)list, BankAccountVO.class);
        SupplierVO supplierVo = (SupplierVO)BeanMapper.map((Object)((Object)supplierEntity), SupplierVO.class);
        supplierVo.setBanks(supplyBankEntities);
        SupplierDTO dto = (SupplierDTO)BeanMapper.map((Object)supplierVo, SupplierDTO.class);
        this.logger.info("dto:" + JSONObject.toJSONString((Object)dto));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01\uff01\uff01\uff01", (Object)dto);
    }

    @GetMapping(value={"selectByUpDate"})
    public CommonResponse<List<SupplierDTO>> selectByUpDate(@RequestParam(value="upDate") String upDate) {
        List<SupplierDTO> vos = this.supplierService.selectByUpDate(upDate);
        return CommonResponse.success(vos);
    }

    @GetMapping(value={"querySupplierByIds"})
    public CommonResponse<List<SupplierVO>> querySupplierByIds(@RequestParam(value="ids") List<Long> ids) {
        this.logger.info("\u63a5\u53d7\u5230\u7684\u53c2\u6570,ids:" + ids);
        List vos = new ArrayList();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.in((Object)"id", ids);
        List entitys = this.supplierService.list((Wrapper)queryWrapper);
        this.logger.info("\u6761\u6570:" + entitys.size());
        if (entitys != null) {
            vos = BeanMapper.mapList((Iterable)entitys, SupplierVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", vos);
    }

    @PostMapping(value={"queryPostSupplierByIds"})
    @ResponseBody
    public CommonResponse<List<SupplierDTO>> queryPostSupplierByIds(@RequestBody Map<String, List<Long>> map) {
        List<Long> ids = map.get("ids");
        this.logger.info("\u63a5\u53d7\u5230\u7684\u53c2\u6570,ids:" + ids);
        ArrayList vos = new ArrayList();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.in((Object)"id", ids);
        List entitys = this.supplierService.list((Wrapper)queryWrapper);
        this.logger.info("\u6761\u6570:" + entitys.size());
        List dtos = BeanMapper.mapList((Iterable)entitys, SupplierDTO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01\uff01\uff01\uff01", (Object)dtos);
    }

    @PostMapping(value={"querySupplierByNames"})
    @ResponseBody
    public CommonResponse<List<SupplierDTO>> querySupplierByNames(@RequestBody List<String> names) {
        this.logger.info("\u6839\u636e\u4f9b\u5e94\u5546 \u540d\u79f0 \u67e5\u8be2\u4f9b\u5e94\u5546\u4fe1\u606f \u63a5\u53d7\u5230\u7684\u53c2\u6570,names:" + names);
        ArrayList vos = new ArrayList();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.in((Object)"name", names);
        List entitys = this.supplierService.list((Wrapper)queryWrapper);
        this.logger.info("\u6839\u636e\u4f9b\u5e94\u5546 \u540d\u79f0 \u67e5\u8be2\u4f9b\u5e94\u5546\u4fe1\u606f \u6761\u6570:" + entitys.size());
        List dtos = BeanMapper.mapList((Iterable)entitys, SupplierDTO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01\uff01\uff01\uff01", (Object)dtos);
    }

    @PostMapping(value={"selectByUnitCodeOrTaxPayerIdentifier"})
    @ResponseBody
    public CommonResponse<List<SupplierDTO>> selectByUnitCodeOrTaxPayerIdentifier(@RequestBody List<String> unitCodeOrTaxPayerIdentifier) {
        this.logger.info("\u6839\u636eI8\u5355\u4f4d\u7f16\u7801\u3001\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff0c\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\uff0c\u63a5\u53d7\u5230\u7684\u53c2\u6570,I8\u5355\u4f4d\u7f16\u7801\u3001\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7:" + unitCodeOrTaxPayerIdentifier);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.in((Object)"unit_i8_code", unitCodeOrTaxPayerIdentifier);
        queryWrapper.or();
        queryWrapper.in((Object)"tax_payer_identifier", unitCodeOrTaxPayerIdentifier);
        List entitys = this.supplierService.list((Wrapper)queryWrapper);
        this.logger.info("\u6839\u636eI8\u5355\u4f4d\u7f16\u7801\u3001\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff0c\u67e5\u8be2\u4f9b\u5e94\u5546\u4fe1\u606f \u6761\u6570:" + entitys.size());
        List dtos = BeanMapper.mapList((Iterable)entitys, SupplierDTO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01\uff01\uff01\uff01", (Object)dtos);
    }

    public static void main(String[] args) {
        CommonResponse commonResponse = new CommonResponse();
        ArrayList<SupplierEntity> entitys = new ArrayList<SupplierEntity>();
        ArrayList dtos = new ArrayList();
        SupplierEntity entity = new SupplierEntity();
        entity.setId(11L);
        entitys.add(entity);
        String data = JSONObject.toJSONString(entitys);
        commonResponse.setData((Object)data);
        Object info = commonResponse.getData();
        System.out.println(info);
    }

    @GetMapping(value={"findOneByName"})
    public CommonResponse<SupplierVO> findOneByName(@RequestParam(value="name") String name, @RequestParam(value="tenantId") Long tenantId) {
        SupplierVO vo = null;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("name", new Parameter("eq", (Object)name));
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
        List list = this.supplierService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            vo = (SupplierVO)BeanMapper.map(list.get(0), SupplierVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", vo);
    }

    @PostMapping(value={"pushSupplierToShare"})
    public CommonResponse<String> pushSupplierToShare(@RequestBody byte[] supplyByte) {
        block28: {
            List banks;
            SupplierVO supplierVO;
            block27: {
                String supplyStr = new String(supplyByte, StandardCharsets.UTF_8);
                this.logger.info("\u63a8\u9001\uff0c\u751f\u6210\u4f01\u4e1a\u4f9b\u5e94\u5546pushSupplierToShare---{}", (Object)supplyStr);
                supplierVO = (SupplierVO)JSONObject.parseObject((String)supplyStr, SupplierVO.class);
                supplierVO.setSupplierFlag(Integer.valueOf(1));
                QueryParam param = new QueryParam();
                String[] supplyType = supplierVO.getSupplyType().split(",");
                ComplexParam c = new ComplexParam();
                c.setLogic("and");
                for (int i = 0; i < supplyType.length; ++i) {
                    String type = supplyType[i];
                    ComplexParam t = new ComplexParam();
                    t.setLogic("or");
                    t.getParams().put("supplyType", new Parameter("like", (Object)type));
                    c.getComplexParams().add(t);
                }
                param.getComplexParams().add(c);
                param.getParams().put("taxPayerIdentifier", new Parameter("eq", (Object)supplierVO.getTaxPayerIdentifier()));
                if (ListUtil.isNotEmpty((List)this.supplierService.queryList(param))) {
                    if (supplierVO.getPersonal().equals("p")) {
                        return CommonResponse.error((String)("\u4f9b\u5e94\u5546\u5e93\u5df2\u5b58\u5728\u8eab\u4efd\u8bc1\u53f7\u4e3a\u3010" + supplierVO.getTaxPayerIdentifier() + "\u3011\u7684\u4f9b\u5e94\u5546\uff01"));
                    }
                    return CommonResponse.error((String)("\u4f9b\u5e94\u5546\u5e93\u5df2\u5b58\u5728\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e3a\u3010" + supplierVO.getTaxPayerIdentifier() + "\u3011\u7684\u4f9b\u5e94\u5546\uff01"));
                }
                QueryParam paramName = new QueryParam();
                paramName.getComplexParams().add(c);
                paramName.getParams().put("name", new Parameter("eq", (Object)supplierVO.getName()));
                if (ListUtil.isNotEmpty((List)this.supplierService.queryList(paramName))) {
                    return CommonResponse.error((String)("\u4f9b\u5e94\u5546\u5e93\u5df2\u5b58\u5728\u540d\u79f0\u4e3a\u3010" + supplierVO.getName() + "\u3011\u7684\u4f9b\u5e94\u5546\uff01"));
                }
                supplierVO.setSocialCreditCode(supplierVO.getTaxPayerIdentifier());
                supplierVO.setEnabled(Integer.valueOf(1));
                supplierVO.setInsideOrg(Boolean.valueOf(false));
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("taxPayerIdentifier", new Parameter("eq", (Object)supplierVO.getTaxPayerIdentifier()));
                List supplierEntityList = this.supplierService.queryList(queryParam);
                if (!ListUtil.isNotEmpty((List)supplierEntityList)) break block27;
                this.logger.info("\u5b58\u5728\u7ed3\u679c\u96c6{}", (Object)supplierEntityList);
                SupplierEntity supplierEntity = (SupplierEntity)((Object)supplierEntityList.get(0));
                SupplierEntity se = (SupplierEntity)((Object)BeanMapper.map((Object)supplierVO, SupplierEntity.class));
                supplierEntity.setGroupInOrOut(se.getGroupInOrOut());
                supplierEntity.setGradeId(se.getGradeId());
                supplierEntity.setGradeName(se.getGradeName());
                supplierEntity.setRegisteredCapital(se.getRegisteredCapital());
                supplierEntity.setTurnover(se.getTurnover());
                supplierEntity.setBusinessPerson(se.getBusinessPerson());
                supplierEntity.setBusinessPhone(se.getBusinessPhone());
                supplierEntity.setInException(se.getInException());
                supplierEntity.setPunishApplyOrg(se.getPunishApplyOrg());
                supplierEntity.setPunishDate(se.getPunishDate());
                supplierEntity.setPunishGrade(se.getGradeName());
                supplierEntity.setPunishMemo(se.getPunishMemo());
                supplierEntity.setPunishType(se.getPunishType());
                supplierEntity.setExceptionEndDate(se.getExceptionEndDate());
                if (StringUtils.isNotEmpty((CharSequence)supplierEntity.getSupplyType())) {
                    if (!supplierEntity.getSupplyType().contains(supplierVO.getSupplyType())) {
                        supplierEntity.setSupplyType(supplierEntity.getSupplyType() + "," + supplierVO.getSupplyType());
                        supplierEntity.setSupplyTypeName(supplierEntity.getSupplyTypeName() + "," + supplierVO.getSupplyTypeName());
                    }
                } else {
                    supplierEntity.setSupplyType(supplierVO.getSupplyType());
                    supplierEntity.setSupplyTypeName(supplierVO.getSupplyTypeName());
                }
                this.logger.info("\u7ed3\u679c\u6570\u636e{}", (Object)supplierVO.getSupplyType());
                if (supplierVO.getSupplyType().contains("material")) {
                    supplierEntity.setMaterialContent(supplierVO.getMaterialContent());
                    supplierEntity.setMaterialContentId(supplierVO.getMaterialContentId());
                    supplierEntity.setMaterialMemo(supplierVO.getMaterialMemo());
                }
                if (supplierVO.getSupplyType().contains("equipment")) {
                    supplierEntity.setEquipmentContent(supplierVO.getEquipmentContent());
                    supplierEntity.setEquipmentContentId(supplierVO.getEquipmentContentId());
                    supplierEntity.setEquipmentMemo(supplierVO.getEquipmentMemo());
                }
                if (supplierVO.getSupplyType().contains("revolvMaterial")) {
                    supplierEntity.setRevolvMaterialContent(supplierVO.getRevolvMaterialContent());
                    supplierEntity.setRevolvMaterialContentId(supplierVO.getRevolvMaterialContentId());
                    supplierEntity.setRevolvMaterialMemo(supplierVO.getRevolvMaterialMemo());
                }
                if (supplierVO.getSupplyType().contains("consult")) {
                    supplierEntity.setConsultContent(supplierVO.getConsultContent());
                    supplierEntity.setConsultContentId(supplierVO.getConsultContentId());
                    supplierEntity.setConsultMemo(supplierVO.getConsultMemo());
                }
                if (supplierVO.getSupplyType().contains("other")) {
                    supplierEntity.setOtherContent(supplierVO.getOtherContent());
                    supplierEntity.setOtherContentId(supplierVO.getOtherContentId());
                    supplierEntity.setOtherMemo(supplierVO.getOtherMemo());
                }
                if (supplierVO.getSupplyType().contains("labor")) {
                    supplierEntity.setLaborContent(supplierVO.getLaborContent());
                    supplierEntity.setLaborContentId(supplierVO.getLaborContentId());
                }
                if (supplierVO.getSupplyType().contains("major")) {
                    supplierEntity.setMajorContent(supplierVO.getMajorContent());
                    supplierEntity.setMajorContentId(supplierVO.getMajorContentId());
                    supplierEntity.setMajorMemo(supplierVO.getMajorMemo());
                }
                if (ListUtil.isNotEmpty((List)supplierVO.getBanks())) {
                    for (BankAccountVO bankAccountVO : supplierVO.getBanks()) {
                        QueryParam bankParam = new QueryParam();
                        bankParam.getParams().put("bankName", new Parameter("eq", (Object)bankAccountVO.getBankName()));
                        bankParam.getParams().put("bankCode", new Parameter("eq", (Object)bankAccountVO.getBankCode()));
                        bankParam.getParams().put("bankAccount", new Parameter("eq", (Object)bankAccountVO.getBankAccount()));
                        List accountEntities = this.bankAccountService.queryList(bankParam, false);
                        if (!ListUtil.isEmpty((List)accountEntities)) continue;
                        this.addBanks(supplierEntity, bankAccountVO);
                    }
                }
                if (ListUtil.isNotEmpty(se.getCerts())) {
                    for (CertsEntity cert : se.getCerts()) {
                        cert.setPid(supplierEntity.getId());
                        supplierEntity.getCerts().add(cert);
                    }
                }
                this.supplierService.saveOrUpdate((Object)supplierEntity, false);
                if (!"laborSub".equals(se.getSupplyQueryType()) || !ListUtil.isNotEmpty(se.getSubLeaders())) break block28;
                for (SubleadersEntity subLeader : se.getSubLeaders()) {
                    subLeader.setPid(supplierEntity.getId());
                    this.subleadersService.saveOrUpdate((Object)subLeader);
                }
                break block28;
            }
            SupplierEntity se = (SupplierEntity)((Object)BeanMapper.map((Object)supplierVO, SupplierEntity.class));
            Boolean coordination = se.getCoordination();
            if (coordination == null) {
                se.setCoordination(false);
            }
            this.supplierService.saveOrUpdate((Object)se, false);
            se = this.supplierService.generateSupplierTenant(se);
            this.supplierService.saveOrUpdate((Object)se, false);
            if ("laborSub".equals(se.getSupplyQueryType()) && ListUtil.isNotEmpty(se.getSubLeaders())) {
                for (SubleadersEntity subLeader : se.getSubLeaders()) {
                    this.supplierService.generateSubSupplierTenant(subLeader, se);
                    this.subleadersService.saveOrUpdate((Object)subLeader);
                }
            }
            if (ListUtil.isNotEmpty((List)(banks = supplierVO.getBanks()))) {
                QueryParam params = new QueryParam();
                List collect = banks.stream().map(BaseVO::getId).collect(Collectors.toList());
                params.getParams().put("id", new Parameter("in", collect));
                List bankAccountEntityList = this.bankAccountService.queryList(params);
                ArrayList<BankAccountVO> rm = new ArrayList<BankAccountVO>();
                if (CollectionUtils.isNotEmpty((Collection)bankAccountEntityList)) {
                    for (BankAccountVO bankAccountVO : banks) {
                        for (BankAccountEntity bankAccountEntity : bankAccountEntityList) {
                            if (!bankAccountVO.getId().equals(bankAccountEntity.getId())) continue;
                            rm.add(bankAccountVO);
                        }
                    }
                }
                banks.removeAll(rm);
                for (BankAccountVO bankAccountVO : banks) {
                    this.addBanks(se, bankAccountVO);
                }
            }
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @PostMapping(value={"pushSupplierToShareZzyj"})
    public CommonResponse<String> pushSupplierToShareZzyj(@RequestBody byte[] supplyByte) {
        block30: {
            List banks;
            SupplierVO supplierVO;
            block29: {
                Boolean coordination;
                String supplyStr = new String(supplyByte, StandardCharsets.UTF_8);
                this.logger.info("\u63a8\u9001\uff0c\u751f\u6210\u4f01\u4e1a\u4f9b\u5e94\u5546pushSupplierToShare---{}", (Object)supplyStr);
                supplierVO = (SupplierVO)JSONObject.parseObject((String)supplyStr, SupplierVO.class);
                supplierVO.setSupplierFlag(Integer.valueOf(1));
                QueryParam param = new QueryParam();
                param.getParams().put("taxPayerIdentifier", new Parameter("eq", (Object)supplierVO.getTaxPayerIdentifier()));
                String[] supplyType = supplierVO.getSupplyType().split(",");
                ComplexParam c = new ComplexParam();
                c.setLogic("and");
                for (int i = 0; i < supplyType.length; ++i) {
                    String type = supplyType[i];
                    ComplexParam t = new ComplexParam();
                    t.setLogic("or");
                    t.getParams().put("supplyType", new Parameter("like", (Object)type));
                    c.getComplexParams().add(t);
                }
                param.getComplexParams().add(c);
                if (ListUtil.isNotEmpty((List)this.supplierService.queryList(param))) {
                    if (supplierVO.getPersonal().equals("p")) {
                        return CommonResponse.error((String)("\u4f9b\u5e94\u5546\u5e93\u5df2\u5b58\u5728\u8eab\u4efd\u8bc1\u53f7\u4e3a\u3010" + supplierVO.getTaxPayerIdentifier() + "\u3011\u7684\u4f9b\u5e94\u5546\uff01"));
                    }
                    return CommonResponse.error((String)("\u4f9b\u5e94\u5546\u5e93\u5df2\u5b58\u5728\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e3a\u3010" + supplierVO.getTaxPayerIdentifier() + "\u3011\u7684\u4f9b\u5e94\u5546\uff01"));
                }
                QueryParam paramName = new QueryParam();
                paramName.getComplexParams().add(c);
                paramName.getParams().put("name", new Parameter("eq", (Object)supplierVO.getName()));
                if (ListUtil.isNotEmpty((List)this.supplierService.queryList(paramName))) {
                    return CommonResponse.error((String)("\u4f9b\u5e94\u5546\u5e93\u5df2\u5b58\u5728\u540d\u79f0\u4e3a\u3010" + supplierVO.getName() + "\u3011\u7684\u4f9b\u5e94\u5546\uff01"));
                }
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("taxPayerIdentifier", new Parameter("eq", (Object)supplierVO.getTaxPayerIdentifier()));
                List supplierEntityList = this.supplierService.queryList(queryParam);
                if (!ListUtil.isNotEmpty((List)supplierEntityList)) break block29;
                SupplierEntity supplierEntity = (SupplierEntity)((Object)supplierEntityList.get(0));
                SupplierEntity se = (SupplierEntity)((Object)BeanMapper.map((Object)supplierVO, SupplierEntity.class));
                supplierEntity.setGroupInOrOut(se.getGroupInOrOut());
                supplierEntity.setGradeId(se.getGradeId());
                supplierEntity.setGradeName(se.getGradeName());
                supplierEntity.setRegisteredCapital(se.getRegisteredCapital());
                supplierEntity.setTurnover(se.getTurnover());
                supplierEntity.setBusinessPerson(se.getBusinessPerson());
                supplierEntity.setBusinessPhone(se.getBusinessPhone());
                if (StringUtils.isNotEmpty((CharSequence)supplierEntity.getSupplyType())) {
                    if (!supplierEntity.getSupplyType().contains(supplierVO.getSupplyType())) {
                        supplierEntity.setSupplyType(supplierEntity.getSupplyType() + "," + supplierVO.getSupplyType());
                        supplierEntity.setSupplyTypeName(supplierEntity.getSupplyTypeName() + "," + supplierVO.getSupplyTypeName());
                    }
                } else {
                    supplierEntity.setSupplyType(supplierVO.getSupplyType());
                    supplierEntity.setSupplyTypeName(supplierVO.getSupplyTypeName());
                }
                if ("material".equals(supplierVO.getSupplyType())) {
                    supplierEntity.setMaterialContent(supplierVO.getMaterialContent());
                    supplierEntity.setMaterialContentId(supplierVO.getMaterialContentId());
                    supplierEntity.setMaterialMemo(supplierVO.getMaterialMemo());
                }
                if ("equipment".equals(supplierVO.getSupplyType())) {
                    supplierEntity.setEquipmentContent(supplierVO.getEquipmentContent());
                    supplierEntity.setEquipmentContentId(supplierVO.getEquipmentContentId());
                    supplierEntity.setEquipmentMemo(supplierVO.getEquipmentMemo());
                }
                if ("revolvMaterial".equals(supplierVO.getSupplyType())) {
                    supplierEntity.setRevolvMaterialContent(supplierVO.getRevolvMaterialContent());
                    supplierEntity.setRevolvMaterialContentId(supplierVO.getRevolvMaterialContentId());
                    supplierEntity.setRevolvMaterialMemo(supplierVO.getRevolvMaterialMemo());
                }
                if ("consult".equals(supplierVO.getSupplyType())) {
                    supplierEntity.setConsultContent(supplierVO.getConsultContent());
                    supplierEntity.setConsultContentId(supplierVO.getConsultContentId());
                    supplierEntity.setConsultMemo(supplierVO.getConsultMemo());
                }
                if ("other".equals(supplierVO.getSupplyType())) {
                    supplierEntity.setOtherContent(supplierVO.getOtherContent());
                    supplierEntity.setOtherContentId(supplierVO.getOtherContentId());
                    supplierEntity.setOtherMemo(supplierVO.getOtherMemo());
                }
                if ("labor".equals(supplierVO.getSupplyType())) {
                    supplierEntity.setLaborContent(supplierVO.getLaborContent());
                    supplierEntity.setLaborContentId(supplierVO.getLaborContentId());
                    supplierEntity.setLaborMemo(supplierVO.getLaborMemo());
                }
                if ("major".equals(supplierVO.getSupplyType())) {
                    supplierEntity.setMajorContent(supplierVO.getMajorContent());
                    supplierEntity.setMajorContentId(supplierVO.getMajorContentId());
                    supplierEntity.setMajorMemo(supplierVO.getMajorMemo());
                }
                if ((coordination = se.getCoordination()) == null) {
                    se.setCoordination(false);
                    coordination = false;
                }
                if (coordination.booleanValue()) {
                    supplierEntity = this.supplierService.generateSupplierTenant(supplierEntity);
                }
                if (ListUtil.isNotEmpty((List)supplierVO.getBanks())) {
                    for (BankAccountVO bankAccountVO : supplierVO.getBanks()) {
                        QueryParam bankParam = new QueryParam();
                        bankParam.getParams().put("bankName", new Parameter("eq", (Object)bankAccountVO.getBankName()));
                        bankParam.getParams().put("bankCode", new Parameter("eq", (Object)bankAccountVO.getBankCode()));
                        bankParam.getParams().put("bankAccount", new Parameter("eq", (Object)bankAccountVO.getBankAccount()));
                        List accountEntities = this.bankAccountService.queryList(bankParam, false);
                        if (!ListUtil.isEmpty((List)accountEntities)) continue;
                        this.addBanks(supplierEntity, bankAccountVO);
                    }
                }
                if (ListUtil.isNotEmpty(se.getCerts())) {
                    for (CertsEntity cert : se.getCerts()) {
                        cert.setPid(supplierEntity.getId());
                        supplierEntity.getCerts().add(cert);
                    }
                }
                this.supplierService.saveOrUpdate((Object)supplierEntity, false);
                if (!"laborSub".equals(se.getSupplyQueryType()) || !ListUtil.isNotEmpty(se.getSubLeaders())) break block30;
                for (SubleadersEntity subLeader : se.getSubLeaders()) {
                    subLeader.setPid(supplierEntity.getId());
                    this.subleadersService.saveOrUpdate((Object)subLeader);
                    if (!coordination.booleanValue()) continue;
                    this.supplierService.generateSubSupplierTenant(subLeader, supplierEntity);
                }
                break block30;
            }
            supplierVO.setSocialCreditCode(supplierVO.getTaxPayerIdentifier());
            supplierVO.setEnabled(Integer.valueOf(1));
            supplierVO.setInsideOrg(Boolean.valueOf(false));
            supplierVO.setComeFrom("\u81ea\u884c\u51c6\u5165");
            SupplierEntity se = (SupplierEntity)((Object)BeanMapper.map((Object)supplierVO, SupplierEntity.class));
            Boolean coordination = se.getCoordination();
            if (coordination == null) {
                se.setCoordination(false);
            }
            this.supplierService.saveOrUpdate((Object)se, false);
            se = this.supplierService.generateSupplierTenant(se);
            this.supplierService.saveOrUpdate((Object)se, false);
            if ("laborSub".equals(se.getSupplyQueryType()) && ListUtil.isNotEmpty(se.getSubLeaders())) {
                for (SubleadersEntity subLeader : se.getSubLeaders()) {
                    this.supplierService.generateSubSupplierTenant(subLeader, se);
                    this.subleadersService.saveOrUpdate((Object)subLeader);
                }
            }
            if (ListUtil.isNotEmpty((List)(banks = supplierVO.getBanks()))) {
                QueryParam params = new QueryParam();
                List collect = banks.stream().map(BaseVO::getId).collect(Collectors.toList());
                params.getParams().put("id", new Parameter("in", collect));
                List bankAccountEntityList = this.bankAccountService.queryList(params);
                ArrayList<BankAccountVO> rm = new ArrayList<BankAccountVO>();
                if (CollectionUtils.isNotEmpty((Collection)bankAccountEntityList)) {
                    for (BankAccountVO bankAccountVO : banks) {
                        for (BankAccountEntity bankAccountEntity : bankAccountEntityList) {
                            if (!bankAccountVO.getId().equals(bankAccountEntity.getId())) continue;
                            rm.add(bankAccountVO);
                        }
                    }
                }
                banks.removeAll(rm);
                for (BankAccountVO bankAccountVO : banks) {
                    this.addBanks(se, bankAccountVO);
                }
            }
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    private void addBanks(SupplierEntity supplierVO, BankAccountVO bankAccountVO) {
        BankAccountEntity accountEntity = (BankAccountEntity)((Object)BeanMapper.map((Object)bankAccountVO, BankAccountEntity.class));
        accountEntity.setOrgId(supplierVO.getApplyOrgId());
        accountEntity.setOrgName(supplierVO.getApplyOrgName());
        accountEntity.setSupplierId(supplierVO.getId());
        accountEntity.setSupplierName(supplierVO.getName());
        accountEntity.setSupplierCode(supplierVO.getCode());
        if (bankAccountVO.getBankNum() == null) {
            BankEntity bankEntity = (BankEntity)((Object)this.bankService.selectById(bankAccountVO.getBankId()));
            accountEntity.setBankNum(bankEntity.getCode());
        }
        accountEntity.setTenantId(999999L);
        accountEntity.setEnabled(1);
        accountEntity.setInsideState(0);
        accountEntity.setSupplierFlag(1);
        if (accountEntity.getDefaultFlag() == null) {
            accountEntity.setDefaultFlag(0);
        }
        this.bankAccountService.saveOrUpdate((Object)accountEntity);
    }

    @GetMapping(value={"judgeTaxpayerNumIsRepeat"})
    public CommonResponse<String> judgeTaxpayerNumIsRepeat(@RequestParam String taxpayerNum, @RequestParam String personal, @RequestParam(required=false) String supplyType) {
        List supplierEntities;
        this.logger.info("\u5224\u91cd\u53c2\u6570\uff1ataxpayerNum={},personal={},supplyType={}", new Object[]{taxpayerNum, personal, supplyType});
        QueryParam param = new QueryParam();
        param.getParams().put("taxPayerIdentifier", new Parameter("eq", (Object)taxpayerNum));
        if (StringUtils.isNotEmpty((CharSequence)supplyType) && !"-".equals(supplyType)) {
            ComplexParam complexParam = new ComplexParam();
            complexParam.setLogic("and");
            for (String s : supplyType.split(",")) {
                ComplexParam c = new ComplexParam();
                c.setLogic("or");
                c.getParams().put("supplyType", new Parameter("like", (Object)s));
                complexParam.getComplexParams().add(c);
            }
            param.getComplexParams().add(complexParam);
        }
        if (ListUtil.isNotEmpty((List)(supplierEntities = this.supplierService.queryList(param)))) {
            if ("p".equals(personal)) {
                return CommonResponse.error((String)("\u4f9b\u5e94\u5546\u5e93\u5df2\u5b58\u5728\u8eab\u4efd\u8bc1\u53f7\u4e3a\u3010" + taxpayerNum + "\u3011\u7684\u4e2a\u4eba\u4f9b\u5e94\u5546\uff01"), (Object)((SupplierEntity)((Object)supplierEntities.get(0))).getSupplyTypeName());
            }
            return CommonResponse.error((String)("\u4f9b\u5e94\u5546\u5e93\u5df2\u5b58\u5728\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e3a\u3010" + taxpayerNum + "\u3011\u7684\u4f01\u4e1a\u4f9b\u5e94\u5546\uff01"), (Object)((SupplierEntity)((Object)supplierEntities.get(0))).getSupplyTypeName());
        }
        return CommonResponse.success((String)"\u4f9b\u5e94\u5546\u4e0d\u91cd\u590d\uff01");
    }

    @PostMapping(value={"pushSubLeadersToShare"})
    public CommonResponse<String> pushSubLeadersToShare(@RequestBody SubleadersPushVO pushVO) {
        this.logger.info("\u5206\u5305\u8d1f\u8d23\u4eba\u63a8\u9001\uff0c\u751f\u6210\u4f01\u4e1a\u4f9b\u5e94\u5546pushSupplierToShare---{}", (Object)JSONObject.toJSONString((Object)pushVO));
        SupplierEntity se = (SupplierEntity)((Object)this.supplierService.selectById(pushVO.getSupplierId()));
        if (se == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u5206\u5305\u8d1f\u8d23\u4eba\u6240\u5728\u4f9b\u5e94\u5546");
        }
        if (ListUtil.isEmpty((List)pushVO.getSubLeaders())) {
            return CommonResponse.error((String)"\u8981\u51c6\u5165\u7684\u5206\u5305\u8d1f\u8d23\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Boolean coordination = se.getCoordination();
        if (coordination == null) {
            se.setCoordination(false);
        }
        for (SubleadersVO subleadersVO : pushVO.getSubLeaders()) {
            SubleadersEntity subLeader = (SubleadersEntity)((Object)BeanMapper.map((Object)subleadersVO, SubleadersEntity.class));
            subLeader.setContentId(subleadersVO.getContentIdForTrans());
            this.supplierService.generateSubSupplierTenant(subLeader, se);
            subLeader.setPid(se.getId());
            this.subleadersService.saveOrUpdate((Object)subLeader);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @PostMapping(value={"punishSupplierBatch"})
    public CommonResponse<String> punishSupplierBatch(@RequestBody List<PunishVO> punishVOs) {
        String msg = this.supplierService.punishSupplierBatch(punishVOs);
        return StringUtils.isNotBlank((CharSequence)msg) ? CommonResponse.error((String)msg) : CommonResponse.success((String)"\u5904\u7f6e\u6210\u529f\uff01");
    }

    @PostMapping(value={"updateSupplierAndSubLeaderBatch"})
    public CommonResponse<String> updateSupplierAndSubLeaderBatch(@RequestBody String updateParamsStr) {
        String updateRs = this.supplierService.updateSupplierAndSubLeaderBatch(updateParamsStr);
        return StringUtils.isNotBlank((CharSequence)updateRs) ? CommonResponse.error((String)updateRs) : CommonResponse.success((String)"\u66f4\u65b0\u6210\u529f\uff01");
    }

    @PostMapping(value={"punishSupplier"})
    public CommonResponse<String> punishSupplier(@RequestBody PunishVO punishVO) {
        String punishVOStr = JSONObject.toJSONString((Object)punishVO);
        this.logger.info("punishVOStr:" + punishVOStr);
        SupplierEntity supplierEntity = (SupplierEntity)((Object)this.supplierService.selectById(punishVO.getSupplierId()));
        if (supplierEntity == null) {
            return CommonResponse.error((String)"\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728\uff01");
        }
        if (null == punishVO.getPunishOldGrade()) {
            punishVO.setPunishOldGrade(supplierEntity.getPunishOldGrade());
        }
        boolean inException = true;
        if (DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)new Date()).equals(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)punishVO.getExceptionEndDate()))) {
            inException = false;
        }
        if (punishVO.getSubLeaderId() == null) {
            this.logger.info("\u6267\u884c\u4e86\u3002\u3002\u3002\u3002\u3002\u3002");
            BeanUtils.copyProperties((Object)punishVO, (Object)((Object)supplierEntity));
            supplierEntity.setGradeId(punishVO.getPunishGradeId());
            supplierEntity.setGradeName(punishVO.getPunishGrade());
            supplierEntity.setPunishOldGrade(punishVO.getPunishOldGrade());
            supplierEntity.setInException(inException);
            Date startDate = new Date();
            boolean b = this.supplierService.saveOrUpdate((Object)supplierEntity, false);
            Date endDate = new Date();
            this.logger.info("\u5904\u7f6e\u7ed3\u679c\u63d2\u5165:" + b);
            this.logger.info("\u5904\u7f6e\u65f6\u95f4(\u6beb\u79d2\u6570):" + (endDate.getTime() - startDate.getTime()));
        } else {
            this.logger.info("\u5230\u4e86.....");
            if (ListUtil.isEmpty(supplierEntity.getSubLeaders())) {
                return CommonResponse.error((String)"\u5206\u5305\u8d1f\u8d23\u4eba\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u5904\u7f6e\uff01");
            }
            SubleadersEntity leader = null;
            for (SubleadersEntity subLeader : supplierEntity.getSubLeaders()) {
                if (!punishVO.getSubLeaderId().equals(subLeader.getId())) continue;
                leader = subLeader;
            }
            if (leader == null) {
                return CommonResponse.error((String)"\u5206\u5305\u8d1f\u8d23\u4eba\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u5904\u7f6e\uff01");
            }
            BeanUtils.copyProperties((Object)punishVO, leader);
            leader.setGrade(punishVO.getPunishGradeId());
            leader.setGradeName(punishVO.getPunishGrade());
            leader.setInException(inException);
            this.logger.info("\u6570\u636e:{}", (Object)leader);
            this.subleadersService.saveOrUpdate((Object)leader, false);
        }
        return CommonResponse.success((String)"\u5904\u7f6e\u6210\u529f\uff01");
    }

    @GetMapping(value={"upgradeSupplier"})
    public CommonResponse<String> upgradeSupplier(@RequestParam(value="supplierId") Long supplierId, @RequestParam(value="gradeId") Long gradeId, @RequestParam(value="gradeName") String gradeName) {
        this.logger.info("\u8bc4\u7ea7\u66f4\u65b0\u4f9b\u5e94\u5546\u5e93");
        this.logger.info(supplierId.toString());
        this.logger.info(gradeId.toString());
        this.logger.info(gradeName);
        SupplierEntity supplierEntity = (SupplierEntity)((Object)this.supplierService.selectById(supplierId));
        if (supplierEntity == null) {
            return CommonResponse.error((String)"\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728\uff01");
        }
        supplierEntity.setGradeId(gradeId);
        supplierEntity.setGradeName(gradeName);
        this.supplierService.saveOrUpdate((Object)supplierEntity, false);
        return CommonResponse.success((String)"\u4f9b\u5e94\u5546\u8bc4\u7ea7\u8bbe\u7f6e\u6210\u529f\uff01");
    }

    @GetMapping(value={"returnSupplierToNormal"})
    public CommonResponse<String> returnSupplierToNormal(@RequestParam(value="supplierId") Long supplierId, @RequestParam(value="gradeId") Long gradeId, @RequestParam(value="gradeName") String gradeName) {
        this.logger.info("\u79fb\u9664\u4f9b\u5e94\u5546\u5f02\u5e38\u6807\u7b7e");
        SupplierEntity supplierEntity = (SupplierEntity)((Object)this.supplierService.selectById(supplierId));
        if (supplierEntity == null) {
            return CommonResponse.error((String)"\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728\uff01");
        }
        supplierEntity.setGradeId(gradeId);
        supplierEntity.setGradeName(gradeName);
        supplierEntity.setInException(false);
        supplierEntity.setExceptionEndDate(null);
        supplierEntity.setPunishType(null);
        this.supplierService.saveOrUpdate((Object)supplierEntity, false);
        return CommonResponse.success((String)"\u4f9b\u5e94\u5546\u8bc4\u7ea7\u8bbe\u7f6e\u6210\u529f\uff01");
    }

    @GetMapping(value={"getEjcCloudSystemCode"})
    public CommonResponse<String> getEjcCloudSystemCode() {
        QueryParam param = new QueryParam();
        List list = this.ejcCloudSystemService.queryList(param, false);
        if (ListUtil.isNotEmpty((List)list)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)((EjcCloudSystemEntity)((Object)list.get(0))).getCode());
        }
        System.out.println("\u76ca\u4f01\u8054\u516c\u6709\u4e91\u5e73\u53f0\u5185\u7684\u7cfb\u7edf\u6807\u8bc6\u7f16\u7801 \u5c1a\u672a\u914d\u7f6e\uff01");
        return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25");
    }

    @GetMapping(value={"getSupplierInfo"})
    @ResponseBody
    public CommonResponse<SupplierProVO> getSupplierInfo(@RequestParam(value="supplierId") Long supplierId) {
        SupplierEntity supplierEntity = (SupplierEntity)((Object)this.supplierService.selectById(supplierId));
        if (supplierEntity == null) {
            return CommonResponse.error((String)"\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728\uff01");
        }
        SupplierProVO vo = (SupplierProVO)BeanMapper.map((Object)((Object)supplierEntity), SupplierProVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u4f9b\u5e94\u5546\u4fe1\u606f\u6210\u529f\uff01", (Object)vo);
    }

    @GetMapping(value={"whetherSupplierCoo"})
    @ResponseBody
    public CommonResponse<Boolean> whetherSupplierCoo(@RequestParam(value="supplierId") Long supplierId) {
        boolean coo = false;
        SupplierEntity supplierEntity = (SupplierEntity)((Object)this.supplierService.selectById(supplierId));
        if (supplierEntity == null) {
            return CommonResponse.error((String)"\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728\uff01");
        }
        if (StringUtils.isNotEmpty((CharSequence)supplierEntity.getSystemId()) && supplierEntity.getCoordination() != null && supplierEntity.getCoordination().booleanValue()) {
            coo = true;
        }
        this.logger.info("\u6839\u636e\u4f9b\u5e94\u5546id\uff0c\u67e5\u8be2\u4f9b\u5e94\u5546\u662f\u5426\u771f\u6b63\u534f\u540c\u6210\u529f{}===>>{}", (Object)coo, (Object)JSONObject.toJSONString((Object)((Object)supplierEntity)));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)coo);
    }

    @GetMapping(value={"updateLastCoDate"})
    public CommonResponse<String> updateLastCoDate(@RequestParam(value="supplierId") Long supplierId) {
        SupplierEntity supplierEntity = (SupplierEntity)((Object)this.supplierService.selectById(supplierId));
        if (supplierEntity == null) {
            return CommonResponse.error((String)"\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728\uff01");
        }
        supplierEntity.setLastCoDate(new Date());
        this.supplierService.saveOrUpdate((Object)supplierEntity);
        return CommonResponse.success((String)"\u66f4\u65b0\u6210\u529f\uff01");
    }

    @GetMapping(value={"selectByTaxpayerNum"})
    public CommonResponse<SupplierDTO> selectByTaxpayerNum(@RequestParam(value="taxpayerNum") String taxpayerNum) {
        QueryParam param = new QueryParam();
        param.getParams().put("taxPayerIdentifier", new Parameter("eq", (Object)taxpayerNum));
        List supplierEntities = this.supplierService.queryList(param);
        if (supplierEntities.size() > 0) {
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)BeanMapper.map(supplierEntities.get(0), SupplierDTO.class));
        }
        return CommonResponse.error((String)"\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728\uff01");
    }

    @GetMapping(value={"checkTaxpayerNumOrNameIsSame"})
    public CommonResponse<Boolean> checkTaxpayerNumOrNameIsSame(@RequestParam(value="taxpayerNum") String taxpayerNum, @RequestParam(value="name") String name) {
        QueryParam param = new QueryParam();
        param.getParams().put("taxPayerIdentifier", new Parameter("eq", (Object)taxpayerNum));
        List supplierEntities = this.supplierService.queryList(param);
        if (ListUtil.isNotEmpty((List)supplierEntities)) {
            if (((SupplierEntity)((Object)supplierEntities.get(0))).getName().equals(name)) {
                return CommonResponse.success((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u548c\u540d\u79f0\u4e00\u81f4", (Object)true);
            }
            return CommonResponse.success((String)"\u4f9b\u5e94\u5546\u5e93\u5b58\u5728\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e00\u81f4\uff0c\u4f46\u662f\u540d\u79f0\u4e0d\u4e00\u81f4\u7684\u4f9b\u5e94\u5546,\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u6b63\u786e\uff01", (Object)false);
        }
        param = new QueryParam();
        param.getParams().put("name", new Parameter("eq", (Object)name));
        supplierEntities = this.supplierService.queryList(param);
        if (ListUtil.isNotEmpty((List)supplierEntities)) {
            if (((SupplierEntity)((Object)supplierEntities.get(0))).getTaxPayerIdentifier().equals(taxpayerNum)) {
                return CommonResponse.success((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u548c\u540d\u79f0\u4e00\u81f4", (Object)true);
            }
            return CommonResponse.success((String)"\u4f9b\u5e94\u5546\u5e93\u5b58\u5728\u540d\u79f0\u4e00\u81f4\uff0c\u4f46\u662f\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e0d\u4e00\u81f4\u7684\u4f9b\u5e94\u5546,\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u6b63\u786e\uff01", (Object)false);
        }
        return CommonResponse.success((String)"\u6ca1\u6709\u627e\u5230\u76f8\u5173\u4f9b\u5e94\u5546\uff0c\u8ba4\u4e3a\u4e00\u81f4", (Object)true);
    }

    @GetMapping(value={"checkSubLeaderIsExist"})
    public CommonResponse<Boolean> checkSubLeaderIsExist(@RequestParam(value="supplierId") Long supplierId, @RequestParam(value="idCardNum") String idCardNum) {
        QueryParam param = new QueryParam();
        param.getParams().put("pid", new Parameter("eq", (Object)supplierId));
        param.getParams().put("idNum", new Parameter("eq", (Object)idCardNum));
        List supplierEntities = this.subleadersService.queryList(param);
        if (ListUtil.isNotEmpty((List)supplierEntities)) {
            return CommonResponse.success((String)("\u5206\u5305\u8d1f\u8d23\u4eba\u8eab\u4efd\u8bc1\u53f7:" + idCardNum + "\u91cd\u590d\uff01"), (Object)true);
        }
        return CommonResponse.success((String)"\u4e0d\u91cd\u590d\uff01", (Object)false);
    }

    @PostMapping(value={"syncSupplier"})
    List<JSONObject> syncSupplier(@RequestBody String suppliers, HttpServletRequest request) {
        boolean dataAccessFlag = this.checkIpAddress(request);
        boolean dataSaveFlag = false;
        this.logger.info("\u63a5\u6536\u5230\u5f85\u540c\u6b65\u5ba2\u5546\u4fe1\u606f\uff1a{}, dataAccessFlag\uff1a{}", (Object)suppliers, (Object)dataAccessFlag);
        this.logger.info("****************\u540c\u6b65\u5ba2\u5546\u4fe1\u606f\u5f00\u59cb*************");
        List syncList = JSONObject.parseArray((String)suppliers, SX2JSyncSupplierVO.class);
        ArrayList<JSONObject> resp = new ArrayList<JSONObject>();
        JSONObject tmpResp = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String SX2JSys = "SX2JSys";
        if (CollectionUtils.isEmpty((Collection)syncList)) {
            tmpResp = new JSONObject();
            tmpResp.put("id", (Object)-1);
            tmpResp.put("retMsg", (Object)"\u63a5\u53d7\u5f85\u540c\u6b65\u5ba2\u5546\u5217\u8868\u4e3a\u7a7a\uff01");
            tmpResp.put("isSuccess", (Object)0);
            tmpResp.put("retDate", (Object)sdf.format(new Date()));
            resp.add(tmpResp);
            return resp;
        }
        this.logger.info("\u63a5\u6536\u5230\u540c\u6b65\u5ba2\u5546\u6570\u636e\uff1a{}\u6761", (Object)syncList.size());
        Map<Object, Object> sourceIdMap = new HashMap();
        List sourceCodes = syncList.stream().map(SX2JSyncSupplierVO::getCode).collect(Collectors.toList());
        QueryWrapper supplierQuery = new QueryWrapper();
        supplierQuery.in((Object)"source_id", sourceCodes);
        supplierQuery.in((Object)"system_id", new Object[]{"SX2JSys"});
        List updateList = this.supplierService.list((Wrapper)supplierQuery);
        if (CollectionUtils.isNotEmpty((Collection)updateList)) {
            sourceIdMap = updateList.stream().collect(Collectors.toMap(SupplierEntity::getSourceId, Function.identity()));
        }
        ArrayList<SupplierEntity> saveList = new ArrayList<SupplierEntity>();
        SupplierEntity tmpEntity = null;
        for (SX2JSyncSupplierVO supplier : syncList) {
            tmpEntity = sourceIdMap.containsKey(supplier.getCode()) ? (SupplierEntity)((Object)sourceIdMap.get(supplier.getId())) : new SupplierEntity();
            this.updateSupplierInfo(supplier, tmpEntity, "SX2JSys");
            saveList.add(tmpEntity);
            tmpResp = new JSONObject();
            tmpResp.put("id", (Object)supplier.getId());
            tmpResp.put("retDate", (Object)sdf.format(new Date()));
            tmpResp.put("isSuccess", (Object)0);
            tmpResp.put("retMsg", (Object)"\u4fdd\u5b58\u66f4\u65b0\u6210\u529f");
            resp.add(tmpResp);
        }
        if (CollectionUtils.isNotEmpty(saveList) && dataAccessFlag) {
            try {
                this.logger.info("\u5f85\u4fdd\u5b58\u66f4\u65b0\u5ba2\u5546\uff1a{}", (Object)saveList.size());
                this.supplierService.saveOrUpdateBatch(saveList, saveList.size(), false);
                dataSaveFlag = true;
            }
            catch (Exception e) {
                this.logger.error("\u4fdd\u5b58\u540c\u6b65\u7684\u9655\u5efa\u5ba2\u5546\u5217\u8868\u5f02\u5e38,", (Throwable)e);
            }
        }
        if (CollectionUtils.isNotEmpty(resp) && !dataSaveFlag) {
            resp.stream().forEach(item -> {
                item.put("isSuccess", (Object)1);
                item.put("retMsg", (Object)(!dataAccessFlag ? "\u9274\u6743\u672a\u901a\u8fc7\uff0c\u540c\u6b65\u5ba2\u5546\u5931\u8d25" : "\u7cfb\u7edf\u9519\u8bef\uff0c\u540c\u6b65\u5ba2\u5546\u5931\u8d25\uff01"));
            });
        }
        this.logger.info("****************\u540c\u6b65\u5ba2\u5546\u4fe1\u606f\u7ed3\u675f*************");
        return resp;
    }

    private void updateSupplierInfo(SX2JSyncSupplierVO supplier, SupplierEntity tmpEntity, String systemId) {
        tmpEntity.setSourceId(supplier.getCode());
        tmpEntity.setSystemId(systemId);
        tmpEntity.setCode(supplier.getCode());
        tmpEntity.setName(supplier.getName());
        tmpEntity.setAddress(supplier.getMerchantaddr());
        tmpEntity.setSupplierFlag("1".equals(supplier.getIsCustom()) && "1".equals(supplier.getIsSup()) ? 3 : ("1".equals(supplier.getIsCustom()) ? 2 : 1));
        tmpEntity.setSocialCreditCode(supplier.getSccode());
        if ("FREEZE".equals(supplier.getDisType())) {
            tmpEntity.setEnabled(0);
        } else {
            tmpEntity.setEnabled(1);
        }
        tmpEntity.setDescription(supplier.getDescription());
        if (null == tmpEntity.getId()) {
            tmpEntity.setSubFlag(1);
            tmpEntity.setBlacklistFlag(0);
            tmpEntity.setRedlistFlag(0);
            tmpEntity.setBillState(1);
            tmpEntity.setSupplyQueryType(supplier.getDefaultSupplyQueryType());
            tmpEntity.setSupplyType(supplier.getDefaultSupplyType());
            tmpEntity.setSupplyTypeName(supplier.getDefaultSupplyTypeName());
            tmpEntity.setPersonal(supplier.getDefaultPersonalFlag());
            tmpEntity.setGroupInOrOut(supplier.getDefaultGroupInOut());
        }
    }

    public boolean checkIpAddress(HttpServletRequest request) {
        List<String> hosts;
        String ip = request.getHeader("x-forwarded-for");
        this.logger.info("x-forwarded-for: {}", (Object)ip);
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Forwarded-For");
            this.logger.info("request.getHeader(\"X-Forwarded-For\")= {}", (Object)ip);
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
            this.logger.info("request.getHeader(\"Proxy-Client-IP\")= {}", (Object)ip);
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
            this.logger.info("request.getHeader(\"WL-Proxy-Client-IP\")= {}", (Object)ip);
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
            this.logger.info("request.getHeader(\"HTTP_CLIENT_IP\")= {}", (Object)ip);
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
            this.logger.info("request.getHeader(\"HTTP_X_FORWARDED_FOR\")= {}", (Object)ip);
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
            this.logger.info("request.getRemoteAddr()= {}", (Object)ip);
        }
        if (null != ip && ip.indexOf(44) != -1) {
            System.out.println("ip=" + ip);
            String[] ips = ip.split(",");
            for (int i = 0; i < ips.length; ++i) {
                if (null == ips[i] || "unknown".equalsIgnoreCase(ips[i])) continue;
                ip = ips[i];
                break;
            }
            if ("0:0:0:0:0:0:1".equals(ip)) {
                this.logger.info("\u7531\u4e8e\u5ba2\u6237\u7aef\u8bbf\u95ee\u5730\u5740\u4f7f\u7528 localhost\uff0c\u83b7\u53d6\u5ba2\u6237\u7aef\u771f\u5b9eIP\u5730\u5740\u9519\u8bef\uff0c\u8bf7\u4f7f\u7528IP\u65b9\u5f0f\u8bbf\u95ee");
            }
        }
        if ("unknown".equalsIgnoreCase(ip)) {
            this.logger.info("\u7531\u4e8e\u5ba2\u6237\u7aef\u901a\u8fc7Squid\u53cd\u5411\u4ee3\u7406\u8f6f\u4ef6\u8bbf\u95ee\uff0c\u83b7\u53d6\u5ba2\u6237\u7aef\u771f\u5b9eIP\u5730\u5740\u9519\u8bef\uff0c\u8bf7\u66f4\u6539squid.conf\u914d\u7f6e\u6587\u4ef6forwarded_for\u9879\u9ed8\u8ba4\u662f\u4e3aon\u89e3\u51b3");
        }
        return StringUtils.isNotBlank((CharSequence)ip) && (hosts = Arrays.asList(this.accessHosts.split(","))).contains(ip);
    }
}

