package com.ejianc.foundation.share.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.share.bean.CustomerLinkerEntity;
import com.ejianc.foundation.share.mapper.CustomerLinkerMapper;
import com.ejianc.foundation.share.service.ICustomerLinkerService;
import com.ejianc.foundation.share.vo.CustomerLinkerVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

@Service("customerLinkerService")
public class CustomerLinkerServiceImpl extends BaseServiceImpl<CustomerLinkerMapper, CustomerLinkerEntity> implements ICustomerLinkerService {

	@Autowired
	private CustomerLinkerMapper customerLinkerMapper;
	
	@Override
	public void deleteByCustomerId(Long customerId) {
		QueryWrapper<CustomerLinkerEntity> deleteWrapper = new QueryWrapper<>();
		deleteWrapper.eq("customer_id", customerId);
		customerLinkerMapper.delete(deleteWrapper);
	}

	@Override
	public CustomerLinkerVO queryByCustomerIdAndLinkman(Long customerId, String linkman) {
		QueryWrapper<CustomerLinkerEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("customer_id", customerId);
		queryWrapper.eq("link_man", linkman);
		
		List<CustomerLinkerEntity> entities = customerLinkerMapper.selectList(queryWrapper);
		if(entities != null && entities.size() > 0) {
			return BeanMapper.map(entities.get(0), CustomerLinkerVO.class);
		}
		return null;
	}

}
