package com.ejianc.foundation.share.controller.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.utils.EJCDateUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.bean.ProjectSetPoolEntity;
import com.ejianc.foundation.share.service.IProjectSetService;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.share.vo.ProjectSurveyVO;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.micrometer.core.instrument.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 项目统计
 */
@RestController
@RequestMapping("/api/projectPool/")
public class ProjectPoolApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IProjectSetService projectSetService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOrgApi orgApi;

    @GetMapping(value = "queryProjectList")
    public CommonResponse<List<ProjectSurveyVO>> queryProjectList(@RequestParam(value = "projectStatus", required = false) String projectStatus, @RequestParam(value = "dateIn", required = false) String dateIn, @RequestParam(value = "orgId", required = false) Long orgId,@RequestParam(value = "currentProvince",required = false) String currentProvince) {
        List<ProjectPoolSetVO> resp = new ArrayList<>();
        QueryWrapper<ProjectSetPoolEntity> queryWrapper = new QueryWrapper<>();
        if (StringUtils.isNotEmpty(projectStatus)) {
            queryWrapper.eq("project_status", projectStatus);
        }
        if (StringUtils.isNotEmpty(dateIn)) {
            queryWrapper.eq("DATE_FORMAT(project_date,\"%Y\")", dateIn);
        }

        /** 租户隔离 */
        queryWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());

        Long _orgId = orgId == null ? InvocationInfoProxy.getOrgId() : orgId;
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        List<OrgVO> orgVOList = (List<OrgVO>) getRespData(orgApi.findChildrenByParentId(_orgId), true, "查询失败，获取当前本下组织信息失败。");
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        /** 要求主表有orgId字段，保存单据所属组织 */
        if (commonOrgIds.size() != 0) {
            queryWrapper.in("org_id", commonOrgIds);
        } else if (departmentIds.size() != 0) {
            queryWrapper.in("project_department_id", departmentIds);
        }

        List<ProjectSetPoolEntity> projectSetPoolEntities = projectSetService.list(queryWrapper);
        List<ProjectSurveyVO> list=new ArrayList<>();
        if (CollectionUtils.isNotEmpty(projectSetPoolEntities)) {
            for (ProjectSetPoolEntity projectSetPoolEntity : projectSetPoolEntities) {
                ProjectSurveyVO projectSurveyVO = new ProjectSurveyVO();
                projectSurveyVO.setId(projectSetPoolEntity.getId());
                projectSurveyVO.setOrgId(projectSetPoolEntity.getOrgId());
                projectSurveyVO.setProjectName(projectSetPoolEntity.getName());
                projectSurveyVO.setParentProjectId(projectSetPoolEntity.getParentProjectId());
                if (StringUtils.isNotEmpty(projectSetPoolEntity.getAreaName())){
                    String areaName=null;
                    if (currentProvince.equals("henan")){
                         areaName = projectSetPoolEntity.getAreaName().replace("/", "");
                    }else {
                        areaName = projectSetPoolEntity.getAreaName().replace(",", "").replaceAll("\\/","");
                    }
                    projectSurveyVO.setArea(areaName);
                }else {
                    projectSurveyVO.setArea(projectSetPoolEntity.getAreaName());
                }
                projectSurveyVO.setProjectDepartmentId(projectSetPoolEntity.getProjectDepartmentId());
                list.add(projectSurveyVO);
            }
        }
        return CommonResponse.success(list);
    }

    @PostMapping(value = "getProjectPoolList")
    public CommonResponse<JSONArray> getProjectPoolList(@RequestBody QueryParam param) {
        if(!param.getParams().containsKey("tenantId") && !param.getParams().containsKey("tenant_id")) {
            param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        }

        List<ProjectSetPoolEntity> entities = projectSetService.queryList(param, false);
        return CommonResponse.success(JSONArray.parseArray(JSONObject.toJSONString(entities)));
    }


    @GetMapping(value = "queryProjectPoolList")
    public CommonResponse<JSONArray> queryProjectPoolList(@RequestParam(value = "projectStatus", required = false) String projectStatus, @RequestParam(value = "dateIn", required = false) String dateIn, @RequestParam(value = "orgId", required = false) Long orgId) {
        List<ProjectPoolSetVO> resp = new ArrayList<>();
        QueryWrapper<ProjectSetPoolEntity> queryWrapper = new QueryWrapper<>();
        if (StringUtils.isNotEmpty(projectStatus)) {
            queryWrapper.eq("project_status", projectStatus);
        }
        if (StringUtils.isNotEmpty(dateIn)) {
            queryWrapper.eq("DATE_FORMAT(project_date,\"%Y\")", dateIn);
        }

        /** 租户隔离 */
        queryWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());

        Long _orgId = orgId == null ? InvocationInfoProxy.getOrgId() : orgId;
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        List<OrgVO> orgVOList = (List<OrgVO>) getRespData(orgApi.findChildrenByParentId(_orgId), true, "查询失败，获取当前本下组织信息失败。");
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        /** 要求主表有orgId字段，保存单据所属组织 */
        if (commonOrgIds.size() != 0) {
            queryWrapper.in("org_id", commonOrgIds);
        } else if (departmentIds.size() != 0) {
            queryWrapper.in("project_department_id", departmentIds);
        }

        List<ProjectSetPoolEntity> projectSetPoolEntities = projectSetService.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(projectSetPoolEntities)) {
            resp = BeanMapper.mapList(projectSetPoolEntities, ProjectPoolSetVO.class);
        }
        return CommonResponse.success(JSONArray.parseArray(JSONObject.toJSONString(resp)));
    }

    @GetMapping(value = "queryProjectPoolById")
    public CommonResponse<JSONArray> queryProjectPoolById(@RequestParam("id") Long id) {
        List<ProjectPoolSetVO> resp = new ArrayList<>();
        QueryWrapper<ProjectSetPoolEntity> queryWrapper = new QueryWrapper<>();
        if (null == id) {
            return CommonResponse.error("请检查参数项目id是否为空！");
        }
        queryWrapper.eq("id", id);
        List<ProjectSetPoolEntity> projectSetPoolEntities = projectSetService.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(projectSetPoolEntities)) {
            resp = BeanMapper.mapList(projectSetPoolEntities, ProjectPoolSetVO.class);
        }
        return CommonResponse.success(JSONArray.parseArray(JSONObject.toJSONString(resp)));
    }


    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(org.apache.commons.lang3.StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    // 根据 项目名称、项目编码、租户id 查询项目池中的项目
    @GetMapping(value = "queryProjectListByNameAndCodeAndTenantId")
    public CommonResponse<List<ProjectPoolSetVO>> queryProjectListByNameAndCodeAndTenantId(@RequestParam("name") String name, @RequestParam("code") String code, @RequestParam("tenantId") Long tenantId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));
        queryParam.getParams().put("name", new Parameter(QueryParam.EQ, name));
        queryParam.getParams().put("code", new Parameter(QueryParam.EQ, code));
        List<ProjectSetPoolEntity> projectSetPoolEntityList = projectSetService.queryList(queryParam);
        return CommonResponse.success("根据项目名称、项目编码、租户id查询项目池中的项目成功", BeanMapper.mapList(projectSetPoolEntityList, ProjectPoolSetVO.class));
    }
    // 根据 项目编码、租户id 查询项目池中的项目
    @GetMapping(value = "queryProjectListByCodeAndTenantId")
    public CommonResponse<List<ProjectPoolSetVO>> queryProjectListByCodeAndTenantId(@RequestParam("code") String code, @RequestParam("tenantId") Long tenantId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));
        queryParam.getParams().put("code", new Parameter(QueryParam.EQ, code));
        List<ProjectSetPoolEntity> projectSetPoolEntityList = projectSetService.queryList(queryParam);
        List<ProjectPoolSetVO> poolSetVOList = BeanMapper.mapList(projectSetPoolEntityList, ProjectPoolSetVO.class);
        logger.info("通过项目编码{}，查出项目池中数据{}", code, JSONObject.toJSONString(poolSetVOList));
        if (CollectionUtils.isNotEmpty(poolSetVOList) && poolSetVOList.get(0).getOrgId() != null && poolSetVOList.get(0).getProjectDepartmentId() != null){
            OrgVO orgVO = (OrgVO) getRespData(orgApi.getOneById(poolSetVOList.get(0).getOrgId()), true, "查询失败，获取当前组织信息失败。");
            poolSetVOList.get(0).setOrgCode(orgVO.getCode());
            OrgVO projectDepartmentVO = (OrgVO) getRespData(orgApi.getOneById(poolSetVOList.get(0).getProjectDepartmentId()), true, "查询失败，获取当前组织信息失败。");
            poolSetVOList.get(0).setProjectDepartmentCode(projectDepartmentVO.getCode());
        }

        return CommonResponse.success("根据项目编码、租户id查询项目池中的项目成功", poolSetVOList);
    }

    // 根据 项目名称、租户id 查询项目池中的项目
    @GetMapping(value = "queryProjectListByNameAndTenantId")
    public CommonResponse<List<ProjectPoolSetVO>> queryProjectListByNameAndTenantId(@RequestParam("name") String name, @RequestParam("tenantId") Long tenantId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));
        queryParam.getParams().put("name", new Parameter(QueryParam.EQ, name));
        List<ProjectSetPoolEntity> projectSetPoolEntityList = projectSetService.queryList(queryParam);
        return CommonResponse.success("根据项目名称、项目编码、租户id查询项目池中的项目成功", BeanMapper.mapList(projectSetPoolEntityList, ProjectPoolSetVO.class));
    }

    // 根据 项目部组织id 查询项目池中的项目
    @GetMapping(value = "queryProjectListByProjectDepartmentId")
    public CommonResponse<List<ProjectPoolSetVO>> queryProjectListByProjectDepartmentId(@RequestParam("projectDepartmentId") Long projectDepartmentId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectDepartmentId", new Parameter(QueryParam.EQ, projectDepartmentId));
        List<ProjectSetPoolEntity> projectSetPoolEntityList = projectSetService.queryList(queryParam);
        return CommonResponse.success("查询成功", BeanMapper.mapList(projectSetPoolEntityList, ProjectPoolSetVO.class));
    }

    // 查询项目池中的项目
    @PostMapping("queryProjectIPage")
    public CommonResponse<Page<ProjectPoolSetVO>> queryProjectIPage(@RequestBody QueryParam param) {

        logger.info("sssss"+ JSONObject.toJSONString(param));

        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("name");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        Long orgId;
        if (null != param.getParams() && null != param.getParams().get("orgId")){
            orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
        }else{
            orgId = InvocationInfoProxy.getOrgId();
        }
        param.getParams().remove("orgId");


        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        List<OrgVO> orgVOList = (List<OrgVO>) getRespData(orgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        /** 要求主表有orgId字段，保存单据所属组织 */
        if(commonOrgIds.size() != 0) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }else if(departmentIds.size() != 0){
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }else {
            return CommonResponse.success("查询列表数据成功！",new Page<>(1, param.getPageSize(), 0));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ProjectSetPoolEntity> page = projectSetService.queryPage(param,false);
        Page<ProjectPoolSetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectPoolSetVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    //根据组织id查询在建的的项目列表
    @GetMapping(value = "/queryProjectIdsByorgId")
    @ResponseBody
    CommonResponse<List<Long>> queryProjectIdsByorgId(@RequestParam("orgId") Long orgId,@RequestParam(value = "projectStatus",required = false) String projectStatus,@RequestParam(value = "dateIn",required = false) String dateIn){
        QueryWrapper<ProjectSetPoolEntity> queryWrapper = new QueryWrapper<>();
        Long _orgId = orgId == null ? InvocationInfoProxy.getOrgId() : orgId;
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        List<OrgVO> orgVOList = (List<OrgVO>) getRespData(orgApi.findChildrenByParentId(_orgId), true, "查询失败，获取当前本下组织信息失败。");
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        /** 要求主表有orgId字段，保存单据所属组织 */
        if (commonOrgIds.size() != 0) {
            queryWrapper.in("org_id", commonOrgIds);
        } else if (departmentIds.size() != 0) {
            queryWrapper.in("project_department_id", departmentIds);
        }
        if (StringUtils.isNotEmpty(projectStatus)){
            if("building".equals(projectStatus)){
                queryWrapper.in("project_status", 1);
            }
        }
        if (StringUtils.isNotEmpty(dateIn)){
            if ("thisYear".equals(dateIn)) {
                dateIn = EJCDateUtil.getYear() + "";
                queryWrapper.eq("DATE_FORMAT(project_date,\"%Y\")", dateIn);
            }
        }
        List<ProjectSetPoolEntity> projectSetPoolEntities = projectSetService.list(queryWrapper);
        List<Long> ids =
                projectSetPoolEntities.stream().map(ProjectSetPoolEntity::getId).collect(Collectors.toList());
        return CommonResponse.success("查询列表数据成功！", ids);
    }

    //根据项目id，查询该项目下所有的子项目(本下)
    @GetMapping(value = "/queryProjectIdsByParentProjectId")
    @ResponseBody
    CommonResponse<List<Long>> queryProjectIdsByParentProjectId(@RequestParam(value = "parentProjectId", required =
            false) Long parentProjectId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("parentProjectId", new Parameter(QueryParam.EQ, parentProjectId));
        List<ProjectSetPoolEntity> list = projectSetService.queryList(queryParam, false);
        List<Long> ids = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)) {
            ids = list.stream().map(ProjectSetPoolEntity::getId).collect(Collectors.toList());
        }
        // 加入查询项目id
        ids.add(parentProjectId);
        return CommonResponse.success("查询列表数据成功！", ids);
    }

    /**
     * 根据项目Id查询项目信息
     *
     * @param id
     * @return
     */
    @GetMapping("queryDetailById")
    public CommonResponse<ProjectVO> queryDetailById(@RequestParam(value = "id") Long id) {
        ProjectSetPoolEntity entity = projectSetService.selectById(id);
        ProjectPoolSetVO vo = BeanMapper.map(entity, ProjectPoolSetVO.class);
        return CommonResponse.success("查询详情数据成功！",this.getProjectVO(vo));
    }

    /**
     * 根据ids查询项目详情
     *
     * @param ids
     * @return
     */
    @PostMapping(value = "queryProjectArray")
    public CommonResponse<JSONArray> queryProjectArray(@RequestBody List<Long> ids){
        List<ProjectPoolSetVO> vos = new ArrayList<>();
        QueryWrapper<ProjectSetPoolEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.in("id", ids);
        List<ProjectSetPoolEntity> entitys = projectSetService.list(queryWrapper);
//		if(entitys!=null){
//			vos = BeanMapper.mapList(entitys, ProjectRegisterVO.class);
//		}
        List<ProjectPoolSetVO> poolList = BeanMapper.mapList(entitys, ProjectPoolSetVO.class);
        List<ProjectVO> voList = this.getProjectVOS(poolList);
        return CommonResponse.success("查询成功！", JSONArray.parseArray(JSONObject.toJSONString(voList)));
    }

    /**
     * 根据ids查询项目详情
     *
     * @param ids
     * @return
     */
    @PostMapping(value = "queryProjectByIds")
    public CommonResponse<JSONArray> queryProjectByIds(@RequestBody List<Long> ids){
        List<ProjectPoolSetVO> vos = new ArrayList<>();
        QueryWrapper<ProjectSetPoolEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.in("id", ids);
        List<ProjectSetPoolEntity> entitys = projectSetService.list(queryWrapper);
//		if(entitys!=null){
//			vos = BeanMapper.mapList(entitys, ProjectRegisterVO.class);
//		}
        List<ProjectPoolSetVO> poolList = BeanMapper.mapList(entitys, ProjectPoolSetVO.class);
        return CommonResponse.success("查询成功！", JSONArray.parseArray(JSONObject.toJSONString(poolList)));
    }

    /**
     * 根据项目部id查询项目信息
     * @param projectDepartmentId
     * @return
     */
    @GetMapping("queryProjectByProjectDepartmentId")
    public CommonResponse<ProjectVO> queryProjectByProjectDepartmentId(@RequestParam(value = "projectDepartmentId") Long projectDepartmentId) {
        ProjectSetPoolEntity entity = projectSetService.selectById(projectDepartmentId);
        if(entity == null){
            QueryParam param = new QueryParam();
            param.getParams().put("project_department_id",new Parameter(QueryParam.EQ,projectDepartmentId));
            List<ProjectSetPoolEntity> list = projectSetService.queryList(param,false);
            if(ListUtil.isNotEmpty(list)){
                entity = list.get(0);
            }
        }
        if(entity == null){
            return CommonResponse.success("查询成功！", null);
        }
        ProjectPoolSetVO vo = BeanMapper.map(entity, ProjectPoolSetVO.class);
        return CommonResponse.success("查询成功！", this.getProjectVO(vo));
    }

    /**
     * 查询项目
     * @return
     */
    @PostMapping("queryProjects")
    @ResponseBody
    public CommonResponse<List<ProjectVO>> queryProjects(@RequestBody QueryParam param) {
        List<Long> orgIds = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());

        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.getParams().put("project_department_id",new Parameter(QueryParam.IN,orgIds));

        List<ProjectSetPoolEntity> list = projectSetService.queryList(param);
        List<ProjectPoolSetVO> voList =BeanMapper.mapList(list,ProjectPoolSetVO.class);
        return CommonResponse.success("查询成功！", this.getProjectVOS(voList));
    }

    /**
     * 查询项目
     * @return
     */
    @PostMapping("queryArray")
    @ResponseBody
    CommonResponse<JSONArray> queryArray(@RequestBody QueryParam param) {
        List<Long> orgIds = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.getParams().put("project_department_id",new Parameter(QueryParam.IN,orgIds));
        List<ProjectSetPoolEntity> list = projectSetService.queryList(param);
        List<ProjectPoolSetVO> poolList = BeanMapper.mapList(list, ProjectPoolSetVO.class);
        List<ProjectVO> voList = this.getProjectVOS(poolList);
        return CommonResponse.success("查询成功！", JSONArray.parseArray(JSONObject.toJSONString(voList)));
    }

    /**
     * 查询当前组织下所有启用且在建的项目
     * @param orgId
     * @return
     */
    @GetMapping("queryProjectsByOrgId")
    @ResponseBody
    public CommonResponse<List<ProjectVO>> queryProjectsByOrgId(@RequestParam("orgId") Long orgId) {
        List<Long> orgIds = orgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        QueryParam param = new QueryParam();
        param.getParams().put("project_status", new Parameter(QueryParam.EQ, 1)); // 在建
//        param.getParams().put("state", new Parameter(QueryParam.EQ, 1)); // 启用
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.getParams().put("project_department_id",new Parameter(QueryParam.IN,orgIds));
        List<ProjectSetPoolEntity> list = projectSetService.queryList(param);
        List<ProjectPoolSetVO> voList =BeanMapper.mapList(list,ProjectPoolSetVO.class);
        return CommonResponse.success("查询成功！", this.getProjectVOS(voList));
    }

    /**
     * 查询当前组织下所有启用且在建的项目
     * @param orgId
     * @return
     */
    @GetMapping("queryArrayByOrgId")
    @ResponseBody
    CommonResponse<JSONArray> queryArrayByOrgId(@RequestParam("orgId") Long orgId) {
        List<Long> orgIds = orgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        QueryParam param = new QueryParam();
        param.getParams().put("project_status", new Parameter(QueryParam.EQ, 1)); // 在建
//        param.getParams().put("state", new Parameter(QueryParam.EQ, 1)); // 启用
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.getParams().put("project_department_id",new Parameter(QueryParam.IN,orgIds));
        List<ProjectSetPoolEntity> list = projectSetService.queryList(param);
        List<ProjectPoolSetVO> poolList = BeanMapper.mapList(list,ProjectPoolSetVO.class);
        List<ProjectVO> voList = this.getProjectVOS(poolList);
        return CommonResponse.success("查询成功！", JSONArray.parseArray(JSONObject.toJSONString(voList)));
    }

    public ProjectVO getProjectVO(ProjectPoolSetVO projectSetVO){
        ProjectVO map = BeanMapper.map(projectSetVO, ProjectVO.class);
        map.setProjectName(projectSetVO.getName());
        map.setBillCode(projectSetVO.getCode());
        map.setLeader(projectSetVO.getProjectManagementId());
        map.setStartDate(projectSetVO.getPlanStartDate());
        map.setEndDate(projectSetVO.getPlanEndDate());
        map.setContractualModel(projectSetVO.getEngineeringType());
        return map;
    }

    public List<ProjectVO> getProjectVOS(List<ProjectPoolSetVO> projectSetVOS){
        List<ProjectVO> list = new ArrayList<>();
        for (ProjectPoolSetVO projectSetVO : projectSetVOS){
            ProjectVO projectVO = this.getProjectVO(projectSetVO);
            list.add(projectVO);
        }
        return list;
    }


    @GetMapping(value = "getOneByCode")
    public CommonResponse<ProjectPoolSetVO> getOneByCode(@RequestParam String code) {
        ProjectPoolSetVO resp = null;
        QueryWrapper<ProjectSetPoolEntity> query = new QueryWrapper<>();
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.eq("code", code);
        ProjectSetPoolEntity e = projectSetService.getOne(query);
        if(null != e) {
            resp = BeanMapper.map(e, ProjectPoolSetVO.class);
        }

        return CommonResponse.success(resp);
    }

    @GetMapping(value = "getOneBySourceId")
    public CommonResponse<ProjectPoolSetVO> getOneBySourceId(@RequestParam String sourceId) {
        ProjectPoolSetVO resp = null;
        QueryWrapper<ProjectSetPoolEntity> query = new QueryWrapper<>();
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.eq("source_id", sourceId);
        ProjectSetPoolEntity e = projectSetService.getOne(query);
        if(null != e) {
            resp = BeanMapper.map(e, ProjectPoolSetVO.class);
        }

        return CommonResponse.success(resp);
    }
}
