/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.SupHisPerformanceVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.bean.SubleadersEntity;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.service.ICertsService;
import com.ejianc.foundation.share.service.ISubleadersService;
import com.ejianc.foundation.share.service.ISupplierLinkerService;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.share.vo.CertsVO;
import com.ejianc.foundation.share.vo.HistoryVO;
import com.ejianc.foundation.share.vo.SubleadersVO;
import com.ejianc.foundation.share.vo.SupplierExcelVO;
import com.ejianc.foundation.share.vo.SupplierLinkerVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.share.vo.SupplyBankVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.bean.BankAccountEntity;
import com.ejianc.foundation.support.service.IBankAccountService;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.foundation.util.ExcelReader;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"/supplier/"})
public class SupplierController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String SUPPLIER_BILL_CODE = "SUPPORT_SUPPLIER";
    @Value(value="${eachLink.host}")
    private String eachLinkHost;
    @Value(value="${eachLink.appId}")
    private String appId;
    @Value(value="${eachLink.secret}")
    private String secret;
    @Autowired
    private ISupplierService supplierService;
    @Autowired
    private ISupplierLinkerService supplierLinkerService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBankAccountService bankAccountService;
    @Autowired
    private ICertsService certsService;
    @Autowired
    private ISubleadersService subleadersService;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private IContractPoolApi contractPoolApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SupplierVO> saveOrUpdate(@RequestBody SupplierVO supplierVo) {
        supplierVo.setBanks(new ArrayList());
        List history = supplierVo.getHistory();
        supplierVo.setHistory(new ArrayList());
        CommonResponse<SupplierVO> response = this.supplierService.saveOrUpdate(supplierVo);
        supplierVo.setHistory(history);
        return response;
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SupplierVO> queryDetail(@RequestParam Long id) {
        return this.queryDetails(id);
    }

    @RequestMapping(value={"/queryDetails"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SupplierVO> queryDetails(@RequestParam Long id) {
        SupplierEntity supplierEntity = (SupplierEntity)((Object)this.supplierService.selectById(id));
        if (supplierEntity == null) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("supplierId", new Parameter("eq", (Object)id));
        List supplyBankEntities = this.bankAccountService.queryList(param, false);
        SupplierVO supplierVo = (SupplierVO)BeanMapper.map((Object)((Object)supplierEntity), SupplierVO.class);
        supplierVo.setBanks(BeanMapper.mapList((Iterable)supplyBankEntities, BankAccountVO.class));
        CommonResponse historyCommon = this.contractPoolApi.supHisPerformanceList(id);
        if (historyCommon.isSuccess()) {
            ArrayList<HistoryVO> historyAllList = new ArrayList<HistoryVO>();
            List historyList = (List)historyCommon.getData();
            for (SupHisPerformanceVO supHisPerformanceVO : historyList) {
                HistoryVO historyVO = new HistoryVO();
                historyVO.setId(Long.valueOf(IdWorker.getId()));
                historyVO.setContacts(supHisPerformanceVO.getContacts());
                historyVO.setContactsPhone(supHisPerformanceVO.getContactsPhone());
                historyVO.setContractMny(supHisPerformanceVO.getContractMny());
                historyVO.setCooperationContent(supHisPerformanceVO.getCooperationContent());
                historyVO.setCooperationOrg(supHisPerformanceVO.getCooperationOrg());
                historyVO.setEndDay(supHisPerformanceVO.getEndDay());
                historyVO.setEngineeringAddress(supHisPerformanceVO.getEngineeringAddress());
                historyVO.setEngineeringName(supHisPerformanceVO.getEngineeringName());
                historyAllList.add(historyVO);
            }
            for (HistoryVO vo : supplierVo.getHistory()) {
                historyAllList.add(vo);
            }
            supplierVo.setHistory(historyAllList);
        }
        return CommonResponse.success((Object)supplierVo);
    }

    @RequestMapping(value={"/querySubDetails"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SupplierVO> querySubDetails(@RequestParam Long id) {
        SubleadersEntity subleadersEntity = (SubleadersEntity)((Object)this.subleadersService.selectById(id));
        if (subleadersEntity == null) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25");
        }
        SupplierEntity supplierEntity = (SupplierEntity)((Object)this.supplierService.selectById(subleadersEntity.getPid()));
        supplierEntity.setExceptionEndDate(subleadersEntity.getExceptionEndDate());
        supplierEntity.setPunishType(subleadersEntity.getPunishType());
        supplierEntity.setPunishDate(subleadersEntity.getPunishDate());
        supplierEntity.setPunishGrade(subleadersEntity.getPunishGrade());
        supplierEntity.setPunishApplyOrg(subleadersEntity.getPunishApplyOrg());
        supplierEntity.setPunishApplyPerson(subleadersEntity.getPunishApplyPerson());
        supplierEntity.setPunishMemo(subleadersEntity.getPunishMemo());
        QueryParam param = new QueryParam();
        param.getParams().put("supplierId", new Parameter("eq", (Object)id));
        List supplyBankEntities = this.bankAccountService.queryList(param, false);
        SupplierVO supplierVo = (SupplierVO)BeanMapper.map((Object)((Object)supplierEntity), SupplierVO.class);
        supplierVo.setBanks(BeanMapper.mapList((Iterable)supplyBankEntities, BankAccountVO.class));
        CommonResponse historyCommon = this.contractPoolApi.supHisPerformanceList(id);
        if (historyCommon.isSuccess()) {
            ArrayList<HistoryVO> historyAllList = new ArrayList<HistoryVO>();
            List historyList = (List)historyCommon.getData();
            for (SupHisPerformanceVO supHisPerformanceVO : historyList) {
                HistoryVO historyVO = new HistoryVO();
                historyVO.setId(Long.valueOf(IdWorker.getId()));
                historyVO.setContacts(supHisPerformanceVO.getContacts());
                historyVO.setContactsPhone(supHisPerformanceVO.getContactsPhone());
                historyVO.setContractMny(supHisPerformanceVO.getContractMny());
                historyVO.setCooperationContent(supHisPerformanceVO.getCooperationContent());
                historyVO.setCooperationOrg(supHisPerformanceVO.getCooperationOrg());
                historyVO.setEndDay(supHisPerformanceVO.getEndDay());
                historyVO.setEngineeringAddress(supHisPerformanceVO.getEngineeringAddress());
                historyVO.setEngineeringName(supHisPerformanceVO.getEngineeringName());
                historyAllList.add(historyVO);
            }
            for (HistoryVO vo : supplierVo.getHistory()) {
                historyAllList.add(vo);
            }
            supplierVo.setHistory(historyAllList);
        }
        return CommonResponse.success((Object)supplierVo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        if (ListUtil.isNotEmpty(ids)) {
            this.bankAccountService.delBySuppAndCustomIds("supplierId", ids);
            for (Long id : ids) {
                CommonResponse response = this.billTypeApi.checkQuote("BT200422000000028", id);
                if (response.isSuccess()) continue;
                return CommonResponse.error((String)("\u5220\u9664\u5931\u8d25\uff1a" + response.getMsg()));
            }
        } else {
            return CommonResponse.error((String)"\u5220\u9664\u5931\u8d25\uff1a\u4e3b\u952e\u4e3a\u7a7a!");
        }
        this.supplierService.deleteSupplier(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/saveOrUpdateBank"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<BankAccountVO>> saveOrUpdateBank(@RequestBody SupplyBankVO supplyBankVO) {
        if (supplyBankVO.getPid() == null) {
            return CommonResponse.error((String)"\u8bf7\u5148\u65b0\u5efa\u4f9b\u5e94\u5546\u518d\u6dfb\u52a0\u94f6\u884c\u6863\u6848\uff01");
        }
        SupplierEntity supplier = (SupplierEntity)((Object)this.supplierService.selectById(supplyBankVO.getPid()));
        if (supplier == null) {
            return CommonResponse.error((String)"\u8bf7\u5148\u65b0\u5efa\u4f9b\u5e94\u5546\u518d\u6dfb\u52a0\u94f6\u884c\u6863\u6848\uff01");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("supplierId", new Parameter("eq", (Object)supplier.getId()));
        List supplyBankEntities = this.bankAccountService.queryList(param, false);
        if (supplyBankEntities.size() == 0) {
            supplyBankVO.setDefaultable(1);
        } else if (supplyBankVO.getId() != null) {
            BankAccountEntity bankAccountEntity = (BankAccountEntity)((Object)this.bankAccountService.selectById(supplyBankVO.getId()));
            if (supplyBankVO.getDefaultable() == 1 && bankAccountEntity.getDefaultFlag() != 1) {
                for (BankAccountEntity bankEntity : supplyBankEntities) {
                    bankEntity.setDefaultFlag(0);
                }
                this.bankAccountService.saveOrUpdateBatch(supplyBankEntities);
                bankAccountEntity = (BankAccountEntity)((Object)this.bankAccountService.selectById(supplyBankVO.getId()));
            } else if (supplyBankVO.getDefaultable() != 1 && bankAccountEntity.getDefaultFlag() == 1) {
                return CommonResponse.error((String)"\u81f3\u5c11\u6709\u4e00\u4e2a\u9ed8\u8ba4\u8d26\u6237\uff01");
            }
            bankAccountEntity.setDefaultFlag(supplyBankVO.getDefaultable());
            bankAccountEntity.setBankId(supplyBankVO.getBankId());
            bankAccountEntity.setBankName(supplyBankVO.getBankName());
            bankAccountEntity.setBankCode(supplyBankVO.getBankCode());
            bankAccountEntity.setBankAccount(supplyBankVO.getBankAccount());
            bankAccountEntity.setCategoryId(supplyBankVO.getCategoryId());
            bankAccountEntity.setCategoryName(supplyBankVO.getCategoryName());
            bankAccountEntity.setSupplierFlag(supplier.getSupplierFlag());
            bankAccountEntity.setBankNum(supplyBankVO.getBankNum());
            bankAccountEntity.setBankAddress(supplyBankVO.getAddress());
            bankAccountEntity.setEnabled(1);
            if (bankAccountEntity.getDefaultFlag() == null) {
                bankAccountEntity.setDefaultFlag(0);
            }
            this.bankAccountService.saveOrUpdateNoES((Object)bankAccountEntity);
            supplyBankEntities = this.bankAccountService.queryList(param, false);
            List vo = BeanMapper.mapList((Iterable)supplyBankEntities, BankAccountVO.class);
            return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01", (Object)vo);
        }
        BankAccountVO bankAccountVO = (BankAccountVO)BeanMapper.map((Object)supplyBankVO, BankAccountVO.class);
        if (supplier.getInsideOrg() != null && supplier.getInsideOrg().booleanValue()) {
            bankAccountVO.setInsideState(Integer.valueOf(1));
        } else {
            bankAccountVO.setInsideState(Integer.valueOf(0));
        }
        bankAccountVO.setSupplierId(supplier.getId());
        bankAccountVO.setSupplierName(supplier.getName());
        bankAccountVO.setOrgId(supplier.getApplyOrgId());
        bankAccountVO.setOrgName(supplier.getApplyOrgName());
        bankAccountVO.setSupplierCode(supplier.getCode());
        bankAccountVO.setBankAddress(supplyBankVO.getAddress());
        bankAccountVO.setSupplierFlag(supplier.getSupplierFlag());
        bankAccountVO.setEnabled(Integer.valueOf(1));
        if (bankAccountVO.getDefaultFlag() == null) {
            bankAccountVO.setDefaultFlag(Integer.valueOf(0));
        }
        this.bankAccountService.insertOrUpdate(bankAccountVO);
        supplyBankEntities = this.bankAccountService.queryList(param, false);
        List vo = BeanMapper.mapList((Iterable)supplyBankEntities, BankAccountVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delBank"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delBank(@RequestBody List<Long> ids) {
        if (ListUtil.isNotEmpty(ids)) {
            for (Long id : ids) {
                CommonResponse response = this.billTypeApi.checkQuote("BT200422000000028", id);
                if (response.isSuccess()) continue;
                return CommonResponse.error((String)("\u5220\u9664\u5931\u8d25\uff1a" + response.getMsg()));
            }
        } else {
            return CommonResponse.error((String)"\u5220\u9664\u5931\u8d25\uff1a\u4e3b\u952e\u4e3a\u7a7a!");
        }
        this.bankAccountService.delBySuppAndCustomIds("supplierId", ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SupplierVO>> queryList(@RequestBody QueryParam queryParam) {
        queryParam.getFuzzyFields().add("name");
        queryParam.getFuzzyFields().add("code");
        queryParam.getFuzzyFields().add("material_content");
        queryParam.getFuzzyFields().add("equipment_content");
        queryParam.getFuzzyFields().add("major_content");
        queryParam.getFuzzyFields().add("punish_apply_org");
        queryParam.getFuzzyFields().add("apply_org_name");
        queryParam.getFuzzyFields().add("tax_payer_identifier");
        queryParam.getFuzzyFields().add("tenantPhone");
        if (queryParam.getParams().get("insideOrg") != null) {
            if ("true".equals(((Parameter)queryParam.getParams().get("insideOrg")).getValue())) {
                queryParam.getParams().put("insideOrg", new Parameter("eq", (Object)true));
            } else {
                queryParam.getParams().put("insideOrg", new Parameter("eq", (Object)false));
            }
        }
        if (queryParam.getParams().get("supplyType") != null) {
            String[] supplyType = ((Parameter)queryParam.getParams().get("supplyType")).getValue().toString().split(",");
            ComplexParam c = new ComplexParam();
            c.setLogic("and");
            for (int i = 0; i < supplyType.length; ++i) {
                String type = supplyType[i];
                ComplexParam t = new ComplexParam();
                t.setLogic("or");
                t.getParams().put("supplyType", new Parameter("like", (Object)type));
                c.getComplexParams().add(t);
            }
            queryParam.getComplexParams().add(c);
            queryParam.getParams().remove("supplyType");
        }
        queryParam.getParams().put("supplierFlag", new Parameter("in", (Object)"1,3"));
        IPage page = this.supplierService.queryPage(queryParam, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SupplierVO.class));
        return CommonResponse.success((Object)pageData);
    }

    @RequestMapping(value={"/querySubLeaderList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SubleadersVO>> querySubLeaderList(@RequestBody QueryParam queryParam) {
        queryParam.getFuzzyFields().add("name");
        IPage page = this.subleadersService.queryPage(queryParam, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        HashMap<Long, SupplierEntity> supplierEntityMap = new HashMap<Long, SupplierEntity>();
        List records = BeanMapper.mapList((Iterable)page.getRecords(), SubleadersVO.class);
        if (ListUtil.isNotEmpty((List)records)) {
            for (SubleadersVO record : records) {
                SupplierEntity supplier = (SupplierEntity)((Object)supplierEntityMap.get(record.getPid()));
                if (supplierEntityMap.get(record.getPid()) != null) {
                    supplier = (SupplierEntity)((Object)supplierEntityMap.get(record.getPid()));
                } else {
                    supplier = (SupplierEntity)((Object)this.supplierService.selectById(record.getPid()));
                    this.logger.info("record{}", (Object)supplier);
                    if (supplier == null) continue;
                    supplierEntityMap.put(supplier.getId(), supplier);
                }
                String content = "";
                if (StringUtils.isNotEmpty((CharSequence)supplier.getLaborContent())) {
                    content = content + supplier.getLaborContent() + ",";
                }
                if (StringUtils.isNotEmpty((CharSequence)supplier.getMajorContent())) {
                    content = content + supplier.getMajorContent();
                }
                record.setSupplierContent(content);
                record.setSupplierName(supplier.getName());
                record.setSupplierGrade(supplier.getGradeName());
                record.setArea(supplier.getAreaName());
                record.setSupplierCode(supplier.getCode());
                record.setPersonal(supplier.getPersonal());
            }
        }
        pageData.setRecords(records);
        return CommonResponse.success((Object)pageData);
    }

    @RequestMapping(value={"/subLeaderRef"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SubleadersVO>> subLeaderRef(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageSize(pageSize);
        queryParam.setPageIndex(pageNumber);
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("idNum");
        queryParam.getFuzzyFields().add("name");
        queryParam.getFuzzyFields().add("phone");
        queryParam.getFuzzyFields().add("gradeName");
        String supplierId = null;
        String inException = null;
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject con = JSONObject.parseObject((String)condition);
            supplierId = con.getString("supplierId");
            inException = con.getString("inException");
        }
        if (StringUtils.isNotEmpty(supplierId)) {
            queryParam.getParams().put("pid", new Parameter("eq", (Object)supplierId));
        }
        if (StringUtils.isNotEmpty(inException)) {
            queryParam.getParams().put("inException", new Parameter("eq", (Object)true));
        } else {
            queryParam.getParams().put("inException", new Parameter("sql", (Object)" in_exception is not true "));
        }
        IPage page = this.subleadersService.queryPage(queryParam, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List records = BeanMapper.mapList((Iterable)page.getRecords(), SubleadersVO.class);
        if (ListUtil.isNotEmpty((List)records)) {
            SupplierEntity supplier = null;
            if (StringUtils.isNotEmpty((CharSequence)supplierId)) {
                supplier = (SupplierEntity)((Object)this.supplierService.selectById((Serializable)((Object)supplierId)));
            }
            for (SubleadersVO record : records) {
                if (supplier == null) {
                    supplier = (SupplierEntity)((Object)this.supplierService.selectById(record.getPid()));
                }
                StringBuilder content = new StringBuilder("");
                if (StringUtils.isNotEmpty((CharSequence)supplier.getLaborContent())) {
                    content.append(supplier.getLaborContent()).append(",");
                }
                if (StringUtils.isNotEmpty((CharSequence)supplier.getMajorContent())) {
                    content.append(supplier.getMajorContent());
                }
                record.setSupplierContent(content.toString());
                record.setSupplierName(supplier.getName());
                record.setSupplierGrade(supplier.getGradeName());
                record.setArea(supplier.getAreaName());
            }
        }
        pageData.setRecords(records);
        return CommonResponse.success((Object)pageData);
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
        IPage<SupplierVO> pageData = this.supplierService.queryPageList(queryParam);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", pageData);
        return CommonResponse.success((Object)jsonObject);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"supplier-import.xlsx", (String)"\u4f9b\u65b9\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        Long tenantId = InvocationInfoProxy.getTenantid();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List<List<String>> result = ExcelReader.readExcel(mf);
        ArrayList<String> errorList = new ArrayList<String>();
        if (result != null && result.size() > 0) {
            for (int i = 0; i < result.size(); ++i) {
                List<String> datas = result.get(i);
                SupplierVO supplierVo = null;
                if (StringUtils.isEmpty((CharSequence)datas.get(2))) {
                    errorList.add("\u7b2c" + i + "\u884c\u6570\u636e\uff1a" + datas.toString() + "\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    continue;
                }
                supplierVo = this.supplierService.queryDetailBySocialCode(String.valueOf(datas.get(2)));
                if (supplierVo != null) {
                    errorList.add("\u7b2c" + i + "\u884c\u6570\u636e\uff1a" + datas.toString() + "\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5b58\u5728\u76f8\u540c\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u7684\u4f9b\u5e94\u5546\uff01");
                    continue;
                }
                supplierVo = new SupplierVO();
                CommonResponse codeBatchByRuleCode = this.billCodeApi.getCodeBatchByRuleCode(SUPPLIER_BILL_CODE, tenantId);
                if (codeBatchByRuleCode.isSuccess()) {
                    supplierVo.setCode((String)codeBatchByRuleCode.getData());
                } else {
                    supplierVo.setCode(String.valueOf(new Date().getTime()));
                }
                if (StringUtils.isEmpty((CharSequence)datas.get(1))) {
                    errorList.add("\u7b2c" + i + "\u884c\u6570\u636e\uff1a" + datas.toString() + "\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u4f9b\u65b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    continue;
                }
                supplierVo.setName(String.valueOf(datas.get(1)));
                supplierVo.setSocialCreditCode(String.valueOf(datas.get(2)));
                supplierVo.setLegal(String.valueOf(datas.get(3)));
                if (StringUtils.isNotEmpty((CharSequence)datas.get(4))) {
                    // empty if block
                }
                supplierVo.setBusinessScope(datas.get(5));
                supplierVo.setTelephone(datas.get(6));
                supplierVo.setArea(datas.get(7));
                supplierVo.setAddress(datas.get(8));
                supplierVo.setBankName(datas.get(9));
                supplierVo.setBankAccount(datas.get(10));
                supplierVo.setBankCode(datas.get(11));
                if (StringUtils.isNotEmpty((CharSequence)datas.get(12))) {
                    ArrayList<SupplierLinkerVO> gridheaders = new ArrayList<SupplierLinkerVO>();
                    String linkman = String.valueOf(datas.get(12));
                    SupplierLinkerVO supplierLinkerVo = this.supplierLinkerService.queryBySupplierIdAndLinkman(supplierVo.getId(), linkman);
                    if (supplierLinkerVo == null) {
                        supplierLinkerVo = new SupplierLinkerVO();
                        supplierLinkerVo.setRowState("add");
                    } else {
                        supplierLinkerVo.setRowState("edit");
                    }
                    supplierLinkerVo.setSupplierId(supplierVo.getId());
                    supplierLinkerVo.setLinkman(datas.get(12));
                    supplierLinkerVo.setCellphone(datas.get(13));
                    gridheaders.add(supplierLinkerVo);
                    supplierVo.setGridheaders(gridheaders);
                }
                supplierVo.setEnabled(Integer.valueOf(1));
                this.supplierService.saveOrUpdate(supplierVo);
            }
        }
        if (errorList.size() > 0) {
            errorList.add("\u5bfc\u5165\u6210\u529f\uff1a" + (result.size() - errorList.size() - 1) + "\u6761, \u5931\u8d25\uff1a" + errorList.size() + "\u6761");
            return CommonResponse.error((String)"\u5bfc\u5165\u5931\u8d25", errorList);
        }
        return CommonResponse.success((String)"\u5bfc\u5165\u6210\u529f");
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getFuzzyFields().add("code");
        queryParam.getFuzzyFields().add("name");
        queryParam.getFuzzyFields().add("material_content");
        queryParam.getFuzzyFields().add("equipment_content");
        queryParam.getFuzzyFields().add("punish_apply_org");
        queryParam.getFuzzyFields().add("major_content");
        queryParam.getFuzzyFields().add("apply_org_name");
        queryParam.getFuzzyFields().add("tax_payer_identifier");
        queryParam.getFuzzyFields().add("tenantPhone");
        queryParam.setPageIndex(1);
        queryParam.setPageSize(-1);
        if (queryParam.getParams().get("insideOrg") != null) {
            if ("true".equals(((Parameter)queryParam.getParams().get("insideOrg")).getValue())) {
                queryParam.getParams().put("insideOrg", new Parameter("eq", (Object)true));
            } else {
                queryParam.getParams().put("insideOrg", new Parameter("eq", (Object)false));
            }
        }
        if (queryParam.getParams().get("supplyType") != null) {
            String[] supplyType = ((Parameter)queryParam.getParams().get("supplyType")).getValue().toString().split(",");
            ComplexParam c = new ComplexParam();
            c.setLogic("and");
            for (int i = 0; i < supplyType.length; ++i) {
                String type = supplyType[i];
                ComplexParam t = new ComplexParam();
                t.setLogic("or");
                t.getParams().put("supplyType", new Parameter("like", (Object)type));
                c.getComplexParams().add(t);
            }
            queryParam.getComplexParams().add(c);
            queryParam.getParams().remove("supplyType");
        }
        queryParam.getParams().put("supplierFlag", new Parameter("in", (Object)"1,3"));
        List supplierVos = this.supplierService.queryList(queryParam, false);
        ArrayList<SupplierExcelVO> suppliers = new ArrayList<SupplierExcelVO>();
        for (SupplierEntity supplierVo : supplierVos) {
            SupplierExcelVO excelVO = (SupplierExcelVO)BeanMapper.map((Object)((Object)supplierVo), SupplierExcelVO.class);
            excelVO.setPersonal("p".equals(supplierVo.getPersonal()) ? "\u4e2a\u4eba" : "\u4f01\u4e1a");
            excelVO.setGroupInOrOut("in".equals(supplierVo.getGroupInOrOut()) ? "\u96c6\u56e2\u5185" : "\u96c6\u56e2\u5916");
            excelVO.setInsideOrg(supplierVo.getInsideOrg() != null && supplierVo.getInsideOrg() != false ? "\u5185\u90e8\u5355\u4f4d" : "\u5916\u90e8\u5355\u4f4d");
            excelVO.setCoordination(supplierVo.getCoordination() != null && supplierVo.getCoordination() != false ? "\u5df2\u534f\u540c" : "\u672a\u534f\u540c");
            if (supplierVo.getPunishType() != null) {
                try {
                    JSONArray array = ReferObjectUtil.getReferEntityValue((String)supplierVo.getPunishType().toString(), (String)"abnormal_grade");
                    if (array != null && array.size() > 0) {
                        excelVO.setPunishType(array.getJSONObject(0).getString("name"));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            String content = "";
            if (StringUtils.isNotEmpty((CharSequence)supplierVo.getMaterialContent())) {
                content = content + supplierVo.getMaterialContent();
            }
            if (StringUtils.isNotEmpty((CharSequence)supplierVo.getEquipmentContent())) {
                content = content + supplierVo.getEquipmentContent();
            }
            if (StringUtils.isNotEmpty((CharSequence)supplierVo.getLaborContent())) {
                content = content + supplierVo.getLaborContent();
            }
            if (StringUtils.isNotEmpty((CharSequence)supplierVo.getMajorContent())) {
                content = content + supplierVo.getMajorContent();
            }
            if (StringUtils.isNotEmpty((CharSequence)supplierVo.getConsultContent())) {
                content = content + supplierVo.getConsultContent();
            }
            if (StringUtils.isNotEmpty((CharSequence)supplierVo.getRevolvMaterialContent())) {
                content = content + supplierVo.getRevolvMaterialContent();
            }
            if (StringUtils.isNotEmpty((CharSequence)supplierVo.getRevolvMaterialContent())) {
                content = content + supplierVo.getRevolvMaterialContent();
            }
            if (StringUtils.isNotEmpty((CharSequence)supplierVo.getSubContent())) {
                content = content + supplierVo.getSubContent();
            }
            excelVO.setMaterialContent(content);
            suppliers.add(excelVO);
        }
        HashMap<String, ArrayList<SupplierExcelVO>> beans = new HashMap<String, ArrayList<SupplierExcelVO>>();
        beans.put("records", suppliers);
        ExcelExport.getInstance().export("supplier-export.xlsx", beans, response);
    }

    @RequestMapping(value={"refSupplierPage"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SupplierVO>> refSupplierPage(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        JSONObject conditionJson;
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)condition) && null != (conditionJson = JSONObject.parseObject((String)condition)).get((Object)"supplyTypes")) {
            String[] supplyTypes = null;
            switch (conditionJson.getString("supplyTypes")) {
                case "laborSub": {
                    supplyTypes = new String[]{"major", "labor", "sub"};
                    break;
                }
                case "materialEquipment": {
                    supplyTypes = new String[]{"material", "equipment", "revolvMaterial"};
                    break;
                }
                case "other": {
                    supplyTypes = new String[]{"consult", "other"};
                    break;
                }
            }
            if (null != supplyTypes) {
                params.put("supplyTypes", supplyTypes);
            }
        }
        params.put("pageIndex", pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        params.put("pageSize", pageSize);
        params.put("searchText", searchText);
        params.put("range", "outside");
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        IPage<SupplierVO> pageData = this.supplierService.queryRefMaterialPage(params);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", pageData);
    }

    @RequestMapping(value={"refProSupplier"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SupplierVO>> refProSupplier(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        QueryParam param = new QueryParam();
        param.setPageIndex(pageNumber);
        param.setPageSize(pageSize);
        param.setSearchText(searchText);
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("tax_payer_identifier");
        param.getFuzzyFields().add("materialContent");
        param.getFuzzyFields().add("equipmentContent");
        param.getFuzzyFields().add("majorContent");
        param.getFuzzyFields().add("laborContent");
        param.getFuzzyFields().add("subContent");
        param.getFuzzyFields().add("otherContent");
        param.getFuzzyFields().add("revolvMaterialContent");
        param.getFuzzyFields().add("consultContent");
        param.getParams().put("inException", new Parameter("sql", (Object)" in_exception is not true "));
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            String supplyType = JSONObject.parseObject((String)condition).getString("supplyType");
            String supplyQueryType = JSONObject.parseObject((String)condition).getString("supplyQueryType");
            String supplierFlag = JSONObject.parseObject((String)condition).getString("supplierFlag");
            String personal = JSONObject.parseObject((String)condition).getString("personal");
            Boolean inException = JSONObject.parseObject((String)condition).getBoolean("inException");
            Boolean insideOrg = JSONObject.parseObject((String)condition).getBoolean("insideOrg");
            if (StringUtils.isNotBlank((CharSequence)supplyType)) {
                String[] types = supplyType.split(",");
                if (types.length == 1) {
                    param.getParams().put("supplyType", new Parameter("like", (Object)types[0]));
                } else {
                    ComplexParam complexParam = new ComplexParam();
                    complexParam.setLogic("and");
                    ArrayList<ComplexParam> complexParams = new ArrayList<ComplexParam>();
                    for (String type : types) {
                        ComplexParam complex = new ComplexParam();
                        complex.setLogic("or");
                        HashMap<String, Parameter> inP = new HashMap<String, Parameter>();
                        inP.put("supplyType", new Parameter("like", (Object)type));
                        complex.setParams(inP);
                        complexParams.add(complex);
                    }
                    complexParam.setComplexParams(complexParams);
                    param.getComplexParams().add(complexParam);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)supplyQueryType)) {
                param.getParams().put("supplyQueryType", new Parameter("eq", (Object)supplyQueryType));
            }
            if (StringUtils.isNotBlank((CharSequence)personal)) {
                param.getParams().put("personal", new Parameter("eq", (Object)personal));
            }
            if (inException != null && inException.booleanValue()) {
                param.getParams().remove("inException");
                param.getParams().put("inException", new Parameter("eq", (Object)inException));
            }
            if (supplierFlag != null) {
                param.getParams().put("supplierFlag", new Parameter("in", (Object)supplierFlag));
            }
            if (insideOrg != null && StringUtils.isEmpty((CharSequence)searchText)) {
                ComplexParam complexParam = new ComplexParam();
                complexParam.setLogic("or");
                complexParam.getParams().put("insideOrg", new Parameter("eq", (Object)insideOrg));
                param.getComplexParams().add(complexParam);
            }
        }
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.supplierService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SupplierVO.class));
        for (SupplierVO vo : pageData.getRecords()) {
            String content = "";
            if (StringUtils.isNotEmpty((CharSequence)vo.getMaterialContent())) {
                content = content + vo.getMaterialContent();
            }
            if (StringUtils.isNotEmpty((CharSequence)vo.getEquipmentContent())) {
                content = content + vo.getEquipmentContent();
            }
            if (StringUtils.isNotEmpty((CharSequence)vo.getLaborContent())) {
                content = content + vo.getLaborContent();
            }
            if (StringUtils.isNotEmpty((CharSequence)vo.getMajorContent())) {
                content = content + vo.getMajorContent();
            }
            if (StringUtils.isNotEmpty((CharSequence)vo.getConsultContent())) {
                content = content + vo.getConsultContent();
            }
            if (StringUtils.isNotEmpty((CharSequence)vo.getRevolvMaterialContent())) {
                content = content + vo.getRevolvMaterialContent();
            }
            if (StringUtils.isNotEmpty((CharSequence)vo.getRevolvMaterialContent())) {
                content = content + vo.getRevolvMaterialContent();
            }
            if (StringUtils.isNotEmpty((CharSequence)vo.getSubContent())) {
                content = content + vo.getSubContent();
            }
            vo.setMaterialContent(content);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"refProSupplierCerts"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<CertsVO>> refProSupplierCerts(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        String supplyId;
        QueryParam param = new QueryParam();
        param.setPageIndex(pageNumber);
        param.setPageSize(pageSize);
        param.setSearchText(searchText);
        param.getFuzzyFields().add("certName");
        param.getFuzzyFields().add("certCode");
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            supplyId = JSONObject.parseObject((String)condition).getString("supplyId");
            if (!StringUtils.isNotBlank((CharSequence)supplyId)) {
                return CommonResponse.error((String)"\u7f3a\u5c11supplyId\u53c2\u6570\uff01");
            }
        } else {
            return CommonResponse.error((String)"\u7f3a\u5c11supplyId\u53c2\u6570\uff01");
        }
        param.getParams().put("pid", new Parameter("eq", (Object)supplyId));
        IPage page = this.certsService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CertsVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"refInsideSupplierPage"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SupplierVO>> refInsideSupplierPage(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pageIndex", pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        params.put("pageSize", pageSize);
        params.put("searchText", searchText);
        params.put("range", "inside");
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        IPage<SupplierVO> pageData = this.supplierService.queryRefMaterialPage(params);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", pageData);
    }

    @RequestMapping(value={"/enableSupplierOrNot"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> enableSupplierOrNot(@RequestBody Map<String, Object> data) {
        if (data == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u53ef\u5904\u7406\u7684\u6570\u636e\uff01");
        }
        List ids = (List)data.get("ids");
        String state = (String)data.get("state");
        if (ListUtil.isEmpty((List)ids) || StringUtils.isEmpty((CharSequence)state)) {
            return CommonResponse.error((String)"\u6ca1\u6709\u53ef\u5904\u7406\u7684\u6570\u636e\uff01");
        }
        if (!state.equals("0") && !state.equals("1")) {
            return CommonResponse.error((String)"\u5408\u4f5c\u72b6\u6001\u4e0d\u6b63\u786e\uff01");
        }
        data.put("tenantId", InvocationInfoProxy.getTenantid());
        data.put("ids", StringUtils.join((Object[])ids.toArray(), (String)","));
        this.supplierService.enableSupplierOrNot(data);
        return CommonResponse.success((String)"\u5904\u7406\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/supplierCollaboration"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> supplierCollaboration(@RequestBody SupplierVO supplierVO) {
        return this.supplierService.supplierCollaboration(supplierVO);
    }

    @RequestMapping(value={"/querySupplierByTenantId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SupplierVO> querySupplierByTenantId(@RequestParam Long tenant) {
        SupplierVO supplierVo = this.supplierService.querySupplierByTenantId(tenant);
        return CommonResponse.success((Object)supplierVo);
    }

    @RequestMapping(value={"/querySupplierByCode"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SupplierVO> querySupplierByCode(@RequestParam String code) {
        SupplierVO supplierVo = new SupplierVO();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"code", (Object)code);
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.supplierService.list((Wrapper)queryWrapper);
        if (list != null && list.size() > 0) {
            supplierVo = (SupplierVO)BeanMapper.map(list.get(0), SupplierVO.class);
            return CommonResponse.success((Object)supplierVo);
        }
        return CommonResponse.success(null);
    }

    @RequestMapping(value={"/querySupplierByTaxCode"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SupplierVO> querySupplierByTaxCode(@RequestParam String taxCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"tax_payer_identifier", (Object)taxCode);
        List list = this.supplierService.list((Wrapper)queryWrapper);
        if (list != null && list.size() > 0) {
            SupplierVO supplierVo = (SupplierVO)BeanMapper.map(list.get(0), SupplierVO.class);
            QueryParam param = new QueryParam();
            param.getParams().put("supplierId", new Parameter("eq", (Object)supplierVo.getId()));
            List supplyBankEntities = this.bankAccountService.queryList(param, false);
            supplierVo.setBanks(BeanMapper.mapList((Iterable)supplyBankEntities, BankAccountVO.class));
            return CommonResponse.success((Object)supplierVo);
        }
        return CommonResponse.success((String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u4f9b\u5e94\u5546");
    }

    @RequestMapping(value={"/querySupplierBySourceId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SupplierVO> querySupplierBySourceId(@RequestParam String sourceId) {
        SupplierVO supplierVo = new SupplierVO();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"source_id", (Object)sourceId);
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.supplierService.list((Wrapper)queryWrapper);
        if (list != null && list.size() > 0) {
            supplierVo = (SupplierVO)BeanMapper.map(list.get(0), SupplierVO.class);
            return CommonResponse.success((Object)supplierVo);
        }
        return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u4f9b\u5e94\u5546");
    }

    @RequestMapping(value={"/generateInsideSupplierAndCustomer"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> generateInsideSupplierAndCustomer(@RequestBody List<OrgVO> orgList) {
        return this.supplierService.generateInsideSupplierAndCustomer(orgList);
    }

    @RequestMapping(value={"/updateInsideSupplierAndCustomer"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OrgVO> updateInsideSupplierAndCustomer(@RequestBody OrgVO orgVO) {
        return this.supplierService.updateInsideSupplierAndCustomer(orgVO);
    }

    @RequestMapping(value={"/generateSupplierAccount"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> generateSupplierAccount(@RequestParam(value="supplierId") Long supplierId, @RequestParam(value="name") String name, @RequestParam(value="telephone") String telephone) {
        return this.supplierService.generateSupplierTenant(supplierId, name, telephone);
    }

    @RequestMapping(value={"/generateSubLeaderAccount"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> generateSubLeaderAccount(@RequestParam(value="supplierId") Long supplierId, @RequestParam(value="subLeaderId") Long subLeaderId, @RequestParam(value="name") String name, @RequestParam(value="telephone") String telephone) {
        SupplierEntity se = (SupplierEntity)((Object)this.supplierService.selectById(supplierId));
        SubleadersEntity subLeader = (SubleadersEntity)((Object)this.subleadersService.selectById(subLeaderId));
        se.setTenantPhone(telephone);
        se.setTenantUserName(name);
        se.setCoordination(true);
        this.supplierService.generateSubSupplierTenant(subLeader, se);
        this.subleadersService.saveOrUpdate((Object)subLeader);
        if (!subLeader.getCoordination().booleanValue()) {
            return CommonResponse.error((String)"\u534f\u540c\u5931\u8d25\uff01");
        }
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/generateAccessToken"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> generateAccessToken(@RequestParam(value="id") Long supplierId) {
        if (this.redisTemplate.opsForValue().get((Object)("EachLink-Open-Api-Info-" + supplierId)) != null) {
            return CommonResponse.success((String)"\u5904\u7406\u6210\u529f\uff01");
        }
        SupplierEntity se = (SupplierEntity)((Object)this.supplierService.selectById(supplierId));
        if (se == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u6b64\u4f9b\u5e94\u5546\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)se.getSystemId())) {
            return CommonResponse.error((String)"\u8be5\u4f9b\u5e94\u5546\u5c1a\u672a\u751f\u6210\u534f\u540c\u8d26\u53f7\uff01");
        }
        CommonResponse res = this.systemDataPushService.exchangeDataWithUniversal("/ejc-idm-web/openapi/enterprise/queryAuthInfo?id=" + se.getSystemId(), RequestMethod.GET, null, this.appId, this.secret, this.eachLinkHost);
        if (res.isSuccess()) {
            JSONObject object = JSONObject.parseObject((String)((String)res.getData()));
            if (object.getInteger("code") == 0) {
                this.redisTemplate.opsForValue().set((Object)("EachLink-Open-Api-Info-" + supplierId), (Object)(this.eachLinkHost + "------" + object.getString("data")));
                return CommonResponse.success((String)"\u5904\u7406\u6210\u529f\uff01");
            }
            return CommonResponse.error((String)object.getString("msg"));
        }
        return res;
    }

    @RequestMapping(value={"/updateSupplierUserPhoneAndName"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> updateSupplierUserPhoneAndName(@RequestParam(value="supplierId") Long supplierId, @RequestParam(value="name") String name, @RequestParam(value="telephone") String telephone) {
        return this.supplierService.updateSupplierUserPhoneAndName(supplierId, name, telephone);
    }

    @Scheduled(cron="30 30 0 * * ?")
    public void recoverSuppliersFromBlackList() {
        this.logger.info("\u5f00\u59cb\u66f4\u65b0\u5f02\u5e38\u4f9b\u5e94\u5546\u5e93>>>>>>>>>>>>>>>>>>>>>>>>>>");
        QueryParam param = new QueryParam();
        param.getParams().put("inException", new Parameter("eq", (Object)true));
        param.getParams().put("exceptionEndDate", new Parameter("le", (Object)DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date())));
        List ex = this.supplierService.queryList(param);
        if (ListUtil.isNotEmpty((List)ex)) {
            for (SupplierEntity supplierEntity : ex) {
                supplierEntity.setInException(false);
                supplierEntity.setPunishType(null);
                supplierEntity.setPunishApplyOrg(null);
                supplierEntity.setPunishDate(null);
                supplierEntity.setPunishGrade(null);
                supplierEntity.setPunishMemo(null);
                supplierEntity.setPunishApplyPerson(null);
            }
            this.logger.info("\u6b64\u6b21\u5f02\u5e38\u4f9b\u5e94\u5546\u5e93\u4e00\u5171\u6709{}\u4e2a\u5373\u5c06\u6062\u590d\u6b63\u5e38\u4f9b\u5e94\u5546\uff01", (Object)ex.size());
            this.supplierService.saveOrUpdateBatch(ex);
        } else {
            this.logger.info("\u6b64\u6b21\u5f02\u5e38\u4f9b\u5e94\u5546\u5e93\u4e00\u5171\u67090\u4e2a\u5373\u5c06\u6062\u590d\u6b63\u5e38\u4f9b\u5e94\u5546\uff01");
        }
        this.logger.info("<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\u5f02\u5e38\u4f9b\u5e94\u5546\u5e93\u6062\u590d\u66f4\u65b0\u5b8c\u6210");
    }
}

