package com.ejianc.foundation.share.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.bean.*;
import com.ejianc.foundation.share.service.IProjectSetService;
import com.ejianc.foundation.share.vo.*;
import com.ejianc.foundation.share.vo.dto.ProjectPoolDTO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author CJ
 * @Description:
 * @date 2020/6/30 15:03
 */
@RestController
@RequestMapping("/api/projectPoolSetApi/")
public class ProjectSetApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProjectSetService projectSetService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IOrgApi orgApi;

    /**
     * 推送，生成项目池
     *
     * @return
     */
    @PostMapping(value = "pushProjectPoolSet")
    public CommonResponse<String> pushSupplierToShare(@RequestBody byte[] supplyByte) {
        String supplyStr = new String(supplyByte, StandardCharsets.UTF_8);
        logger.info("推送，生成项目池pushProjectPoolSet---{}", supplyStr);
        ProjectPoolSetVO projectPoolSetVO = JSONObject.parseObject(supplyStr, ProjectPoolSetVO.class);
        ProjectSetPoolEntity entity = BeanMapper.map(projectPoolSetVO, ProjectSetPoolEntity.class);
        /** 各种状态初始化 */
        entity.setProjectStatus("1");
        entity.setBusinessStatus("1");
        entity.setSettleStatus("1");
        entity.setArchiveStatus("10");
        entity.setCapitalStatus("14");
        entity.setReadNum("是");

        /** 先删除以前数据 */
        List<Long> ids = new ArrayList<>();
        ids.add(entity.getId());
        projectSetService.deleteProjectById(ids);

        /** 再新增*/
        projectSetService.saveOrUpdate(entity, false);
        return CommonResponse.success("保存成功！");
    }

    /**
     * 撤回 项目立项 删除项目池对应数据
     *
     * @return
     */
    @GetMapping(value = "callBackProjectPool")
    public CommonResponse<String> callBackProjectPool(@RequestParam Long id) {
        ProjectSetPoolEntity entity = projectSetService.selectById(id);
        if(entity == null){
            return CommonResponse.error("没有找到该项目立项对应的项目信息！");
        }
        // 参数是单据类型编码字符串 根据需求是否打开下面代码
        CommonResponse<String> resp = billTypeApi.checkQuote("BT220218000000001", entity.getId());
        if(!resp.isSuccess()){
            return CommonResponse.error(resp.getMsg());
        }
        projectSetService.removeById(id);
        logger.info("项目已被撤回！"+JSONObject.toJSONString(entity));
        return CommonResponse.success("删除项目池对应数据成功！");
    }

    /***
     * @description: 更改项目业务状态
     *
     * @param projectId      项目id
     * @param businessStatus 业务状态
     * @return: com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     * @author songlx
     * @date: 2022/3/21
     */
    @Deprecated
    @GetMapping(value = "changeProjectBusinessStatus")
    public CommonResponse<String> changeProjectBusinessStatus(@RequestParam(value = "projectId") Long projectId, @RequestParam(value = "businessStatus") String businessStatus) {
        if (projectId == null || StringUtils.isEmpty(businessStatus)) {
            return CommonResponse.error("projectId和businessStatus不能为空！");
        }
        LambdaUpdateWrapper<ProjectSetPoolEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(ProjectSetPoolEntity::getId, projectId);
        updateWrapper.set(ProjectSetPoolEntity::getBusinessStatus, businessStatus);
        projectSetService.update(updateWrapper);
        ProjectSetPoolEntity poolEntity = projectSetService.selectById(projectId);
        if(poolEntity == null){
            return CommonResponse.error("项目不存在！");
        }
        changeOrgStatus(poolEntity.getProjectDepartmentId(),poolEntity.getProjectStatus());
        return CommonResponse.success("更改项目业务状态成功！");
    }

    /**
     * @param projectId       项目id
     * @param projectStatus   项目状态：1、在建 2、项目中止 3、竣工 4、保修
     * @param businessStatus  业务状态：1、开工准备 2、在施 3、停工 5、完工 4、项目中止 6、竣工验收 12、保修中 13、保修结束
     * @param settleStatus    结算状态：1、未决算 8、决算中 9、已决算
     * @param archiveStatus   归档状态：10、资料未归档 11、资料已归档
     * @param capitalStatus   资金管控状态：14、开账正常 15、资金冻结 16、成本关门  17、已销账
     * @return: com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     * @description: 更新项目各种状态，为空则不更新该状态，不为空则更新,同时更新该项目的父项目相关状态
     * @date: 2022/8/24
     */
    @GetMapping(value = "changeProjectStatus")
    public CommonResponse<String> changeProjectStatus(@RequestParam(value = "projectId") Long projectId,
                                                      @RequestParam(value = "projectStatus",required = false) String projectStatus,
                                                      @RequestParam(value = "businessStatus",required = false) String businessStatus,
                                                      @RequestParam(value = "settleStatus",required = false) String settleStatus,
                                                      @RequestParam(value = "archiveStatus",required = false) String archiveStatus,
                                                      @RequestParam(value = "capitalStatus",required = false) String capitalStatus) {
        if (projectId == null) {
            return CommonResponse.error("projectId不能为空！");
        }
        ProjectSetPoolEntity poolEntity = projectSetService.selectById(projectId);
        if(poolEntity == null){
            return CommonResponse.error("项目不存在！");
        }
        boolean noChange = true;
        if(StringUtils.isNotEmpty(projectStatus)){
            noChange = false;
            poolEntity.setProjectStatus(projectStatus);
        }
        if(StringUtils.isNotEmpty(businessStatus)){
            noChange = false;
            poolEntity.setBusinessStatus(businessStatus);
        }
        if(StringUtils.isNotEmpty(settleStatus)){
            noChange = false;
            poolEntity.setSettleStatus(settleStatus);
        }
        if(StringUtils.isNotEmpty(archiveStatus)){
            noChange = false;
            poolEntity.setArchiveStatus(archiveStatus);
        }
        if(StringUtils.isNotEmpty(capitalStatus)){
            noChange = false;
            poolEntity.setCapitalStatus(capitalStatus);
        }
        if(noChange){
            return CommonResponse.error("未改变任何状态！");
        }
        projectSetService.saveOrUpdate(poolEntity,false);
        if(poolEntity.getParentProjectId()!=null){
            /** 自动更新父项目状态 */
            ProjectSetPoolEntity parent = projectSetService.selectById(poolEntity.getParentProjectId());
            if(parent != null){
               /** 找出所有子项目 */
               QueryParam param = new QueryParam();
               param.getParams().put("parentProjectId",new Parameter(QueryParam.EQ,parent.getId()));
               List<ProjectSetPoolEntity> children = projectSetService.queryList(param);
               if(ListUtil.isNotEmpty(children)){
                   /**
                    * 父项目的各类状态的处理
                    * 原则：父项目的各类状态，取值各个子项目的最高优先级的状态值
                    *
                    * 1) “项目状态”的优先级：在建>项目中止>竣工>保修
                    * 2) “业务状态”的优先级：开工准备>在建>停工>完工>项目中止>竣工验收>保修中>保修结束
                    * 3) “结算状态”的优先级：未结算>决算中>已决算
                    * 4) “资料归档状态”的优先级：资料未归档>资料已归档
                    * 5) “资金管控状态”的优先级：开账正常>资金冻结>成本关门>已销账
                    * */
                   /** 项目状态 */
                   List<String> status = children.stream().map(ProjectSetPoolEntity::getProjectStatus).sorted(Comparator.comparingInt(Integer::valueOf)).collect(Collectors.toList());
                   logger.info("项目状态：{}",JSONObject.toJSONString(status));
                   parent.setProjectStatus(status.get(0));
                   /** 业务状态 */
                   status = children.stream().map(ProjectSetPoolEntity::getBusinessStatus).sorted(Comparator.comparingInt(Integer::valueOf)).collect(Collectors.toList());
                   logger.info("业务状态：{}",JSONObject.toJSONString(status));
                   parent.setBusinessStatus(status.get(0));
                   /** 结算状态 */
                   status = children.stream().map(ProjectSetPoolEntity::getSettleStatus).sorted(Comparator.comparingInt(Integer::valueOf)).collect(Collectors.toList());
                   logger.info("结算状态：{}",JSONObject.toJSONString(status));
                   parent.setSettleStatus(status.get(0));
                   /** 归档状态 */
                   status = children.stream().map(ProjectSetPoolEntity::getArchiveStatus).sorted(Comparator.comparingInt(Integer::valueOf)).collect(Collectors.toList());
                   logger.info("归档状态：{}",JSONObject.toJSONString(status));
                   parent.setArchiveStatus(status.get(0));
                   /** 资金管控状态 */
                   status = children.stream().map(ProjectSetPoolEntity::getCapitalStatus).sorted(Comparator.comparingInt(Integer::valueOf)).collect(Collectors.toList());
                   logger.info("资金管控状态：{}",JSONObject.toJSONString(status));
                   parent.setCapitalStatus(status.get(0));
                   projectSetService.saveOrUpdate(parent);
               }else {
                   logger.info("子项目列表为空不处理 -- {} ",JSONObject.toJSONString(poolEntity));
               }
                /** 为空不处理*/
            }else {
                logger.info("父项目为空不处理 -- {} ",JSONObject.toJSONString(poolEntity));
            }
            /** 为空不处理*/
        }else {
            logger.info("父项目id为空不处理 -- {} ",JSONObject.toJSONString(poolEntity));
        }
        changeOrgStatus(poolEntity.getProjectDepartmentId(),poolEntity.getProjectStatus());
        return CommonResponse.success("更改项目业务状态成功！");
    }

    private void changeOrgStatus(Long orgId,String status){
        CommonResponse<OrgVO> response = orgApi.getOneById(orgId);
        if(response.isSuccess() && response.getData()!=null){
            OrgVO orgVO = response.getData();
            if(!(Objects.equals(1,orgVO.getProjectState()) && Objects.equals("1",status))){
                if(Objects.equals("1",status)){
                    orgVO.setProjectState(1);
                }else {
                    orgVO.setProjectState(2);
                }
                orgApi.saveOrgInfo(orgVO);
            }
        }
    }

    /**
     * 根据id查询项目数据
     * @param projectId
     * @return
     */
    @GetMapping(value = "getProjectId")
    public CommonResponse<ProjectPoolSetVO> getProjectId(@RequestParam(value = "projectId") Long projectId) {
        if (projectId == null ) {
            return CommonResponse.error("projectId不能为空！");
        }
        ProjectSetPoolEntity projectSetPoolEntity =projectSetService.selectById(projectId);
        ProjectPoolSetVO vo =BeanMapper.map(projectSetPoolEntity,ProjectPoolSetVO.class);
        return CommonResponse.success("查询数据成功",vo);
    }

    /**
     * 根据集合查询多条数据
     * @param projectIds
     * @return
     */
    @PostMapping(value = "getProjectListIds")
    public CommonResponse<List<ProjectPoolDTO>> getProjectListIds(@RequestBody List<Long> projectIds) {
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter(QueryParam.IN, projectIds));
        List<ProjectSetPoolEntity> list =projectSetService.queryList(param);
        List<ProjectPoolDTO> dtoList =BeanMapper.mapList(list,ProjectPoolDTO.class);
        return CommonResponse.success("查询数据成功",dtoList);
    }

    public static void main(String[] args) {
        List<String> sort = new ArrayList<>();
        sort.add("10");
        sort.add("3");
        sort.add("12");
        sort.add("6");
        sort.add("22");
        sort.add("8");
        sort.sort(Comparator.comparingInt(Integer::valueOf));
        System.out.println(JSONObject.toJSONString(sort));
        sort.sort(Comparator.comparingInt(Integer::parseInt));
        System.out.println(JSONObject.toJSONString(sort));
    }
}
