package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.bean.ProjectSetPoolEntity;
import com.ejianc.foundation.share.service.IProjectSetService;
import com.ejianc.foundation.util.HttpToolKitZd4;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import java.util.Calendar;
import java.util.Date;
import java.util.List;

@RestController
@RequestMapping("/zd4/project/")
public class Zd4ProjectSyncController {
    private Logger logger = LoggerFactory.getLogger(getClass());

    @Value("${zd4.syncBaseHost:0}")
    private String syncBaseHost;//同步接口地址
    @Value("${zd4.appid:0}")
    private String appid;
    @Value("${zd4.secret:0}")
    private String secret;
    private static final Calendar calendar = Calendar.getInstance(); //创建Calendar 的实例

    @Autowired
    private IProjectSetService projectSetService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IEmployeeApi iEmployeeApi;


    @GetMapping("syncAll")
    @ResponseBody
    public CommonResponse<String> syncAll() {
        return syncProject(new JSONObject());
    }

    @GetMapping("syncDaily")
    @ResponseBody
    public CommonResponse<String> syncDaily() {
        calendar.setTime(new Date());
        calendar.add(Calendar.DAY_OF_MONTH, -2);
        JSONObject parems = new JSONObject();
        parems.put("BeginDateTime", DateFormatUtil.formatDate(DateFormatUtil.PATTERN_ISO_ON_DATE, calendar.getTime()));
//        parems.put("BeginDateTime", "2023-12-02");
        calendar.setTime(new Date());
        calendar.add(Calendar.DAY_OF_MONTH, 1);
        parems.put("BeginDateTime", DateFormatUtil.formatDate(DateFormatUtil.PATTERN_ISO_ON_DATE, calendar.getTime()));
//        parems.put("EndDateTime", "2023-12-06");
        return syncProject(parems);
    }

    /**
     * 同步项目以及项目下人员兼职数据
     * <p>
     * {
     * "Account_Project_id": "FWE0023",                                 //项目编码
     * "Account_Project_shortname": "FWE002",                           //项目名称
     * "Area": "中国,北京市,东城区",                                        //项目地区
     * "AuditingEngineer": "康利聪",
     * "AuditingEngineer_SID": "000a8211-0000-0000-0000-0000c7c1de56",
     * "C_CM_AccountingProjectSetOID": "0008e5c0-0000-0000-0000-00008ada7ae1", //项目主键
     * "DIVISION_Name": "信息中心",
     * "Dept_name": "信息中心",                                          //项目所属组织名称
     * "Dept_sid": "0005103b-0000-0005-0000-00004a339977",              //项目所属组织id
     * "DetArea": "22121232332323232",                                  //项目地址
     * "ProjectManager": "陈生",
     * "ProjectManager_Sid": "000fa92c-0000-0000-0000-000023b7ccfd",    //项目经理主键
     * "Project_SuBList": [
     * {
     * "BeginTime": "2022/6/22 18:01:06",
     * "CON_EMP_NUM": "105265",
     * "C_CM_AccountingProjectSet_SuBOID": "7247d656-1100-4cde-aa40-0bb36edb71f0",
     * "EndTime": "1900/1/1 0:00:00",
     * "EstimateEndTime": "1900/1/1 0:00:00",
     * "HeadName": "康利聪",
     * "HeadSID": "000A8211-0000-0000-0000-0000C7C1DE56",
     * "IsScene": "1",
     * "Title": "项目经理",
     * "Title_ID": "3401"
     * }
     * ],
     * "Project_status": "外结完成"
     * }
     */
    private CommonResponse<String> syncProject(JSONObject parems) {
        logger.info("中电4公司同步项目以及项目下人员兼职数据 开始------url={}{},---params={}", syncBaseHost, "/cefoc/yql/getProjectList", parems.toJSONString());
        try {
            HttpToolKitZd4.setSecureAccount(appid, secret);
            String res = HttpToolKitZd4.post(syncBaseHost + "/cefoc/yql/getProjectList", parems.toJSONString());
            logger.info(res);
            if (StringUtils.isNotEmpty(res)) {
                JSONObject jsonObject = JSONObject.parseObject(res);
                if ("ok".equals(jsonObject.getString("status"))) {
                    if (jsonObject.getInteger("allCount") > 0) {
                        JSONArray dataArray = jsonObject.getJSONArray("data");
                        QueryParam param = new QueryParam();
                        param.getParams().put("tenantId", Parameter.getEqInstance(999999L));
                        for (Object o : dataArray) {
                            JSONObject object = (JSONObject) o;
                            param.getParams().put("sourceId", Parameter.getEqInstance(object.getString("C_CM_AccountingProjectSetOID")));
                            List<ProjectSetPoolEntity> entities = projectSetService.queryList(param);
                            ProjectSetPoolEntity poolEntity = null;
                            CommonResponse<OrgVO> response = iOrgApi.findBySourceId(object.getString("Dept_sid"));
                            if (!response.isSuccess() || response.getData() == null) {
                                logger.info("中电4公司同步项目以及项目下人员兼职数据失败！！！查询项目所属组织失败！{}", JSONObject.toJSONString(response));
                                continue;
                            }
                            OrgVO orgVO = response.getData();
                            if (ListUtil.isNotEmpty(entities)) {
                                /** 更新项目 */
                                poolEntity = entities.get(0);
                            } else {
                                /** 新增项目 */
                                poolEntity = new ProjectSetPoolEntity();
                                poolEntity.setBillState(1);
                                poolEntity.setNationalName("中国");
                                poolEntity.setNationalId(493873812443236045L);
                                poolEntity.setSourceId(object.getString("C_CM_AccountingProjectSetOID"));
                            }
                            poolEntity.setOrgId(orgVO.getId());
                            poolEntity.setOrgName(orgVO.getName());
                            poolEntity.setName(object.getString("Account_Project_shortname"));
                            poolEntity.setShortName(object.getString("Account_Project_shortname"));
                            poolEntity.setCode(object.getString("Account_Project_id"));
                            poolEntity.setProjectStatus(object.getString("Project_status"));
                            poolEntity.setAreaName(StringUtils.isNotEmpty(object.getString("Area")) ? object.getString("Area").replace(",", "/") : null);
                            poolEntity.setAddress(object.getString("DetArea"));

                            if (StringUtils.isNotEmpty(object.getString(""))) {
                                CommonResponse<EmployeeVO> response1 = iEmployeeApi.getOneBySourceId(object.getString("ProjectManager_Sid"));
                                if (response1.isSuccess() && response1.getData() != null) {
                                    EmployeeVO employeeVO = response1.getData();
                                    poolEntity.setProjectManagementId(employeeVO.getUserId());
                                    poolEntity.setProjectManagementName(employeeVO.getName());
                                } else {
                                    logger.info("查询项目经理信息失败！{}", JSONObject.toJSONString(response1));
                                    continue;
                                }
                            }
                            OrgVO projectDepartment = generateProjectDepartment(poolEntity, orgVO);
                            poolEntity.setProjectDepartmentId(projectDepartment.getId());
                            poolEntity.setProjectDepartmentName(projectDepartment.getName());
                            CommonResponse<OrgVO> resp = iOrgApi.saveOrgInfo(projectDepartment);
                            if (!resp.isSuccess()) {
                                logger.info("中电4公司同步项目以及项目下人员兼职数据失败，保存项目部组织信息出错: " + resp.getMsg());
                                continue;
                            }
                            /** 保存或更新项目信息 */
                            projectSetService.saveOrUpdate(poolEntity, false);
                            /** 处理项目的人员兼职信息 */
                            JSONArray array = object.getJSONArray("Project_SuBList");
                            if (array != null && array.size() > 0) {
                                for (Object o1 : array) {
                                    JSONObject data = (JSONObject) o1;
                                    data.put("projectDepartmentId", projectDepartment.getId());
                                }
                                iEmployeeApi.partJobBeachForZd4(array);
                            }
                        }
                    }
                } else {
                    logger.info("中电4公司同步项目以及项目下人员兼职数据失败！！！{}", res);
                    return CommonResponse.error("中电4公司同步项目以及项目下人员兼职数据失败!" + res);
                }
            } else {
                logger.info("中电4公司同步项目以及项目下人员兼职数据失败！！！响应数据为空---{}", res);
                return CommonResponse.error("中电4公司同步组织失败!响应数据为空");
            }
        } catch (Exception e) {
            logger.info("中电4公司同步项目以及项目下人员兼职数据失败！！！{}", e.getMessage());
            e.printStackTrace();
            return CommonResponse.error("中电4公司同步项目以及项目下人员兼职数据失败!" + e.getMessage());
        }
        logger.info("中电4公司同步项目以及项目下人员兼职数据成功！！！------666------");
        return CommonResponse.success("中电4公司同步项目以及项目下人员兼职数据成功！");
    }

    /**
     * 生成项目对应的项目部信息
     *
     * @param
     * @return
     */
    private OrgVO generateProjectDepartment(ProjectSetPoolEntity poolEntity, OrgVO parentOrg) {
        OrgVO projectDepartment = null;
        if (poolEntity.getProjectDepartmentId() != null) {
            projectDepartment = iOrgApi.getOneById(poolEntity.getProjectDepartmentId()).getData();
        } else {
            projectDepartment = new OrgVO();
            projectDepartment.setId(IdWorker.getId());
            projectDepartment.setTenantId(999999L);
            projectDepartment.setName(poolEntity.getName());
            projectDepartment.setShortName(poolEntity.getShortName());
            projectDepartment.setState(1);
            //项目部类型
            projectDepartment.setOrgType(OrgVO.ORG_TYPE_DEPARTMENT);
        }
        projectDepartment.setIsParent(false);
        projectDepartment.setProjectCode(poolEntity.getCode());
        projectDepartment.setEnterpriseId(parentOrg.getEnterpriseId());
        projectDepartment.setParentId(parentOrg.getId());
        projectDepartment.setNote("主数据生成项目部！时间：" + DateFormatUtil.formatDate(DateFormatUtil.PATTERN_DEFAULT_ON_SECOND, new Date()));
        return projectDepartment;
    }
}
