package com.ejianc.foundation.share.controller.api;

import com.ejianc.foundation.share.service.ISupplierLinkerService;
import com.ejianc.foundation.share.vo.SupplierLinkerVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2024/1/30 16:06
 */
@RestController
@RequestMapping(value = "/api/shareSupplierLinkerApi")
public class SupplierLinkerApi {

    @Autowired
    private ISupplierLinkerService service;

    /**
     * 同步准入数据
     *
     * @return
     */
    @PostMapping(value = "/getBySourceIds")
    public CommonResponse<List<SupplierLinkerVO>> getBySourceIds(@RequestBody List<Long> sourceIds) {
        List<SupplierLinkerVO> vos = service.getBySourceIds(sourceIds);
        return CommonResponse.success("查询成功", vos);
    }
}
