package com.ejianc.foundation.share.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.share.vo.ProsubItemVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.foundation.share.bean.ProsubItemEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 专业分包档案
 * 
 * @author generator
 * 
 */
@Mapper
public interface ProsubItemMapper extends BaseCrudMapper<ProsubItemEntity> {

    int updateByCategoryId(@Param("categoryId") Long categoryId,@Param("subjectId") Long subjectId,@Param("subjectName") String subjectName);

    List<ProsubItemVO> queryProsubItemList(Page<ProsubItemVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper);

    // 根据ID查询数据，left join专业分包档案分类表"ejc_share_prosub_category"
    List<Map<String, Object>> queryProItemListByIds(@Param("idList") List<Long> idList, @Param("tenantId") Long tenantId);

    // 跟据分类ID查询分类表数据
    List<Map<String, Object>> queryProCategoryListByCategoryIds(@Param("categoryIdList") List<Long> categoryIdList, @Param("tenantId") Long tenantId);
}
