/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.supplierChange.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.share.vo.SupplierExcelVO;
import com.ejianc.foundation.supplierChange.bean.SupplierChangeEntity;
import com.ejianc.foundation.supplierChange.service.ISupplierChangeService;
import com.ejianc.foundation.supplierChange.vo.CertsChangeVO;
import com.ejianc.foundation.supplierChange.vo.SubleadersChangeVO;
import com.ejianc.foundation.supplierChange.vo.SupplierChangeVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/supplierChange"})
public class SupplierChangeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private ISupplierChangeService service;
    @Autowired
    private ISupplierService supplierService;
    @Autowired
    private IAttachmentApi attachmentApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    public CommonResponse<SupplierChangeVO> saveOrUpdate(@RequestBody SupplierChangeVO saveOrUpdateVO) {
        SupplierChangeEntity entity = (SupplierChangeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SupplierChangeEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        SupplierChangeVO vo = (SupplierChangeVO)BeanMapper.map((Object)((Object)entity), SupplierChangeVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    public CommonResponse<SupplierChangeVO> queryDetail(Long id) {
        SupplierChangeEntity entity = (SupplierChangeEntity)((Object)this.service.selectById(id));
        SupplierChangeVO vo = (SupplierChangeVO)BeanMapper.map((Object)((Object)entity), SupplierChangeVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public CommonResponse<String> delete(@RequestBody List<SupplierChangeVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SupplierChangeVO supplierChangeVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    public CommonResponse<IPage<SupplierChangeVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        fuzzyFields.add("material_content");
        fuzzyFields.add("equipment_content");
        fuzzyFields.add("equipment_content");
        fuzzyFields.add("major_content");
        fuzzyFields.add("laborContent");
        fuzzyFields.add("subContent");
        fuzzyFields.add("otherContent");
        fuzzyFields.add("revolvMaterialContent");
        fuzzyFields.add("consultContent");
        fuzzyFields.add("apply_org_name");
        fuzzyFields.add("tax_payer_identifier");
        fuzzyFields.add("supplyTypeName");
        fuzzyFields.add("areaName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (param.getParams().get("insideOrg") != null) {
            if ("true".equals(((Parameter)param.getParams().get("insideOrg")).getValue())) {
                param.getParams().put("insideOrg", new Parameter("eq", (Object)true));
            } else {
                param.getParams().put("insideOrg", new Parameter("eq", (Object)false));
            }
        }
        param.getParams().put("supplierFlag", new Parameter("in", (Object)"1,3"));
        if (null != param.getParams().get("supplyType")) {
            String[] supplyTypes = ((Parameter)param.getParams().get("supplyType")).getValue().toString().split(",");
            ComplexParam c1 = new ComplexParam();
            c1.setLogic("and");
            for (String supplyType : supplyTypes) {
                ComplexParam c = new ComplexParam();
                c.setLogic("or");
                c.getParams().put("supplyType", new Parameter("like", (Object)supplyType));
                c1.getComplexParams().add(c);
            }
            param.getComplexParams().add(c1);
            param.getParams().remove("supplyType");
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SupplierChangeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryDetails"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SupplierChangeVO> queryDetails(@RequestParam Long id) {
        SupplierChangeEntity supplierChange = (SupplierChangeEntity)((Object)this.service.selectById(id));
        if (supplierChange == null) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25");
        }
        SupplierChangeVO resp = (SupplierChangeVO)BeanMapper.map((Object)((Object)supplierChange), SupplierChangeVO.class);
        return CommonResponse.success((Object)resp);
    }

    @GetMapping(value={"/addSupplierChange"})
    public CommonResponse<SupplierChangeVO> addSupplierChange(@RequestParam Long supplierId) {
        CommonResponse fileCopyResp;
        CommonResponse subFileCopyResp;
        SupplierChangeEntity saveEntity = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"source_supplier_id", (Object)supplierId);
        query.notIn((Object)"bill_state", new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        saveEntity = (SupplierChangeEntity)((Object)this.service.getOne((Wrapper)query));
        if (null != saveEntity) {
            return CommonResponse.error((String)"\u8be5\u4f9b\u5e94\u5546\u5df2\u6709\u672a\u751f\u6548\u7684\u53d8\u66f4\u5355\uff01");
        }
        SupplierEntity supplier = (SupplierEntity)((Object)this.supplierService.selectById(supplierId));
        SupplierChangeVO resp = (SupplierChangeVO)BeanMapper.map((Object)((Object)supplier), SupplierChangeVO.class);
        resp.setSourceSupplierId(resp.getId());
        resp.setId(Long.valueOf(IdWorker.getId()));
        if (CollectionUtils.isNotEmpty((Collection)resp.getCerts())) {
            for (CertsChangeVO cert : resp.getCerts()) {
                cert.setPid(resp.getId());
                cert.setSourceSupplierCertId(cert.getId());
                cert.setSourceSupplierId(supplierId);
                cert.setRowState("edit");
                subFileCopyResp = this.attachmentApi.copyFiles(cert.getSourceSupplierCertId().toString(), null, null, cert.getId().toString(), null, null, false);
                if (subFileCopyResp.isSuccess()) continue;
                throw new BusinessException("\u52a0\u8f7d\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff0c\u5206\u5305\u8d1f\u8d23\u4eba\u9644\u4ef6\u590d\u5236\u5931\u8d25\uff01");
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)resp.getSubLeaders())) {
            for (SubleadersChangeVO subLeader : resp.getSubLeaders()) {
                subLeader.setSourceSupplierId(supplierId);
                subLeader.setSourceSupplierSubLeaderId(subLeader.getId());
                subLeader.setId(Long.valueOf(IdWorker.getId()));
                subLeader.setRowState("edit");
                subFileCopyResp = this.attachmentApi.copyFiles(subLeader.getSourceSupplierSubLeaderId().toString(), null, null, subLeader.getId().toString(), null, null, false);
                if (subFileCopyResp.isSuccess()) continue;
                throw new BusinessException("\u52a0\u8f7d\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff0c\u5206\u5305\u8d1f\u8d23\u4eba\u9644\u4ef6\u590d\u5236\u5931\u8d25\uff01");
            }
        }
        if (!(fileCopyResp = this.attachmentApi.copyFiles(resp.getSourceSupplierId().toString(), null, null, resp.getId().toString(), null, null, false)).isSuccess()) {
            throw new BusinessException("\u52a0\u8f7d\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff0c\u4f9b\u5e94\u5546\u9644\u4ef6\u590d\u5236\u5931\u8d25\uff01");
        }
        resp.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        resp.setCreateTime(null);
        resp.setCreateUserCode(null);
        resp.setUpdateTime(null);
        resp.setUpdateUserCode(null);
        saveEntity = (SupplierChangeEntity)((Object)BeanMapper.map((Object)resp, SupplierChangeEntity.class));
        this.service.saveOrUpdate((Object)saveEntity, false);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)saveEntity), SupplierChangeVO.class));
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        fuzzyFields.add("material_content");
        fuzzyFields.add("equipment_content");
        fuzzyFields.add("equipment_content");
        fuzzyFields.add("major_content");
        fuzzyFields.add("laborContent");
        fuzzyFields.add("subContent");
        fuzzyFields.add("otherContent");
        fuzzyFields.add("revolvMaterialContent");
        fuzzyFields.add("consultContent");
        fuzzyFields.add("apply_org_name");
        fuzzyFields.add("tax_payer_identifier");
        fuzzyFields.add("supplyTypeName");
        fuzzyFields.add("areaName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        if (param.getParams().get("insideOrg") != null) {
            if ("true".equals(((Parameter)param.getParams().get("insideOrg")).getValue())) {
                param.getParams().put("insideOrg", new Parameter("eq", (Object)true));
            } else {
                param.getParams().put("insideOrg", new Parameter("eq", (Object)false));
            }
        }
        param.getParams().put("supplierFlag", new Parameter("in", (Object)"1,3"));
        if (null != param.getParams().get("supplyType")) {
            String[] supplyTypes = ((Parameter)param.getParams().get("supplyType")).getValue().toString().split(",");
            ComplexParam c1 = new ComplexParam();
            c1.setLogic("and");
            for (String supplyType : supplyTypes) {
                ComplexParam c = new ComplexParam();
                c.setLogic("or");
                c.getParams().put("supplyType", new Parameter("like", (Object)supplyType));
                c1.getComplexParams().add(c);
            }
            param.getComplexParams().add(c1);
            param.getParams().remove("supplyType");
        }
        List list = this.service.queryList(param);
        HashMap beans = new HashMap();
        ArrayList suppliers = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            list.forEach(supplierVo -> {
                SupplierExcelVO excelVO = (SupplierExcelVO)BeanMapper.map((Object)supplierVo, SupplierExcelVO.class);
                excelVO.setPersonal("p".equals(supplierVo.getPersonal()) ? "\u4e2a\u4eba" : "\u4f01\u4e1a");
                excelVO.setGroupInOrOut("in".equals(supplierVo.getGroupInOrOut()) ? "\u96c6\u56e2\u5185" : "\u96c6\u56e2\u5916");
                excelVO.setInsideOrg(supplierVo.getInsideOrg() != null && Integer.valueOf("1").equals(supplierVo.getInsideOrg()) ? "\u5185\u90e8\u5355\u4f4d" : "\u5916\u90e8\u5355\u4f4d");
                excelVO.setCoordination(supplierVo.getCoordination() != null && Integer.valueOf("1").equals(supplierVo.getCoordination()) ? "\u5df2\u534f\u540c" : "\u672a\u534f\u540c");
                if (supplierVo.getPunishType() != null) {
                    try {
                        JSONArray array = ReferObjectUtil.getReferEntityValue((String)supplierVo.getPunishType().toString(), (String)"abnormal_grade");
                        if (array != null && array.size() > 0) {
                            excelVO.setPunishType(array.getJSONObject(0).getString("name"));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                String content = "";
                if (StringUtils.isNotEmpty((CharSequence)supplierVo.getMaterialContent())) {
                    content = content + supplierVo.getMaterialContent();
                }
                if (StringUtils.isNotEmpty((CharSequence)supplierVo.getEquipmentContent())) {
                    content = content + supplierVo.getEquipmentContent();
                }
                if (StringUtils.isNotEmpty((CharSequence)supplierVo.getLaborContent())) {
                    content = content + supplierVo.getLaborContent();
                }
                if (StringUtils.isNotEmpty((CharSequence)supplierVo.getMajorContent())) {
                    content = content + supplierVo.getMajorContent();
                }
                if (StringUtils.isNotEmpty((CharSequence)supplierVo.getConsultContent())) {
                    content = content + supplierVo.getConsultContent();
                }
                if (StringUtils.isNotEmpty((CharSequence)supplierVo.getRevolvMaterialContent())) {
                    content = content + supplierVo.getRevolvMaterialContent();
                }
                if (StringUtils.isNotEmpty((CharSequence)supplierVo.getRevolvMaterialContent())) {
                    content = content + supplierVo.getRevolvMaterialContent();
                }
                if (StringUtils.isNotEmpty((CharSequence)supplierVo.getSubContent())) {
                    content = content + supplierVo.getSubContent();
                }
                excelVO.setMaterialContent(content);
                excelVO.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)supplierVo.getBillState()).getDescription());
                suppliers.add(excelVO);
            });
        }
        beans.put("records", suppliers);
        ExcelExport.getInstance().export("supplier-change-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSupplierChangeData"}, method={RequestMethod.GET})
    public CommonResponse<IPage<SupplierChangeVO>> refSupplierChangeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SupplierChangeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

