/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.supplier.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.supplier.bean.ShareSupplierEntity;
import com.ejianc.foundation.supplier.bean.ShareSupplierLinkerEntity;
import com.ejianc.foundation.supplier.service.IShareSupplierLinkerService;
import com.ejianc.foundation.supplier.service.IShareSupplierService;
import com.ejianc.foundation.supplier.vo.ShareSupplierLinkerVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"shareSupplierLinker"})
public class ShareSupplierLinkerController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IShareSupplierLinkerService service;
    @Autowired
    private IShareSupplierService shareSupplierService;

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    public CommonResponse<ShareSupplierLinkerVO> queryDetail(Long id) {
        ShareSupplierLinkerEntity entity = (ShareSupplierLinkerEntity)((Object)this.service.selectById(id));
        ShareSupplierLinkerVO vo = (ShareSupplierLinkerVO)BeanMapper.map((Object)((Object)entity), ShareSupplierLinkerVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @GetMapping(value={"/getAllBySupplierId"})
    public CommonResponse<List<ShareSupplierLinkerVO>> getAllBySupplierId(@RequestParam Long id) {
        List resp = new ArrayList();
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"supplier_id", (Object)id);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        List list = this.service.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            resp = BeanMapper.mapList((Iterable)list, ShareSupplierLinkerVO.class);
        }
        return CommonResponse.success(resp);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public CommonResponse<String> delete(@RequestBody List<ShareSupplierLinkerVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ShareSupplierLinkerVO shareSupplierLinkerVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    public CommonResponse<IPage<ShareSupplierLinkerVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ShareSupplierLinkerVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ShareSupplierLinker-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refShareSupplierLinkerData"}, method={RequestMethod.GET})
    public CommonResponse<IPage<ShareSupplierLinkerVO>> refShareSupplierLinkerData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ShareSupplierLinkerVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"/accCoordination"})
    public CommonResponse<ShareSupplierLinkerVO> accCoordination(@RequestBody ShareSupplierLinkerVO linkerVO) {
        ShareSupplierEntity supplier = (ShareSupplierEntity)((Object)this.shareSupplierService.selectById(linkerVO.getId()));
        if (Integer.valueOf("0").equals(supplier.getCoordination())) {
            this.shareSupplierService.createSupTenant(supplier);
        }
        ShareSupplierLinkerEntity linker = (ShareSupplierLinkerEntity)((Object)this.service.selectById(linkerVO.getId()));
        ShareSupplierLinkerVO vo = this.service.createSupAccount(linker);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)vo);
    }
}

