package com.ejianc.foundation.share.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.share.bean.SupplierLinkerEntity;
import com.ejianc.foundation.share.mapper.SupplierLinkerMapper;
import com.ejianc.foundation.share.service.ISupplierLinkerService;
import com.ejianc.foundation.share.vo.ShareSupLinkerVO;
import com.ejianc.foundation.share.vo.SupplierLinkerVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class SupplierLinkerServiceImpl extends BaseServiceImpl<SupplierLinkerMapper, SupplierLinkerEntity> implements ISupplierLinkerService {

	@Autowired
	private SupplierLinkerMapper supplierLinkerMapper;
	
	@Override
	public void deleteBySupplierId(Long supplierId) {
		QueryWrapper<SupplierLinkerEntity> deleteWrapper = new QueryWrapper<>();
		deleteWrapper.eq("supplier_id", supplierId);
		supplierLinkerMapper.delete(deleteWrapper);
	}

	@Override
	public SupplierLinkerVO queryBySupplierIdAndLinkman(Long supplierId, String linkman) {
		QueryWrapper<SupplierLinkerEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("supplier_id", supplierId);
		queryWrapper.eq("link_man", linkman);
		
		List<SupplierLinkerEntity> entities = supplierLinkerMapper.selectList(queryWrapper);
		if(entities != null && entities.size() > 0) {
			return BeanMapper.map(entities.get(0), SupplierLinkerVO.class);
		}
		return null;
	}

	@Override
	public String defaultFlag(SupplierLinkerVO vo) {
		SupplierLinkerEntity entity = super.selectById(vo.getId());
		if(!NumberUtils.INTEGER_ONE.equals(vo.getDefaultFlag()) && !NumberUtils.INTEGER_ONE.equals(entity.getDefaultFlag())){
			throw new BusinessException("已经为非默认银行账户！");
		}
		if(NumberUtils.INTEGER_ONE.equals(vo.getDefaultFlag()) && NumberUtils.INTEGER_ONE.equals(entity.getDefaultFlag())){
			throw new BusinessException("已经为默认银行账户！");
		}
		if(!NumberUtils.INTEGER_ONE.equals(vo.getDefaultFlag()) && NumberUtils.INTEGER_ONE.equals(entity.getDefaultFlag())){
			throw new BusinessException("至少有一个为默认银行账户！");
		}
		// 处理默认
		QueryParam param = new QueryParam();
		param.getParams().put("supplierId", new Parameter(QueryParam.EQ, entity.getSupplierId()));
		param.getParams().put("defaultFlag", new Parameter(QueryParam.EQ, 1));
		List<SupplierLinkerEntity> dataList = super.queryList(param);
		if(NumberUtils.INTEGER_ONE.equals(vo.getDefaultFlag()) && CollectionUtils.isNotEmpty(dataList)){// 如果引入有默认，把之前的默认修改
			dataList.forEach(x->{
				x.setDefaultFlag(0);
			});
			super.saveOrUpdateBatch(dataList);
		}
		entity.setDefaultFlag(1);
		super.saveOrUpdate(entity, false);
		return "操作成功！";
	}

	@Override
	public List<ShareSupLinkerVO> getBySourceIds(List<String> sourceIds) {
		List<ShareSupLinkerVO> resp = new ArrayList<>();
		QueryWrapper<SupplierLinkerEntity> query = new QueryWrapper<>();
		query.in("source_id", sourceIds);
		query.eq("dr", BaseVO.DR_UNDELETE);
		List<SupplierLinkerEntity> list = super.list(query);

		if(CollectionUtils.isNotEmpty(list)) {
			resp = BeanMapper.mapList(list, ShareSupLinkerVO.class);
		}

		return resp;
	}

}
