package com.ejianc.foundation.supplier.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.supplier.bean.ShareSupplierLinkerEntity;
import com.ejianc.foundation.supplier.mapper.ShareSupplierLinkerMapper;
import com.ejianc.foundation.supplier.service.IShareSupplierLinkerService;
import com.ejianc.foundation.supplier.vo.ShareSupplierLinkerVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * 供应商联系人
 * 
 * @author generator
 * 
 */
@Service("shareSupplierLinkerService")
public class ShareSupplierLinkerServiceImpl extends BaseServiceImpl<ShareSupplierLinkerMapper, ShareSupplierLinkerEntity> implements IShareSupplierLinkerService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private final String REQ_URL = "/ejc-oms-web/openapi/enterprise/createOrUpdateUser";

    @Value("${eachLink.host}")
    private String host;

    @Value("${eachLink.appId}")
    private String appId;

    @Value("${eachLink.secret}")
    private String secret;

    @Autowired
    private ISystemDataPushService systemDataPushService;

    @Override
    public ShareSupplierLinkerVO createSupAccount(ShareSupplierLinkerEntity linker) {
        Map<String, String> reqParam = new HashMap<>();

        if(StringUtils.isBlank(linker.getLinkPhone())) {
            throw new BusinessException("联系人电话为空");
        }
        reqParam.put("linkMobile", linker.getLinkPhone());
        reqParam.put("linkName", linker.getLinkName());
        reqParam.put("linkSupType", getLinkSupType(linker.getLinkSupType()));
        reqParam.put("supplierAccRole", linker.getSupplierAccRole());
        reqParam.put("supplierTenantId", linker.getSupplierId().toString());

        CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(host+REQ_URL,
                reqParam,
                linker.getSupplierId().toString(),
                null);

        if(!syncReqResp.isSuccess()) {
            logger.error("供应商联系人id-{}生成协同账户失败，参数：{}, 结果：{}", linker.getId(), JSONObject.toJSONString(reqParam), JSONObject.toJSONString(syncReqResp));
        }
        CommonResponse<JSONObject> resp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
        if (!resp.isSuccess()) {
            logger.error("供应商联系人id-{}生成协同账户失败，参数：{}, 结果：{}", linker.getId(), JSONObject.toJSONString(reqParam), JSONObject.toJSONString(resp));
            throw new BusinessException("生成供方协同账户信息失败！");
        }

        linker.setSupplierAccFlag(1);
        super.saveOrUpdate(linker, false);

        return BeanMapper.map(linker, ShareSupplierLinkerVO.class);
    }

    private String getLinkSupType(String linkSupType) {
        StringBuilder sp = new StringBuilder();

        if(linkSupType.indexOf("labor") >= 0) {
            sp.append("labor,");
        }
        if(linkSupType.indexOf("material") >= 0) {
            sp.append("material,");
        }
        return sp.substring(0, sp.length()-1);
    }
}
