/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.supplier.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.share.bean.EjcCloudSystemEntity;
import com.ejianc.foundation.share.service.IEjcCloudSystemService;
import com.ejianc.foundation.supplier.bean.ShareSupplierEntity;
import com.ejianc.foundation.supplier.mapper.ShareSupplierMapper;
import com.ejianc.foundation.supplier.service.IShareSupplierService;
import com.ejianc.foundation.tenant.vo.TenantVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="shareSupplierService")
public class ShareSupplierServiceImpl
extends BaseServiceImpl<ShareSupplierMapper, ShareSupplierEntity>
implements IShareSupplierService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String REQ_URL = "/ejc-oms-web/openapi/enterprise/createOrUpdateTenant";
    @Value(value="${eachLink.host}")
    private String host;
    @Value(value="${eachLink.appId}")
    private String appId;
    @Value(value="${eachLink.secret}")
    private String secret;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IEjcCloudSystemService ejcCloudSystemService;

    @Override
    public TenantVO createSupTenant(ShareSupplierEntity supplier) {
        CommonResponse resp;
        HashMap<String, String> reqParam = new HashMap<String, String>();
        QueryParam param = new QueryParam();
        List list = this.ejcCloudSystemService.queryList(param, false);
        reqParam.put("socialCreditCode", supplier.getSocialCreditCode());
        reqParam.put("supplierType", this.getSupplierType(supplier));
        reqParam.put("systemId", ((EjcCloudSystemEntity)((Object)list.get(0))).getCode());
        reqParam.put("supplierName", supplier.getName());
        reqParam.put("supplierTenantId", supplier.getId().toString());
        CommonResponse syncReqResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(this.host + "/ejc-oms-web/openapi/enterprise/createOrUpdateTenant", reqParam, supplier.getId().toString(), null);
        if (!syncReqResp.isSuccess()) {
            this.logger.error("\u4f9b\u5e94\u5546id-{}\u751f\u6210\u534f\u540c\u79df\u6237\u5931\u8d25\uff0c\u53c2\u6570\uff1a{}, \u7ed3\u679c\uff1a{}", new Object[]{supplier.getId(), JSONObject.toJSONString(reqParam), JSONObject.toJSONString((Object)syncReqResp)});
        }
        if (!(resp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class)).isSuccess()) {
            this.logger.error("\u4f9b\u5e94\u5546id-{}\u751f\u6210\u534f\u540c\u79df\u6237\u5931\u8d25\uff0c\u53c2\u6570\uff1a{}, \u7ed3\u679c\uff1a{}", new Object[]{supplier.getId(), JSONObject.toJSONString(reqParam), JSONObject.toJSONString((Object)resp)});
            throw new BusinessException("\u751f\u6210\u4f9b\u65b9\u79df\u6237\u4fe1\u606f\u5931\u8d25\uff01");
        }
        TenantVO t = (TenantVO)JSONObject.parseObject((String)JSON.toJSONString((Object)resp.getData()), TenantVO.class);
        supplier.setCoordination(1);
        super.saveOrUpdate((Object)supplier, false);
        return t;
    }

    private String getSupplierType(ShareSupplierEntity supplier) {
        StringBuilder sp = new StringBuilder();
        if (StringUtils.isBlank((CharSequence)supplier.getLaborSourceId())) {
            sp.append("labor,");
        }
        if (StringUtils.isNotBlank((CharSequence)supplier.getMaterialSourceId())) {
            sp.append("material,");
        }
        return sp.substring(0, sp.length() - 1);
    }
}

