/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.bean.ProsubCategoryEntity;
import com.ejianc.foundation.share.bean.ProsubItemEntity;
import com.ejianc.foundation.share.bean.SubjectOrgEntity;
import com.ejianc.foundation.share.mapper.ProsubItemMapper;
import com.ejianc.foundation.share.service.IProsubCategoryService;
import com.ejianc.foundation.share.service.IProsubItemService;
import com.ejianc.foundation.share.service.ISubjectOrgService;
import com.ejianc.foundation.share.vo.ProsubItemImportVO;
import com.ejianc.foundation.share.vo.ProsubItemVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="prosubItemService")
public class ProsubItemServiceImpl
extends BaseServiceImpl<ProsubItemMapper, ProsubItemEntity>
implements IProsubItemService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "PSI_CODE";
    @Autowired
    private IProsubItemService service;
    @Autowired
    private IProsubCategoryService prosubCategoryService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ProsubItemMapper prosubItemMapper;
    @Autowired
    private ISubjectOrgService subjectOrgService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public CommonResponse updateByCategoryId(Long categoryId, Long subjectId, String subjectName) {
        int i = this.prosubItemMapper.updateByCategoryId(categoryId, subjectId, subjectName);
        return CommonResponse.success();
    }

    @Override
    public CommonResponse<JSONObject> excelProsubImport(HttpServletRequest request) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        ArrayList<ProsubItemImportVO> successList = new ArrayList<ProsubItemImportVO>();
        ArrayList<ProsubItemImportVO> errorList = new ArrayList<ProsubItemImportVO>();
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u4e13\u4e1a\u5206\u5305\u6863\u6848\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            HashMap caListMap = new HashMap();
            HashMap materialMap = new HashMap();
            HashMap<String, ProsubItemVO> materialBeanMap = new HashMap<String, ProsubItemVO>();
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                ProsubItemImportVO prosubItemImport = new ProsubItemImportVO();
                prosubItemImport.setId(IdWorker.getId());
                prosubItemImport.setCategoryCode((String)datas.get(0));
                prosubItemImport.setTrawlingCode((String)datas.get(1));
                prosubItemImport.setTrawlingName((String)datas.get(2));
                prosubItemImport.setPriceType((String)datas.get(3));
                prosubItemImport.setUnitName((String)datas.get(4));
                prosubItemImport.setJobContent((String)datas.get(5));
                prosubItemImport.setRemarks((String)datas.get(6));
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    prosubItemImport.setRemarks("\u6863\u6848\u7f16\u7801\u4e3a\u7a7a\uff01");
                    errorList.add(prosubItemImport);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                    prosubItemImport.setRemarks("\u6863\u6848\u540d\u79f0\u4e3a\u7a7a\uff01");
                    errorList.add(prosubItemImport);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    prosubItemImport.setRemarks("\u4ef7\u683c\u7c7b\u578b\u4e3a\u7a7a\uff01");
                    errorList.add(prosubItemImport);
                    continue;
                }
                List materialCategoryVo = (List)caListMap.get(datas.get(0));
                if (ListUtil.isEmpty((List)materialCategoryVo)) {
                    QueryParam queryParam = new QueryParam();
                    queryParam.getParams().put("categoryCode", new Parameter("eq", (Object)String.valueOf(datas.get(0))));
                    materialCategoryVo = this.prosubCategoryService.queryList(queryParam, false);
                    if (ListUtil.isNotEmpty((List)materialCategoryVo)) {
                        caListMap.put(datas.get(0), materialCategoryVo);
                    }
                }
                if (ListUtil.isNotEmpty((List)materialCategoryVo)) {
                    List list;
                    ProsubItemEntity one;
                    QueryWrapper queryWrapper;
                    prosubItemImport.setCategoryId(((ProsubCategoryEntity)((Object)materialCategoryVo.get(0))).getId());
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                        CommonResponse codeBatchByRuleCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, tenantId);
                        if (codeBatchByRuleCode.isSuccess()) {
                            prosubItemImport.setTrawlingCode((String)codeBatchByRuleCode.getData());
                        } else {
                            prosubItemImport.setTrawlingCode(System.currentTimeMillis() + "");
                        }
                    } else {
                        ProsubItemVO vo = (ProsubItemVO)materialMap.get(datas.get(1));
                        if (vo == null) {
                            queryWrapper = new QueryWrapper();
                            queryWrapper.eq((Object)"trawling_code", (Object)String.valueOf(datas.get(1)));
                            one = null;
                            list = this.service.list((Wrapper)queryWrapper);
                            if (CollectionUtils.isNotEmpty((Collection)list)) {
                                one = (ProsubItemEntity)((Object)list.get(0));
                            }
                            if (one != null) {
                                vo = (ProsubItemVO)BeanMapper.map((Object)((Object)one), ProsubItemVO.class);
                            }
                            if (vo != null) {
                                materialMap.put(datas.get(1), vo);
                            }
                        }
                        if (vo != null) {
                            prosubItemImport.setRemarks("\u6863\u6848\u7f16\u53f7\u91cd\u590d\uff01");
                            errorList.add(prosubItemImport);
                            continue;
                        }
                    }
                    ProsubItemVO materialBean = (ProsubItemVO)materialBeanMap.get(prosubItemImport.getTrawlingName() + prosubItemImport.getPriceType() + prosubItemImport.getUnitName() + ((ProsubCategoryEntity)((Object)materialCategoryVo.get(0))).getId());
                    if (materialBean == null) {
                        queryWrapper = new QueryWrapper();
                        queryWrapper.eq((Object)"trawling_name", (Object)prosubItemImport.getTrawlingName());
                        queryWrapper.eq((Object)"price_type", (Object)prosubItemImport.getPriceType());
                        queryWrapper.eq((Object)"unit_name", (Object)prosubItemImport.getUnitName());
                        queryWrapper.eq((Object)"category_id", (Object)((ProsubCategoryEntity)((Object)materialCategoryVo.get(0))).getId());
                        prosubItemImport.setCategoryName(((ProsubCategoryEntity)((Object)materialCategoryVo.get(0))).getCategoryName());
                        one = null;
                        list = this.service.list((Wrapper)queryWrapper);
                        if (CollectionUtils.isNotEmpty((Collection)list)) {
                            one = (ProsubItemEntity)((Object)list.get(0));
                        }
                        if (one != null) {
                            materialBean = (ProsubItemVO)BeanMapper.map((Object)((Object)one), ProsubItemVO.class);
                            materialBeanMap.put(prosubItemImport.getTrawlingName() + prosubItemImport.getPriceType() + prosubItemImport.getUnitName() + ((ProsubCategoryEntity)((Object)materialCategoryVo.get(0))).getId(), materialBean);
                        }
                    }
                    if (materialBean != null) {
                        prosubItemImport.setRemarks("\u91cd\u590d\u6863\u6848\uff01");
                        errorList.add(prosubItemImport);
                        continue;
                    }
                    prosubItemImport.setCreateUserCode(InvocationInfoProxy.getUsercode());
                    prosubItemImport.setCreateTime(new Date());
                    prosubItemImport.setTenantId(InvocationInfoProxy.getTenantid());
                    prosubItemImport.setEnabled(1);
                    successList.add(prosubItemImport);
                } else {
                    prosubItemImport.setRemarks("\u6863\u6848\u5206\u7c7b\u7f16\u53f7\u4e0d\u5b58\u5728\uff01");
                    errorList.add(prosubItemImport);
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(7)))) continue;
                String subjectName = ((String)datas.get(7)).toString();
                QueryWrapper subjectQueryWrapper = new QueryWrapper();
                subjectQueryWrapper.like((Object)"subject_name", (Object)subjectName);
                List list = this.subjectOrgService.list((Wrapper)subjectQueryWrapper);
                if (!CollectionUtils.isNotEmpty((Collection)list)) continue;
                prosubItemImport.setSubjectId(((SubjectOrgEntity)((Object)list.get(0))).getId());
                prosubItemImport.setSubjectName(((SubjectOrgEntity)((Object)list.get(0))).getSubjectName());
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CommonResponse<ProsubItemVO> saveOrUpdateProsubItem(ProsubItemVO saveorUpdateVO) {
        ProsubItemEntity entity = (ProsubItemEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, ProsubItemEntity.class));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("trawlingCode", new Parameter("eq", (Object)saveorUpdateVO.getTrawlingCode()));
        List prosubItemEntities = this.service.queryList(queryParam);
        if (saveorUpdateVO.getId() != null) {
            if (StringUtils.isEmpty((CharSequence)saveorUpdateVO.getTrawlingCode())) {
                return CommonResponse.error((String)"\u5206\u5305\u6863\u6848\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            ProsubItemEntity prosubItemEntity = (ProsubItemEntity)((Object)this.service.selectById(saveorUpdateVO.getId()));
            if (!prosubItemEntity.getTrawlingCode().equals(saveorUpdateVO.getTrawlingCode()) && CollectionUtils.isNotEmpty((Collection)prosubItemEntities)) {
                return CommonResponse.error((String)"\u5206\u5305\u6863\u6848\u7f16\u7801\u91cd\u590d\uff01");
            }
        } else if (CollectionUtils.isNotEmpty((Collection)prosubItemEntities)) {
            return CommonResponse.error((String)"\u5206\u5305\u6863\u6848\u7f16\u7801\u91cd\u590d\uff01");
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            if (null == entity.getSubjectId()) {
                Long categoryId = entity.getCategoryId();
                ProsubCategoryEntity prosubCategoryEntity = (ProsubCategoryEntity)((Object)this.prosubCategoryService.selectById(categoryId));
                entity.setSubjectId(prosubCategoryEntity.getSubjectId());
                entity.setSubjectName(prosubCategoryEntity.getSubjectName());
            }
            if (saveorUpdateVO.getTrawlingCode() == null) {
                entity.setTrawlingCode((String)billCode.getData());
            }
            entity.setEnabled(0);
            entity.setOrgId(this.sessionManager.getUserContext().getOrgId());
            entity.setOrgName(this.sessionManager.getUserContext().getOrgName());
            ProsubCategoryEntity prosubCategoryEntity = (ProsubCategoryEntity)((Object)this.prosubCategoryService.selectById(entity.getCategoryId()));
            if (prosubCategoryEntity != null) {
                entity.setCategoryName(prosubCategoryEntity.getCategoryName());
            }
        } else {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)saveorUpdateVO.getId());
            updateWrapper.set(ProsubItemEntity::getTrawlingName, (Object)saveorUpdateVO.getTrawlingName());
            updateWrapper.set(ProsubItemEntity::getPriceType, (Object)saveorUpdateVO.getPriceType());
            updateWrapper.set(ProsubItemEntity::getUnitName, (Object)saveorUpdateVO.getUnitName());
            updateWrapper.set(ProsubItemEntity::getJobContent, (Object)saveorUpdateVO.getJobContent());
            updateWrapper.set(ProsubItemEntity::getOrgId, (Object)this.sessionManager.getUserContext().getOrgId());
            updateWrapper.set(ProsubItemEntity::getOrgName, (Object)this.sessionManager.getUserContext().getOrgName());
            updateWrapper.set(ProsubItemEntity::getRemarks, (Object)saveorUpdateVO.getRemarks());
            updateWrapper.set(ProsubItemEntity::getSubjectId, (Object)saveorUpdateVO.getSubjectId());
            updateWrapper.set(ProsubItemEntity::getTrawlingCode, (Object)saveorUpdateVO.getTrawlingCode());
            updateWrapper.set(BaseEntity::getUpdateTime, (Object)new Date());
            updateWrapper.set(BaseEntity::getUpdateUserCode, (Object)InvocationInfoProxy.getUsercode());
            updateWrapper.set(ProsubItemEntity::getDetailMeasurementRules, (Object)saveorUpdateVO.getDetailMeasurementRules());
            updateWrapper.set(ProsubItemEntity::getSubjectName, (Object)saveorUpdateVO.getSubjectName());
            this.service.update((Wrapper)updateWrapper);
            return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01");
        }
        this.service.saveOrUpdate((Object)entity, false);
        ProsubItemVO vo = (ProsubItemVO)BeanMapper.map((Object)((Object)entity), ProsubItemVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public List<ProsubItemVO> queryProsubItemList(Page<ProsubItemVO> page, QueryWrapper wrapper) {
        return ((ProsubItemMapper)this.baseMapper).queryProsubItemList(page, wrapper);
    }

    @Override
    public void updateSubject(Long subjectId, String subjectName, List<Long> ids) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, ids);
        updateWrapper.set(ProsubItemEntity::getSubjectId, (Object)subjectId);
        updateWrapper.set(ProsubItemEntity::getSubjectName, (Object)subjectName);
        this.service.update((Wrapper)updateWrapper);
    }
}

