/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.foundation.share.bean.AdmixTureEntity;
import com.ejianc.foundation.share.mapper.AdmixTureMapper;
import com.ejianc.foundation.share.service.IAdmixTureService;
import com.ejianc.foundation.share.vo.AdmixTureVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="admixTureService")
public class AdmixTureServiceImpl
extends BaseServiceImpl<AdmixTureMapper, AdmixTureEntity>
implements IAdmixTureService {
    @Autowired
    private IAdmixTureService iAdmixTureService;

    @Override
    public CommonResponse<AdmixTureVO> saveOrUpdate(AdmixTureVO saveorUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        AdmixTureEntity entity = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(AdmixTureEntity::getAdmixtureCode, (Object)saveorUpdateVO.getAdmixtureCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)saveorUpdateVO.getId());
            List entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                return CommonResponse.error((String)"\u5b58\u5728\u76f8\u540c\u7f16\u53f7\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
            entity = (AdmixTureEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), AdmixTureEntity.class));
            super.saveOrUpdate((Object)entity, false);
            return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
        }
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambda.eq(AdmixTureEntity::getAdmixtureCode, (Object)saveorUpdateVO.getAdmixtureCode());
        List entities = super.list((Wrapper)lambda);
        if (entities != null && entities.size() > 0) {
            return CommonResponse.error((String)"\u5b58\u5728\u76f8\u540c\u7f16\u53f7\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        entity = (AdmixTureEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), AdmixTureEntity.class));
        entity.setId(IdWorker.getId());
        entity.setOrgId(InvocationInfoProxy.getOrgId());
        super.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        HashMap map = new HashMap();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            ArrayList<AdmixTureVO> admixTureVOList = new ArrayList<AdmixTureVO>();
            QueryParam queryParam = new QueryParam();
            ArrayList<String> codeList = new ArrayList<String>();
            List oldList = this.queryList(queryParam);
            for (AdmixTureEntity admixTureEntity : oldList) {
                codeList.add(admixTureEntity.getAdmixtureCode());
            }
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                AdmixTureVO admixTureVO = new AdmixTureVO();
                boolean flag = false;
                boolean parentWarn = false;
                String warnType = "";
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(0)))) {
                    admixTureVO.setAdmixtureCode(null);
                    warnType = warnType + "\u7f16\u53f7\u4e3a\u7a7a,";
                    flag = true;
                    parentWarn = true;
                } else if (codeList.contains(datas.get(0))) {
                    admixTureVO.setAdmixtureCode((String)datas.get(0));
                    warnType = warnType + "\u7f16\u53f7\u91cd\u590d,";
                    flag = true;
                    parentWarn = true;
                } else {
                    String admixTureCode = (String)datas.get(0);
                    admixTureVO.setAdmixtureCode(admixTureCode);
                }
                String admixtureName = (String)datas.get(1);
                if (StringUtils.isEmpty((CharSequence)admixtureName)) {
                    admixTureVO.setAdmixtureName(null);
                    warnType = warnType + "\u540d\u79f0\u4e3a\u7a7a,";
                    flag = true;
                    parentWarn = true;
                } else {
                    admixTureVO.setAdmixtureName(admixtureName);
                }
                String specModels = (String)datas.get(2);
                if (StringUtils.isEmpty((CharSequence)specModels)) {
                    admixTureVO.setSpecModels(null);
                    warnType = warnType + "\u89c4\u683c\u578b\u53f7\u4e3a\u7a7a,";
                    flag = true;
                    parentWarn = true;
                } else {
                    admixTureVO.setSpecModels(specModels);
                }
                String memo = (String)datas.get(3);
                admixTureVO.setMemo(memo);
                admixTureVO.setImportFlag(!flag);
                admixTureVO.setWarnType(warnType);
                admixTureVO.setRowState("add");
                admixTureVO.setEnabled(0);
                admixTureVO.setOrgId(InvocationInfoProxy.getOrgId());
                admixTureVO.setId(IdWorker.getId());
                admixTureVOList.add(admixTureVO);
            }
            ArrayList successList = new ArrayList();
            ArrayList errorList = new ArrayList();
            if (CollectionUtils.isNotEmpty(admixTureVOList)) {
                admixTureVOList.forEach(vo -> {
                    if (StringUtils.isEmpty((CharSequence)vo.getWarnType())) {
                        successList.add(vo);
                    } else {
                        errorList.add(vo);
                    }
                });
            }
            resp.put("successList", successList);
            resp.put("errorList", errorList);
            resp.put("successNum", (Object)successList.size());
            resp.put("errorNum", (Object)errorList.size());
            return CommonResponse.success((Object)resp);
        }
        return CommonResponse.error((String)"Excel\u4e3a\u7a7a");
    }

    @Override
    public String saveImportExcel(HttpServletRequest request, List<AdmixTureVO> importVOS) {
        if (ListUtil.isEmpty(importVOS)) {
            throw new BusinessException("\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        List saveOrUpldates = BeanMapper.mapList(importVOS, AdmixTureEntity.class);
        this.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
        return "\u4fdd\u5b58\u6210\u529f\uff01";
    }
}

