/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.supplier.controller.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.supplier.bean.ShareSupplierEntity;
import com.ejianc.foundation.supplier.service.IShareSupplierService;
import com.ejianc.foundation.supplier.vo.ShareSupplierVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/zds/shareSupplier/"})
public class ZDSShareSupplierApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IShareSupplierService shareSupplierService;

    private void setSupplierQueryType(String supplierType, QueryWrapper<ShareSupplierEntity> query, String sourceId) {
        switch (supplierType) {
            case "material": {
                query.eq((Object)"material_source_id", (Object)sourceId);
                break;
            }
            case "sub": {
                query.eq((Object)"labor_source_id", (Object)sourceId);
                break;
            }
            default: {
                query.and(q -> (QueryWrapper)((QueryWrapper)((QueryWrapper)q.eq((Object)"material_source_id", (Object)sourceId)).or()).eq((Object)"labor_source_id", (Object)sourceId));
            }
        }
    }

    private void setSuppliersQueryType(String supplierType, QueryWrapper<ShareSupplierEntity> query, JSONArray sourceIds) {
        switch (supplierType) {
            case "material": {
                query.in((Object)"material_source_id", (Collection)sourceIds);
                break;
            }
            case "sub": {
                query.in((Object)"labor_source_id", (Collection)sourceIds);
                break;
            }
            default: {
                query.and(q -> (QueryWrapper)((QueryWrapper)((QueryWrapper)q.in((Object)"material_source_id", (Collection)sourceIds)).or()).in((Object)"labor_source_id", (Collection)sourceIds));
            }
        }
    }

    @GetMapping(value={"getOneBySourceId"})
    CommonResponse<ShareSupplierVO> getOneBySourceId(@RequestParam(value="sourceId") String sourceId, @RequestParam(required=false) String supplierType) {
        ShareSupplierVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        this.setSupplierQueryType(supplierType, (QueryWrapper<ShareSupplierEntity>)query, sourceId);
        ShareSupplierEntity e = (ShareSupplierEntity)((Object)this.shareSupplierService.getOne((Wrapper)query));
        if (null != e) {
            resp = (ShareSupplierVO)BeanMapper.map((Object)((Object)e), ShareSupplierVO.class);
        }
        return CommonResponse.success(resp);
    }

    @PostMapping(value={"getAllBySourceIds"})
    CommonResponse<List<ShareSupplierVO>> getAllBySourceIds(@RequestBody JSONObject params) {
        List resp = new ArrayList();
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        this.setSuppliersQueryType(params.getString("supplierType"), (QueryWrapper<ShareSupplierEntity>)query, params.getJSONArray("sourceIds"));
        List eList = this.shareSupplierService.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)eList)) {
            resp = BeanMapper.mapList((Iterable)eList, ShareSupplierVO.class);
        }
        return CommonResponse.success(resp);
    }

    @GetMapping(value={"getOneByCode"})
    CommonResponse<ShareSupplierVO> getOneByCode(@RequestParam(value="code") String code) {
        ShareSupplierVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        query.eq((Object)"code", (Object)code);
        ShareSupplierEntity e = (ShareSupplierEntity)((Object)this.shareSupplierService.getOne((Wrapper)query));
        if (null != e) {
            resp = (ShareSupplierVO)BeanMapper.map((Object)((Object)e), ShareSupplierVO.class);
        }
        return CommonResponse.success(resp);
    }

    @PostMapping(value={"getAllByCodes"})
    CommonResponse<List<ShareSupplierVO>> getAllByCodes(@RequestBody List<String> code) {
        List resp = new ArrayList();
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        query.in((Object)"code", code);
        List eList = this.shareSupplierService.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)eList)) {
            resp = BeanMapper.mapList((Iterable)eList, ShareSupplierVO.class);
        }
        return CommonResponse.success(resp);
    }

    @GetMapping(value={"getByTenantId"})
    CommonResponse<ShareSupplierVO> getByTenantId(@RequestParam Long tenantId) {
        ShareSupplierVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        query.eq((Object)"tenant", (Object)tenantId);
        ShareSupplierEntity e = (ShareSupplierEntity)((Object)this.shareSupplierService.getOne((Wrapper)query));
        if (null != e) {
            resp = (ShareSupplierVO)BeanMapper.map((Object)((Object)e), ShareSupplierVO.class);
        }
        return CommonResponse.success(resp);
    }

    @PostMapping(value={"getByTenantIds"})
    CommonResponse<List<ShareSupplierVO>> getByTenantIds(@RequestParam List<Long> tenantIds) {
        List resp = new ArrayList();
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        query.in((Object)"tenant", tenantIds);
        List eList = this.shareSupplierService.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)eList)) {
            resp = BeanMapper.mapList((Iterable)eList, ShareSupplierVO.class);
        }
        return CommonResponse.success(resp);
    }
}

