package com.ejianc.foundation.supplier.controller.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.supplier.bean.ShareSupplierEntity;
import com.ejianc.foundation.supplier.service.IShareSupplierService;
import com.ejianc.foundation.supplier.vo.ShareSupplierVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;


@RestController
@RequestMapping("/api/zds/shareSupplierApi/")
public class ZDSShareSupplierApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IShareSupplierService shareSupplierService;


    private void setSupplierQueryType(String supplierType, QueryWrapper<ShareSupplierEntity> query, String sourceId) {
        switch (supplierType) {
            case "material":
                query.eq("material_source_id", sourceId);
                break;
            case "sub":
                query.eq("labor_source_id", sourceId);
                break;
            default:
                query.and(q -> q.eq("material_source_id", sourceId).or().eq("labor_source_id", sourceId));
        }
    }

    private void setSuppliersQueryType(String supplierType, QueryWrapper<ShareSupplierEntity> query, JSONArray sourceIds) {
        switch (supplierType) {
            case "material":
                query.in("material_source_id", sourceIds);
                break;
            case "sub":
                query.in("labor_source_id", sourceIds);
                break;
            default:
                query.and(q -> q.in("material_source_id", sourceIds).or().in("labor_source_id", sourceIds));
        }
    }

    /**
     * 根据供应商来源Id，获取供应商信息
     */
    @GetMapping(value = "getOneBySourceId")
    CommonResponse<ShareSupplierVO> getOneBySourceId(@RequestParam("sourceId") String sourceId, @RequestParam(required = false) String supplierType) {
        ShareSupplierVO resp = null;
        QueryWrapper<ShareSupplierEntity> query = new QueryWrapper<>();
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        setSupplierQueryType(supplierType, query, sourceId);
        ShareSupplierEntity e = shareSupplierService.getOne(query);

        if(null != e) {
            resp = BeanMapper.map(e, ShareSupplierVO.class);
        }

        return CommonResponse.success(resp);
    }

    /**
     * 根据供应商来源Id，获取供应商信息
     * @param params sourceIds-List<String>  supplierType-String
     * @return
     */
    @PostMapping(value = "getAllBySourceIds")
    CommonResponse<List<ShareSupplierVO>> getAllBySourceIds(@RequestBody JSONObject params) {
        List<ShareSupplierVO> resp = new ArrayList<>();
        QueryWrapper<ShareSupplierEntity> query = new QueryWrapper<>();
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        setSuppliersQueryType(params.getString("supplierType"), query, params.getJSONArray("sourceIds"));
        List<ShareSupplierEntity> eList = shareSupplierService.list(query);

        if(CollectionUtils.isNotEmpty(eList)) {
            resp = BeanMapper.mapList(eList, ShareSupplierVO.class);
        }

        return CommonResponse.success(resp);
    }

    /**
     * 根据供应商编码，获取供应商信息
     */
    @GetMapping(value = "getOneByCode")
    CommonResponse<ShareSupplierVO> getOneByCode(@RequestParam("code") String code) {
        ShareSupplierVO resp = null;
        QueryWrapper<ShareSupplierEntity> query = new QueryWrapper<>();
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.eq("code", code);
        ShareSupplierEntity e = shareSupplierService.getOne(query);

        if(null != e) {
            resp = BeanMapper.map(e, ShareSupplierVO.class);
        }

        return CommonResponse.success(resp);
    }

    /**
     * 根据供应商编码，获取供应商信息
     * @return
     */
    @PostMapping(value = "getAllByCodes")
    CommonResponse<List<ShareSupplierVO>> getAllByCodes(@RequestBody List<String> code) {
        List<ShareSupplierVO> resp = new ArrayList<>();
        QueryWrapper<ShareSupplierEntity> query = new QueryWrapper<>();
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.in("code", code);
        List<ShareSupplierEntity> eList = shareSupplierService.list(query);

        if(CollectionUtils.isNotEmpty(eList)) {
            resp = BeanMapper.mapList(eList, ShareSupplierVO.class);
        }

        return CommonResponse.success(resp);
    }


    /**
     * 根据租户Id获取对应供应商信息
     *
     * @param tenantId
     * @return
     */
    @GetMapping(value = "getByTenantId")
    CommonResponse<ShareSupplierVO> getByTenantId(@RequestParam Long tenantId) {
        ShareSupplierVO resp = null;
        QueryWrapper<ShareSupplierEntity> query = new QueryWrapper<>();
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.eq("tenant", tenantId);
        ShareSupplierEntity e = shareSupplierService.getOne(query);

        if(null != e) {
            resp = BeanMapper.map(e, ShareSupplierVO.class);
        }

        return CommonResponse.success(resp);
    }

    /**
     * 根据租户Ids获取对应供应商信息列表
     *
     * @param tenantIds
     * @return
     */
    @PostMapping(value = "getByTenantIds")
    CommonResponse<List<ShareSupplierVO>> getByTenantIds(@RequestParam List<Long> tenantIds) {
        List<ShareSupplierVO> resp = new ArrayList<>();
        QueryWrapper<ShareSupplierEntity> query = new QueryWrapper<>();
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.in("tenant", tenantIds);
        List<ShareSupplierEntity> eList = shareSupplierService.list(query);

        if(CollectionUtils.isNotEmpty(eList)) {
            resp = BeanMapper.mapList(eList, ShareSupplierVO.class);
        }

        return CommonResponse.success(resp);
    }

}
