/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.support.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.bean.BankAccountEntity;
import com.ejianc.foundation.support.bean.BankCategoryEntity;
import com.ejianc.foundation.support.bean.BankEntity;
import com.ejianc.foundation.support.mapper.BankAccountMapper;
import com.ejianc.foundation.support.service.IBankAccountService;
import com.ejianc.foundation.support.service.IBankCategoryService;
import com.ejianc.foundation.support.service.IBankService;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="bankAccountService")
public class BankAccountServiceImpl
extends BaseServiceImpl<BankAccountMapper, BankAccountEntity>
implements IBankAccountService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_TYPE_CODE = "BT211028000000001";
    @Autowired
    private IBankService bankService;
    @Autowired
    private IBankCategoryService categoryService;
    @Autowired
    private ISupplierService supplierService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBillTypeApi billTypeApi;

    @Override
    public BankAccountVO insertOrUpdate(BankAccountVO saveorUpdateVO) {
        Long categoryId;
        int count;
        BankAccountEntity entity = (BankAccountEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, BankAccountEntity.class));
        Long id = entity.getId();
        Long supplierId = entity.getSupplierId();
        if (StringUtils.isNotEmpty((CharSequence)entity.getBankCode())) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"bank_code", (Object)entity.getBankCode());
            queryWrapper.ne(id != null, (Object)"id", (Object)id);
            count = this.count((Wrapper)queryWrapper);
            if (count > 0) {
                throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff01\u94f6\u884c\u8d26\u53f7\u5df2\u5b58\u5728");
            }
        }
        QueryWrapper defaultWrapper = new QueryWrapper();
        defaultWrapper.eq((Object)"supplier_id", (Object)supplierId);
        defaultWrapper.ne(id != null, (Object)"id", (Object)id);
        count = this.count((Wrapper)defaultWrapper);
        if (count > 9) {
            throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff01\u8be5\u4f9b\u5e94\u5546\u540d\u4e0b\u8d26\u6237\u5df2\u8d85\u8fc710\u4e2a\uff01");
        }
        SupplierEntity supplierEntity = (SupplierEntity)((Object)this.supplierService.selectById(supplierId));
        if (supplierEntity == null) {
            throw new BusinessException("\u672a\u5728\u4f9b\u5e94\u5546\u5e93\u67e5\u8be2\u5230\u8be5\u4f9b\u5e94\u5546/\u5ba2\u6237/\u5ba2\u5546");
        }
        entity.setSupplierName(supplierEntity.getName());
        entity.setSupplierFlag(supplierEntity.getSupplierFlag());
        entity.setInsideState(supplierEntity.getInsideOrg() != null && supplierEntity.getInsideOrg() != false ? 1 : 0);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"supplier_id", (Object)supplierId);
        wrapper.eq((Object)"default_flag", (Object)1);
        wrapper.ne(id != null, (Object)"id", (Object)id);
        int count1 = super.count((Wrapper)wrapper);
        entity.setDefaultFlag(count1 == 0 ? 1 : 0);
        if (entity.getDefaultFlag() == 1 && entity.getEnabled() != 1) {
            throw new BusinessException("\u4f9b\u5e94\u5546\u9ed8\u8ba4\u8d26\u6237\u7684\u542f\u52a8\u72b6\u6001\u4e0d\u53ef\u4fee\u6539\uff01");
        }
        if (entity.getEnabled() == null) {
            entity.setEnabled(1);
        }
        if (entity.getEnableUserId() == null) {
            entity.setEnableUserId(InvocationInfoProxy.getUserid());
            entity.setEnableUserName(this.sessionManager.getUserContext().getUserName());
            entity.setEnableTime(new Date());
        }
        if ((categoryId = entity.getCategoryId()) != null) {
            BankCategoryEntity byId = (BankCategoryEntity)((Object)this.categoryService.getById(categoryId));
            entity.setCategoryCode(byId != null ? byId.getCode() : entity.getCategoryCode());
        }
        super.saveOrUpdate((Object)entity, false);
        BankAccountVO vo = (BankAccountVO)BeanMapper.map((Object)((Object)entity), BankAccountVO.class);
        return vo;
    }

    @Override
    public String delete(List<Long> ids) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter("in", ids));
        List list = super.queryList(queryParam);
        for (BankAccountEntity entity : list) {
            if (!NumberUtils.INTEGER_ONE.equals(entity.getDefaultFlag())) continue;
            throw new BusinessException("\u3010" + entity.getBankCode() + "\u3011\u4e3a\u9ed8\u8ba4\u94f6\u884c\u8d26\u6237\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
        }
        Map map = list.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
        for (Long id : ids) {
            if (!map.containsKey(id)) continue;
            BankAccountEntity data = (BankAccountEntity)((Object)map.get(id));
            CommonResponse res = this.billTypeApi.checkQuote(BILL_TYPE_CODE, id);
            this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
            if (!res.isSuccess()) {
                throw new BusinessException("\u5220\u9664\u5931\u8d25\uff01\u94f6\u884c\u8d26\u6237\u3010" + data.getBankCode() + "\u3011\u5df2\u4f7f\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
            }
            if (!NumberUtils.INTEGER_ONE.equals(data.getDefaultFlag())) continue;
            QueryParam param = new QueryParam();
            if (data.getSupplierId() != null) {
                param.getParams().put("supplierId", new Parameter("eq", (Object)data.getSupplierId()));
            }
            if (!MapUtils.isNotEmpty((Map)param.getParams())) continue;
            param.getParams().put("id", new Parameter("not_in", ids));
            List dataList = super.queryList(param);
            if (!CollectionUtils.isNotEmpty((Collection)dataList)) continue;
            throw new BusinessException("\u5220\u9664\u5931\u8d25\uff01\u94f6\u884c\u8d26\u6237\u3010" + data.getBankCode() + "\u3011\u4e3a\u9ed8\u8ba4\u8d26\u6237\uff0c\u4e14\u975e\u6863\u6848\u4e0b\u552f\u4e00\u8d26\u6237\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
        }
        super.removeByIds(ids, true);
        return "\u5220\u9664\u6210\u529f\uff01";
    }

    @Override
    public String delBySuppAndCustomIds(String type, List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new BusinessException("\u672a\u9009\u62e9\u5355\u636e");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter("in", ids));
        List list = super.queryList(queryParam);
        ArrayList<Long> delIds = new ArrayList<Long>();
        for (BankAccountEntity entity : list) {
            CommonResponse res = this.billTypeApi.checkQuote(BILL_TYPE_CODE, entity.getId());
            this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
            if (!res.isSuccess()) {
                throw new BusinessException("\u5220\u9664\u5931\u8d25\uff01\u94f6\u884c\u8d26\u6237\u3010" + entity.getBankCode() + "\u3011\u5df2\u4f7f\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
            }
            delIds.add(entity.getId());
        }
        if (CollectionUtils.isNotEmpty(delIds)) {
            super.removeByIds(delIds, true);
        }
        return "\u5220\u9664\u6210\u529f\uff01";
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
            ArrayList<BankAccountVO> voList = new ArrayList<BankAccountVO>();
            HashMap<String, Integer> countMap = new HashMap<String, Integer>();
            HashMap<String, String> defaultFlagMap = new HashMap<String, String>();
            for (int i = 0; i < result.size(); ++i) {
                Integer count;
                List datas = (List)result.get(i);
                BankAccountVO vo2 = new BankAccountVO();
                vo2.setId(Long.valueOf(IdWorker.getId()));
                String warnType = "";
                String supplierName = (String)datas.get(0);
                String supplierCode = (String)datas.get(1);
                String bankCode = (String)datas.get(2);
                if (StringUtils.isEmpty((CharSequence)supplierName)) {
                    vo2.setSupplierName(null);
                    warnType = warnType + "[\u4f9b\u5e94\u5546/\u5ba2\u6237/\u5ba2\u5546\u540d\u79f0\u4e3a\u7a7a]";
                } else {
                    vo2.setSupplierName(supplierName.trim());
                }
                if (StringUtils.isEmpty((CharSequence)supplierCode)) {
                    vo2.setSupplierCode(null);
                    warnType = warnType + "[\u4f9b\u5e94\u5546/\u5ba2\u6237/\u5ba2\u5546\u7f16\u7801\u4e3a\u7a7a]";
                } else {
                    vo2.setSupplierCode(supplierCode.trim());
                }
                if (StringUtils.isEmpty((CharSequence)bankCode)) {
                    vo2.setBankCode(null);
                    warnType = warnType + "[\u4f9b\u5e94\u5546/\u5ba2\u6237/\u5ba2\u5546\u8d26\u6237\u4e3a\u7a7a]";
                } else {
                    vo2.setBankCode(bankCode);
                    if (indexMap.containsKey(bankCode)) {
                        return CommonResponse.error((String)("\u7b2c" + (i + 2) + "\u884c\u8d26\u53f7\u548c\u7b2c" + ((Integer)indexMap.get(bankCode) + 2) + "\u884c\u91cd\u590d"));
                    }
                    indexMap.put(bankCode, i);
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(3)))) {
                    vo2.setBankAccount(null);
                    warnType = warnType + "[\u6237\u540d\u4e3a\u7a7a]";
                } else {
                    vo2.setBankAccount(((String)datas.get(3)).trim());
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(4)))) {
                    vo2.setBankName(null);
                    warnType = warnType + "[\u5f00\u6237\u94f6\u884c\u4e3a\u7a7a]";
                } else {
                    vo2.setBankName(((String)datas.get(4)).trim());
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(5)))) {
                    vo2.setCategoryName(null);
                    warnType = warnType + "[\u94f6\u884c\u7c7b\u522b\u4e3a\u7a7a]";
                } else {
                    vo2.setCategoryName(((String)datas.get(5)).trim());
                }
                vo2.setMemo((String)datas.get(6));
                vo2.setDefaultFlagName((String)datas.get(7));
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(7)))) {
                    vo2.setDefaultFlag(Integer.valueOf(0));
                    warnType = warnType + "[\u9ed8\u8ba4\u4e0d\u80fd\u4e3a\u7a7a]";
                } else if ("\u662f".equals(datas.get(7))) {
                    vo2.setDefaultFlag(Integer.valueOf(1));
                    String str = defaultFlagMap.get(supplierCode);
                    if (StringUtils.isNotEmpty((CharSequence)str)) {
                        warnType = warnType + "['" + supplierName + "'\u53ea\u80fd\u6709\u4e00\u6761\u9ed8\u8ba4\u8d26\u6237]";
                    } else {
                        defaultFlagMap.put(supplierCode, supplierCode);
                    }
                } else {
                    vo2.setDefaultFlag(Integer.valueOf(0));
                }
                Integer n = count = countMap.get(supplierCode) != null ? countMap.get(supplierCode) : Integer.valueOf(0);
                if (count > 10) {
                    warnType = warnType + "['" + supplierName + "'\u7d2f\u8ba1\u8d26\u6237\u8d85\u8fc710\u4e2a\uff01]";
                } else {
                    Integer n2 = count;
                    Integer n3 = count = Integer.valueOf(count + 1);
                }
                countMap.put(supplierCode, count);
                vo2.setWarnType(warnType);
                vo2.setRowState("add");
                voList.add(vo2);
            }
            this.validate(voList, defaultFlagMap, countMap, true);
            ArrayList successList = new ArrayList();
            ArrayList errorList = new ArrayList();
            if (CollectionUtils.isNotEmpty(voList)) {
                voList.forEach(vo -> {
                    if (StringUtils.isEmpty((CharSequence)vo.getWarnType())) {
                        successList.add(vo);
                    } else {
                        errorList.add(vo);
                    }
                });
            }
            resp.put("successList", successList);
            resp.put("errorList", errorList);
            resp.put("successNum", (Object)successList.size());
            resp.put("errorNum", (Object)errorList.size());
            return CommonResponse.success((Object)resp);
        }
        return CommonResponse.error((String)"Excel\u4e3a\u7a7a");
    }

    @Override
    public String saveImportExcel(HttpServletRequest request, List<BankAccountVO> importVOS) {
        if (ListUtil.isEmpty(importVOS)) {
            throw new BusinessException("\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (BankAccountVO importVO : importVOS) {
            importVO.setEnabled(Integer.valueOf(1));
            importVO.setEnableUserId(InvocationInfoProxy.getUserid());
            importVO.setEnableUserName(this.sessionManager.getUserContext().getUserName());
            importVO.setEnableTime(new Date());
            list.add(BeanMapper.map((Object)importVO, BankAccountEntity.class));
        }
        if (CollectionUtils.isNotEmpty(list)) {
            super.saveOrUpdateBatch(list);
        }
        return "\u4fdd\u5b58\u6210\u529f\uff01";
    }

    @Override
    public String enabled(List<BankAccountVO> vos) {
        if (CollectionUtils.isEmpty(vos)) {
            return "\u672a\u9009\u62e9\u5355\u636e\uff01";
        }
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter("in", ids));
        List entityList = super.queryList(queryParam);
        for (BankAccountEntity entity : entityList) {
            if (!NumberUtils.INTEGER_ONE.equals(vos.get(0).getEnabled()) && NumberUtils.INTEGER_ONE.equals(entity.getDefaultFlag())) {
                throw new BusinessException("\u3010" + entity.getBankCode() + "\u3011\u4e3a\u9ed8\u8ba4\u94f6\u884c\u8d26\u6237\uff0c\u4e0d\u5141\u8bb8\u505c\u7528\uff01");
            }
            Integer enabled = vos.get(0).getEnabled();
            entity.setEnabled(enabled);
            if (enabled == 1) {
                entity.setEnableUserId(InvocationInfoProxy.getUserid());
                entity.setEnableUserName(this.sessionManager.getUserContext().getUserName());
                entity.setEnableTime(new Date());
            }
            if (enabled != 0) continue;
            entity.setUnenableUserId(InvocationInfoProxy.getUserid());
            entity.setUnenableUserName(this.sessionManager.getUserContext().getUserName());
            entity.setUnenableTime(new Date());
        }
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            super.saveOrUpdateBatch((Collection)entityList);
        }
        return "\u64cd\u4f5c\u6210\u529f\uff01";
    }

    @Override
    public String defaultFlag(BankAccountVO vo) {
        BankAccountEntity entity = (BankAccountEntity)((Object)super.selectById((Serializable)vo.getId()));
        if (!NumberUtils.INTEGER_ONE.equals(vo.getDefaultFlag()) && !NumberUtils.INTEGER_ONE.equals(entity.getDefaultFlag())) {
            throw new BusinessException("\u5df2\u7ecf\u4e3a\u975e\u9ed8\u8ba4\u94f6\u884c\u8d26\u6237\uff01");
        }
        if (NumberUtils.INTEGER_ONE.equals(vo.getDefaultFlag()) && NumberUtils.INTEGER_ONE.equals(entity.getDefaultFlag())) {
            throw new BusinessException("\u5df2\u7ecf\u4e3a\u9ed8\u8ba4\u94f6\u884c\u8d26\u6237\uff01");
        }
        if (!NumberUtils.INTEGER_ONE.equals(vo.getDefaultFlag()) && NumberUtils.INTEGER_ONE.equals(entity.getDefaultFlag())) {
            throw new BusinessException("\u81f3\u5c11\u6709\u4e00\u4e2a\u4e3a\u9ed8\u8ba4\u94f6\u884c\u8d26\u6237\uff01");
        }
        if (NumberUtils.INTEGER_ONE.equals(vo.getDefaultFlag()) && !NumberUtils.INTEGER_ONE.equals(entity.getEnabled())) {
            throw new BusinessException("\u8be5\u94f6\u884c\u8d26\u6237\u5df2\u505c\u7528\uff01");
        }
        QueryParam param = new QueryParam();
        if (entity.getSupplierId() != null) {
            param.getParams().put("supplierId", new Parameter("eq", (Object)entity.getSupplierId()));
        }
        param.getParams().put("defaultFlag", new Parameter("eq", (Object)1));
        List dataList = super.queryList(param);
        if (NumberUtils.INTEGER_ONE.equals(vo.getDefaultFlag()) && CollectionUtils.isNotEmpty((Collection)dataList)) {
            dataList.forEach(x -> x.setDefaultFlag(0));
            super.saveOrUpdateBatch((Collection)dataList);
        }
        entity.setDefaultFlag(1);
        super.saveOrUpdate((Object)entity, false);
        return "\u64cd\u4f5c\u6210\u529f\uff01";
    }

    @Override
    public void validate(List<BankAccountVO> voList, HashMap<String, String> defaultFlagMap, HashMap<String, Integer> countMap, boolean isValidateDefaultAndCount) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("bankCode", new Parameter("in", voList.stream().map(BankAccountVO::getBankCode).distinct().collect(Collectors.toList())));
        List dataList = super.queryList(queryParam);
        List bankCodes = dataList.stream().map(BankAccountEntity::getBankCode).distinct().collect(Collectors.toList());
        QueryParam queryParam2 = new QueryParam();
        queryParam2.getParams().put("name", new Parameter("in", voList.stream().map(BankAccountVO::getBankName).distinct().collect(Collectors.toList())));
        List bankList = this.bankService.queryList(queryParam2);
        Map bankMap = bankList.stream().collect(Collectors.toMap(x -> x.getName() + "-" + x.getBankCategoryName(), Function.identity(), (x1, x2) -> x1));
        QueryParam queryParam3 = new QueryParam();
        queryParam3.getParams().put("name", new Parameter("in", voList.stream().map(BankAccountVO::getCategoryName).distinct().collect(Collectors.toList())));
        List categoryList = this.categoryService.queryList(queryParam3);
        Map categoryMap = categoryList.stream().collect(Collectors.toMap(x -> x.getName(), Function.identity(), (x1, x2) -> x1));
        Map<Object, Object> supplierMapTemp = new HashMap();
        List collect1 = voList.stream().filter(t -> t.getSupplierCode() != null).map(BankAccountVO::getSupplierCode).distinct().collect(Collectors.toList());
        if (collect1.size() > 0) {
            QueryParam queryParam5 = new QueryParam();
            queryParam5.getParams().put("code", new Parameter("in", voList.stream().filter(t -> t.getSupplierCode() != null).map(BankAccountVO::getSupplierCode).distinct().collect(Collectors.toList())));
            List supplierEntities = this.supplierService.queryList(queryParam5);
            supplierMapTemp = supplierEntities.stream().collect(Collectors.toMap(x -> x.getCode(), Function.identity(), (x1, x2) -> x1));
        }
        HashMap supplierMap = supplierMapTemp;
        if (CollectionUtils.isNotEmpty(voList)) {
            voList.forEach(vo -> {
                if (bankCodes.contains(vo.getBankCode())) {
                    vo.setWarnType(vo.getWarnType() + "[\u94f6\u884c\u8d26\u53f7'" + vo.getBankCode() + "'\u5df2\u5b58\u5728]");
                }
                if (categoryMap.containsKey(vo.getCategoryName())) {
                    BankCategoryEntity bankCategoryEntity = (BankCategoryEntity)((Object)((Object)categoryMap.get(vo.getCategoryName())));
                    vo.setCategoryId(bankCategoryEntity.getId());
                    vo.setCategoryCode(bankCategoryEntity.getCode());
                    vo.setCategoryName(bankCategoryEntity.getName());
                } else {
                    vo.setWarnType(vo.getWarnType() + "[\u94f6\u884c\u7c7b\u522b'" + vo.getCategoryName() + "'\u4e0d\u5b58\u5728]");
                }
                if (bankMap.containsKey(vo.getBankName() + "-" + vo.getCategoryName())) {
                    BankEntity bankEntity = (BankEntity)((Object)((Object)bankMap.get(vo.getBankName() + "-" + vo.getCategoryName())));
                    vo.setBankId(bankEntity.getId());
                    vo.setBankNum(bankEntity.getCode());
                    vo.setBankName(bankEntity.getName());
                    vo.setBankAddress(bankEntity.getAddress());
                } else {
                    vo.setWarnType(vo.getWarnType() + "[\u94f6\u884c\u6863\u6848'" + vo.getBankName() + "'\u4e0d\u5b58\u5728]");
                }
                String supplierCode = vo.getSupplierCode();
                if (StringUtils.isNotEmpty((CharSequence)supplierCode)) {
                    if (supplierMap.containsKey(supplierCode)) {
                        SupplierEntity supplierEntity = (SupplierEntity)((Object)((Object)supplierMap.get(supplierCode)));
                        vo.setSupplierId(supplierEntity.getId());
                        vo.setSupplierFlag(supplierEntity.getSupplierFlag());
                        vo.setInsideState(Integer.valueOf(supplierEntity.getInsideOrg() != false ? 1 : 0));
                        vo.setOrgId(supplierEntity.getOrgId());
                        vo.setOrgName(supplierEntity.getOrgName());
                    } else {
                        vo.setWarnType(vo.getWarnType() + "[\u7f16\u7801\u4e3a'" + supplierCode + "'\u7684\u4f9b\u5e94\u5546/\u5ba2\u6237/\u5ba2\u5546\u4e0d\u5b58\u5728]");
                    }
                }
                if (isValidateDefaultAndCount) {
                    String str;
                    QueryWrapper wrapper = new QueryWrapper();
                    wrapper.eq((Object)"supplier_code", (Object)supplierCode);
                    int count = super.count((Wrapper)wrapper);
                    Integer importCount = (Integer)countMap.get(supplierCode);
                    if (importCount + count > 10) {
                        vo.setWarnType("['" + vo.getSupplierName() + "'\u7d2f\u8ba1\u8d26\u6237\u8d85\u8fc710\u4e2a\uff01]");
                    }
                    if (StringUtils.isNotEmpty((CharSequence)(str = (String)defaultFlagMap.get(supplierCode)))) {
                        QueryWrapper defaultWrapper = new QueryWrapper();
                        defaultWrapper.eq((Object)"supplier_code", (Object)supplierCode);
                        defaultWrapper.eq((Object)"default_flag", (Object)1);
                        int defaultCount = super.count((Wrapper)defaultWrapper);
                        if (defaultCount > 0) {
                            vo.setWarnType("['" + vo.getSupplierName() + "'\u53ea\u80fd\u6709\u4e00\u4e2a\u9ed8\u8ba4\u8d26\u6237\uff01]");
                        }
                    }
                }
            });
        }
    }
}

