package com.ejianc.foundation.share.service.impl;

import com.ejianc.foundation.share.service.IProjectTeamService;
import com.ejianc.foundation.share.vo.ProjectTeamVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 项目团队
 * 
 * @author generator
 * 
 */
@Service("projectTeamService")
public class ProjectTeamServiceImpl implements IProjectTeamService{

    @Autowired
    private IEmployeeApi employeeApi;

    /**
     * 保存
     * @param projectTeamEntityList
     * @return
     */
    @Override
    public boolean saveOrUpdates(List<ProjectTeamVO> projectTeamEntityList) {
        Map<String, Object> memberMap = getMemberMap(projectTeamEntityList);
        if(!memberMap.isEmpty()) {
            //保存新增的成员信息
            CommonResponse<String> resp = employeeApi.manageProjectMembers(memberMap);
            if(!resp.isSuccess()) {
                throw new BusinessException("保存失败，新增成员出错: " + resp.getMsg());
            }
        }
        return true;
    }

    @Override
    public void updateType(Map<String, Object> map) {
        if(!map.isEmpty()) {
            //保存新增的成员信息
                CommonResponse<String> resp = employeeApi.updateJobType(map);
            if(!resp.isSuccess()) {
                throw new BusinessException("修改人员类型出错: " + resp.getMsg());
            }
        }
    }

    /**
     *
     * 封map
     * @param projectTeamVOList
     * @return
     */
    private Map<String, Object> getMemberMap(List<ProjectTeamVO> projectTeamVOList) {
        Long orgId = null;
        Map<String, Object> dataMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(projectTeamVOList)) {
            orgId =projectTeamVOList.get(0).getOrgId();
            //保存项目成员
            Map<String, Object> moveMap = new HashMap<>(),
            parttimeMap = new HashMap<>();

            List<RoleUserRelationVO> relationList = null;
            RoleUserRelationVO tmp = null;

            for(ProjectTeamVO member :  projectTeamVOList) {
                //过滤掉非新增的成员
                tmp = new RoleUserRelationVO();
                tmp.setUserId(null != member.getUserId() ? Long.valueOf(member.getUserId().toString()) : null);
                tmp.setJobId(null != member.getJobId() ? Long.valueOf(member.getJobId().toString()) : null);
                 tmp.setAuthOrgId(orgId);
                tmp.setEmployeeId(null != member.getEmployeeId() ? Long.valueOf(member.getEmployeeId().toString()) : null);
                tmp.setRoleId(null != member.getRoleId()? Long.valueOf(member.getRoleId().toString()) : null);
                tmp.setProjectPost(null != member.getProjectPost()?member.getProjectPost().toString() : null);

                if("move".equals(member.getType().toString())) {
                    relationList = (List<RoleUserRelationVO>) moveMap.get(tmp.getEmployeeId());
                    if(null == relationList) {
                        relationList = new ArrayList<>();
                    }
                    relationList.add(tmp);
                    moveMap.put(tmp.getEmployeeId().toString(), relationList);
                } else {
                    relationList = (List<RoleUserRelationVO>) parttimeMap.get(tmp.getEmployeeId());
                    if(null == relationList) {
                        relationList = new ArrayList<>();
                    }
                    relationList.add(tmp);
                    parttimeMap.put(tmp.getEmployeeId().toString(), relationList);
                }
            }

            if(!moveMap.isEmpty()) {
                Map<String, Object> moveData = new HashMap<>();
                moveData.put("orgId", orgId);
                moveData.put("detail", moveMap);
                dataMap.put("moveMembers", moveData);
            }
            if(!parttimeMap.isEmpty()) {
                Map<String, Object> parttimeData = new HashMap<>();
                parttimeData.put("orgId", orgId);
                parttimeData.put("detail", parttimeMap);
                dataMap.put("parttimeMembers", parttimeData);
            }
        }

        return dataMap;
    }

}
