/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.bean.ProjectSetPoolEntity;
import com.ejianc.foundation.share.service.IProjectSetService;
import com.ejianc.foundation.util.HttpToolKitZd4;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/zd4/project/"})
public class Zd4ProjectSyncController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${zd4.syncBaseHost:0}")
    private String syncBaseHost;
    @Value(value="${zd4.appid:0}")
    private String appid;
    @Value(value="${zd4.secret:0}")
    private String secret;
    private static final Calendar calendar = Calendar.getInstance();
    @Autowired
    private IProjectSetService projectSetService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IEmployeeApi iEmployeeApi;

    @GetMapping(value={"syncAll"})
    @ResponseBody
    public CommonResponse<String> syncAll() {
        return this.syncProject(new JSONObject());
    }

    @GetMapping(value={"syncDaily"})
    @ResponseBody
    public CommonResponse<String> syncDaily(@RequestBody JSONObject syncParam) {
        calendar.setTime(new Date());
        calendar.add(5, -2);
        JSONObject parems = new JSONObject();
        parems.put("BeginDateTime", (Object)(null != syncParam && null != syncParam.get((Object)"beginDateTime") ? syncParam.getString("beginDateTime") : DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)calendar.getTime()) + " 00:00:00"));
        calendar.setTime(new Date());
        calendar.add(5, 1);
        parems.put("EndDateTime", (Object)(null != syncParam && null != syncParam.get((Object)"endDateTime") ? syncParam.getString("endDateTime") : DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)calendar.getTime()) + " 23:59:59"));
        return this.syncProject(parems);
    }

    private CommonResponse<String> syncProject(JSONObject parems) {
        int pageNum = null != parems.get((Object)"PageNum") ? parems.getInteger("PageNum") : 1;
        int pageSize = null != parems.get((Object)"PageNum") ? parems.getInteger("PageSize") : 50;
        boolean run = true;
        parems.put("PageNum", (Object)pageNum);
        parems.put("PageSize", (Object)pageSize);
        Integer errTimes = null != parems.get((Object)"errTimes") ? parems.getInteger("errTimes") : 0;
        parems.remove((Object)"errTimes");
        this.logger.info("\u4e2d\u75354\u516c\u53f8\u540c\u6b65\u9879\u76ee\u4ee5\u53ca\u9879\u76ee\u4e0b\u4eba\u5458\u517c\u804c\u6570\u636e \u5f00\u59cb------url={}{},---params={}", new Object[]{this.syncBaseHost, "/cefoc/yql/getProjectList", parems.toJSONString()});
        try {
            HttpToolKitZd4.setSecureAccount(this.appid, this.secret);
            while (run) {
                String res = HttpToolKitZd4.post(this.syncBaseHost + "/cefoc/yql/getProjectList", parems.toJSONString());
                if (StringUtils.isNotEmpty((CharSequence)res)) {
                    JSONObject jsonObject = JSONObject.parseObject((String)res);
                    if ("ok".equals(jsonObject.getString("status"))) {
                        errTimes = 0;
                        JSONArray dataArray = jsonObject.getJSONArray("data");
                        if (dataArray != null && dataArray.size() > 0) {
                            this.logger.info("\u4e2d\u75354\u516c\u53f8\u540c\u6b65\u9879\u76ee\u4ee5\u53ca\u9879\u76ee\u4e0b\u4eba\u5458\u517c\u804c\u6570\u636e \u5904\u7406\u7b2c{}\u9875{}\u6761\u6570\u636e\uff01\uff01\uff01", (Object)pageNum, (Object)dataArray.size());
                            this.syncProjectPage(dataArray);
                            parems.put("PageNum", (Object)(++pageNum));
                            continue;
                        }
                        this.logger.info("\u4e2d\u75354\u516c\u53f8\u540c\u6b65\u9879\u76ee\u4ee5\u53ca\u9879\u76ee\u4e0b\u4eba\u5458\u517c\u804c\u6570\u636e \u5904\u7406\u6570\u636e\u5b8c\u6210\uff01\uff01\uff01\u603b\u5171{}\u9875\u6570\u636e\uff01", (Object)pageNum);
                        run = false;
                        continue;
                    }
                    this.logger.info("\u4e2d\u75354\u516c\u53f8\u540c\u6b65\u9879\u76ee\u4ee5\u53ca\u9879\u76ee\u4e0b\u4eba\u5458\u517c\u804c\u6570\u636e\u5931\u8d25, \u8bf7\u6c42ERP\u63a5\u53e3\u5931\u8d25\uff01\uff01\uff01{}", (Object)res);
                    run = false;
                    continue;
                }
                this.logger.info("\u4e2d\u75354\u516c\u53f8\u540c\u6b65\u9879\u76ee\u4ee5\u53ca\u9879\u76ee\u4e0b\u4eba\u5458\u517c\u804c\u6570\u636e\u5931\u8d25\uff01\uff01\uff01\u54cd\u5e94\u6570\u636e\u4e3a\u7a7a---{}", (Object)res);
                run = false;
            }
        }
        catch (Exception e) {
            this.logger.info("\u4e2d\u75354\u516c\u53f8\u540c\u6b65\u9879\u76ee\u4ee5\u53ca\u9879\u76ee\u4e0b\u4eba\u5458\u517c\u804c\u6570\u636e\u5931\u8d25\uff01\uff01\uff01", (Throwable)e);
            Integer jsonObject = errTimes;
            Integer n = errTimes = Integer.valueOf(errTimes + 1);
            if (errTimes >= 2) {
                this.logger.error("\u4e2d\u75354\u516c\u53f8\u540c\u6b65\u9879\u76ee\u4ee5\u53ca\u9879\u76ee\u4e0b\u4eba\u5458\u517c\u804c\u6570\u636e \u8fde\u7eed\u4e24\u6b21\u8bf7\u6c42ERP\u5931\u8d25\uff0c\u4efb\u52a1\u6267\u884c\u7ed3\u675f\u3002\u3002\u3002\u3002\u3002\u3002  ");
                return CommonResponse.error((String)("\u4e2d\u75354\u516c\u53f8\u540c\u6b65\u9879\u76ee\u4ee5\u53ca\u9879\u76ee\u4e0b\u4eba\u5458\u517c\u804c\u6570\u636e\u5931\u8d25!" + e.getMessage()));
            }
            try {
                this.logger.info("\u4e2d\u75354\u516c\u53f8\u540c\u6b65\u9879\u76ee\u4ee5\u53ca\u9879\u76ee\u4e0b\u4eba\u5458\u517c\u804c\u6570\u636e \u8bf7\u6c42ERP\u670d\u52a1\u5f02\u5e38\uff0c\u4f11\u606f5s\u540e\u91cd\u8bd5\u4efb\u52a1");
                Thread.sleep(5000L);
                return this.syncProject(parems);
            }
            catch (Exception e1) {
                this.logger.error("\u91cd\u542f \u4e2d\u75354\u516c\u53f8\u540c\u6b65\u9879\u76ee\u4ee5\u53ca\u9879\u76ee\u4e0b\u4eba\u5458\u517c\u804c\u6570\u636e\u540c\u6b65\u63a5\u53e3\u5f02\u5e38,", (Throwable)e1);
                return CommonResponse.error((String)"\u540c\u6b65\u4e2d\u75354\u516c\u53f8\u540c\u6b65\u9879\u76ee\u4ee5\u53ca\u9879\u76ee\u4e0b\u4eba\u5458\u517c\u804c\u6570\u636e\u4fe1\u606f\u5f02\u5e38");
            }
        }
        this.logger.info("\u4e2d\u75354\u516c\u53f8\u540c\u6b65\u9879\u76ee\u4ee5\u53ca\u9879\u76ee\u4e0b\u4eba\u5458\u517c\u804c\u6570\u636e\u6210\u529f\uff01\uff01\uff01------666------");
        return CommonResponse.success((String)"\u4e2d\u75354\u516c\u53f8\u540c\u6b65\u9879\u76ee\u4ee5\u53ca\u9879\u76ee\u4e0b\u4eba\u5458\u517c\u804c\u6570\u636e\u6210\u529f\uff01");
    }

    private void syncProjectPage(JSONArray dataArray) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", Parameter.getEqInstance((Object)999999L));
        for (Object o : dataArray) {
            JSONObject object = (JSONObject)o;
            param.getParams().put("sourceId", Parameter.getEqInstance((Object)object.getString("C_CM_AccountingProjectSetOID")));
            List entities = this.projectSetService.queryList(param);
            ProjectSetPoolEntity poolEntity = null;
            CommonResponse response = this.iOrgApi.findBySourceId(object.getString("EngineDeptSid"));
            if (!response.isSuccess() || response.getData() == null) {
                this.logger.info("\u4e2d\u75354\u516c\u53f8\u540c\u6b65\u9879\u76ee-{}, \u67e5\u8be2\u9879\u76ee\u6240\u5c5e\u7ec4\u7ec7[\u5de5\u7a0b\u90e8]\u5931\u8d25\uff01{}--{}\uff0c\u67e5\u8be2\u9879\u76ee\u6240\u5c5e\u6267\u884c\u90e8\u95e8", new Object[]{object.getString("Account_Project_shortname"), JSONObject.toJSONString((Object)response), object.getString("EngineDeptSid")});
                response = this.iOrgApi.findBySourceId(object.getString("Dept_sid"));
                if (!response.isSuccess() || response.getData() == null) {
                    this.logger.info("\u4e2d\u75354\u516c\u53f8\u540c\u6b65\u9879\u76ee-{}, \u67e5\u8be2\u9879\u76ee\u6240\u5c5e\u7ec4\u7ec7[\u6267\u884c\u90e8\u95e8]\u5931\u8d25\uff01{}--{}", new Object[]{object.getString("Account_Project_shortname"), JSONObject.toJSONString((Object)response), object.getString("Dept_sid")});
                    continue;
                }
            }
            OrgVO orgVO = (OrgVO)response.getData();
            if (ListUtil.isNotEmpty((List)entities)) {
                poolEntity = (ProjectSetPoolEntity)((Object)entities.get(0));
            } else {
                poolEntity = new ProjectSetPoolEntity();
                poolEntity.setBillState(1);
                poolEntity.setNationalName("\u4e2d\u56fd");
                poolEntity.setNationalId(493873812443236045L);
                poolEntity.setSourceId(object.getString("C_CM_AccountingProjectSetOID"));
                poolEntity.setAttribute("2");
                poolEntity.setHasParent(0);
                poolEntity.setKeyProject(false);
            }
            poolEntity.setPlanVersion(object.getString("PlanVersion"));
            poolEntity.setOrgId(orgVO.getId());
            poolEntity.setOrgName(orgVO.getName());
            poolEntity.setName(object.getString("Account_Project_shortname"));
            poolEntity.setShortName(object.getString("Account_Project_shortname"));
            poolEntity.setCode(object.getString("Account_Project_id"));
            poolEntity.setProjectStatus(object.getString("Project_status"));
            poolEntity.setAreaName(StringUtils.isNotEmpty((CharSequence)object.getString("Area")) ? object.getString("Area").replace(",", "/") : null);
            poolEntity.setAddress(object.getString("DetArea"));
            poolEntity.setBudgetVer(object.getString("BudgetVer"));
            if (StringUtils.isNotEmpty((CharSequence)object.getString("ProjectManager_Sid"))) {
                CommonResponse response1 = this.iEmployeeApi.getOneBySourceId(object.getString("ProjectManager_Sid"));
                if (response1.isSuccess() && response1.getData() != null) {
                    EmployeeVO employeeVO = (EmployeeVO)response1.getData();
                    poolEntity.setProjectManagementId(employeeVO.getUserId());
                    poolEntity.setProjectManagementName(employeeVO.getName());
                } else {
                    this.logger.error("\u67e5\u8be2\u9879\u76ee-{}\u7ecf\u7406\u4fe1\u606f\u5931\u8d25\uff01{}", (Object)object.getString("Account_Project_shortname"), (Object)JSONObject.toJSONString((Object)response1));
                }
            }
            OrgVO projectDepartment = this.generateProjectDepartment(poolEntity, orgVO);
            poolEntity.setProjectDepartmentId(projectDepartment.getId());
            poolEntity.setProjectDepartmentName(projectDepartment.getName());
            projectDepartment.setProjectState(Integer.valueOf(1));
            CommonResponse resp = this.iOrgApi.saveOrgInfo(projectDepartment);
            if (!resp.isSuccess()) {
                this.logger.error("\u4e2d\u75354\u516c\u53f8\u540c\u6b65\u9879\u76ee\u4ee5\u53ca\u9879\u76ee\u4e0b\u4eba\u5458\u517c\u804c\u6570\u636e\u5931\u8d25\uff0c\u4fdd\u5b58\u9879\u76ee\u90e8\u7ec4\u7ec7\u4fe1\u606f\u51fa\u9519: " + resp.getMsg());
                continue;
            }
            this.projectSetService.saveOrUpdate((Object)poolEntity, false);
            JSONArray array = object.getJSONArray("Project_SuBList");
            if (array == null || array.size() <= 0) continue;
            for (Object o1 : array) {
                JSONObject data = (JSONObject)o1;
                data.put("projectDepartmentId", (Object)projectDepartment.getId());
            }
            this.iEmployeeApi.partJobBeachForZd4(array);
        }
    }

    private OrgVO generateProjectDepartment(ProjectSetPoolEntity poolEntity, OrgVO parentOrg) {
        OrgVO projectDepartment = null;
        if (poolEntity.getProjectDepartmentId() != null) {
            projectDepartment = (OrgVO)this.iOrgApi.getOneById(poolEntity.getProjectDepartmentId()).getData();
        } else {
            projectDepartment = new OrgVO();
            projectDepartment.setId(Long.valueOf(IdWorker.getId()));
            projectDepartment.setTenantId(Long.valueOf(999999L));
            projectDepartment.setName(poolEntity.getName());
            projectDepartment.setShortName(poolEntity.getShortName());
            projectDepartment.setState(Integer.valueOf(1));
            projectDepartment.setOrgType(OrgVO.ORG_TYPE_DEPARTMENT);
        }
        projectDepartment.setIsParent(Boolean.valueOf(false));
        projectDepartment.setProjectCode(poolEntity.getCode());
        projectDepartment.setEnterpriseId(parentOrg.getEnterpriseId());
        projectDepartment.setParentId(parentOrg.getId());
        projectDepartment.setNote("\u4e3b\u6570\u636e\u751f\u6210\u9879\u76ee\u90e8\uff01\u65f6\u95f4\uff1a" + DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date()));
        return projectDepartment;
    }
}

