package com.ejianc.foundation.support.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.support.bean.BankAccountEntity;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;

/**
 * 银行账户实体
 * 
 * @author generator
 * 
 */
public interface IBankAccountService extends IBaseService<BankAccountEntity> {

    BankAccountVO insertOrUpdate(BankAccountVO saveorUpdateVO);

    String delete(List<Long> ids);

    /**
     * 删除供方或者客户，对应银行账户也删除
     * @param type  supplierId or customerId
     * @param ids
     * @return
     */
    String delBySuppAndCustomIds(String type, List<Long> ids);

    CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response);

    String saveImportExcel(HttpServletRequest request, List<BankAccountVO> importVOS);

    String enabled(List<BankAccountVO> vos);

    String defaultFlag(BankAccountVO vo);

    /**
     * @description:
     *
     * @param voList
     * @param defaultFlagMap
     * @param countMap
     * @param isValidateDefaultAndCount  费否校验只能有一个默认账户和银行账户总数不能大于10
     * @return: void
     * @author songlx
     * @date: 2022/5/24
     */
    void validate(List<BankAccountVO> voList, HashMap<String, String> defaultFlagMap, HashMap<String, Integer> countMap, boolean isValidateDefaultAndCount);
}
