/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller.api;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.share.bean.ProjectSetPoolEntity;
import com.ejianc.foundation.share.bean.ProjectWbsEntity;
import com.ejianc.foundation.share.service.IProjectSetService;
import com.ejianc.foundation.share.service.IProjectWbsService;
import com.ejianc.foundation.share.vo.ProjectWbsVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/shareProjectWbsApi/"})
public class ProjectWbsApi {
    @Autowired
    private IProjectWbsService projectWbsService;
    @Autowired
    private IProjectSetService projectSetService;

    @GetMapping(value={"queryProjectWbsList"})
    public CommonResponse<List<ProjectWbsVO>> queryProjectWbsList(@RequestParam(value="id") Long id) {
        ProjectWbsEntity parent = (ProjectWbsEntity)((Object)this.projectWbsService.selectById(id));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("innerCode", new Parameter("like_right", (Object)parent.getInnerCode()));
        queryParam.getParams().put("enabled", new Parameter("eq", (Object)1));
        List list = this.projectWbsService.queryList(queryParam, false);
        List projectWbsVOList = BeanMapper.mapList((Iterable)list, ProjectWbsVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)projectWbsVOList);
    }

    @GetMapping(value={"queryByProjectId"})
    CommonResponse<List<ProjectWbsVO>> queryByProjectId(@RequestParam(value="projectId") Long projectId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        queryParam.getParams().put("enabled", new Parameter("eq", (Object)1));
        List list = this.projectWbsService.queryList(queryParam, false);
        List projectWbsVOList = BeanMapper.mapList((Iterable)list, ProjectWbsVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)projectWbsVOList);
    }

    @GetMapping(value={"queryByProjectIds"})
    CommonResponse<Map<Long, ProjectWbsVO>> queryByProjectIds(@RequestParam(value="projectIds") List<Long> projectIds) {
        HashMap<Long, Object> map = new HashMap<Long, Object>();
        if (CollectionUtils.isNotEmpty(projectIds)) {
            for (int i = 0; i < projectIds.size(); ++i) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"project_id", (Object)projectIds.get(i));
                List list = this.projectWbsService.list((Wrapper)queryWrapper);
                if (0 == list.size()) {
                    ProjectSetPoolEntity projectSetPoolEntity = (ProjectSetPoolEntity)((Object)this.projectSetService.selectById(projectIds.get(i)));
                    long id = IdWorker.getId();
                    ProjectWbsVO projectWbsVO = new ProjectWbsVO();
                    projectWbsVO.setId(id);
                    projectWbsVO.setCode(projectSetPoolEntity.getCode());
                    projectWbsVO.setName(projectSetPoolEntity.getName());
                    projectWbsVO.setProjectId(projectIds.get(i));
                    projectWbsVO.setOrgId(projectSetPoolEntity.getOrgId());
                    projectWbsVO.setEnabled(1);
                    projectWbsVO.setInnerCode(String.valueOf(id));
                    ProjectWbsEntity projectWbsEntity = (ProjectWbsEntity)((Object)BeanMapper.map((Object)((Object)projectWbsVO), ProjectWbsEntity.class));
                    this.projectWbsService.saveOrUpdate((Object)projectWbsEntity);
                    map.put(projectIds.get(i), BeanMapper.map((Object)((Object)projectWbsEntity), ProjectWbsVO.class));
                    continue;
                }
                map.put(projectIds.get(i), BeanMapper.map(list.get(0), ProjectWbsVO.class));
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", map);
    }
}

