package com.ejianc.foundation.supplier.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.supplier.bean.ShareSupplierEntity;
import com.ejianc.foundation.supplier.bean.ShareSupplierLinkerEntity;
import com.ejianc.foundation.supplier.service.IShareSupplierLinkerService;
import com.ejianc.foundation.supplier.service.IShareSupplierService;
import com.ejianc.foundation.supplier.vo.ShareSupplierLinkerVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 供应商联系人
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("shareSupplierLinker")
public class ShareSupplierLinkerController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IShareSupplierLinkerService service;
    @Autowired
    private IShareSupplierService shareSupplierService;

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ShareSupplierLinkerVO> queryDetail(Long id) {
    	ShareSupplierLinkerEntity entity = service.selectById(id);
    	ShareSupplierLinkerVO vo = BeanMapper.map(entity, ShareSupplierLinkerVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    @GetMapping(value = "/getAllBySupplierId")
    @ResponseBody
    public CommonResponse<List<ShareSupplierLinkerVO>> getAllBySupplierId(@RequestParam Long id) {
        List<ShareSupplierLinkerVO> resp = new ArrayList<>();
        QueryWrapper<ShareSupplierLinkerEntity> query = new QueryWrapper<>();
        query.eq("supplier_id", id);
        query.eq("dr", BaseVO.DR_UNDELETE);

        List<ShareSupplierLinkerEntity> list = service.list(query);
        if(CollectionUtils.isNotEmpty(list)) {
            resp = BeanMapper.mapList(list, ShareSupplierLinkerVO.class);
        }

        return CommonResponse.success(resp);
    }


    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ShareSupplierLinkerVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<ShareSupplierLinkerEntity> page = service.queryPage(param,false);
        IPage<ShareSupplierLinkerVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ShareSupplierLinkerVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<ShareSupplierLinkerEntity> list = service.queryList(param);
        List<ShareSupplierLinkerVO> vos = BeanMapper.mapList(list, ShareSupplierLinkerVO.class);
        vos.stream().forEach(item -> {
            item.setSupplierAccFlagStr(0 == item.getSupplierAccFlag() ? "未生成" : "已生成");
            item.setSupplierAccStatusStr(0 == item.getSupplierAccStatus() ? "已停用" : "正常");
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", vos);
        ExcelExport.getInstance().export("supplier-linker-export.xlsx", beans, response);
    }

    /**
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/refShareSupplierLinkerData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ShareSupplierLinkerVO>> refShareSupplierLinkerData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ShareSupplierLinkerEntity> page = service.queryPage(param,false);
        IPage<ShareSupplierLinkerVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ShareSupplierLinkerVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

     @PostMapping(value = "/accCoordination")
     @ResponseBody
    public CommonResponse<ShareSupplierLinkerVO> accCoordination(@RequestBody ShareSupplierLinkerVO linkerVO) {
         ShareSupplierLinkerEntity linker = service.selectById(linkerVO.getId());
        //查询供应商是否协同
        ShareSupplierEntity supplier = shareSupplierService.selectById(linker.getSupplierId());
        if(Integer.valueOf("0").equals(supplier.getCoordination())) {
            //供应商为生成协同租户，则先创建协同租户
            shareSupplierService.createSupTenant(supplier);
        }
         ShareSupplierLinkerVO vo = service.createSupAccount(linker, supplier.getTenant());

        return CommonResponse.success("查询成功", vo);
    }
}
