/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.bean.CustomerProEntity;
import com.ejianc.foundation.share.service.ICustomerProService;
import com.ejianc.foundation.share.service.ISupplyBankService;
import com.ejianc.foundation.share.vo.CustomerProVO;
import com.ejianc.foundation.share.vo.SupplyBankVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.bean.BankAccountEntity;
import com.ejianc.foundation.support.service.IBankAccountService;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"customerPro"})
public class CustomerProController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "pro-supplier-code";
    @Autowired
    private ICustomerProService service;
    @Autowired
    private ISupplyBankService supplyBankService;
    @Autowired
    private IBankAccountService bankAccountService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CustomerProVO> saveOrUpdate(@RequestBody CustomerProVO saveOrUpdateVO) {
        QueryParam param;
        CustomerProEntity entity = (CustomerProEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, CustomerProEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            if (StringUtils.isEmpty((CharSequence)entity.getCode())) {
                BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
                CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    entity.setCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
            param = new QueryParam();
            param.getParams().put("code", new Parameter("eq", (Object)entity.getCode()));
            List entities = this.service.queryList(param);
            if (ListUtil.isNotEmpty((List)entities)) {
                return CommonResponse.error((String)"\u7f16\u7801\u91cd\u590d\uff01");
            }
            param = new QueryParam();
            param.getParams().put("taxPayerIdentifier", new Parameter("eq", (Object)entity.getTaxPayerIdentifier()));
            entities = this.service.queryList(param);
            if (ListUtil.isNotEmpty((List)entities)) {
                return CommonResponse.error((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u91cd\u590d\uff01");
            }
            param = new QueryParam();
            param.getParams().put("name", new Parameter("eq", (Object)entity.getName()));
            entities = this.service.queryList(param);
            if (ListUtil.isNotEmpty((List)entities)) {
                return CommonResponse.error((String)"\u5ba2\u6237\u540d\u79f0\u91cd\u590d\uff01");
            }
        } else {
            param = new QueryParam();
            param.getParams().put("code", new Parameter("eq", (Object)entity.getCode()));
            param.getParams().put("id", new Parameter("ne", (Object)entity.getId()));
            List entities = this.service.queryList(param);
            if (ListUtil.isNotEmpty((List)entities)) {
                return CommonResponse.error((String)"\u7f16\u7801\u91cd\u590d\uff01");
            }
            param = new QueryParam();
            param.getParams().put("id", new Parameter("ne", (Object)entity.getId()));
            param.getParams().put("taxPayerIdentifier", new Parameter("eq", (Object)entity.getTaxPayerIdentifier()));
            entities = this.service.queryList(param);
            if (ListUtil.isNotEmpty((List)entities)) {
                return CommonResponse.error((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u91cd\u590d\uff01");
            }
            param = new QueryParam();
            param.getParams().put("id", new Parameter("ne", (Object)entity.getId()));
            param.getParams().put("name", new Parameter("eq", (Object)entity.getName()));
            entities = this.service.queryList(param);
            if (ListUtil.isNotEmpty((List)entities)) {
                return CommonResponse.error((String)"\u5ba2\u6237\u540d\u79f0\u91cd\u590d\uff01");
            }
        }
        if (entity.getEnabled() == null) {
            entity.setEnabled(1);
        }
        this.service.saveOrUpdate((Object)entity, false);
        CustomerProVO vo = (CustomerProVO)BeanMapper.map((Object)((Object)entity), CustomerProVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CustomerProVO> queryDetail(Long id) {
        CustomerProEntity entity = (CustomerProEntity)((Object)this.service.selectById(id));
        QueryParam param = new QueryParam();
        param.getParams().put("supplierId", new Parameter("eq", (Object)id));
        List supplyBankEntities = this.bankAccountService.queryList(param, false);
        CustomerProVO vo = (CustomerProVO)BeanMapper.map((Object)((Object)entity), CustomerProVO.class);
        vo.setBanks(BeanMapper.mapList((Iterable)supplyBankEntities, BankAccountVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CustomerProVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (CustomerProVO vo : vos) {
                CommonResponse resp = this.billTypeApi.checkQuote("BT200422000000028", vo.getId());
                if (!resp.isSuccess()) {
                    return CommonResponse.error((String)("\u5220\u9664\u5931\u8d25\uff01" + resp.getMsg()));
                }
                CustomerProEntity customer = (CustomerProEntity)((Object)this.service.selectById(vo.getId()));
                if (customer.getInsideOrg() == null || !customer.getInsideOrg().booleanValue()) continue;
                return CommonResponse.error((String)"\u5220\u9664\u5931\u8d25\uff01\u4e0d\u80fd\u5220\u9664\u5185\u90e8\u5355\u4f4d\uff01");
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CustomerProVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        fuzzyFields.add("tax_payer_identifier");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (param.getParams().get("supplierFlag") == null) {
            param.getParams().put("supplierFlag", new Parameter("in", (Object)"2,3"));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CustomerProVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("CustomerPro-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refCustomerProData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<CustomerProVO>> refCustomerProData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        Boolean insideOrg;
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        fuzzyFields.add("tax_payer_identifier");
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("supplierFlag", new Parameter("in", (Object)"2,3"));
        if (StringUtils.isNotEmpty((CharSequence)condition) && (insideOrg = (_con = JSONObject.parseObject((String)condition)).getBoolean("insideOrg")) != null) {
            param.getParams().put("insideOrg", new Parameter("eq", (Object)insideOrg));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CustomerProVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/saveOrUpdateBank"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<BankAccountVO>> saveOrUpdateBank(@RequestBody SupplyBankVO supplyBankVO) {
        if (supplyBankVO.getPid() == null) {
            return CommonResponse.error((String)"\u8bf7\u5148\u65b0\u5efa\u5ba2\u6237\u518d\u6dfb\u52a0\u94f6\u884c\u6863\u6848\uff01");
        }
        CustomerProEntity customer = (CustomerProEntity)((Object)this.service.selectById(supplyBankVO.getPid()));
        if (customer == null) {
            return CommonResponse.error((String)"\u8bf7\u5148\u65b0\u5efa\u5ba2\u6237\u518d\u6dfb\u52a0\u94f6\u884c\u6863\u6848\uff01");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("supplierId", new Parameter("eq", (Object)customer.getId()));
        List supplyBankEntities = this.bankAccountService.queryList(param, false);
        if (supplyBankEntities.size() == 0) {
            supplyBankVO.setDefaultable(1);
        } else if (supplyBankVO.getId() != null) {
            BankAccountEntity bankAccountEntity = (BankAccountEntity)((Object)this.bankAccountService.selectById(supplyBankVO.getId()));
            if (supplyBankVO.getDefaultable() == 1 && bankAccountEntity.getDefaultFlag() != 1) {
                for (BankAccountEntity bankEntity : supplyBankEntities) {
                    bankEntity.setDefaultFlag(0);
                }
                this.bankAccountService.saveOrUpdateBatch(supplyBankEntities);
                bankAccountEntity = (BankAccountEntity)((Object)this.bankAccountService.selectById(supplyBankVO.getId()));
            } else if (supplyBankVO.getDefaultable() != 1 && bankAccountEntity.getDefaultFlag() == 1) {
                return CommonResponse.error((String)"\u81f3\u5c11\u6709\u4e00\u4e2a\u9ed8\u8ba4\u8d26\u6237\uff01");
            }
            bankAccountEntity.setDefaultFlag(supplyBankVO.getDefaultable());
            bankAccountEntity.setBankId(supplyBankVO.getBankId());
            bankAccountEntity.setBankName(supplyBankVO.getBankName());
            bankAccountEntity.setBankCode(supplyBankVO.getBankCode());
            bankAccountEntity.setBankAccount(supplyBankVO.getBankAccount());
            bankAccountEntity.setCategoryId(supplyBankVO.getCategoryId());
            bankAccountEntity.setCategoryName(supplyBankVO.getCategoryName());
            bankAccountEntity.setSupplierFlag(customer.getSupplierFlag());
            bankAccountEntity.setBankAddress(supplyBankVO.getAddress());
            bankAccountEntity.setBankNum(supplyBankVO.getBankNum());
            bankAccountEntity.setSupplierCode(customer.getCode());
            bankAccountEntity.setEnabled(1);
            if (bankAccountEntity.getDefaultFlag() == null) {
                bankAccountEntity.setDefaultFlag(0);
            }
            this.bankAccountService.saveOrUpdateNoES((Object)bankAccountEntity);
            supplyBankEntities = this.bankAccountService.queryList(param, false);
            List vo = BeanMapper.mapList((Iterable)supplyBankEntities, BankAccountVO.class);
            return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01", (Object)vo);
        }
        BankAccountVO bankAccountVO = (BankAccountVO)BeanMapper.map((Object)supplyBankVO, BankAccountVO.class);
        if (customer.getInsideOrg() != null && customer.getInsideOrg().booleanValue()) {
            bankAccountVO.setInsideState(Integer.valueOf(1));
        } else {
            bankAccountVO.setInsideState(Integer.valueOf(0));
        }
        bankAccountVO.setSupplierId(customer.getId());
        bankAccountVO.setSupplierName(customer.getName());
        bankAccountVO.setOrgId(customer.getApplyOrgId());
        bankAccountVO.setOrgName(customer.getApplyOrgName());
        bankAccountVO.setSupplierCode(customer.getCode());
        bankAccountVO.setBankAddress(supplyBankVO.getAddress());
        bankAccountVO.setSupplierFlag(customer.getSupplierFlag());
        bankAccountVO.setEnabled(Integer.valueOf(1));
        if (bankAccountVO.getDefaultFlag() == null) {
            bankAccountVO.setDefaultFlag(Integer.valueOf(0));
        }
        this.bankAccountService.insertOrUpdate(bankAccountVO);
        supplyBankEntities = this.bankAccountService.queryList(param, false);
        List vo = BeanMapper.mapList((Iterable)supplyBankEntities, BankAccountVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delBank"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<BankAccountVO>> delBank(@RequestBody List<Long> ids) {
        BankAccountEntity accountEntity = null;
        if (ListUtil.isNotEmpty(ids)) {
            for (Long id : ids) {
                CommonResponse response = this.billTypeApi.checkQuote("BT200422000000028", id);
                if (!response.isSuccess()) {
                    return CommonResponse.error((String)("\u5220\u9664\u5931\u8d25\uff1a" + response.getMsg()));
                }
                accountEntity = (BankAccountEntity)((Object)this.bankAccountService.selectById(id));
            }
        } else {
            return CommonResponse.error((String)"\u5220\u9664\u5931\u8d25\uff1a\u4e3b\u952e\u4e3a\u7a7a!");
        }
        this.bankAccountService.delBySuppAndCustomIds("supplierId", ids);
        QueryParam param = new QueryParam();
        param.getParams().put("supplierId", new Parameter("eq", (Object)accountEntity.getSupplierId()));
        List supplyBankEntities = this.bankAccountService.queryList(param, false);
        List vo = BeanMapper.mapList((Iterable)supplyBankEntities, BankAccountVO.class);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }
}

