package com.ejianc.foundation.share.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.share.bean.SubjectProjectEntity;
import com.ejianc.foundation.share.service.ISubjectProjectService;
import com.ejianc.foundation.share.vo.SubjectProjectVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping("/api/shareSubjectProjectApi/")
public class SubjectProjectApi {

    @Autowired
    private ISubjectProjectService subjectProjectService;

    /**
     * 根据编码集合查询档案列表
     * @Author zhangwx
     * @param nameList
     * @return
     */
    @GetMapping("queryListByProjAndCodes")
    public CommonResponse<List<SubjectProjectVO>> queryListByProjAndCodes(@RequestParam(value = "projectId") Long projectId, @RequestParam(value = "nameList", required = false) List<String> nameList) {
        QueryWrapper<SubjectProjectEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("enabled", 0);
        wrapper.eq("project_id", projectId);
        wrapper.in(CollectionUtils.isNotEmpty(nameList), "subject_name", nameList);
        List<SubjectProjectEntity> entitys = subjectProjectService.list(wrapper);
        if(null != entitys && entitys.size() > 0){
            return CommonResponse.success(BeanMapper.mapList(entitys, SubjectProjectVO.class));
        }
        return CommonResponse.error("查询失败,未查到相关数据。");
    }


}
