package com.ejianc.foundation.init.service.impl;

import com.ejianc.foundation.init.mapper.InitMapper;
import com.ejianc.foundation.init.service.InitService;
import com.ejianc.foundation.initData.vo.EnterpriseInitVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class InitServiceImpl implements InitService {
    @Autowired
    InitMapper initMapper;


    @Override
    public void initData(EnterpriseInitVO vo) {
        if(isNotAdmin()){
            throw new BusinessException("无权操作!");
        }
        if(vo.getTenantId() == null){
            throw new BusinessException("租户id不存在!");
        }
        //建表
        initMapper.createThreeTables(vo.getTenantId());
    }

    @Override
    public void rollBack(Long tenantId) {
        if(isNotAdmin()){
            throw new BusinessException("无权操作!");
        }
        if(tenantId == null){
            throw new BusinessException("租户id不存在!");
        }
        initMapper.dropThreeTables(tenantId);
    }

    public Boolean isNotAdmin(){
        return !InvocationInfoProxy.getTenantid().equals(999999L);
    }
}
