/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.util;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class HttpToolKitZd4 {
    private static String appid;
    private static String secret;
    private static final Map<String, String> headers;
    private static final int connTimeout = 120000;
    private static final int readTimeout = 120000;
    private static final Charset charset;
    private static HttpClient client;

    public static void setSecureAccount(String appid, String secret) {
        HttpToolKitZd4.appid = appid;
        HttpToolKitZd4.secret = secret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String url, String body) throws Exception {
        CloseableHttpClient client = null;
        HttpPost post = new HttpPost(url);
        String result = "";
        try {
            HttpResponse res;
            if (StringUtils.isNotBlank((CharSequence)body)) {
                StringEntity entity = new StringEntity(body, ContentType.create((String)"application/json", (Charset)charset));
                post.setEntity((HttpEntity)entity);
            }
            Map<String, String> headers = HttpToolKitZd4.getHeaders();
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                post.addHeader(entry.getKey(), entry.getValue());
            }
            RequestConfig.Builder customReqConf = RequestConfig.custom();
            customReqConf.setConnectTimeout(120000);
            customReqConf.setSocketTimeout(120000);
            post.setConfig(customReqConf.build());
            if (url.startsWith("https")) {
                client = HttpToolKitZd4.createSSLInsecureClient();
                res = client.execute((HttpUriRequest)post);
            } else {
                client = HttpToolKitZd4.client;
                res = client.execute((HttpUriRequest)post);
            }
            result = IOUtils.toString((InputStream)res.getEntity().getContent(), (Charset)charset);
        }
        catch (Throwable throwable) {
            post.releaseConnection();
            if (url.startsWith("https") && client != null && client instanceof CloseableHttpClient) {
                ((CloseableHttpClient)client).close();
            }
            throw throwable;
        }
        post.releaseConnection();
        if (url.startsWith("https") && client != null && client instanceof CloseableHttpClient) {
            client.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String url, Map<String, String> params) throws Exception {
        CloseableHttpClient client = null;
        if (params != null && params.size() > 0) {
            String[] paramsArray = params.keySet().toArray(new String[0]);
            for (int i = 0; i < paramsArray.length; ++i) {
                if (params.get(paramsArray[i]) == null) continue;
                url = url + (i == 0 ? "?" : "&") + paramsArray[i] + "=" + URLEncoder.encode(params.get(paramsArray[i]), "UTF-8");
            }
        }
        HttpGet get = new HttpGet(url);
        String result = "";
        try {
            RequestConfig.Builder customReqConf = RequestConfig.custom();
            customReqConf.setConnectTimeout(120000);
            Map<String, String> headers = HttpToolKitZd4.getHeaders();
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                get.addHeader(entry.getKey(), entry.getValue());
            }
            customReqConf.setSocketTimeout(120000);
            get.setConfig(customReqConf.build());
            HttpResponse res = null;
            if (url.startsWith("https")) {
                client = HttpToolKitZd4.createSSLInsecureClient();
                res = client.execute((HttpUriRequest)get);
            } else {
                client = HttpToolKitZd4.client;
                res = client.execute((HttpUriRequest)get);
            }
            result = IOUtils.toString((InputStream)res.getEntity().getContent(), (Charset)charset);
        }
        catch (Throwable throwable) {
            get.releaseConnection();
            if (url.startsWith("https") && client instanceof CloseableHttpClient) {
                ((CloseableHttpClient)client).close();
            }
            throw throwable;
        }
        get.releaseConnection();
        if (url.startsWith("https") && client instanceof CloseableHttpClient) {
            client.close();
        }
        return result;
    }

    private static CloseableHttpClient createSSLInsecureClient() throws GeneralSecurityException {
        SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                return true;
            }
        }).build();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, new X509HostnameVerifier(){

            public boolean verify(String arg0, SSLSession arg1) {
                return true;
            }

            public void verify(String host, SSLSocket ssl) throws IOException {
            }

            public void verify(String host, X509Certificate cert) throws SSLException {
            }

            public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
            }
        });
        return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
    }

    private static Map<String, String> getHeaders() {
        headers.put("appid", HttpToolKitZd4.toMD5(appid));
        headers.put("ticket", DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date()));
        headers.put("sign", HttpToolKitZd4.toMD5(secret + HttpToolKitZd4.toMD5(appid) + HttpToolKitZd4.toMD5(headers.get("ticket"))));
        System.out.println(JSONObject.toJSONString(headers));
        return headers;
    }

    private static String toMD5(String plainText) {
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        byte[] hashBytes = digest.digest(plainText.getBytes());
        StringBuilder sb = new StringBuilder();
        for (byte b : hashBytes) {
            sb.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString().toLowerCase();
    }

    static {
        headers = new HashMap<String, String>();
        charset = StandardCharsets.UTF_8;
        client = null;
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(128);
        cm.setDefaultMaxPerRoute(128);
        client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
    }
}

