package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.SupHisPerformanceVO;
import com.ejianc.business.zdssupplier.sub.api.ISubSupplierApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.bean.CertsEntity;
import com.ejianc.foundation.share.bean.SubleadersEntity;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.service.ICertsService;
import com.ejianc.foundation.share.service.ISubleadersService;
import com.ejianc.foundation.share.service.ISupplierLinkerService;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.share.vo.*;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.bean.BankAccountEntity;
import com.ejianc.foundation.support.service.IBankAccountService;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.foundation.util.ExcelReader;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;

/**
 * 供方controller
 *
 * @author guoming
 */
@Controller
@RequestMapping("/supplier/")
public class SupplierController implements Serializable {

	private static final long serialVersionUID = 1L;

	private static final String SUPPLIER_BILL_CODE = "SUPPORT_SUPPLIER";
	@Value("${eachLink.host}")
	private String eachLinkHost;

	@Value("${eachLink.appId}")
	private String appId;

	@Value("${eachLink.secret}")
	private String secret;

	@Autowired
	private ISupplierService supplierService;
	@Autowired
	private ISupplierLinkerService supplierLinkerService;
	@Autowired
	private IBillCodeApi billCodeApi;
	@Autowired
	private IBillTypeApi billTypeApi;
	@Autowired
	private IBankAccountService bankAccountService;
	@Autowired
	private ICertsService certsService;
	@Autowired
	private ISubleadersService subleadersService;
	@Autowired
	private ISystemDataPushService systemDataPushService;
	@Autowired
	private RedisTemplate<String, Object> redisTemplate;
	@Autowired
	private IContractPoolApi contractPoolApi;
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private ISubSupplierApi subSupplierApi;

	/**
	 * 新增或者修改
	 *
	 * @param supplierVo
	 * @return
	 */
	@RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<SupplierVO> saveOrUpdate(@RequestBody SupplierVO supplierVo) {
		supplierVo.setBanks(new ArrayList<>());
		List<HistoryVO> history = supplierVo.getHistory();
		supplierVo.setHistory(new ArrayList<>());
		CommonResponse<SupplierVO> response = supplierService.saveOrUpdate(supplierVo);
		supplierVo.setHistory(history);
		return response;
	}

	/**
	 * 根据主键ID查询供方详情
	 *
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<SupplierVO> queryDetail(@RequestParam Long id) {
		return queryDetails(id);
	}

	/**
	 * 查询企业供应商详情
	 *
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/queryDetails", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<SupplierVO> queryDetails(@RequestParam Long id) {
		SupplierEntity supplierEntity = supplierService.selectById(id);
		if(supplierEntity == null){
			return CommonResponse.error("查询失败");
		}
		QueryParam param = new QueryParam();
		param.getParams().put("supplierId", new Parameter(QueryParam.EQ, id));

		List<BankAccountEntity> supplyBankEntities = bankAccountService.queryList(param, false);
		SupplierVO supplierVo = BeanMapper.map(supplierEntity,SupplierVO.class);
		supplierVo.setBanks(BeanMapper.mapList(supplyBankEntities,BankAccountVO.class));

		CommonResponse<List<SupHisPerformanceVO>> historyCommon =contractPoolApi.supHisPerformanceList(id);
		if(historyCommon.isSuccess()){
			List<HistoryVO> historyAllList = new ArrayList<>();
			List<SupHisPerformanceVO> historyList= historyCommon.getData();
			for (SupHisPerformanceVO supHisPerformanceVO:historyList){
				HistoryVO historyVO = new HistoryVO();
				historyVO.setId(IdWorker.getId());
				historyVO.setContacts(supHisPerformanceVO.getContacts());
				historyVO.setContactsPhone(supHisPerformanceVO.getContactsPhone());
				historyVO.setContractMny(supHisPerformanceVO.getContractMny());
				historyVO.setCooperationContent(supHisPerformanceVO.getCooperationContent());
				historyVO.setCooperationOrg(supHisPerformanceVO.getCooperationOrg());
				historyVO.setEndDay(supHisPerformanceVO.getEndDay());
				historyVO.setEngineeringAddress(supHisPerformanceVO.getEngineeringAddress());
				historyVO.setEngineeringName(supHisPerformanceVO.getEngineeringName());
				historyAllList.add(historyVO);
			}
			for (HistoryVO vo:supplierVo.getHistory()){
				historyAllList.add(vo);
			}
			supplierVo.setHistory(historyAllList);
		}
		return CommonResponse.success(supplierVo);
	}
	/**
	 * 查询企业供应商详情
	 *
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/querySubDetails", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<SupplierVO> querySubDetails(@RequestParam Long id) {
		SubleadersEntity subleadersEntity = subleadersService.selectById(id);
		if(subleadersEntity == null){
			return CommonResponse.error("查询失败");
		}
		SupplierEntity supplierEntity = supplierService.selectById(subleadersEntity.getPid());
		supplierEntity.setExceptionEndDate(subleadersEntity.getExceptionEndDate());
		supplierEntity.setPunishType(subleadersEntity.getPunishType());
		supplierEntity.setPunishDate(subleadersEntity.getPunishDate());
		supplierEntity.setPunishGrade(subleadersEntity.getPunishGrade());
		supplierEntity.setPunishApplyOrg(subleadersEntity.getPunishApplyOrg());
		supplierEntity.setPunishApplyPerson(subleadersEntity.getPunishApplyPerson());
		supplierEntity.setPunishMemo(subleadersEntity.getPunishMemo());

		QueryParam param = new QueryParam();
		param.getParams().put("supplierId", new Parameter(QueryParam.EQ, id));

		List<BankAccountEntity> supplyBankEntities = bankAccountService.queryList(param, false);
		SupplierVO supplierVo = BeanMapper.map(supplierEntity,SupplierVO.class);
		supplierVo.setBanks(BeanMapper.mapList(supplyBankEntities,BankAccountVO.class));

		CommonResponse<List<SupHisPerformanceVO>> historyCommon =contractPoolApi.supHisPerformanceList(id);
		if(historyCommon.isSuccess()){
			List<HistoryVO> historyAllList = new ArrayList<>();
			List<SupHisPerformanceVO> historyList= historyCommon.getData();
			for (SupHisPerformanceVO supHisPerformanceVO:historyList){
				HistoryVO historyVO = new HistoryVO();
				historyVO.setId(IdWorker.getId());
				historyVO.setContacts(supHisPerformanceVO.getContacts());
				historyVO.setContactsPhone(supHisPerformanceVO.getContactsPhone());
				historyVO.setContractMny(supHisPerformanceVO.getContractMny());
				historyVO.setCooperationContent(supHisPerformanceVO.getCooperationContent());
				historyVO.setCooperationOrg(supHisPerformanceVO.getCooperationOrg());
				historyVO.setEndDay(supHisPerformanceVO.getEndDay());
				historyVO.setEngineeringAddress(supHisPerformanceVO.getEngineeringAddress());
				historyVO.setEngineeringName(supHisPerformanceVO.getEngineeringName());
				historyAllList.add(historyVO);
			}
			for (HistoryVO vo:supplierVo.getHistory()){
				historyAllList.add(vo);
			}
			supplierVo.setHistory(historyAllList);
		}
		return CommonResponse.success(supplierVo);
	}
	/**
	 * 删除
	 *
	 * @param ids
	 * @return
	 */
	@RequestMapping(value = "/delete", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> delete(@RequestBody List<Long> ids) {
		if(ListUtil.isNotEmpty(ids)){
			bankAccountService.delBySuppAndCustomIds("supplierId",ids);
			for (Long id : ids) {
				CommonResponse<String>  response = billTypeApi.checkQuote("BT200422000000028",id);
				if(!response.isSuccess()){
					return CommonResponse.error("删除失败："+response.getMsg());
				}
			}
		}else {
			return CommonResponse.error("删除失败：主键为空!");
		}
		supplierService.deleteSupplier(ids);
		return CommonResponse.success("删除成功");
	}




	/**
	 * 新增或者修改银行信息
	 *
	 * @param
	 * @return
	 */
	@RequestMapping(value = "/saveOrUpdateBank", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<List<BankAccountVO>> saveOrUpdateBank(@RequestBody SupplyBankVO supplyBankVO) {
		if(supplyBankVO.getPid() == null){
			return CommonResponse.error("请先新建供应商再添加银行档案！");
		}
		SupplierEntity supplier = supplierService.selectById(supplyBankVO.getPid());
		if(supplier == null){
			return CommonResponse.error("请先新建供应商再添加银行档案！");
		}

		QueryParam param = new QueryParam();
		param.getParams().put("supplierId", new Parameter(QueryParam.EQ, supplier.getId()));
		List<BankAccountEntity> supplyBankEntities = bankAccountService.queryList(param, false);


		if(supplyBankEntities.size() == 0) {
			supplyBankVO.setDefaultable(1);
		}else {
			if(supplyBankVO.getId()!=null){
				BankAccountEntity bankAccountEntity = bankAccountService.selectById(supplyBankVO.getId());
				if(supplyBankVO.getDefaultable() == 1 && bankAccountEntity.getDefaultFlag() != 1){
					for (BankAccountEntity bankEntity : supplyBankEntities) {
						bankEntity.setDefaultFlag(0);
					}
					bankAccountService.saveOrUpdateBatch(supplyBankEntities);
					bankAccountEntity = bankAccountService.selectById(supplyBankVO.getId());
				}else {
					if(supplyBankVO.getDefaultable() != 1 && bankAccountEntity.getDefaultFlag() == 1){
						return CommonResponse.error("至少有一个默认账户！");
					}
				}
				bankAccountEntity.setDefaultFlag(supplyBankVO.getDefaultable());
				bankAccountEntity.setBankId(supplyBankVO.getBankId());
				bankAccountEntity.setBankName(supplyBankVO.getBankName());
				bankAccountEntity.setBankCode(supplyBankVO.getBankCode());
				bankAccountEntity.setBankAccount(supplyBankVO.getBankAccount());
				bankAccountEntity.setCategoryId(supplyBankVO.getCategoryId());
				bankAccountEntity.setCategoryName(supplyBankVO.getCategoryName());
				bankAccountEntity.setSupplierFlag(supplier.getSupplierFlag());
				bankAccountEntity.setBankNum(supplyBankVO.getBankNum());
				bankAccountEntity.setBankAddress(supplyBankVO.getAddress());
				bankAccountEntity.setEnabled(1);
				if(bankAccountEntity.getDefaultFlag()==null){
					bankAccountEntity.setDefaultFlag(0);
				}
				bankAccountService.saveOrUpdateNoES(bankAccountEntity);

				supplyBankEntities = bankAccountService.queryList(param, false);

				List<BankAccountVO> vo = BeanMapper.mapList(supplyBankEntities,BankAccountVO.class);
				return CommonResponse.success("修改成功！",vo);
			}
		}

		BankAccountVO bankAccountVO = BeanMapper.map(supplyBankVO, BankAccountVO.class);
		if(supplier.getInsideOrg()!=null && supplier.getInsideOrg()){
			bankAccountVO.setInsideState(1);
		}else {
			bankAccountVO.setInsideState(0);
		}
		bankAccountVO.setSupplierId(supplier.getId());
		bankAccountVO.setSupplierName(supplier.getName());
		bankAccountVO.setOrgId(supplier.getApplyOrgId());
		bankAccountVO.setOrgName(supplier.getApplyOrgName());
		bankAccountVO.setSupplierCode(supplier.getCode());
		bankAccountVO.setBankAddress(supplyBankVO.getAddress());
		bankAccountVO.setSupplierFlag(supplier.getSupplierFlag());
		bankAccountVO.setEnabled(1);
		if(bankAccountVO.getDefaultFlag()==null){
			bankAccountVO.setDefaultFlag(0);
		}
		bankAccountService.insertOrUpdate(bankAccountVO);
		supplyBankEntities = bankAccountService.queryList(param, false);
		List<BankAccountVO> vo = BeanMapper.mapList(supplyBankEntities,BankAccountVO.class);
		return CommonResponse.success("保存成功！",vo);
	}

	/**
	 * 删除银行账户
	 *
	 * @param ids
	 * @return
	 */
	@RequestMapping(value = "/delBank", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> delBank(@RequestBody List<Long> ids) {
		if(ListUtil.isNotEmpty(ids)){
			for (Long id : ids) {
				CommonResponse<String>  response = billTypeApi.checkQuote("BT200422000000028",id);
				if(!response.isSuccess()){
					return CommonResponse.error("删除失败："+response.getMsg());
				}
			}
			bankAccountService.delBySuppAndCustomIds("supplierId",ids);
		}else {
			return CommonResponse.error("删除失败：主键为空!");
		}
		return CommonResponse.success("删除成功");
	}
	/**
	 * 查询 供应商库
	 *
	 * @param queryParam
	 * @return
	 */
	@RequestMapping(value = "/queryList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<IPage<SupplierVO>> queryList(@RequestBody QueryParam queryParam) {

		queryParam.getFuzzyFields().add("name");
		queryParam.getFuzzyFields().add("code");
		queryParam.getFuzzyFields().add("material_content");
		queryParam.getFuzzyFields().add("equipment_content");
		queryParam.getFuzzyFields().add("major_content");
		queryParam.getFuzzyFields().add("punish_apply_org");
		queryParam.getFuzzyFields().add("apply_org_name");
		queryParam.getFuzzyFields().add("tax_payer_identifier");
		queryParam.getFuzzyFields().add("tenantPhone");


		if(queryParam.getParams().get("insideOrg") != null){
			if("true".equals(queryParam.getParams().get("insideOrg").getValue())){
				queryParam.getParams().put("insideOrg",new Parameter(QueryParam.EQ,true));
			}else {
				queryParam.getParams().put("insideOrg",new Parameter(QueryParam.EQ,false));

			}
		}

		if(queryParam.getParams().get("supplyType") != null){
			String[] supplyType =  queryParam.getParams().get("supplyType").getValue().toString().split(",");
			ComplexParam c = new ComplexParam();
			c.setLogic(ComplexParam.AND);
			for (int i = 0; i < supplyType.length; i++) {
				String type = supplyType[i];
				ComplexParam t = new ComplexParam();
				t.setLogic(ComplexParam.OR);
				t.getParams().put("supplyType",new Parameter(QueryParam.LIKE,type));
				c.getComplexParams().add(t);
			}
			queryParam.getComplexParams().add(c);
			queryParam.getParams().remove("supplyType");
		}
		//supplierFlag 客商属性，1、供应商，2、客户，3、客商
		queryParam.getParams().put("supplierFlag", new Parameter(QueryParam.IN, "1,3"));

		IPage<SupplierEntity> page = supplierService.queryPage(queryParam,false);

		IPage<SupplierVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SupplierVO.class));

		return CommonResponse.success(pageData);
	}

	/**
	 * 查询 分包负责人供应商库
	 *
	 * @param queryParam
	 * @return
	 */
	@RequestMapping(value = "/querySubLeaderList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<IPage<SubleadersVO>> querySubLeaderList(@RequestBody QueryParam queryParam) {

		queryParam.getFuzzyFields().add("name");

		IPage<SubleadersEntity> page = subleadersService.queryPage(queryParam,false);

		IPage<SubleadersVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
		Map<Long,SupplierEntity> supplierEntityMap = new HashMap<>();
		List<SubleadersVO> records = BeanMapper.mapList(page.getRecords(), SubleadersVO.class);
		if(ListUtil.isNotEmpty(records)){
			for (SubleadersVO record : records) {
				SupplierEntity supplier = supplierEntityMap.get(record.getPid());

					if(supplierEntityMap.get(record.getPid())!=null){
						supplier = supplierEntityMap.get(record.getPid());
					}else {

						supplier = supplierService.selectById(record.getPid());
						logger.info("record{}",supplier);
						if(supplier ==null){
							continue;
						}

						supplierEntityMap.put(supplier.getId(),supplier);
					}
					String content = "";
					if(StringUtils.isNotEmpty(supplier.getLaborContent())){
						content+=supplier.getLaborContent()+",";
					}
					if(StringUtils.isNotEmpty(supplier.getMajorContent())){
						content+=supplier.getMajorContent();
					}
					record.setSupplierContent(content);
					record.setSupplierName(supplier.getName());
					record.setSupplierGrade(supplier.getGradeName());
					record.setArea(supplier.getAreaName());
					record.setSupplierCode(supplier.getCode());
					record.setPersonal(supplier.getPersonal());

			}
		}
		pageData.setRecords(records);

		return CommonResponse.success(pageData);
	}



	/**
	 * 参照 供应商库下的分包负责人
	 *
	 * @return
	 */
	@RequestMapping(value = "/subLeaderRef", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<IPage<SubleadersVO>> subLeaderRef(@RequestParam(defaultValue = "1") int pageNumber,
															@RequestParam(defaultValue = "10") int pageSize,
															@RequestParam(required=false) String searchText,
															@RequestParam(required=false) String condition) {
		QueryParam queryParam = new QueryParam();

		queryParam.setPageSize(pageSize);
		queryParam.setPageIndex(pageNumber);
		queryParam.setSearchText(searchText);
		queryParam.getFuzzyFields().add("idNum");
		queryParam.getFuzzyFields().add("name");
		queryParam.getFuzzyFields().add("phone");
		queryParam.getFuzzyFields().add("gradeName");

		String supplierId = null;
		String inException = null;
		if (StringUtils.isNotEmpty(condition)) {
			JSONObject con = JSONObject.parseObject(condition);
			supplierId = con.getString("supplierId");
			inException = con.getString("inException");
		}
		if (StringUtils.isNotEmpty(supplierId)) {
			queryParam.getParams().put("pid", new Parameter(QueryParam.EQ, supplierId));
		}
		if (StringUtils.isNotEmpty(inException)) {
			queryParam.getParams().put("inException", new Parameter(QueryParam.EQ, true));//查询异常供应商
		} else {
			queryParam.getParams().put("inException", new Parameter(QueryParam.SQL, " in_exception is not true "));//排除异常供应商
		}

		IPage<SubleadersEntity> page = subleadersService.queryPage(queryParam, false);
		IPage<SubleadersVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
		List<SubleadersVO> records = BeanMapper.mapList(page.getRecords(), SubleadersVO.class);
		if (ListUtil.isNotEmpty(records)) {
			SupplierEntity supplier = null;
			if (StringUtils.isNotEmpty(supplierId)) {
				supplier = supplierService.selectById(supplierId);
			}
			for (SubleadersVO record : records) {
				if (supplier == null) {
					supplier = supplierService.selectById(record.getPid());
				}
				StringBuilder content = new StringBuilder("");
				if (StringUtils.isNotEmpty(supplier.getLaborContent())) {
					content.append(supplier.getLaborContent()).append(",");
				}
				if (StringUtils.isNotEmpty(supplier.getMajorContent())) {
					content.append(supplier.getMajorContent());
				}
				record.setSupplierContent(content.toString());
				record.setSupplierName(supplier.getName());
				record.setSupplierGrade(supplier.getGradeName());
				record.setArea(supplier.getAreaName());
			}
		}
		pageData.setRecords(records);

		return CommonResponse.success(pageData);
	}

	/**
	 * 查询供方分页列表
	 *
	 * @param queryParam
	 * @return
	 */
	@RequestMapping(value = "/pageList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
		IPage<SupplierVO> pageData = supplierService.queryPageList(queryParam);

		JSONObject jsonObject = new JSONObject();
		jsonObject.put("data", pageData);
		return CommonResponse.success(jsonObject);
	}

	/**
	 * 导入模板下载
	 *
	 * @param request
	 * @param response
	 */
	@RequestMapping(value = "/download")
	@ResponseBody
	public void download(HttpServletRequest request, HttpServletResponse response){
		ImportTemplate.initialize(response);
		ImportTemplate.templetdownload(request, "supplier-import.xlsx", "供方导入模板");
	}

	/**
	 * excel导入
	 *
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/excelImport", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<Object> excelImport(HttpServletRequest request, HttpServletResponse response) {
		MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
		Long tenantId = InvocationInfoProxy.getTenantid();
		boolean isFailed = false;
		MultipartFile mf = null;
		for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
			mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
        	extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
            	isFailed = true;
            	break;
            }
        }

		if(isFailed) {
			return CommonResponse.error("文件格式不合法");
		}else{
			//只读第一页（sheet）
			List<List<String>> result = ExcelReader.readExcel(mf);
			List<String> errorList = new ArrayList<String>();
			if(result != null && result.size() > 0) {
				for(int i=0;i<result.size();i++) {
					List<String> datas = result.get(i);
					SupplierVO supplierVo = null;
					if (StringUtils.isEmpty(datas.get(2))) {
						errorList.add("第" + i + "行数据：" + datas.toString() + "导入失败，原因：统一社会信用代码不能为空！");
						continue;
					} else {
						supplierVo = supplierService.queryDetailBySocialCode(String.valueOf(datas.get(2)));
						if (supplierVo != null) {
							errorList.add("第" + i + "行数据：" + datas.toString() + "导入失败，原因：存在相同统一社会信用代码的供应商！");
							continue;
						}
						supplierVo = new SupplierVO();
					}

					CommonResponse<String> codeBatchByRuleCode = billCodeApi.getCodeBatchByRuleCode(SUPPLIER_BILL_CODE, tenantId);
					if (codeBatchByRuleCode.isSuccess()) {
						supplierVo.setCode(codeBatchByRuleCode.getData());
					} else {
						supplierVo.setCode(String.valueOf(new Date().getTime()));
					}


					if (StringUtils.isEmpty(datas.get(1))) {
						errorList.add("第" + i + "行数据：" + datas.toString() + "导入失败，原因：供方名称不能为空！");
						continue;
					}
					supplierVo.setName(String.valueOf(datas.get(1)));
					supplierVo.setSocialCreditCode(String.valueOf(datas.get(2)));
					supplierVo.setLegal(String.valueOf(datas.get(3)));
					if (StringUtils.isNotEmpty(datas.get(4))) {
//							CommonResponse<DefdocDetailVO> defdocDetailVOCommonResponse = defdocApi.queryDetailByName(String.valueOf(datas.get(4)));
//							if(defdocDetailVOCommonResponse.isSuccess() && defdocDetailVOCommonResponse.getData() != null) {
//								supplierVo.setTaxPayerType(defdocDetailVOCommonResponse.getData().getId());
//							}
					}
					supplierVo.setBusinessScope(datas.get(5));
					supplierVo.setTelephone(datas.get(6));
					supplierVo.setArea(datas.get(7));
					supplierVo.setAddress(datas.get(8));
					supplierVo.setBankName(datas.get(9));
					supplierVo.setBankAccount(datas.get(10));
					supplierVo.setBankCode(datas.get(11));
					//供方方联系人
					if (StringUtils.isNotEmpty(datas.get(12))) {
						List<SupplierLinkerVO> gridheaders = new ArrayList<SupplierLinkerVO>();

						String linkman = String.valueOf(datas.get(12));
						SupplierLinkerVO supplierLinkerVo = supplierLinkerService.queryBySupplierIdAndLinkman(supplierVo.getId(), linkman);
						if (supplierLinkerVo == null) {
							supplierLinkerVo = new SupplierLinkerVO();
							supplierLinkerVo.setRowState("add");
						} else {
							supplierLinkerVo.setRowState("edit");
						}
						supplierLinkerVo.setSupplierId(supplierVo.getId());
						supplierLinkerVo.setLinkman(datas.get(12));
						supplierLinkerVo.setCellphone(datas.get(13));
						gridheaders.add(supplierLinkerVo);
						supplierVo.setGridheaders(gridheaders);
					}
					supplierVo.setEnabled(1);
					supplierService.saveOrUpdate(supplierVo);
				}
			}
			if(errorList.size() > 0) {

				errorList.add("导入成功："+(result.size() - errorList.size() - 1)+"条, 失败：" +errorList.size()+"条");
				return CommonResponse.error("导入失败", errorList);
			}else{
				return CommonResponse.success("导入成功");
			}
		}
	}

	/**
	 * excel导出
	 *
	 * @return
	 */
	@RequestMapping(value = "/excelExport", method = RequestMethod.POST)
	@ResponseBody
	public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
		queryParam.getFuzzyFields().add("code");
		queryParam.getFuzzyFields().add("name");
		queryParam.getFuzzyFields().add("material_content");
		queryParam.getFuzzyFields().add("equipment_content");
		queryParam.getFuzzyFields().add("punish_apply_org");
		queryParam.getFuzzyFields().add("major_content");
		queryParam.getFuzzyFields().add("apply_org_name");
		queryParam.getFuzzyFields().add("tax_payer_identifier");
		queryParam.getFuzzyFields().add("tenantPhone");

		queryParam.setPageIndex(1);
		queryParam.setPageSize(-1);

		if(queryParam.getParams().get("insideOrg") != null){
			if("true".equals(queryParam.getParams().get("insideOrg").getValue())){
				queryParam.getParams().put("insideOrg",new Parameter(QueryParam.EQ,true));
			}else {
				queryParam.getParams().put("insideOrg",new Parameter(QueryParam.EQ,false));

			}
		}

		if(queryParam.getParams().get("supplyType") != null){
			String[] supplyType =  queryParam.getParams().get("supplyType").getValue().toString().split(",");
			ComplexParam c = new ComplexParam();
			c.setLogic(ComplexParam.AND);
			for (int i = 0; i < supplyType.length; i++) {
				String type = supplyType[i];
				ComplexParam t = new ComplexParam();
				t.setLogic(ComplexParam.OR);
				t.getParams().put("supplyType",new Parameter(QueryParam.LIKE,type));
				c.getComplexParams().add(t);
			}
			queryParam.getComplexParams().add(c);
			queryParam.getParams().remove("supplyType");
		}
		//supplierFlag 客商属性，1、供应商，2、客户，3、客商
		queryParam.getParams().put("supplierFlag", new Parameter(QueryParam.IN, "1,3"));

		List<SupplierEntity> supplierVos = supplierService.queryList(queryParam,false);
		List<SupplierExcelVO> suppliers = new ArrayList<>();
		for (SupplierEntity supplierVo : supplierVos) {
			SupplierExcelVO excelVO = BeanMapper.map(supplierVo,SupplierExcelVO.class);
			excelVO.setPersonal("p".equals(supplierVo.getPersonal())?"个人":"企业");
			excelVO.setGroupInOrOut("in".equals(supplierVo.getGroupInOrOut())?"集团内":"集团外");
			excelVO.setInsideOrg(supplierVo.getInsideOrg()!=null&&supplierVo.getInsideOrg()?"内部单位":"外部单位");
			excelVO.setCoordination(supplierVo.getCoordination()!=null&&supplierVo.getCoordination()?"已协同":"未协同");
			if(supplierVo.getPunishType()!=null){
				try {
					JSONArray array = ReferObjectUtil.getReferEntityValue(supplierVo.getPunishType().toString(),"abnormal_grade");
					if(array!=null && array.size()>0){
						excelVO.setPunishType(array.getJSONObject(0).getString("name"));
					}
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
			String content="";
			if(StringUtils.isNotEmpty(supplierVo.getMaterialContent())){
				content+=supplierVo.getMaterialContent();
			}
			if(StringUtils.isNotEmpty(supplierVo.getEquipmentContent())){
				content+=supplierVo.getEquipmentContent();
			}
			if(StringUtils.isNotEmpty(supplierVo.getLaborContent())){
				content+=supplierVo.getLaborContent();
			}
			if(StringUtils.isNotEmpty(supplierVo.getMajorContent())){
				content+=supplierVo.getMajorContent();
			}
			if(StringUtils.isNotEmpty(supplierVo.getConsultContent())){
				content+=supplierVo.getConsultContent();
			}
			if(StringUtils.isNotEmpty(supplierVo.getRevolvMaterialContent())){
				content+=supplierVo.getRevolvMaterialContent();
			}
			if(StringUtils.isNotEmpty(supplierVo.getRevolvMaterialContent())){
				content+=supplierVo.getRevolvMaterialContent();
			}
			if(StringUtils.isNotEmpty(supplierVo.getSubContent())){
				content+=supplierVo.getSubContent();
			}
			excelVO.setMaterialContent(content);
			suppliers.add(excelVO);
		}
		Map<String, Object> beans = new HashMap<>();
		beans.put("records", suppliers);
		ExcelExport.getInstance().export("supplier-export.xlsx", beans, response);
	}

	/**
	 * 供方列表
	 *
	 * @param pageNumber
	 * @param pageSize
	 * @param relyCondition
	 * @param searchText
	 * @param condition
	 * @return
	 */
	@RequestMapping(value = "refSupplierPage", method = RequestMethod.GET)
	@ResponseBody
    public CommonResponse<IPage<SupplierVO>> refSupplierPage(@RequestParam(defaultValue = "1") int pageNumber,
															 @RequestParam(defaultValue = "10") int pageSize,
															 @RequestParam(required=false) String relyCondition,
															 @RequestParam(required=false) String searchText,
															 @RequestParam(required=false) String condition
								) {
		Map<String,Object> params = new HashMap<>();
    	if(StringUtils.isNotBlank(condition)) {
    		JSONObject conditionJson = JSONObject.parseObject(condition);
    		if(null != conditionJson.get("supplyTypes")) {
    			String[] supplyTypes = null;
    			switch (conditionJson.getString("supplyTypes")) {
					case "laborSub":
						supplyTypes = new String[]{"major","labor","sub"};
						break;
					case "materialEquipment":
						supplyTypes = new String[]{"material","equipment","revolvMaterial"};
						break;
					case "other":
						supplyTypes = new String[]{"consult","other"};
						break;
					default:
						;
				}
				if(null != supplyTypes) {
					params.put("supplyTypes", supplyTypes);
				}
			}
		}
    	params.put("pageIndex", pageNumber <= 0 ? 0:(pageNumber-1)*pageSize);
    	params.put("pageSize", pageSize);
    	params.put("searchText", searchText);
    	params.put("range", "outside");
    	/** 过滤掉不合作的供方 */
    	params.put("tenantId", InvocationInfoProxy.getTenantid());
    	IPage<SupplierVO> pageData = supplierService.queryRefMaterialPage(params);
        return CommonResponse.success("查询成功！", pageData);
	}

	/**
	 * 企业供方参照
	 *
	 * @param pageNumber
	 * @param pageSize
	 * @param searchText
	 * @param condition  {supplyType:"material,equipment"}
	 * @return
	 */
	@RequestMapping(value = "refProSupplier", method = RequestMethod.GET)
	@ResponseBody
    public CommonResponse<IPage<SupplierVO>> refProSupplier(@RequestParam(defaultValue = "1") int pageNumber,
															 @RequestParam(defaultValue = "10") int pageSize,
															 @RequestParam(required=false) String searchText,
															 @RequestParam(required=false) String condition
															) {
		QueryParam param = new QueryParam();

		param.setPageIndex(pageNumber);
		param.setPageSize(pageSize);
		param.setSearchText(searchText);
		param.getFuzzyFields().add("name");
		param.getFuzzyFields().add("tax_payer_identifier");
		param.getFuzzyFields().add("materialContent");
		param.getFuzzyFields().add("equipmentContent");
		param.getFuzzyFields().add("majorContent");
		param.getFuzzyFields().add("laborContent");
		param.getFuzzyFields().add("subContent");
		param.getFuzzyFields().add("otherContent");
		param.getFuzzyFields().add("revolvMaterialContent");
		param.getFuzzyFields().add("consultContent");

		param.getParams().put("inException",new Parameter(QueryParam.SQL," in_exception is not true "));//排除异常供应商
		if(StringUtils.isNotBlank(condition)){
			String supplyType = JSONObject.parseObject(condition).getString("supplyType");
			String supplyQueryType = JSONObject.parseObject(condition).getString("supplyQueryType");
			String supplierFlag = JSONObject.parseObject(condition).getString("supplierFlag");
			String personal = JSONObject.parseObject(condition).getString("personal");
			Boolean inException = JSONObject.parseObject(condition).getBoolean("inException");
			Boolean insideOrg = JSONObject.parseObject(condition).getBoolean("insideOrg");
			if(StringUtils.isNotBlank(supplyType)){
				String[] types = supplyType.split(",");

				if(types.length == 1){
					param.getParams().put("supplyType",new Parameter(QueryParam.LIKE,types[0]));
				}else {
					ComplexParam complexParam = new ComplexParam();
					complexParam.setLogic(ComplexParam.AND);
					List<ComplexParam> complexParams = new ArrayList<>();

					for (String type : types) {
						ComplexParam complex = new ComplexParam();
						complex.setLogic(ComplexParam.OR);
						Map<String, Parameter> inP = new HashMap<>();
						inP.put("supplyType",new Parameter(QueryParam.LIKE,type));
						complex.setParams(inP);
						complexParams.add(complex);
					}
					complexParam.setComplexParams(complexParams);
					param.getComplexParams().add(complexParam);
				}

			}
			if(StringUtils.isNotBlank(supplyQueryType)){
				param.getParams().put("supplyQueryType",new Parameter(QueryParam.EQ,supplyQueryType));
			}
			if(StringUtils.isNotBlank(personal)){
				param.getParams().put("personal",new Parameter(QueryParam.EQ,personal));
			}
			if(inException!=null && inException){
				//包含异常供应商
				param.getParams().remove("inException");
				param.getParams().put("inException",new Parameter(QueryParam.EQ,inException));//排除异常供应商
			}
			if(supplierFlag!=null){
				param.getParams().put("supplierFlag",new Parameter(QueryParam.IN,supplierFlag));
			}
			if(insideOrg!=null && StringUtils.isEmpty(searchText)){
				ComplexParam complexParam = new ComplexParam();
				complexParam.setLogic(ComplexParam.OR);
				complexParam.getParams().put("insideOrg",new Parameter(QueryParam.EQ,insideOrg));
				param.getComplexParams().add(complexParam);
			}
		}
		param.getOrderMap().put("createTime",QueryParam.DESC);
		IPage<SupplierEntity> page = supplierService.queryPage(param,false);

		IPage<SupplierVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());



		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SupplierVO.class));
		for (SupplierVO vo:pageData.getRecords()){
			String content="";
			if(StringUtils.isNotEmpty(vo.getMaterialContent())){
				content+=vo.getMaterialContent();
			}
			if(StringUtils.isNotEmpty(vo.getEquipmentContent())){
				content+=vo.getEquipmentContent();
			}
			if(StringUtils.isNotEmpty(vo.getLaborContent())){
				content+=vo.getLaborContent();
			}
			if(StringUtils.isNotEmpty(vo.getMajorContent())){
				content+=vo.getMajorContent();
			}
			if(StringUtils.isNotEmpty(vo.getConsultContent())){
				content+=vo.getConsultContent();
			}
			if(StringUtils.isNotEmpty(vo.getRevolvMaterialContent())){
				content+=vo.getRevolvMaterialContent();
			}
			if(StringUtils.isNotEmpty(vo.getRevolvMaterialContent())){
				content+=vo.getRevolvMaterialContent();
			}
			if(StringUtils.isNotEmpty(vo.getSubContent())){
				content+=vo.getSubContent();
			}
			vo.setMaterialContent(content);
		}
        return CommonResponse.success("查询成功！", pageData);
	}

	/**
	 * 根据企业供方id，查询其资质证书 参照
	 *
	 * @param pageNumber
	 * @param pageSize
	 * @param searchText
	 * @param condition  {supplyId:"3212287233829122912"}
	 * @return
	 */
	@RequestMapping(value = "refProSupplierCerts", method = RequestMethod.GET)
	@ResponseBody
    public CommonResponse<IPage<CertsVO>> refProSupplierCerts(@RequestParam(defaultValue = "1") int pageNumber,
															  @RequestParam(defaultValue = "10") int pageSize,
															  @RequestParam(required=false) String searchText,
															  @RequestParam(required=false) String condition
															) {
		QueryParam param = new QueryParam();

		param.setPageIndex(pageNumber);
		param.setPageSize(pageSize);
		param.setSearchText(searchText);
		param.getFuzzyFields().add("certName");
		param.getFuzzyFields().add("certCode");

		if(StringUtils.isNotBlank(condition)){
			String supplyId = JSONObject.parseObject(condition).getString("supplyId");
			if(StringUtils.isNotBlank(supplyId)){
				param.getParams().put("pid",new Parameter(QueryParam.EQ,supplyId));

			}else {
				return CommonResponse.error("缺少supplyId参数！");
			}
		}else {
			return CommonResponse.error("缺少supplyId参数！");
		}

		IPage<CertsEntity> page = certsService.queryPage(param,false);

		IPage<CertsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
		pageData.setRecords(BeanMapper.mapList(page.getRecords(), CertsVO.class));
        return CommonResponse.success("查询成功！", pageData);
	}

	/**
	 * 供方列表
	 *
	 * @param pageNumber
	 * @param pageSize
	 * @param relyCondition
	 * @param searchText
	 * @param condition
	 * @return
	 */
	@RequestMapping(value = "refInsideSupplierPage", method = RequestMethod.GET)
	@ResponseBody
    public CommonResponse<IPage<SupplierVO>> refInsideSupplierPage(@RequestParam(defaultValue = "1") int pageNumber,
															 @RequestParam(defaultValue = "10") int pageSize,
															 @RequestParam(required=false) String relyCondition,
															 @RequestParam(required=false) String searchText,
															 @RequestParam(required=false) String condition
								) {
		Map<String,Object> params = new HashMap<>();
    	params.put("pageIndex", pageNumber <= 0 ? 0:(pageNumber-1)*pageSize);
    	params.put("pageSize", pageSize);
    	params.put("searchText", searchText);
    	params.put("range", "inside");
    	/** 过滤掉不合作的供方 */
    	params.put("tenantId", InvocationInfoProxy.getTenantid());
    	IPage<SupplierVO> pageData = supplierService.queryRefMaterialPage(params);
        return CommonResponse.success("查询成功！", pageData);
	}

	/**
	 * @Author mrsir_wxp
	 * @Date 2020/7/15 处理供方合租不合作状态
	 * @Description enableSupplierOrNot
	 * @Param [data]
	 * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
	 */
	@RequestMapping(value = "/enableSupplierOrNot", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> enableSupplierOrNot(@RequestBody Map<String,Object> data){
		if(data == null){
			return CommonResponse.error("没有可处理的数据！");
		}
		List<Long> ids = (List<Long>)data.get("ids");
		String state = (String)data.get("state");
		if(ListUtil.isEmpty(ids) || StringUtils.isEmpty(state)){
			return CommonResponse.error("没有可处理的数据！");
		}
		if(!(state.equals("0") || state.equals("1"))){
			return CommonResponse.error("合作状态不正确！");
		}
		data.put("tenantId",InvocationInfoProxy.getTenantid());
		data.put("ids",StringUtils.join(ids.toArray(), ","));
		supplierService.enableSupplierOrNot(data);
		return CommonResponse.success("处理成功！");
	}

	/**
	 *
	 * 供方协同(生成租户)
	 * */
	@RequestMapping(value = "/supplierCollaboration", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> supplierCollaboration(@RequestBody SupplierVO supplierVO){

		return supplierService.supplierCollaboration(supplierVO);
	}

	/**
	 * 获取供应商信息
	 *
	 * @param tenant
	 * @return
	 */
	@RequestMapping(value = "/querySupplierByTenantId", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<SupplierVO> querySupplierByTenantId(@RequestParam Long tenant) {
		SupplierVO supplierVo = supplierService.querySupplierByTenantId(tenant);
		return CommonResponse.success(supplierVo);
	}

	/**
	 * 根据code获取供应商信息
	 *
	 * @return
	 */
	@RequestMapping(value = "/querySupplierByCode", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<SupplierVO> querySupplierByCode(@RequestParam String code) {
		SupplierVO supplierVo = new SupplierVO();
		QueryWrapper<SupplierEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("code", code);
		queryWrapper.eq("dr", 0);
		List<SupplierEntity> list = supplierService.list(queryWrapper);
		if(list!=null&&list.size()>0){
			supplierVo = BeanMapper.map(list.get(0), SupplierVO.class);
			return CommonResponse.success(supplierVo);
		}
		return CommonResponse.success(null);
	}

	/**
	 * 根据纳税人识别号获取供应商信息
	 *
	 * @param taxCode
	 * @return
	 */
	@RequestMapping(value = "/querySupplierByTaxCode", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<SupplierVO> querySupplierByTaxCode(@RequestParam String taxCode) {
		SupplierVO supplierVo;
		QueryWrapper<SupplierEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("dr", 0);
		queryWrapper.eq("tax_payer_identifier", taxCode);
		List<SupplierEntity> list = supplierService.list(queryWrapper);
		if(list!=null&&list.size()>0){
			supplierVo = BeanMapper.map(list.get(0), SupplierVO.class);
			QueryParam param = new QueryParam();
			param.getParams().put("supplierId", new Parameter(QueryParam.EQ, supplierVo.getId()));
			List<BankAccountEntity> supplyBankEntities = bankAccountService.queryList(param, false);
			supplierVo.setBanks(BeanMapper.mapList(supplyBankEntities,BankAccountVO.class));
			return CommonResponse.success(supplierVo);
		}
		return CommonResponse.success("未查询到对应供应商");
	}

	/**
	 * 根据sourceId获取供应商信息
	 *
	 * @param sourceId
	 * @return
	 */
	@RequestMapping(value = "/querySupplierBySourceId", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<SupplierVO> querySupplierBySourceId(@RequestParam String sourceId) {
		SupplierVO supplierVo = new SupplierVO();
		QueryWrapper<SupplierEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("source_id", sourceId);
		queryWrapper.eq("dr", 0);
		List<SupplierEntity> list = supplierService.list(queryWrapper);
		if(list!=null&&list.size()>0){
			supplierVo = BeanMapper.map(list.get(0), SupplierVO.class);
			return CommonResponse.success(supplierVo);
		}
		return CommonResponse.error("未查询到对应供应商");
	}

	/**
	 *
	 * 组织调用----生成内部客商（客户供应商）
	 * */
	@RequestMapping(value = "/generateInsideSupplierAndCustomer", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> generateInsideSupplierAndCustomer(@RequestBody List<OrgVO> orgList){
		return supplierService.generateInsideSupplierAndCustomer(orgList);
	}

	/**
	 *
	 * 组织调用----更新内部客商（客户供应商）
	 * */
	@RequestMapping(value = "/updateInsideSupplierAndCustomer", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<OrgVO> updateInsideSupplierAndCustomer(@RequestBody OrgVO orgVO){
		return supplierService.updateInsideSupplierAndCustomer(orgVO);
	}

	/**
	 * 供方协同 --- 推送到公有云，生成供方协同账号
	 *
	 * */
	@RequestMapping(value = "/generateSupplierAccount", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<String> generateSupplierAccount(@RequestParam("supplierId") Long supplierId,
														  @RequestParam("name") String name,
														  @RequestParam("telephone") String telephone
														  ){
		return supplierService.generateSupplierTenant(supplierId,name,telephone);
	}

	/**
	 * 供方协同 --- 分包负责人推送到公有云，生成供方协同账号
	 *
	 * */
	@RequestMapping(value = "/generateSubLeaderAccount", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<String> generateSubLeaderAccount(@RequestParam("supplierId") Long supplierId,
														   @RequestParam("subLeaderId") Long subLeaderId,
														  @RequestParam("name") String name,
														  @RequestParam("telephone") String telephone
														  ){
		SupplierEntity se = supplierService.selectById(supplierId);
		SubleadersEntity subLeader = subleadersService.selectById(subLeaderId);
		se.setTenantPhone(telephone);
		se.setTenantUserName(name);
		se.setCoordination(true);
		supplierService.generateSubSupplierTenant(subLeader,se);
		subleadersService.saveOrUpdate(subLeader);
		if(!subLeader.getCoordination()){
			return CommonResponse.error("协同失败！");
		}
		return CommonResponse.success("操作成功！");
	}

	/**
	 * 供方协同 --- 根据供应商id，获取该供应商在公有云配置的openId信息
	 *
	 * */
	@RequestMapping(value = "/generateAccessToken", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<String> generateAccessToken(@RequestParam("id") Long supplierId){
		if(redisTemplate.opsForValue().get("EachLink-Open-Api-Info-"+supplierId) != null){
			return CommonResponse.success("处理成功！");
		}
		String systemId = null;
		//优先查询新的供应商库
		CommonResponse<String> resp = subSupplierApi.getSystemById(supplierId);
		if(!resp.isSuccess()) {
			logger.error("根据供应商id-{}查询系统Id信息异常：{}", JSONObject.toJSONString(resp));
			return CommonResponse.error(StringUtils.isNotBlank(resp.getMsg()) ? resp.getMsg() : "查询供应商信息失败！");
		}
		systemId = resp.getData();

		if(null  == systemId) {
			SupplierEntity se = supplierService.selectById(supplierId);
			systemId = null != se ? se.getSystemId() : null;
		}
		if(systemId == null){
			return CommonResponse.error("没有查询到此供应商！");
		}
		if(StringUtils.isEmpty(systemId)){
			return CommonResponse.error("该供应商尚未生成协同账号！");
		}
		CommonResponse<String> res = systemDataPushService.exchangeDataWithUniversal(
				"/ejc-idm-web/openapi/enterprise/queryAuthInfo?id="+systemId,//查询该供应商企业注册的AppID和AppSecret
				RequestMethod.GET,
				null,
				appId,
				secret,
				eachLinkHost
		);
		if(res.isSuccess()){
			JSONObject object = JSONObject.parseObject(res.getData());
			if(object.getInteger("code") == 0){
				redisTemplate.opsForValue().set("EachLink-Open-Api-Info-"+supplierId, eachLinkHost+"------"+object.getString("data"));
				return CommonResponse.success("处理成功！");
			}else {
				return CommonResponse.error(object.getString("msg"));
			}
		}
		return res;
	}



	/**
	 * 供方协同 --- 更新协同账号和姓名
	 *
	 * */
	@RequestMapping(value = "/updateSupplierUserPhoneAndName", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<String> updateSupplierUserPhoneAndName(@RequestParam("supplierId") Long supplierId,
														   @RequestParam("name") String name,
														   @RequestParam("telephone") String telephone
	){
		return supplierService.updateSupplierUserPhoneAndName(supplierId,name,telephone);
	}

	/**
	 * 每天定时更新
	 * 将到期的异常供应商给更新为正常供应商
	 * */
	@Scheduled(cron = "30 30 0 * * ?")
	public void recoverSuppliersFromBlackList(){
		logger.info("开始更新异常供应商库>>>>>>>>>>>>>>>>>>>>>>>>>>");
		QueryParam param = new QueryParam();
		param.getParams().put("inException",new Parameter(QueryParam.EQ,true));//
		param.getParams().put("exceptionEndDate",new Parameter(QueryParam.LE, DateFormatUtil.formatDate(DateFormatUtil.PATTERN_DEFAULT_ON_SECOND,new Date())));//
		List<SupplierEntity> ex = supplierService.queryList(param);
		if(ListUtil.isNotEmpty(ex)){
			for (SupplierEntity supplierEntity : ex) {
				supplierEntity.setInException(false);
				supplierEntity.setPunishType(null);
				supplierEntity.setPunishApplyOrg(null);
				supplierEntity.setPunishDate(null);
				supplierEntity.setPunishGrade(null);
				supplierEntity.setPunishMemo(null);
				supplierEntity.setPunishApplyPerson(null);
			}
			logger.info("此次异常供应商库一共有{}个即将恢复正常供应商！",ex.size());
			supplierService.saveOrUpdateBatch(ex);
		}else {
			logger.info("此次异常供应商库一共有0个即将恢复正常供应商！");
		}
		logger.info("<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<异常供应商库恢复更新完成");
	}

}
