package com.ejianc.foundation.share.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.foundation.share.bean.SubjectOrgEntity;
import com.ejianc.foundation.share.bean.SubjectProjectEntity;
import com.ejianc.foundation.share.mapper.SubjectProjectMapper;
import com.ejianc.foundation.share.service.ISubjectOrgService;
import com.ejianc.foundation.share.service.ISubjectProjectService;
import com.ejianc.foundation.share.vo.SubjectOrgVO;
import com.ejianc.foundation.share.vo.SubjectProjectImportVO;
import com.ejianc.foundation.share.vo.SubjectProjectVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 项目成本科目实体
 *
 * @author generator
 */
@Service("subjectProjectService")
public class SubjectProjectServiceImpl extends BaseServiceImpl<SubjectProjectMapper, SubjectProjectEntity> implements ISubjectProjectService {

    @Autowired
    private ISubjectOrgService subjectOrgService;

    @Override
    public CommonResponse<SubjectProjectVO> saveOrUpdate(SubjectProjectVO saveorUpdateVO) {
        SubjectProjectEntity entity = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) { //修改
            entity = BeanMapper.map(saveorUpdateVO, SubjectProjectEntity.class);
            super.saveOrUpdate(entity, false);
            return CommonResponse.success("修改成功！");
        } else {//新增
            entity = BeanMapper.map(saveorUpdateVO, SubjectProjectEntity.class);
            entity.setId(IdWorker.getId());
            if (entity.getParentId() != null && entity.getParentId() > 0) {
                SubjectProjectEntity uniqueBean = baseMapper.selectById(entity.getParentId());
                entity.setInnerCode(uniqueBean.getInnerCode() + "," + entity.getId());
            } else {
                entity.setInnerCode(entity.getId().toString());
            }
            super.saveOrUpdate(entity, false);
            return CommonResponse.success("保存成功！");
        }
    }

    @Override
    public Boolean delRefCheck(List<Long> ids) {
        LambdaQueryWrapper<SubjectProjectEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(SubjectProjectEntity::getDr, 0);
        lambda.in(SubjectProjectEntity::getOrgSubjectId, ids);
        List<SubjectProjectEntity> list = super.list(lambda);
        return list != null && list.size() > 0;
    }
    @Override
    public List<SubjectProjectVO> getChildrenByPid(Long id) {
        SubjectProjectEntity parent = this.selectById(id);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("innerCode", new Parameter(QueryParam.LIKE_RIGHT, parent.getInnerCode()));
        List<SubjectProjectEntity> list = super.queryList(queryParam, false);
        return BeanMapper.mapList(list, SubjectProjectVO.class);
    }

    @Override
    public void importOrgSubject(SubjectProjectImportVO importVo) {
        List<SubjectOrgVO> detailList = importVo.getDetailList();
        List<Long> ids = detailList.stream().map(SubjectOrgVO::getId).collect(Collectors.toList());

        // 添加父级
        List<String> innerCodeList = detailList.stream().map(SubjectOrgVO::getInnerCode).collect(Collectors.toList());
        List<Long> innerCodes = new ArrayList<>();
        innerCodeList.forEach(x->{
            if(StringUtils.isNotEmpty(x)){
                innerCodes.addAll(Arrays.asList(x.split(",")).stream().map(y-> Long.valueOf(y)).filter(y->!ids.contains(y)).collect(Collectors.toList()));
            }
        });
        if(CollectionUtils.isNotEmpty(innerCodes)){
            List<SubjectOrgEntity> innerList = (List<SubjectOrgEntity>) subjectOrgService.listByIds(innerCodes);
            ids.addAll(innerCodes);
            detailList.addAll(BeanMapper.mapList(innerList, SubjectOrgVO.class));
        }

        LambdaQueryWrapper<SubjectProjectEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(SubjectProjectEntity::getDr, 0);
        lambda.eq(SubjectProjectEntity::getProjectId, importVo.getProjectId());
        lambda.in(SubjectProjectEntity::getOrgSubjectId, ids);
        List<SubjectProjectEntity> list = super.list(lambda);
        List<Long> oldIds = new ArrayList<>();
        Map<Long, Long> parentMap = new HashMap<>();
        for (SubjectProjectEntity spe : list) {
            parentMap.put(spe.getOrgSubjectId(), spe.getId());
            oldIds.add(spe.getOrgSubjectId());
        }
        List<SubjectProjectEntity> saveList = new ArrayList<>();
        for (SubjectOrgVO vo : detailList) {
            if (!oldIds.contains(vo.getId())) {
                SubjectProjectEntity entity = new SubjectProjectEntity();
                long id = IdWorker.getId();
                entity.setId(id);
                entity.setSubjectCode(vo.getSubjectCode());
                entity.setSubjectName(vo.getSubjectName());
                entity.setMemo(vo.getMemo());
                entity.setOrgId(importVo.getOrgId());
                entity.setOrgName(importVo.getOrgName());
                entity.setProjectId(importVo.getProjectId());
                entity.setProjectName(importVo.getProjectName());
                entity.setOrgSubjectId(vo.getId());
                entity.setParentId(vo.getParentId());
                entity.setInnerCode(vo.getInnerCode());
                parentMap.put(vo.getId(), id);
                saveList.add(entity);
            }
        }

        if (saveList.size() > 0) {
            for (SubjectProjectEntity spe : saveList) {
                spe.setParentId(parentMap.get(spe.getParentId()));
                String innerCode = spe.getInnerCode();
                String[] split = innerCode.split(",");
                String newInnerCode = "";
                for(int i = 0;i<split.length;i++){
                    Long aLong = parentMap.get(Long.parseLong(split[i]));
                    if(i==0){
                        newInnerCode = aLong.toString();
                    }else{
                        newInnerCode = newInnerCode+","+aLong.toString();
                    }
                }
                spe.setInnerCode(newInnerCode);
            }
            super.saveBatch(saveList);
        }
    }

    @Override
    public CommonResponse<SubjectProjectVO> updateEn(SubjectProjectVO saveorUpdateVO) {
        //修改子节点
        List<SubjectProjectEntity> list = BeanMapper.mapList(getChildrenByPid(saveorUpdateVO.getId()),SubjectProjectEntity.class);
        for (SubjectProjectEntity entity : list) {
            entity.setEnabled(saveorUpdateVO.getEnabled());
        }
        saveOrUpdateBatch(list);
        return CommonResponse.success("修改成功！");
    }
}
