/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.util;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;

public class DataToYzwUtil {
    private static final String CHARSET_UTF8 = "utf-8";
    private static final int TIMEOUT = 45000;
    public static final String ENCODING = "UTF-8";

    public static String queryByYzw(JSONObject object, String url, String method, String version, String appKey, String appSecret) throws Exception {
        String jsonBody = object.toJSONString();
        String timestamp = DataToYzwUtil.gettime();
        String sign = DataToYzwUtil.generateSign(appKey, timestamp, appSecret, method, version, null, jsonBody);
        System.err.println("time: " + timestamp + "   sign: " + sign);
        HashMap<String, String> queryParam = new HashMap<String, String>();
        queryParam.put("method", method);
        queryParam.put("sign", sign);
        queryParam.put("appkey", appKey);
        queryParam.put("version", version);
        queryParam.put("timestamp", timestamp);
        url = StringUtils.isNotBlank((String)url) ? url : "http://api.jc.yzw.cn/open.api";
        String response = DataToYzwUtil.callApi_ceshi(new URL(url + "?" + DataToYzwUtil.buildParamQuery(queryParam)), queryParam, jsonBody.toString());
        System.out.println(response);
        return response;
    }

    private static String callApi_ceshi(URL url, Map<String, String> params, String body) throws Exception {
        String returnStr = DataToYzwUtil.post(url.toString(), params, body);
        return returnStr;
    }

    public static String post(String address, Map<String, String> headerParameters, String body) throws Exception {
        return DataToYzwUtil.proxyHttpRequest(address, "POST", headerParameters, body);
    }

    public static String proxyHttpRequest(String address, String method, Map<String, String> headerParameters, String body) throws Exception {
        String result = null;
        HttpURLConnection httpConnection = null;
        try {
            httpConnection = DataToYzwUtil.createConnection(address, method, headerParameters, body);
            String encoding = ENCODING;
            if (httpConnection.getContentType() != null && httpConnection.getContentType().indexOf("charset=") >= 0) {
                encoding = httpConnection.getContentType().substring(httpConnection.getContentType().indexOf("charset=") + 8);
            }
            result = DataToYzwUtil.inputStream2String(httpConnection.getInputStream(), encoding);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (httpConnection != null) {
                httpConnection.disconnect();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpURLConnection createConnection(String url, String method, Map<String, String> headerParameters, String body) throws Exception {
        URL Url = new URL(url);
        DataToYzwUtil.trustAllHttpsCertificates();
        System.setProperty("https.protocols", "TLSv1");
        HttpURLConnection httpConnection = (HttpURLConnection)Url.openConnection();
        httpConnection.setConnectTimeout(45000);
        if (headerParameters != null) {
            for (String key : headerParameters.keySet()) {
                httpConnection.setRequestProperty(key, headerParameters.get(key));
            }
        }
        httpConnection.addRequestProperty("Content-Type", "application/json;charset=utf-8");
        httpConnection.addRequestProperty("accept", "*/*");
        httpConnection.setRequestMethod(method);
        httpConnection.setDoOutput(true);
        httpConnection.setDoInput(true);
        if (body != null && !body.trim().equals("")) {
            OutputStream writer = httpConnection.getOutputStream();
            try {
                writer.write(body.getBytes(ENCODING));
            }
            finally {
                if (writer != null) {
                    writer.flush();
                    writer.close();
                }
            }
        }
        return httpConnection;
    }

    private static String inputStream2String(InputStream input, String encoding) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, encoding));
        StringBuilder result = new StringBuilder();
        String temp = null;
        while ((temp = reader.readLine()) != null) {
            result.append(temp);
        }
        return result.toString();
    }

    private static void trustAllHttpsCertificates() throws Exception {
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String str, SSLSession session) {
                return true;
            }
        });
        TrustManager[] trustAllCerts = new TrustManager[1];
        miTM tm = new miTM();
        trustAllCerts[0] = tm;
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, null);
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
    }

    public static String generateSign(String appKey, String timestamp, String appSecret, String method, String version, Map<String, String> requestParam, String jsonBody) throws UnsupportedEncodingException {
        String signContent = DataToYzwUtil.buildSignContent(appKey, timestamp, method, version, requestParam, jsonBody);
        return DataToYzwUtil.sign(signContent, appSecret);
    }

    public static String buildSignContent(String appKey, String timestamp, String method, String version, Map<String, String> requestParam, String jsonBody) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("appkey", appKey);
        params.put("method", method);
        params.put("version", version);
        params.put("timestamp", timestamp);
        if (requestParam != null && CollUtil.isNotEmpty(requestParam)) {
            params.putAll(requestParam);
        }
        if (jsonBody != null && jsonBody.length() > 0) {
            params.put("", jsonBody);
        }
        ArrayList<String> list = new ArrayList<String>();
        Set entrySet = params.entrySet();
        for (Map.Entry entry : entrySet) {
            String key = (String)entry.getKey() + (String)entry.getValue();
            list.add(key);
        }
        Collections.sort(list);
        StringBuilder sourceWithSecret = new StringBuilder();
        for (String key : list) {
            sourceWithSecret.append(key + "&");
        }
        return sourceWithSecret.toString();
    }

    private static String sign(String source, String appsecret) throws UnsupportedEncodingException {
        String sourceWithSecret = source + appsecret;
        String sign = DigestUtils.md5Hex((byte[])sourceWithSecret.getBytes(CHARSET_UTF8));
        System.out.println("YzwSigner sourceStr:" + sourceWithSecret + ", sign:" + sign);
        return sign;
    }

    public static String buildParamQuery(Map<String, String> params) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            sb.append("&").append(entry.getKey()).append("=").append(entry.getValue());
        }
        return sb.substring(1);
    }

    public static String gettime() {
        long l = System.currentTimeMillis();
        Date date = new Date(l);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        String time = formatter.format(date);
        return time;
    }

    static class miTM
    implements TrustManager,
    X509TrustManager {
        miTM() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public boolean isServerTrusted(X509Certificate[] certs) {
            return true;
        }

        public boolean isClientTrusted(X509Certificate[] certs) {
            return true;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }
    }
}

