package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.bean.MaterialCategoryEntity;
import com.ejianc.foundation.share.bean.MaterialEntity;
import com.ejianc.foundation.share.bean.MaterialRelationEntity;
import com.ejianc.foundation.share.bean.SupplierCategoryEntity;
import com.ejianc.foundation.share.mapper.ImportDataMapper;
import com.ejianc.foundation.share.service.IMaterialCategoryService;
import com.ejianc.foundation.share.service.IMaterialService;
import com.ejianc.foundation.share.vo.*;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.usercenter.api.IThirdSystemApi;
import com.ejianc.foundation.usercenter.vo.ThirdSystemVO;
import com.ejianc.foundation.util.DataToYzwUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * 物料controller
 *
 * @author guominga
 */
@RestController
@RequestMapping("/material/")
public class MaterialController implements Serializable {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final long serialVersionUID = 1L;
    private static final String MATERIAL_BILL_CODE = "SUPPORT_MATERIAL";
    private static final String MATERIAL_CATEGORY_BILL_CODE = "SUPPORT_MATERIAL_CATEGORY";

    @Value("${oms.tenantid}")
    private String OMS_TENANT;
    @Value("${common.env.base-host}")
    private String ENV_PROFILE;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IMaterialService materialService;
    @Autowired
    private IMaterialCategoryService materialCategoryService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IThirdSystemApi thirdSystemApi;
    @Autowired
    private ImportDataMapper importDataMapper;

    private final static Integer QUERY_TIMEOUT = 60;
    private final static String INDEX_NAME = "ejc_wj_org_material_relation_es";

    @Autowired(required = false)
    private RestHighLevelClient client;

    @Value("${yzwSignUrl:https://zyq-rpc.yzwqa.cn/api/e-sign/rpc}")
    private String yzwSignUrl;
    @Value("${yzwUrl1:http://api-jc.yzwqa.cn/open.api}")
    private String yzwUrl1;
    @Value("${yzwVersion:1.0}")
    private String yzwVersion;
    @Value("${yzwAppKey1:T000101000111}")
    private String yzwAppKey1;
    @Value("${yzwAppSecret1:fffe9bcba10f4abf8816b358d4d4a4d1}")
    private String yzwAppSecret1;
    @Value("${yzwUrl2:https://open.yzwqa.cn/api}")
    private String yzwUrl2;
    @Value("${yzwAppKey2:ltCIIzc0}")
    private String yzwAppKey2;
    @Value("${yzwAppSecret2:3pr152viev63r91q2o2ahduf9q3wielt}")
    private String yzwAppSecret2;

    /**
     * 新增或者修改
     *
     * @param materialVo
     * @return
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody MaterialVO materialVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (materialVo.getId() != null && materialVo.getId() > 0) {
            MaterialVO uniqueBean = materialService.queryDetail(materialVo.getId());
            uniqueBean.setCode(materialVo.getCode());
            uniqueBean.setName(materialVo.getName());
            uniqueBean.setSpec(materialVo.getSpec());
            uniqueBean.setUnitName(materialVo.getUnitName());
            uniqueBean.setDescription(materialVo.getDescription());
            uniqueBean.setSequence(materialVo.getSequence());
            uniqueBean.setProperty(materialVo.getProperty());
            uniqueBean.setPropertyName(materialVo.getPropertyName());
            uniqueBean.setUpdateUserCode(InvocationInfoProxy.getUsercode());
            uniqueBean.setUpdateTime(new Date());
            uniqueBean.setTenantId(InvocationInfoProxy.getTenantid());
            materialService.update(uniqueBean);
//            return CommonResponse.success("修改成功");
        } else {
            CommonResponse<String> codeBatchByRuleCode = billCodeApi.getCodeBatchByRuleCode(MATERIAL_BILL_CODE, tenantId);
            if (codeBatchByRuleCode.isSuccess()) {
                materialVo.setCode(codeBatchByRuleCode.getData());
            }
            materialVo.setId(IdWorker.getId());

            materialVo.setCreateUserCode(InvocationInfoProxy.getUsercode());
            materialVo.setCreateTime(new Date());
            materialVo.setTenantId(InvocationInfoProxy.getTenantid());
            materialVo.setEnabled(1);
            materialVo.setOrgId(InvocationInfoProxy.getOrgId());
            materialService.save(materialVo);
        }

        // 创建主 JSONObject
        JSONObject mainObject = new JSONObject();
//

        mainObject.put("sourceSystem", 99001);


        // 创建 EBillMateList 数组
        JSONArray eBillMateList = new JSONArray();
        JSONObject mateObject = new JSONObject();
        mateObject.put("categoryCode", materialVo.getCategoryCode());
        mateObject.put("code", materialVo.getCode());
        mateObject.put("model", materialVo.getSpec());
        mateObject.put("name", materialVo.getName());
        mateObject.put("unitName", materialVo.getUnitName());

        eBillMateList.add(mateObject);

        mainObject.put("sskuList", eBillMateList);
        JSONObject result = new JSONObject();
        String method = null;
        if(materialVo.getId() != null){
            method = "ymc.co.material.update";;
        }else{
            method = "ymc.co.material.push";;
        }

        try {
            logger.info("参数：{}",mainObject.toJSONString());
            String response = DataToYzwUtil.queryByYzw(mainObject,yzwUrl2,method,yzwVersion,yzwAppKey2,yzwAppSecret2);
            logger.info("物资新增推送返回接口:{}" , response);
            JSONObject respone = JSONObject.parseObject(response);
            if(0 == ((Integer)respone.get("Code")) && null != respone.getJSONObject("Data").getJSONArray("Rows")){
//					JSONArray jsonArrayjsonArray = respone.getJSONArray("Data");
//					result = jsonArrayjsonArray.getJSONObject(0);
            }else{
                logger.info(respone.toJSONString());
            }
        } catch (Exception e) {
            logger.info(e.getMessage());
        }

        return CommonResponse.success("保存或修改成功");

    }

    /**
     * 批量修改
     *
     * @param
     * @return
     * @throws
     */
    @RequestMapping(value = "/amend", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> amend(@RequestBody List<MaterialVO> materialVo) {
        if (ListUtil.isNotEmpty(materialVo)) {
            for (MaterialVO e : materialVo) {
                materialService.amend(e.getId(), e.getProperty(), e.getPropertyName());
            }
        }
        return CommonResponse.success("修改成功");
    }

    /**
     * 根据主键ID查询物料详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MaterialVO> queryDetail(@RequestParam Long id) {
        MaterialVO materialVo = materialService.queryDetail(id);
        return CommonResponse.success(materialVo);
    }
    /**
     * 绑定科目
     *
     * @param map
     * @return
     */
    @RequestMapping(value = "/bandSubject", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> bandSubject(@RequestBody Map map) {
        List<Long> ids = (List<Long>) map.get("ids");
        Long subjectId = Long.valueOf(map.get("subjectId").toString());
        String subjectName = (String) map.get("subjectName");
        materialService.updateSubject(subjectId,subjectName,ids);
        return CommonResponse.success("绑定成功!");
    }
    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        if (ListUtil.isNotEmpty(ids)) {
            for (Long id : ids) {
                CommonResponse<String> response = billTypeApi.checkQuote("BT200422000000025", id);
                if (!response.isSuccess()) {
                    return CommonResponse.error("删除失败：" + response.getMsg());
                }
            }
        } else {
            return CommonResponse.error("删除失败：主键为空!");
        }
        materialService.delete(ids);

        // 创建主 JSONObject
        JSONObject mainObject = new JSONObject();

        mainObject.put("sourceSystem", 99001);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter(QueryParam.IN,ids));
        List<MaterialEntity> materialEntities = materialService.queryList(queryParam);

        // 创建 EBillMateList 数组
        JSONArray eBillMateList = new JSONArray();
        for (MaterialEntity materialEntity : materialEntities){
            JSONObject mateObject = new JSONObject();
            mateObject.put("categoryCode", materialEntity.getCategoryId());
            mateObject.put("code", materialEntity.getCode());
            mateObject.put("model", materialEntity.getSpec());
            mateObject.put("name", materialEntity.getName());
            mateObject.put("unitName", materialEntity.getUnitName());
            mateObject.put("isDelete", true);

            eBillMateList.add(mateObject);

        }


        mainObject.put("sskuList", eBillMateList);
        JSONObject result = new JSONObject();
        String method =  "ymc.co.material.update";

        try {
            logger.info("参数：{}",mainObject.toJSONString());
            String response = DataToYzwUtil.queryByYzw(mainObject,yzwUrl2,method,yzwVersion,yzwAppKey2,yzwAppSecret2);
            logger.info("物资新增推送返回接口:{}" , response);
            JSONObject respone = JSONObject.parseObject(response);
            if(0 == ((Integer)respone.get("Code")) && null != respone.getJSONObject("Data").getJSONArray("Rows")){
//					JSONArray jsonArrayjsonArray = respone.getJSONArray("Data");
//					result = jsonArrayjsonArray.getJSONObject(0);
            }else{
                logger.info(respone.toJSONString());
            }
        } catch (Exception e) {
            logger.info(e.getMessage());
        }


        return CommonResponse.success("删除成功");
    }

    /**
     * 查询待分页的列表
     *
     * @param queryParam
     * @return
     */
    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<MaterialEntity> pageData = materialService.queryPage(queryParam);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", pageData);
        return CommonResponse.success(jsonObject);

    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "material-import.xlsx", "物料导入模板");
    }

    /**
     * excel导入
     * 已废弃----2020年6月30日
     *
     * @param request
     * @return
     */
    @Deprecated
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    public CommonResponse<Object> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<String> errorList = new ArrayList<String>();
            if (result != null && result.size() > 0) {
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    MaterialVO materialVo = null;
                    //通过物料分类Code获取物料分类ID
                    List<MaterialCategoryEntity> materialCategoryVo = materialCategoryService.queryByCode(String.valueOf(datas.get(0)));
                    if (materialCategoryVo != null) {
                        materialVo = new MaterialVO();
                        materialVo.setId(IdWorker.getId());
                        materialVo.setCategoryId(materialCategoryVo.get(0).getId());

                        if (StringUtils.isBlank(datas.get(1))) {

                            CommonResponse<String> codeBatchByRuleCode = billCodeApi.getCodeBatchByRuleCode(MATERIAL_BILL_CODE, tenantId);
                            if(codeBatchByRuleCode.isSuccess()){
                                materialVo.setCode(codeBatchByRuleCode.getData());
                            } else {
                                materialVo.setCode(new Date().getTime() + "");
                            }

                        } else {
                            materialVo.setCode(datas.get(1));
                        }
                        materialVo.setName(datas.get(2));
                        materialVo.setSpec(datas.get(3));
                        materialVo.setUnitName(datas.get(4));
                        MaterialVO materialBean = materialService.queryExitFlag(materialVo.getName(), materialVo.getSpec(), materialVo.getUnitName(), materialCategoryVo.get(0).getId());
                        if (materialBean != null) {
                            continue;
                        }
                        materialVo.setCreateUserCode(InvocationInfoProxy.getUsercode());
                        materialVo.setCreateTime(new Date());
                        materialVo.setTenantId(InvocationInfoProxy.getTenantid());
                        materialVo.setEnabled(1);
                        materialService.save(materialVo);
                    } else {
                        errorList.add("第" + i + "行数据：" + datas.toString() + "导入失败，原因：物料分类编号不正确！");
                        continue;
                    }
                }
            }
            if (errorList.size() > 0) {
                errorList.add("导入成功：" + (result.size() - errorList.size() - 1) + "条, 失败：" + errorList.size() + "条");

                return CommonResponse.error("导入失败", errorList);
            } else {
                return CommonResponse.success("导入成功");
            }
        }
    }

    /**
     * @Author mrsir_wxp
     * @Date 2020/6/29 物料详情导入excel校验
     * @Description excelMaterialImport
     * @Param [request, response]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.alibaba.fastjson.JSONObject>
     */
    @RequestMapping(value = "/excelMaterialImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelMaterialImport(HttpServletRequest request) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        List<MaterialImportVO> successList = new ArrayList<>();
        List<MaterialImportVO> errorList = new ArrayList<>();
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                if (result.size() > 10000) {
                    return CommonResponse.error("物料超过10000条，请分批上传！");
                }
                Map<String, List<MaterialCategoryEntity>> caListMap = new HashMap<>();
                Map<String, MaterialVO> materialMap = new HashMap<>();
                Map<String, MaterialVO> materialBeanMap = new HashMap<>();
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    MaterialImportVO materialVo = new MaterialImportVO();
                    materialVo.setId(IdWorker.getId());
                    materialVo.setCategoryCode(datas.get(0));
                    materialVo.setCode(datas.get(1));
                    materialVo.setName(datas.get(2));
                    materialVo.setSpec(datas.get(3));
                    materialVo.setUnitName(datas.get(4));
                    materialVo.setPropertyName(datas.get(5));
                    if (StringUtils.isBlank(datas.get(5))) {
                        materialVo.setDescription("物料属性为空！");
                        errorList.add(materialVo);
                        continue;
                    } else {
                        switch (datas.get(5)) {
                            case "工程材料":
                                materialVo.setProperty(1L);
                                break;
                            case "周转材":
                                materialVo.setProperty(2L);
                                break;
                            case "低值易耗品":
                                materialVo.setProperty(3L);
                                break;
                            case "设备":
                                materialVo.setProperty(4L);
                                break;
                            default:
                                materialVo.setDescription("物料属性不合法！");
                                errorList.add(materialVo);
                                continue;
                        }
                    }
                    if (StringUtils.isBlank(datas.get(0))) {
                        materialVo.setDescription("物料分类编号为空！");
                        errorList.add(materialVo);
                        continue;
                    }
                    if (StringUtils.isBlank(datas.get(2))) {
                        materialVo.setDescription("物料名称为空！");
                        errorList.add(materialVo);
                        continue;
                    }
                    //通过物料分类Code获取物料分类ID
                    List<MaterialCategoryEntity> materialCategoryVo = caListMap.get(datas.get(0));
                    if (ListUtil.isEmpty(materialCategoryVo)) {
                        materialCategoryVo = materialCategoryService.queryByCode(String.valueOf(datas.get(0)));
                        if (ListUtil.isNotEmpty(materialCategoryVo)) {
                            caListMap.put(datas.get(0), materialCategoryVo);
                        }
                    }
                    if (ListUtil.isNotEmpty(materialCategoryVo)) {
                        materialVo.setCategoryId(materialCategoryVo.get(0).getId());

                        if (StringUtils.isBlank(datas.get(1))) {//没有编号，自动生成一个
                            CommonResponse<String> codeBatchByRuleCode = billCodeApi.getCodeBatchByRuleCode(MATERIAL_BILL_CODE, tenantId);
                            if(codeBatchByRuleCode.isSuccess()){
                                materialVo.setCode(codeBatchByRuleCode.getData());
                            }else{
                                materialVo.setCode(new Date().getTime() + "");
                            }

                        } else {//有编号，判重
                            MaterialVO vo = materialMap.get(datas.get(1));
                            if (vo == null) {
                                vo = materialService.queryByCode(datas.get(1));
                                if (vo != null) {
                                    materialMap.put(datas.get(1), vo);
                                }
                            }
                            if (vo != null) {
                                materialVo.setDescription("物料编号重复！");
                                errorList.add(materialVo);
                                continue;
                            }
                        }

                        MaterialVO materialBean = materialBeanMap.get(materialVo.getName() + materialVo.getSpec() + materialVo.getUnitName() + materialCategoryVo.get(0).getId());
                        if (materialBean == null) {
                            materialBean = materialService.queryExitFlag(materialVo.getName(), materialVo.getSpec(), materialVo.getUnitName(), materialCategoryVo.get(0).getId());
                            if (materialBean != null) {
                                materialBeanMap.put(materialVo.getName() + materialVo.getSpec() + materialVo.getUnitName() + materialCategoryVo.get(0).getId(), materialBean);
                            }
                        }
                        if (materialBean != null) {
                            materialVo.setDescription("重复物料！");
                            errorList.add(materialVo);
                            continue;
                        }
                        materialVo.setCreateUserCode(InvocationInfoProxy.getUsercode());
                        materialVo.setCreateTime(new Date());
                        materialVo.setTenantId(InvocationInfoProxy.getTenantid());
                        materialVo.setEnabled(1);
                        successList.add(materialVo);
                    } else {
                        materialVo.setDescription("物料分类编号不存在！");
                        errorList.add(materialVo);
                    }
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success(json);
    }

    @RequestMapping(value = "/saveImportExcelMaterial", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveImportExcelMaterial(@RequestBody List<MaterialImportVO> importVOS) {
        if (ListUtil.isEmpty(importVOS)) {
            return CommonResponse.error("导入的数据为空！");
        }
        List<MaterialVO> list = new ArrayList<>();
        importVOS.forEach(importVO -> list.add(BeanMapper.map(importVO, MaterialVO.class)));
        materialService.insertBatch(list);
        return CommonResponse.success("保存成功！");
    }

    /**
     * excel导出
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<MaterialEntity> resultList = materialService.queryList(queryParam);
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", resultList);
        ExcelExport.getInstance().export("material-export.xlsx", beans, response);
    }

    /**
     * 同步平台物料
     *
     * @return
     */
    @RequestMapping(value = "/sync", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> syncMaterialList() {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (OMS_TENANT.equals(tenantId.toString())) {
            return CommonResponse.error("平台运营人员不能操作此功能");
        }
        materialService.insertMaterialListFromPlatform();
        return CommonResponse.success("同步成功");
    }

    /**
     * 材料列表
     *
     * @param pageNumber
     * @param pageSize
     * @param relyCondition
     * @param searchText
     * @param condition
     * @return
     */
    @RequestMapping(value = "refMaterialPage", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MaterialEntity>> refMaterialPage(@RequestParam(defaultValue = "1") int pageNumber, @RequestParam(defaultValue = "10") int pageSize,
                                                                 @RequestParam(required = false) String relyCondition,
                                                                 @RequestParam(required = false) String searchText,
                                                                 @RequestParam(required = false) String condition,
                                                                 @RequestParam(required = false) String searchObject
    ) {
        Map<String, Object> params = new HashMap<>();
        if (StringUtils.isNotBlank(relyCondition)) {
            Long categoryId = Long.parseLong(relyCondition.split("=")[1]);
            MaterialCategoryVO materialCategoryVo = materialCategoryService.queryDetail(categoryId);
            if (materialCategoryVo != null) {
                params.put("innerCode", materialCategoryVo.getInnerCode());
            }
        }
        if (StringUtils.isNotBlank(searchObject)) {
            JSONObject search = JSONObject.parseObject(searchObject);
            if (search.get("categoryCode") != null) {
                params.put("categoryCode", search.get("categoryCode").toString());
            }
            if (search.get("categoryName") != null) {
                params.put("categoryName", search.get("categoryName").toString());
            }
            if (search.get("code") != null) {
                params.put("code", search.get("code").toString());
            }
            if (search.get("name") != null) {
                params.put("name", search.get("name").toString());
            }
            if (search.get("spec") != null) {
                params.put("spec", search.get("spec").toString());
            }
            if (search.get("unitName") != null) {
                params.put("unitName", search.get("unitName").toString());
            }
        }
        params.put("pageIndex", pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        params.put("pageSize", pageSize);
        params.put("searchText", searchText);
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        IPage<MaterialEntity> pageData = materialService.queryRefMaterialPage(params);
        pageData.setCurrent(pageNumber);
        pageData.setSize(pageSize);

        return CommonResponse.success("查询成功！", pageData);
    }

    /************************水电八局接口start************************/
    /**
     * 物资列表
     *
     * @param pageNumber
     * @param pageSize
     * @param relyCondition
     * @param searchText
     * @param condition
     * @return
     */
    @RequestMapping(value = "refList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MaterialEntity>> refList(@RequestParam(defaultValue = "1") int pageNumber, @RequestParam(defaultValue = "10") int pageSize,
                                                         @RequestParam(required = false) String relyCondition,
                                                         @RequestParam(required = false) String searchText,
                                                         @RequestParam(required = false) String condition,
                                                         @RequestParam(required = false) String searchObject
    ) {
        Map<String, Object> params = new HashMap<>();
        if (StringUtils.isNotBlank(ENV_PROFILE) && ENV_PROFILE.contains("qlh")) {//水电八局环境根据组织Id进行查询
            params.put("orgId", InvocationInfoProxy.getOrgId());
            if (StringUtils.isNotBlank(condition)) {
                JSONObject conditionJson = JSON.parseObject(condition);
                if (null != conditionJson.get("orgId")) {
                    long orgId = Long.parseLong(conditionJson.get("orgId").toString());
                    params.put("orgId", orgId);
                }
            }
        }
        if (StringUtils.isNotBlank(condition)) {
            //郑州一建环境根据分类Id进行过滤物资
            JSONObject conditionJson = JSON.parseObject(condition);
            if (null != conditionJson.get("categoryId")) {
                long categoryId = Long.parseLong(conditionJson.get("categoryId").toString());
                params.put("categoryId", categoryId);
            }
            if (null != conditionJson.get("categoryIds") ) {
                String categoryIds = conditionJson.get("categoryIds").toString();
                if (StringUtils.isNotEmpty(categoryIds)){
                    String[] split = categoryIds.split(",");
                    List<String> categoryList = Arrays.asList(split);
                    params.put("categoryIds", categoryList);
                }
            }
        }
        if (StringUtils.isNotBlank(searchObject)) {
            JSONObject search = JSON.parseObject(searchObject);
            if (search.get("categoryName") != null) {
                params.put("categoryName", search.get("categoryName").toString());
            }
            if (search.get("code") != null) {
                params.put("code", search.get("code").toString());
            }
            if (search.get("name") != null) {
                params.put("name", search.get("name").toString());
            }
            if (search.get("spec") != null) {
                params.put("spec", search.get("spec").toString());
            }
            if (search.get("unitName") != null) {
                params.put("unitName", search.get("unitName").toString());
            }
        }
        params.put("pageIndex", pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        params.put("pageSize", pageSize);
        params.put("searchText", searchText);
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        IPage<MaterialEntity> pageData = materialService.queryRefMaterialPage(params);
        pageData.setCurrent(pageNumber);
        pageData.setSize(pageSize);
        return CommonResponse.success("查询成功！", pageData);
    }

    @RequestMapping(value = "/syncMaterial", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> syncMaterial(@RequestBody List<SyncMaterialParam> materialList) {
        if (materialList == null || materialList.size() == 0) {
            return CommonResponse.error("同步数据不能为空");
        }
        //获取来源系统id
        Long systemId = null;
        CommonResponse<ThirdSystemVO> sysVO = thirdSystemApi.getOneByCode(materialList.get(0).getSystemCode());
        if (sysVO.isSuccess() && sysVO.getData() != null) {
            systemId = sysVO.getData().getId();
        } else {
            return CommonResponse.error("同步成失败，编码【systemCode: " + materialList.get(0).getSystemCode() + "】无匹配的系统信息。");
        }
        List<String> errorMsg = new ArrayList<>();
        for (SyncMaterialParam param : materialList) {
            try {
                //获取物资分类
                Long categoryId = null;
                MaterialCategoryVO category = materialCategoryService.queryBySourceId(param.getCategoryId());
                if (category == null) {
                    errorMsg.add("物资：" + param.getName() + "的分类为查询到，请先同步该分类");
                    continue;
                }
                categoryId = category.getId();
                if (1 == param.getSyncType()) {
                    MaterialEntity entity = materialService.queryBySourceId(param.getId());
                    if (entity != null) {
                        errorMsg.add("物资:" + param.getName() + "已存在");
                        continue;
                    }
                    //新增
                    MaterialVO vo = new MaterialVO();
                    vo.setId(IdWorker.getId());
                    vo.setName(param.getName());
                    vo.setCode(param.getCode());
                    vo.setSpec(param.getSpec());
                    vo.setUnitName(param.getUnitName());
                    vo.setSourceId(param.getId());
                    vo.setSystemId(systemId);
                    vo.setCategoryId(categoryId);
                    vo.setCreateUserCode(InvocationInfoProxy.getUsercode());
                    vo.setCreateTime(new Date());
                    vo.setTenantId(InvocationInfoProxy.getTenantid());
                    if (StringUtils.isNotBlank(param.getProjectId())) {
                        CommonResponse<OrgVO> orgVO = orgApi.findBySourceId(param.getProjectId());
                        if (orgVO.isSuccess() && orgVO.getData() != null) {
                            vo.setOrgId(orgVO.getData().getId());
                        }
                    }
                    vo.setDef1(param.getProjectId());//存放项目id
                    materialService.save(vo);
                } else if (2 == param.getSyncType()) {
                    //修改
                    MaterialEntity entity = materialService.queryBySourceId(param.getId());
                    if (entity == null) {
                        //新增--不存在新增
                        MaterialVO vo = new MaterialVO();
                        vo.setId(IdWorker.getId());
                        vo.setName(param.getName());
                        vo.setCode(param.getCode());
                        vo.setSpec(param.getSpec());
                        vo.setUnitName(param.getUnitName());
                        vo.setSourceId(param.getId());
                        vo.setSystemId(systemId);
                        vo.setCategoryId(categoryId);
                        vo.setCreateUserCode(InvocationInfoProxy.getUsercode());
                        vo.setCreateTime(new Date());
                        vo.setTenantId(InvocationInfoProxy.getTenantid());
                        if (StringUtils.isNotBlank(param.getProjectId())) {
                            CommonResponse<OrgVO> orgVO = orgApi.findBySourceId(param.getProjectId());
                            if (orgVO.isSuccess() && orgVO.getData() != null) {
                                vo.setOrgId(orgVO.getData().getId());
                            }
                        }
                        vo.setDef1(param.getProjectId());//存放项目id
                        materialService.save(vo);
                    } else {
                        entity.setName(param.getName());
                        entity.setCode(param.getCode());
                        entity.setSpec(param.getSpec());
                        entity.setUnitName(param.getUnitName());
                        if (StringUtils.isNotBlank(param.getProjectId())) {
                            CommonResponse<OrgVO> orgVO = orgApi.findBySourceId(param.getProjectId());
                            if (orgVO.isSuccess() && orgVO.getData() != null) {
                                entity.setOrgId(orgVO.getData().getId());
                            }
                        }
                        entity.setDef1(param.getProjectId());//存放项目id
                        entity.setUpdateUserCode(InvocationInfoProxy.getUsercode());
                        entity.setUpdateTime(new Date());
                        MaterialVO vo = BeanMapper.map(entity, MaterialVO.class);
                        materialService.update(vo);
                    }
                } else if (3 == param.getSyncType()) {
                    //删除
                    MaterialEntity entity = materialService.queryBySourceId(param.getId());
                    if (entity == null) {
                        errorMsg.add("物资:" + param.getName() + "不存在，请先同步该物资再进行删除操作");
                        continue;
                    }
                    List<Long> delList = new ArrayList<>();
                    delList.add(entity.getId());
                    materialService.delete(delList);
                }
            } catch (Exception e) {
                errorMsg.add("物资分类: " + param.getName() + "同步错误，具体错误：" + e);
            }
        }
        String msg = "";
        for (String m : errorMsg) {
            if (msg.length() > 0) {
                msg += (";" + m);
            } else {
                msg += m;
            }
        }
        String message = "同步完成，已同步成功" + (materialList.size() - errorMsg.size()) + "条，失败" + errorMsg.size() + "条。" + (errorMsg.size() > 0 ? ("失败具体原因如下：" + msg) : "");
        return CommonResponse.success(message);
    }

    /************************水电八局接口end************************/

    /************************中间五局接口begin************************/
    /**
     * 材料列表
     *
     * @param pageNumber
     * @param pageSize
     * @param relyCondition
     * @param searchText
     * @param condition
     * @return
     */
    @RequestMapping(value = "refZjwjMaterialPage", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MaterialEntity>> refZjwjMaterialPage(@RequestParam(defaultValue = "1") int pageNumber, @RequestParam(defaultValue = "10") int pageSize,
                                                                     @RequestParam(required = false) String relyCondition,
                                                                     @RequestParam(required = false) String searchText,
                                                                     @RequestParam(required = false) String condition,
                                                                     @RequestParam(required = false) String searchObject
    ) {

        IPage<MaterialEntity> page = new Page<>();
        IPage<MaterialRelationEntity> relationEntityIPage = new Page<>();

        SearchRequest searchRequest = new SearchRequest(INDEX_NAME);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        if (StringUtils.isNotBlank(relyCondition)) {
            Long categoryId = Long.parseLong(relyCondition.split("=")[1]);
            boolQuery.must(QueryBuilders.prefixQuery("innerCode", String.valueOf(categoryId)));
//			MaterialCategoryVO materialCategoryVo = materialCategoryService.queryDetail(categoryId);
//			if(materialCategoryVo != null) {
//				boolQuery.must(QueryBuilders.prefixQuery("innerCode", materialCategoryVo.getInnerCode()));
//			}
        }
        if (StringUtils.isNotBlank(searchObject)) {
            JSONObject search = JSONObject.parseObject(searchObject);
            if (search.get("categoryName") != null) {
                boolQuery.must(QueryBuilders.matchQuery("categoryName", search.get("categoryName").toString()));
            }
            if (search.get("code") != null) {
                boolQuery.must(QueryBuilders.matchQuery("code", search.get("code").toString()));
            }
            if (search.get("name") != null) {
                boolQuery.must(QueryBuilders.matchQuery("name", search.get("name").toString()));
            }
            if (search.get("spec") != null) {
                boolQuery.must(QueryBuilders.matchQuery("spec", search.get("spec").toString()));
            }
            if (search.get("unitName") != null) {
                boolQuery.must(QueryBuilders.matchQuery("unitName", search.get("unitName").toString()));
            }
        }

        if (StringUtils.isNotBlank(condition)) {
            JSONObject search = JSONObject.parseObject(condition);
            if (search.get("sourceOrgId") != null) {
                boolQuery.must(QueryBuilders.termQuery("sourceOrgId", search.get("sourceOrgId").toString()));
            }
        }

        if (StringUtils.isNotBlank(searchText)) {
            QueryBuilder qb1 = QueryBuilders.matchQuery("name", searchText);
            QueryBuilder qb2 = QueryBuilders.matchQuery("code", searchText);
            QueryBuilder qb3 = QueryBuilders.matchQuery("spec", searchText);
            QueryBuilder qb4 = QueryBuilders.matchQuery("unitName", searchText);
            QueryBuilder qb5 = QueryBuilders.matchQuery("categoryName", searchText);
            boolQuery.must(QueryBuilders.boolQuery().should(qb1).should(qb2).should(qb3).should(qb4).should(qb5));
        }
        sourceBuilder.from(pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        sourceBuilder.size(pageSize);
        sourceBuilder.query(boolQuery);
//		sourceBuilder.sort("code", SortOrder.ASC);
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue(QUERY_TIMEOUT, TimeUnit.SECONDS)); //设置超时时间
        searchRequest.source(sourceBuilder);


        try {
            relationEntityIPage = refZjwjMaterialEsPage(searchRequest);
        } catch (IOException e) {
            try { //重试一次
                relationEntityIPage = refZjwjMaterialEsPage(searchRequest);
            } catch (IOException e1) {
                logger.error(e1.getMessage());
                throw new BusinessException("根据 parammap 条件，查询全部记录索引失败，MSG：" + e1.getMessage());
            }
        }
        List<Long> pklist = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(relationEntityIPage.getRecords())) {
            pklist = relationEntityIPage.getRecords().stream().map(MaterialRelationEntity::getMaterialId).collect(Collectors.toList());
        }
        List<MaterialEntity> materialEntityList = null;
        if (CollectionUtils.isNotEmpty(pklist)) {
            materialEntityList = materialService.queryMaterialByIds(pklist);
        }
        page.setCurrent(pageNumber);
        page.setRecords(materialEntityList);
        page.setTotal(relationEntityIPage.getTotal());
        return CommonResponse.success("查询成功！", page);
    }

    private IPage<MaterialRelationEntity> refZjwjMaterialEsPage(SearchRequest searchRequest) throws IOException {
        IPage<MaterialRelationEntity> page = new Page<>();
        List<MaterialRelationEntity> list = new ArrayList<>();
        SearchResponse response = client.search(searchRequest, RequestOptions.DEFAULT);
        SearchHits hits = response.getHits();
        for (SearchHit hit : hits) {
            String sourceAsString = hit.getSourceAsString();
            list.add(JSON.parseObject(sourceAsString, MaterialRelationEntity.class));
        }
        page.setRecords(list);
        page.setTotal(hits.getTotalHits().value);
        return page;
    }

    /************************中间五局接口end************************/

	/*@RequestMapping(value = "/test/initMaterialData", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<String> testInitMaterialData() {
		List<JSONObject> importMaterialDatas = importDataMapper.queryMaterialData();

		System.out.println("========="+importMaterialDatas.size());
		for(int i=0;i<importMaterialDatas.size();i++) {
			try{
				JSONObject materialData = importMaterialDatas.get(i);
				MaterialVO materialVo = new MaterialVO();
				materialVo.setId(IdWorker.getId());
				materialVo.setCategoryId(materialData.getLong("category_id"));
				materialVo.setCode(materialData.getString("code"));
				materialVo.setName(materialData.getString("name"));
				materialVo.setSpec(materialData.getString("spec"));
				materialVo.setUnitName(materialData.getString("unit"));
				materialVo.setEnabled(1);
				materialVo.setSequence(i);
				materialVo.setCreateUserCode(InvocationInfoProxy.getUsercode());
				materialVo.setCreateTime(new Date());
				materialVo.setTenantId(InvocationInfoProxy.getTenantid());

				materialService.save(materialVo);

				System.out.println("========="+i);
				logger.info("=================="+i);
			}catch(Exception e){}
		}
		return CommonResponse.success();
	}*/
}
