package com.ejianc.foundation.share.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.foundation.share.bean.SubjectOrgEntity;
import com.ejianc.foundation.share.mapper.SubjectOrgMapper;
import com.ejianc.foundation.share.service.ISubjectOrgService;
import com.ejianc.foundation.share.service.ISubjectProjectService;
import com.ejianc.foundation.share.vo.SubjectOrgVO;
import com.ejianc.foundation.util.ExcelImportUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * 集团成本科目实体
 *
 * @author generator
 */
@Service("subjectOrgService")
public class SubjectOrgServiceImpl extends BaseServiceImpl<SubjectOrgMapper, SubjectOrgEntity> implements ISubjectOrgService {

    @Autowired
    private ISubjectProjectService subjectProjectService;

    @Autowired
    private ISubjectOrgService subjectOrgService;

    @Override
    public CommonResponse<SubjectOrgVO> saveOrUpdate(SubjectOrgVO saveorUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        SubjectOrgEntity entity = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) { //修改
            List<Long> ids = new ArrayList<>();
            ids.add(saveorUpdateVO.getId());
            Boolean flag = subjectProjectService.delRefCheck(ids);
            if (flag) {
                return CommonResponse.error("存在被引用的核算对象，暂不允许编辑!");
            }
            //修改  校验合同编号是否重复
            LambdaQueryWrapper<SubjectOrgEntity> lambda = Wrappers.<SubjectOrgEntity>lambdaQuery();
            lambda.eq(SubjectOrgEntity::getSubjectCode, saveorUpdateVO.getSubjectCode());
            lambda.eq(SubjectOrgEntity::getTenantId, tenantId);
            lambda.ne(SubjectOrgEntity::getId, saveorUpdateVO.getId());
            List<SubjectOrgEntity> entities = super.list(lambda);
            if (entities != null && entities.size() > 0) {
                return CommonResponse.error("存在相同编码，不允许保存!");
            }

            entity = BeanMapper.map(saveorUpdateVO, SubjectOrgEntity.class);
            super.saveOrUpdate(entity, false);
            return CommonResponse.success("修改成功！");
        } else {//新增
            //校验合同编号是否重复
            LambdaQueryWrapper<SubjectOrgEntity> lambda = Wrappers.<SubjectOrgEntity>lambdaQuery();
            lambda.eq(SubjectOrgEntity::getTenantId, tenantId);
            lambda.eq(SubjectOrgEntity::getSubjectCode, saveorUpdateVO.getSubjectCode());
            List<SubjectOrgEntity> entities = super.list(lambda);
            if (entities != null && entities.size() > 0) {
                return CommonResponse.error("存在相同编码，不允许保存!");
            }
            entity = BeanMapper.map(saveorUpdateVO, SubjectOrgEntity.class);
            entity.setId(IdWorker.getId());
            if (entity.getParentId() != null && entity.getParentId() > 0) {
                SubjectOrgEntity uniqueBean = baseMapper.selectById(entity.getParentId());
                entity.setInnerCode(uniqueBean.getInnerCode() + "," + entity.getId());
            } else {
                entity.setInnerCode(entity.getId().toString());
            }
            super.saveOrUpdate(entity, false);
            return CommonResponse.success("保存成功！");
        }
    }

    @Override
    public CommonResponse<SubjectOrgVO> updateEn(SubjectOrgVO saveorUpdateVO) {
        //修改子节点
        List<SubjectOrgEntity> list = BeanMapper.mapList(getChildrenByPid(saveorUpdateVO.getId()),SubjectOrgEntity.class);
        for (SubjectOrgEntity entity : list) {
            if(saveorUpdateVO.getEnabled()==1) {
                entity.setEnabled(1);
            }else{
                entity.setEnabled(0);
            }
        }
        saveOrUpdateBatch(list);

        return CommonResponse.success("修改成功！");
    }

    @Override
    public List<SubjectOrgVO> getChildrenByPid(Long id) {
        SubjectOrgEntity parent = this.selectById(id);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("innerCode", new Parameter(QueryParam.LIKE_RIGHT, parent.getInnerCode()));
        List<SubjectOrgEntity> list = super.queryList(queryParam, false);
        return BeanMapper.mapList(list, SubjectOrgVO.class);
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            if(result != null && result.size() > 0) {
                //父子关系重复校验
                Map<String, Integer> indexMap = new HashMap<>();
                //父子关系虚拟主键映射
                List<SubjectOrgVO> subjectOrgVOList = new ArrayList<>();
                Map<String,String> tidMap = new HashMap<>();
                //编码重复校验
                List<String> excelCodeList = new ArrayList<>();
                //查询所有成本科目-集团
                QueryParam queryParam = new QueryParam();
                List<String> codeList = new ArrayList<>();
                List<SubjectOrgEntity> oldList = subjectOrgService.queryList(queryParam);
                for(SubjectOrgEntity subjectOrgEntity : oldList){
                    codeList.add(subjectOrgEntity.getSubjectCode());
                }
                //结果集遍历
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    SubjectOrgVO vo = new SubjectOrgVO();
                    boolean flag = false;
                    boolean parentWarn = false;
                    String warnType = "";

                    //编号
                    String subjectCode = datas.get(0);
                    vo.setSubjectCode(subjectCode);
                    //父编号
                    String subjectParentCode = datas.get(1);
                    //维护父子关系(虚拟id)
                    String id = UUID.randomUUID().toString().replaceAll("-", "");
                    //设置虚拟id
                    vo.setTid(id);
                    //虚拟id映射
                    tidMap.put(subjectCode,id);
                    //设置虚拟父id
                    vo.setTpid(subjectParentCode);
                    //导入数据校验
                    //编码非空
                    if(StringUtils.isEmpty(subjectCode)){
                        vo.setSubjectCode(null);
                        warnType = warnType+"编码为空,";
                        flag = true;
                        parentWarn = true;
                    }else{
                        //编码重复
                        if(codeList.contains(subjectCode)){
                            vo.setSubjectCode(subjectCode);
                            warnType = warnType+"编码重复,";
                            flag = true;
                            parentWarn = true;
                        }
                        if(excelCodeList.contains(subjectCode)){
                            vo.setSubjectCode(subjectCode);
                            warnType = warnType+"导入编码重复,";
                            flag = true;
                            parentWarn = true;
                        }else{
                            excelCodeList.add(subjectCode);
                        }
                        vo.setSubjectCode(subjectCode);
                    }
                    String name = datas.get(2);
                    if(StringUtils.isEmpty(name)){
                        vo.setSubjectName(null);
                        warnType = warnType+"名称为空,";
                        flag = true;
                        parentWarn = true;
                    }else{
                        vo.setSubjectName(name);
                    }

                    vo.setMemo(datas.get(3));
                    vo.setEnabled(1);
                    // true=可以导入，false=不可导入
                    vo.setImportFlag(!flag);
                    vo.setParentWarn(parentWarn);
                    if(flag){
                        warnType = warnType.substring(0,warnType.length()-1);
                    }
                    vo.setWarnType(warnType);
                    vo.setRowState("add");
                    vo.setShadowId(vo.getTid());
//                    vo.setChangeType(3);//增补项

                    subjectOrgVOList.add(vo);
                }
                //此处将之前存储的父级code转换为虚拟父级id
                for(SubjectOrgVO tVo:subjectOrgVOList){
                    if(StringUtils.isNotEmpty(tidMap.get(tVo.getTpid()))){
                        tVo.setTpid(tidMap.get(tVo.getTpid()));
                    }
                }
                List<Map<String, Object>> deailTreeData =ExcelImportUtil.treeData(BeanMapper.mapList(subjectOrgVOList, Map.class));
                List<Map<String, Object>> mapList = ExcelImportUtil.importFlag(deailTreeData);
                List<Map<String, Object>> falseList = new ArrayList<>();
                List<List<Map<String, Object>>> allList = ExcelImportUtil.separate(mapList, falseList);
                List<Map<String, Object>> errorList=ExcelImportUtil.treeToList(allList.get(1),true);
                List<Map<String, Object>> successList=ExcelImportUtil.treeToList(allList.get(0),false);
                resp.put("successList",successList);
                resp.put("errorList",errorList);
                resp.put("successNum",result.size() - errorList.size());
                resp.put("errorNum",errorList.size());
                return CommonResponse.success(resp);
            }
            return CommonResponse.error("Excel为空");
        }
    }

    @Override
    public String saveImportExcel(HttpServletRequest request, List<SubjectOrgVO> importVOS) {
        if (ListUtil.isEmpty(importVOS)) {
            throw new BusinessException("导入的数据为空！");
        }
        List<SubjectOrgEntity> saveOrUpldates = BeanMapper.mapList(importVOS, SubjectOrgEntity.class);
        subjectOrgService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
        if (saveOrUpldates.size() > 0) {
            //维护父子级关系
            Map<String, Long> idMap = new HashMap<>();
            for (SubjectOrgEntity cdEntity : saveOrUpldates) {
                //存储虚拟id和真实id
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (SubjectOrgEntity cdEntity : saveOrUpldates) {
                if (StringUtils.isNotEmpty(cdEntity.getTpid())) {
                    //通过虚拟id父子关系存储真实导入id
                    if(idMap.get(cdEntity.getTpid())==null){
                       //tpid不为空且导入中不存在父子关系，查询已存在父id
                        LambdaQueryWrapper<SubjectOrgEntity> lambda = Wrappers.<SubjectOrgEntity>lambdaQuery();
                        lambda.eq(SubjectOrgEntity::getSubjectCode, cdEntity.getTpid());
                        SubjectOrgEntity subjectOrgEntity = subjectOrgService.getOne(lambda);
                        if(subjectOrgEntity!=null){
                            cdEntity.setParentId(subjectOrgEntity.getId());
                        }
                    }else{
                        //导入父子关系替换父id
                        cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                    }
                }
            }
            //innercode
            for(SubjectOrgEntity subjectOrgEntity : saveOrUpldates){
                if (subjectOrgEntity.getParentId() != null && subjectOrgEntity.getParentId() > 0) {
                    SubjectOrgEntity uniqueBean = baseMapper.selectById(subjectOrgEntity.getParentId());
                    subjectOrgEntity.setInnerCode(uniqueBean.getInnerCode() + "," + subjectOrgEntity.getId());
                } else {
                    subjectOrgEntity.setInnerCode(subjectOrgEntity.getId().toString());
                }
                subjectOrgService.saveOrUpdate(subjectOrgEntity);
            }
            subjectOrgService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
        }
        return "保存成功！";
    }
}
