package com.ejianc.foundation.util;

import com.alibaba.fastjson.JSONObject;

import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.Map.Entry;
import java.util.zip.GZIPInputStream;

import static com.taobao.api.Constants.CONTENT_ENCODING_GZIP;


public class DataToYzwUtil1 {
	private static final String CHARSET_UTF8 = "utf-8";

	private static String signRequest(Map<String, String> params, String secret) throws IOException {
		// 第一步：检查参数是否已经排序
		String[] keys = params.keySet().toArray(new String[0]);
		Arrays.sort(keys);

		// 第二步：把所有参数名和参数值串在一起
		StringBuilder query = new StringBuilder();
		for (String key : keys) {
			String value = params.get(key);
			if (isNotEmpty(key) && isNotEmpty(value)) {
				query.append("&").append(key).append("=").append(value);
			}
		}
		// 第三步：使用MD5/HMAC加密
		query.append("&appsecret=").append(secret);
		String data = query.toString().substring(1).toLowerCase();
		byte[] bytes = encryptMD5(data);

		// 第四步：把二进制转化为大写的十六进制
		return byte2hex(bytes);
	}

	public static String queryByYzwList(JSONObject object,String url,String method,String appKey,String appSecret) throws Exception {

		Map<String, String> params = new HashMap<String, String>();
		params.put("appid", appKey);// 由接口提供方分配给接口调用方的身份标识符 TODO
		params.put("format", "json");// 接口返回结果类型:json
		params.put("method", method);// 由接口提供方指定的接口标识符
		String nonce = getUitstr();// 生成随机数
		params.put("nonce", nonce);// 随机数，由调用方生成，在约定的调用时差范围内不可重复。
		String dateitme = gettime();
		params.put("timestamp", dateitme);// 调用方时间戳，格式为“4位年+2位月+2位日+2位小时(24小时制)+2位分+2位秒”，用于接口提供方判断调用方的时间，通常约定调用请求的时间戳与接口提供方收到请求的时间差在约定的范围内。
		params.put("version", "1.0");// 由接口提供方指定的接口版本。注：Endpoint+ method+version决定了接口的语义。
		params.put("data", object.toString());// 具体的接口方法中的参数实体信息（对象需要转换成JSON String）
		String sign = signRequest(params, appSecret);// 签名，按照签名生成算法计算得来。
		params.put("sign", sign);
		System.out.println(params);
		String response = callApione(new URL( url), params);
		System.out.println(sign);
//		System.out.println(response);
		return response;
	}

	private static String buildQuery(Map<String, String> params, String charset) throws IOException {
		if (params == null || params.isEmpty()) {
			return null;
		}

		StringBuilder query = new StringBuilder();
		Set<Entry<String, String>> entries = params.entrySet();
		boolean hasParam = false;

		for (Entry<String, String> entry : entries) {
			String name = entry.getKey();
			String value = entry.getValue();
			// 忽略参数名或参数值为空的参数
			if (isNotEmpty(name) && isNotEmpty(value)) {
				if (hasParam) {
					query.append("&");
				} else {
					hasParam = true;
				}

				query.append(name).append("=").append(URLEncoder.encode(value, charset));
			}
		}

		return query.toString();
	}


	private static String callApione(URL url, Map<String, String> params) throws IOException {
		String query = buildQuery(params, CHARSET_UTF8);
		byte[] content = {};
		if (query != null) {
			content = query.getBytes(CHARSET_UTF8);
		}

		HttpURLConnection conn = null;
		OutputStream out = null;
		String rsp = null;
		try {
			conn = (HttpURLConnection) url.openConnection();
			conn.setRequestMethod("POST");
			conn.setDoInput(true);
			conn.setDoOutput(true);
//            conn.setRequestProperty("Host", url.getHost());
			conn.setRequestProperty("Accept", "application/json");
			//conn.setRequestProperty("User-Agent", "top-sdk-java");
			conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=" + CHARSET_UTF8);
			out = conn.getOutputStream();
			out.write(content);
			rsp = getResponseAsString(conn);
		} finally {
			if (out != null) {
				out.close();
			}
			if (conn != null) {
				conn.disconnect();
			}
		}

		return rsp;
	}

	private static String getResponseAsString(HttpURLConnection conn) throws IOException {
		String charset = getResponseCharset(conn.getContentType());
		if (conn.getResponseCode() < 400) {
			String contentEncoding = conn.getContentEncoding();
			if (CONTENT_ENCODING_GZIP.equalsIgnoreCase(contentEncoding)) {
				return getStreamAsString(new GZIPInputStream(conn.getInputStream()), charset);
			} else {
				return getStreamAsString(conn.getInputStream(), charset);
			}
		} else {// Client Error 4xx and Server Error 5xx
			throw new IOException(conn.getResponseCode() + " " + conn.getResponseMessage());
		}
	}

	private static String getStreamAsString(InputStream stream, String charset) throws IOException {
		try {
			Reader reader = new InputStreamReader(stream, charset);
			StringBuilder response = new StringBuilder();

			final char[] buff = new char[1024];
			int read = 0;
			while ((read = reader.read(buff)) > 0) {
				response.append(buff, 0, read);
			}

			return response.toString();
		} finally {
			if (stream != null) {
				stream.close();
			}
		}
	}

	private static String getResponseCharset(String ctype) {
		String charset = CHARSET_UTF8;

		if (isNotEmpty(ctype)) {
			String[] params = ctype.split(";");
			for (String param : params) {
				param = param.trim();
				if (param.startsWith("charset")) {
					String[] pair = param.split("=", 2);
					if (pair.length == 2) {
						if (isNotEmpty(pair[1])) {
							charset = pair[1].trim();
						}
					}
					break;
				}
			}
		}
		return charset;
	}


	/**
	 * 生成随机数
	 *
	 */
	public static String getUitstr(){
		char[] chars = new char[]{'1', '2', '3', '4','5', '6', '7', '8', '9', '0',
				'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n',
				'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z',
				'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N',
				'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

		//2，获取当前时间字符串
		long l = System.currentTimeMillis();
		Date date = new Date(l);
		SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
		String time = formatter.format(date);
		//3，获取随机字符串
		String randStr = "";
		//4，通过 SecureRandom强随机数生成器，生成16位随机数，
		//并去1步骤中创建的字符集随机获取字符，组成16位字符串，
		SecureRandom random = new SecureRandom();
		for (int i = 0; i < 16; i++) {
			int index = random.nextInt(36);
			randStr+=chars[index];
		}

		return time+randStr;
	}

	/**
	 * 取得时间
	 * @return
	 */
	public static String gettime(){

		//2，获取当前时间字符串
		long l = System.currentTimeMillis();
		Date date = new Date(l);
		SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
		String time = formatter.format(date);

		return time;
	}

	/**
	 * 对字符串采用UTF-8编码后，用MD5进行摘要。
	 */
	private static byte[] encryptMD5(String data) throws IOException {
		return encryptMD5(data.getBytes(CHARSET_UTF8));
	}

	/**
	 * 对字节流进行MD5摘要。
	 */
	private static byte[] encryptMD5(byte[] data) throws IOException {
		byte[] bytes = null;
		try {
			MessageDigest md = MessageDigest.getInstance("MD5");
			bytes = md.digest(data);
		} catch (GeneralSecurityException gse) {
			throw new IOException(gse.toString());
		}
		return bytes;
	}

	/**
	 * 对字节流进行HMAC_MD5摘要。
	 */
	private static byte[] encryptHMAC(String data, String secret) throws IOException {
		byte[] bytes = null;
		try {
			SecretKey secretKey = new SecretKeySpec(secret.getBytes(CHARSET_UTF8), "HmacMD5");
			Mac mac = Mac.getInstance(secretKey.getAlgorithm());
			mac.init(secretKey);
			bytes = mac.doFinal(data.getBytes(CHARSET_UTF8));
		} catch (GeneralSecurityException gse) {
			throw new IOException(gse.toString());
		}
		return bytes;
	}

	/**
	 * 把字节流转换为十六进制表示方式。
	 */
	private static String byte2hex(byte[] bytes) {
		StringBuilder sign = new StringBuilder();
		for (int i = 0; i < bytes.length; i++) {
			String hex = Integer.toHexString(bytes[i] & 0xFF);
			if (hex.length() == 1) {
				sign.append("0");
			}
			sign.append(hex.toLowerCase());
		}
		return sign.toString();
	}

	private static boolean isNotEmpty(String value) {
		int strLen;
		if (value == null || (strLen = value.length()) == 0) {
			return false;
		}
		for (int i = 0; i < strLen; i++) {
			if ((Character.isWhitespace(value.charAt(i)) == false)) {
				return true;
			}
		}
		return false;
	}

}
