package com.ejianc.foundation.share.mapper;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import com.ejianc.foundation.share.bean.EquipmentEntity;
import com.ejianc.foundation.share.vo.EquipmentVO;

@Mapper
public interface EquipmentMapper {

	List<EquipmentEntity> queryListByCategoryId(@Param("tenantId") Long tenantId,@Param("categoryId") Long categoryId);

	List<EquipmentEntity> queryList(Map<String, Object> condition);

	Long queryCount(Map<String, Object> condition);

	EquipmentEntity queryDetail(@Param("tenantId") Long tenantId, @Param("id") Long id);

	void save(EquipmentVO equipmentVo);

	void insertBatch(@Param("tenantId") Long tenantId,@Param("list") List<EquipmentVO> list);

	void update(EquipmentVO uniqueBean);

	void amend(@Param("id") Long id, @Param("property") Long property, @Param("propertyName") String propertyName,@Param("tenantId") Long tenantId);

	void delete(@Param("tenantId") Long tenantId, @Param("id") Long id);

	EquipmentVO queryExitFlag(@Param("tenantId") Long tenantId, @Param("name") String name,@Param("spec") String spec,@Param("unitName") String unitName,@Param("categoryId") Long categoryId);

	EquipmentVO queryByCode(@Param("tenantId") Long tenantId, @Param("code") String code);

	List<EquipmentEntity> queryExportList(Map<String, Object> condition);

	void insertEquipmentListFromPlatform(@Param("tenantId") Long tenantId);

	List<EquipmentEntity> queryRefEquipmentList(Map<String, Object> params);

	Long queryRefEquipmentCount(Map<String, Object> params);

}
