/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleVO;
import com.ejianc.foundation.share.bean.ProjectArchiveEntity;
import com.ejianc.foundation.share.bean.ProjectWbsEntity;
import com.ejianc.foundation.share.service.IProjectArchiveService;
import com.ejianc.foundation.share.service.IProjectWbsService;
import com.ejianc.foundation.share.vo.ProjectArchiveVO;
import com.ejianc.foundation.share.vo.ProjectWbsVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.foundation.util.SeparatorUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"projectWbs"})
public class ProjectWbsController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PARAM_LOAD_APPLY_VIEW_CODE = "P-50U29j0017";
    @Autowired
    private IRoleApi roleApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IProjectWbsService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IProjectArchiveService projectSetService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProjectWbsVO> saveOrUpdate(@RequestBody ProjectWbsVO saveOrUpdateVO) {
        return this.service.saveOrUpdate(saveOrUpdateVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProjectWbsVO> queryDetail(Long id) {
        ProjectWbsEntity entity = (ProjectWbsEntity)((Object)this.service.selectById(id));
        ProjectWbsVO vo = (ProjectWbsVO)((Object)BeanMapper.map((Object)((Object)entity), ProjectWbsVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody ProjectWbsVO projectWbsVO) {
        List<Long> ids = projectWbsVO.getIds();
        if (ListUtil.isNotEmpty(ids)) {
            for (Long id : ids) {
                CommonResponse resp = this.billTypeApi.checkQuote("EJCBT202206000006", id);
                if (resp.isSuccess()) continue;
                return CommonResponse.error((String)("\u5220\u9664\u5931\u8d25\uff01" + resp.getMsg()));
            }
            this.service.removeByIds(ids);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        Parameter projectIdParam;
        JSONObject jsonObject = new JSONObject();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List wbsEntityList = this.service.queryList(param, false);
        if (CollectionUtils.isNotEmpty((Collection)wbsEntityList) && !this.canViewAll().booleanValue()) {
            String userIdStr = this.sessionManager.getUserContext().getEmployeeId().toString();
            List userDataIdList = wbsEntityList.stream().filter(e -> null != e.getHeadId() && e.getHeadId().contains(userIdStr)).map(BaseEntity::getId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(userDataIdList)) {
                List innerCodeIdList = wbsEntityList.stream().filter(e -> null != e.getHeadId() && e.getHeadId().contains(userIdStr)).map(ProjectWbsEntity::getInnerCode).collect(Collectors.toList());
                HashSet<String> returnIds = new HashSet<String>();
                for (String idStr : innerCodeIdList) {
                    List<String> list = Arrays.asList(idStr.split(","));
                    returnIds.addAll(list);
                }
                for (Long dataId : userDataIdList) {
                    List<Long> idList = wbsEntityList.stream().filter(e -> dataId != e.getId() && null != e.getInnerCode() && e.getInnerCode().contains(dataId.toString())).map(BaseEntity::getId).collect(Collectors.toList());
                    idList.forEach(e -> returnIds.add(e.toString()));
                }
                wbsEntityList = wbsEntityList.stream().filter(e -> returnIds.contains(e.getId().toString())).collect(Collectors.toList());
            } else {
                jsonObject.put("records", (Object)"");
                return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
            }
        }
        if (param.getParams().containsKey("projectId") && (projectIdParam = (Parameter)param.getParams().get("projectId")).getValue() != null) {
            Long projectId = Long.valueOf(projectIdParam.getValue().toString());
            this.addDefaultOne(projectId, wbsEntityList);
        }
        List resultMapList = BeanMapper.mapList((Iterable)wbsEntityList, Map.class);
        jsonObject.put("records", (Object)ResultAsTree.createTreeData((List)resultMapList));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ProjectWbs-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"projectWbs-export.xlsx", (String)"\u5408\u540c\u6e05\u5355\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response, Long projectId) {
        return this.service.excelImport(request, response, projectId);
    }

    @RequestMapping(value={"/saveImportExcel"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveImportExcel(HttpServletRequest request, @RequestBody List<ProjectWbsVO> importVOS) {
        return CommonResponse.success((String)((String)this.service.saveImportExcel(request, importVOS)));
    }

    @RequestMapping(value={"/refProjectWbsData"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> refProjectWbsData(@RequestParam(value="searchText", required=false) String searchText, @RequestParam(value="condition", required=false) String condition) {
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        param.setSearchText(searchText);
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("enabled", new Parameter("eq", (Object)1));
        Long projectId = null;
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                projectId = Long.valueOf(conditionMap.get("projectId").toString());
                param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
            }
            if (null != conditionMap.get("wbsTypeList")) {
                String wbsType = String.valueOf(conditionMap.get("wbsTypeList").toString());
                this.logger.info("\u63a5\u6536wbsType-{}", (Object)wbsType);
                List<String> wbsTypeList = Arrays.asList(wbsType.split(","));
                param.getParams().put("wbsType", new Parameter("in", wbsTypeList));
            }
            if (null != conditionMap.get("parentId")) {
                String parentId = String.valueOf(conditionMap.get("parentId").toString());
                this.logger.info("\u63a5\u6536parentId-{}", (Object)parentId);
                param.getParams().put("parentId", new Parameter("eq", (Object)parentId));
            }
        }
        List wbsEntityList = this.service.queryList(param, false);
        this.addDefaultOne(projectId, wbsEntityList);
        ArrayList resultMapList = new ArrayList();
        HashMap<String, Object> map = null;
        for (ProjectWbsEntity entity : wbsEntityList) {
            String name = entity.getName();
            if (null != entity.getWbsType() && (3 == entity.getWbsType() || 4 == entity.getWbsType())) {
                name = name + "\uff08" + (3 == entity.getWbsType() ? "\u4ea7\u54c1" : "\u6784\u4ef6") + "\uff09";
            }
            map = new HashMap<String, Object>();
            map.put("id", entity.getId());
            map.put("key", entity.getId());
            map.put("name", name);
            map.put("code", entity.getCode());
            map.put("parentId", entity.getParentId());
            map.put("memo", entity.getMemo());
            map.put("innerCode", entity.getInnerCode());
            map.put("wbsType", entity.getWbsType());
            resultMapList.add(map);
        }
        return ResultAsTree.createTreeData(resultMapList);
    }

    @RequestMapping(value={"queryWBSWholeTreeItemsById"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> queryWBSWholeTreeItemsById(@RequestParam(value="idStr") String idStr) {
        return this.service.queryWBSWholeTreeItemsById(idStr);
    }

    public Boolean canViewAll() {
        Long userid;
        CommonResponse roleRes;
        ParamRegisterSetVO paramRegisterSetVO;
        String valueData;
        CommonResponse byCode = this.paramConfigApi.getByCode(PARAM_LOAD_APPLY_VIEW_CODE);
        if (byCode.isSuccess() && null != byCode.getData() && StringUtils.isNotEmpty((CharSequence)(valueData = (paramRegisterSetVO = (ParamRegisterSetVO)byCode.getData()).getValueData())) && (roleRes = this.roleApi.queryRoleByUserId(userid = InvocationInfoProxy.getUserid())).isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)roleRes.getData()))) {
            List<String> valList = Arrays.asList(valueData.split(",|\uff0c"));
            for (RoleVO roleVO : (List)roleRes.getData()) {
                if (!valList.contains(roleVO.getCode())) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    @RequestMapping(value={"/refProjectWbsTotal"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> refProjectWbsTotal(@RequestParam(value="searchText", required=false) String searchText, @RequestParam(value="condition", required=false) String condition) {
        Map conditionMap;
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        param.setSearchText(searchText);
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("enabled", new Parameter("eq", (Object)1));
        Long projectId = null;
        if (StringUtils.isNotEmpty((CharSequence)condition) && null != (conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class)).get("projectId")) {
            projectId = Long.valueOf(conditionMap.get("projectId").toString());
            param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        }
        List<ProjectWbsEntity> wbsEntityList = this.service.queryList(param, false);
        this.addDefaultOne(projectId, wbsEntityList);
        if (CollectionUtils.isNotEmpty((Collection)wbsEntityList) && !this.canViewAll().booleanValue()) {
            wbsEntityList = this.filterWbsList(wbsEntityList);
        }
        ArrayList resultMapList = new ArrayList();
        HashMap<String, Object> map = null;
        for (ProjectWbsEntity entity : wbsEntityList) {
            String name = entity.getName();
            if (null != entity.getWbsType() && (3 == entity.getWbsType() || 4 == entity.getWbsType())) {
                name = name + "\uff08" + (3 == entity.getWbsType() ? "\u4ea7\u54c1" : "\u6784\u4ef6") + "\uff09";
            }
            map = new HashMap<String, Object>();
            map.put("id", entity.getId());
            map.put("key", entity.getId());
            map.put("name", name);
            map.put("code", entity.getCode());
            map.put("parentId", entity.getParentId());
            map.put("memo", entity.getMemo());
            map.put("innerCode", entity.getInnerCode());
            map.put("wbsType", entity.getWbsType());
            resultMapList.add(map);
        }
        return ResultAsTree.createTreeData(resultMapList);
    }

    @RequestMapping(value={"/reportList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProjectArchiveVO>> reportList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("customName");
        return CommonResponse.success(this.service.reportList(param, false));
    }

    @GetMapping(value={"/api/shareProjectWbsApi/getProjectIdsNoWbs"})
    public CommonResponse<List<ProjectArchiveVO>> getProjectIdsNoWbs() {
        return CommonResponse.success(this.service.getProjectIdsNoWbs());
    }

    private List<ProjectWbsEntity> filterWbsList(List<ProjectWbsEntity> wbsList) {
        List ids = wbsList.stream().filter(e -> null != e.getHeadId() && e.getHeadId().contains(InvocationInfoProxy.getEmployeeId().toString())).map(BaseEntity::getId).collect(Collectors.toList());
        List codes = wbsList.stream().filter(x -> ids.contains(x.getId())).map(x -> x.getInnerCode()).collect(Collectors.toList());
        Set innerCodes = codes.stream().flatMap(x -> SeparatorUtil.substringPre(x, ",").stream()).collect(Collectors.toSet());
        Set result = wbsList.stream().filter(x -> innerCodes.contains(x.getInnerCode())).collect(Collectors.toSet());
        for (ProjectWbsEntity detail : wbsList) {
            for (String code : codes) {
                if (!detail.getInnerCode().startsWith(code)) continue;
                result.add(detail);
            }
        }
        return new ArrayList<ProjectWbsEntity>(result);
    }

    private void addDefaultOne(Long projectId, List<ProjectWbsEntity> wbsList) {
        if (projectId == null) {
            return;
        }
        QueryWrapper ew = new QueryWrapper();
        ew.eq((Object)"project_id", (Object)projectId);
        int count = this.service.count((Wrapper)ew);
        if (count > 0) {
            return;
        }
        ProjectArchiveEntity projectSetPoolEntity = (ProjectArchiveEntity)((Object)this.projectSetService.selectById(projectId));
        ProjectWbsVO vo = new ProjectWbsVO();
        vo.setId(IdWorker.getId());
        vo.setCode(projectSetPoolEntity.getCode());
        vo.setName(projectSetPoolEntity.getName());
        vo.setProjectId(projectId);
        vo.setOrgId(projectSetPoolEntity.getOrgId());
        vo.setEnabled(1);
        vo.setInnerCode(String.valueOf(vo.getId()));
        ProjectWbsEntity entity = (ProjectWbsEntity)((Object)BeanMapper.map((Object)((Object)vo), ProjectWbsEntity.class));
        if (this.service.saveOrUpdate((Object)entity)) {
            wbsList.add(entity);
        }
    }
}

