package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.share.bean.SupplierCategoryEntity;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.service.ISupplierCategoryService;
import com.ejianc.foundation.share.service.ISupplierLinkerService;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.share.vo.SupplierCategoryVO;
import com.ejianc.foundation.share.vo.SupplierLinkerVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.usercenter.api.IJuliApi;
import com.ejianc.foundation.util.ExcelReader;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 供方controller
 *
 * @author guoming
 */
@Controller
@RequestMapping("/supplier/")
public class SupplierController implements Serializable {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	private static final long serialVersionUID = 1L;

	private static final String SUPPLIER_BILL_CODE = "SUPPORT_SUPPLIER";

	@Autowired
	private ISupplierService supplierService;
	@Autowired
	private ISupplierCategoryService supplierCategoryService;
	@Autowired
	private IDefdocApi defdocApi;
	@Autowired
	private ISupplierLinkerService supplierLinkerService;
	@Autowired
	private IBillCodeApi billCodeApi;
	@Autowired
	private IBillTypeApi billTypeApi;

	/** bip 同步相关参数 */
	@Value("${juli.bip.pkOrg:0001A11000000000NKRQ}")
	private String juliBipPkOrg;
	private static final String SYNC_SUPPLY_URL = "nccloud/api/uapbd/suppliermanage/supplierbaseinfo/supplierbaseinfoquery";
	@Autowired
	private IJuliApi juliApi;

	/**
	 * 新增或者修改
	 *
	 * @return
	 */
	@RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<SupplierVO> saveOrUpdate(@RequestBody SupplierVO supplierVo) {
		if(supplierVo.getCategoryId() == null){
			return CommonResponse.error("供方分类不能为空！");
		}
		JSONObject parent =supplierVo.getParent();
		CommonResponse<SupplierVO> response = supplierService.saveOrUpdate(supplierVo);
		supplierVo = supplierService.queryDetail(response.getData().getId());
		supplierVo.setParent(parent);
		response.setData(supplierVo);
		response.getData().setCategoryName(parent.getString("name"));
		return response;
	}


	@RequestMapping(value = "/saveOrUpdateReturn", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<SupplierVO> saveOrUpdateReturn(@RequestBody SupplierVO supplierVo) {
		if(supplierVo.getCategoryId() == null){
			return CommonResponse.error("供方分类不能为空！");
		}
		JSONObject parent =supplierVo.getParent();
		CommonResponse<SupplierVO> response = supplierService.saveOrUpdateReturn(supplierVo);
		supplierVo = supplierService.queryDetail(response.getData().getId());
		supplierVo.setParent(parent);
		response.setData(supplierVo);
		response.getData().setCategoryName(parent.getString("name"));
		return response;
	}


	/**
	 * 根据主键ID查询供方详情
	 *
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<SupplierVO> queryDetail(@RequestParam Long id) {
		SupplierVO supplierVo = supplierService.queryDetail(id);
		JSONObject parent = new JSONObject();
		SupplierCategoryEntity e = supplierCategoryService.selectById(supplierVo.getCategoryId());
		parent.put("id",e.getId());
		parent.put("code",e.getCode());
		parent.put("name",e.getName());
		supplierVo.setParent(parent);
		supplierVo.setCategoryName(e.getName());
		return CommonResponse.success(supplierVo);
	}

	/**
	 * 删除
	 *
	 * @param ids
	 * @return
	 */
	@RequestMapping(value = "/delete", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> delete(@RequestBody List<Long> ids) {
		if(ListUtil.isNotEmpty(ids)){
			for (Long id : ids) {
				CommonResponse<String> response = billTypeApi.checkQuote("BT200422000000028",id);
				if(!response.isSuccess()){
					return CommonResponse.error("删除失败："+response.getMsg());
				}
			}
		}else {
			return CommonResponse.error("删除失败：主键为空!");
		}
		supplierService.deleteSupplier(ids);
		return CommonResponse.success("删除成功");
	}

	/**
	 * 删除
	 *
	 * @param ids
	 * @return
	 */
	@RequestMapping(value = "/deleteSupplierVO", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> deleteSupplierVO(@RequestBody List<SupplierVO> ids) {
		if(ListUtil.isNotEmpty(ids)){
			for (SupplierVO supplierVO : ids) {
				CommonResponse<String> response = billTypeApi.checkQuote("BT200422000000028",supplierVO.getId());
				if(!response.isSuccess()){
					return CommonResponse.error("删除失败："+response.getMsg());
				}
			}
		}else {
			return CommonResponse.error("删除失败：主键为空!");
		}
		supplierService.deleteSupplier(ids.stream().map(SupplierVO::getId).collect(Collectors.toList()));
		return CommonResponse.success("删除成功");
	}

	/**
	 * 查询供方分页列表
	 *
	 * @param queryParam
	 * @return
	 */
	@RequestMapping(value = "/pageList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
		IPage<SupplierVO> pageData = supplierService.queryPageList(queryParam);

		JSONObject jsonObject = new JSONObject();
		jsonObject.put("data", pageData);
		return CommonResponse.success(jsonObject);
	}

	/**
	 * 查询供方分页列表
	 *
	 * @param queryParam
	 * @return
	 */
	@RequestMapping(value = "/queryList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<IPage<SupplierVO>> queryList(@RequestBody QueryParam queryParam) {
		IPage<SupplierVO> pageData = supplierService.queryPageList(queryParam);
		return CommonResponse.success(pageData);
	}

	/**
	 * 导入模板下载
	 *
	 * @param request
	 * @param response
	 */
	@RequestMapping(value = "/download")
	@ResponseBody
	public void download(HttpServletRequest request, HttpServletResponse response){
		ImportTemplate.initialize(response);
		ImportTemplate.templetdownload(request, "supplier-import.xlsx", "供方导入模板");
	}

	/**
	 * excel导入
	 *
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/excelImport", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<Object> excelImport(HttpServletRequest request, HttpServletResponse response) {
		MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
		Long tenantId = InvocationInfoProxy.getTenantid();
		boolean isFailed = false;
		MultipartFile mf = null;
		for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
			mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
        	extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
            	isFailed = true;
            	break;
            }
        }

		if(isFailed) {
			return CommonResponse.error("文件格式不合法");
		}else{
			//只读第一页（sheet）
			List<List<String>> result = ExcelReader.readExcel(mf);
			List<String> errorList = new ArrayList<String>();
			if(result != null && result.size() > 0) {
				for(int i=0;i<result.size();i++) {
					List<String> datas = result.get(i);
					SupplierVO supplierVo = null;
					SupplierCategoryVO supplierCategoryVo = supplierCategoryService.queryByCode(String.valueOf(datas.get(0)));
					if(supplierCategoryVo != null) {
						if(StringUtils.isEmpty(datas.get(3))) {
							errorList.add("第"+(i+1)+"行数据：" + datas.toString()+"导入失败，原因：统一社会信用代码不能为空！");
							continue;
						}else{
							supplierVo = supplierService.queryDetailBySocialCode(String.valueOf(datas.get(3)));
							if(supplierVo != null) {
								errorList.add("第"+(i+1)+"行数据：" + datas.toString()+"导入失败，原因：存在相同统一社会信用代码的供应商！");
								continue;
							}
							supplierVo = new SupplierVO();
						}
						if(StringUtils.isEmpty(datas.get(1))){

							BillCodeParam billCodeParam = BillCodeParam.build(SUPPLIER_BILL_CODE , InvocationInfoProxy.getTenantid(), supplierVo);
							CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
							if(billCode.isSuccess()) {
								supplierVo.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
							}else{
								throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
							}

						}else {
							supplierVo.setCode(datas.get(1));
						}
						if(StringUtils.isEmpty(datas.get(2))) {
							errorList.add("第"+(i+1)+"行数据：" + datas.toString()+"导入失败，原因：供方名称不能为空！");
							continue;
						}
						supplierVo.setName(String.valueOf(datas.get(2)));
						supplierVo.setCategoryId(supplierCategoryVo.getId());
						supplierVo.setSocialCreditCode(String.valueOf(datas.get(3)));
						supplierVo.setLegal(String.valueOf(datas.get(4)));

						//巨力改造：去掉纳税人
//						if(StringUtils.isNotEmpty(datas.get(5))) {
//							DefdocDetailVO taxPayerTypeVo = defdocDetailService.queryDetailByName(String.valueOf(datas.get(5)));
//							if(taxPayerTypeVo != null) {
//								supplierVo.setTaxPayerType(taxPayerTypeVo.getId());
//							}
//						}

						supplierVo.setBusinessScope(datas.get(6));
						supplierVo.setTelephone(datas.get(7));
						supplierVo.setArea(datas.get(8));
						supplierVo.setAddress(datas.get(9));
						supplierVo.setBankName(datas.get(10));
						supplierVo.setBankAccount(datas.get(11));
						supplierVo.setBankCode(datas.get(12));
						//供方方联系人
						if(StringUtils.isNotEmpty(datas.get(13))) {
							List<SupplierLinkerVO> gridheaders = new ArrayList<SupplierLinkerVO>();

							String linkman = String.valueOf(datas.get(13));
							SupplierLinkerVO supplierLinkerVo = supplierLinkerService.queryBySupplierIdAndLinkman(supplierVo.getId(), linkman);
							if(supplierLinkerVo == null) {
								supplierLinkerVo = new SupplierLinkerVO();
								supplierLinkerVo.setRowState("add");
							}else{
								supplierLinkerVo.setRowState("edit");
							}
							supplierLinkerVo.setSupplierId(supplierVo.getId());
							supplierLinkerVo.setLinkman(datas.get(13));
							supplierLinkerVo.setCellphone(datas.get(14));
							gridheaders.add(supplierLinkerVo);
							supplierVo.setGridheaders(gridheaders);
						}
						supplierVo.setEnabled(1);
						supplierService.saveOrUpdate(supplierVo);
					}else{
						errorList.add("第"+(i+1)+"行数据：" + datas.toString()+"导入失败，原因：供方分类编号不正确！");
						continue;
					}
				}
			}
			if(errorList.size() > 0) {

				errorList.add("导入成功："+(result.size() - errorList.size() )+"条, 失败：" +errorList.size()+"条");
				return CommonResponse.error("导入失败", errorList);
			}else{
				return CommonResponse.success("导入成功");
			}
		}
	}

	/**
	 * excel导出
	 *
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/excelExport", method = RequestMethod.POST)
	@ResponseBody
	public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
		List<SupplierVO> supplierVos = new ArrayList<>();
//		if(queryParam.getParams().get("categoryId")!=null){
//			if(StringUtils.isNotBlank(queryParam.getParams().get("categoryId").getValue().toString())){
				queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
				supplierVos = supplierService.queryExportList(queryParam);
//			}
//		}
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", supplierVos);
		ExcelExport.getInstance().export("supplier-export.xlsx", beans, response);
	}

	/**
	 * 供方列表
	 *
	 * @param pageNumber
	 * @param pageSize
	 * @param relyCondition
	 * @param searchText
	 * @param condition
	 * @return
	 */
	@RequestMapping(value = "refSupplierPage", method = RequestMethod.GET)
	@ResponseBody
    public CommonResponse<IPage<SupplierVO>> refSupplierPage(@RequestParam(defaultValue = "1") int pageNumber,
                                                             @RequestParam(defaultValue = "10") int pageSize,
                                                             @RequestParam(required=false) String relyCondition,
                                                             @RequestParam(required=false) String searchText,
                                                             @RequestParam(required=false) String condition
								) {
		Map<String,Object> params = new HashMap<>();
    	if(StringUtils.isNotBlank(relyCondition)){
    		Long categoryId = Long.parseLong(relyCondition.split("=")[1]);
    		SupplierCategoryEntity supplierCategoryEntity = supplierCategoryService.queryDetail(categoryId);
    		if(supplierCategoryEntity != null) {
    			params.put("innerCode", supplierCategoryEntity.getInnerCode());
    		}
    	}
		if (StringUtils.isNotBlank(condition)) {
			JSONObject jsonObject = JSON.parseObject(condition);
			if (jsonObject.containsKey("supplierIds")) {
				params.put("supplierIds", jsonObject.getString("supplierIds"));
			}
		}
    	params.put("pageIndex", pageNumber <= 0 ? 0:(pageNumber-1)*pageSize);
    	params.put("pageSize", pageSize);
    	params.put("searchText", searchText);
    	/** 过滤掉不合作的供方 */
    	params.put("enabled", 1);
    	params.put("tenantId", InvocationInfoProxy.getTenantid());
    	IPage<SupplierVO> pageData = supplierService.queryRefMaterialPage(params);
        return CommonResponse.success("查询成功！", pageData);
	}


	/**
	 * ref供应商列表（询价管理专用）
	 *
	 * @param pageNumber    页码
	 * @param pageSize      页面大小
	 * @param relyCondition 使用条件
	 * @param searchText    搜索文本
	 * @param condition     条件(租户id)
	 *
	 * @return {@link CommonResponse}<{@link List}<{@link SupplierVO}>>
	 */
	@RequestMapping(value = "refSupplierList", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<List<SupplierVO>> refSupplierList(@RequestParam(defaultValue = "1") int pageNumber,
                                                            @RequestParam(defaultValue = "10") int pageSize,
                                                            @RequestParam(required = false) String relyCondition,
                                                            @RequestParam(required = false) String searchText,
                                                            @RequestParam(required = false) String condition) {
		Map<String, Object> params = new HashMap<>();
		if (StringUtils.isNotBlank(relyCondition)) {
			Long categoryId = Long.parseLong(relyCondition.split("=")[1]);
			SupplierCategoryEntity supplierCategoryEntity = supplierCategoryService.queryDetail(categoryId);
			if (supplierCategoryEntity != null) {
				params.put("innerCode", supplierCategoryEntity.getInnerCode());
			}
		}
		params.put("pageIndex", pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
		params.put("pageSize", pageSize);
		params.put("searchText", searchText);
		/** 过滤掉不合作的供方 */
		params.put("enabled", 1);
		if (StringUtils.isNotBlank(condition)) {
			JSONObject jsonObject = JSON.parseObject(condition);
			if (jsonObject.containsKey("tenantId")) {
				params.put("tenantId", Long.parseLong(jsonObject.getString("tenantId")));
			}
		}
		List<SupplierVO> pageData = supplierService.querySupplierList(params);
		return CommonResponse.success("查询成功！", pageData);
	}

	/**
	 * @Author mrsir_wxp
	 * @Date 2020/7/15 处理供方合租不合作状态
	 * @Description enableSupplierOrNot
	 * @Param [data]
	 * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
	 */
	@RequestMapping(value = "/enableSupplierOrNot", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> enableSupplierOrNot(@RequestBody Map<String,Object> data){
		if(data == null){
			return CommonResponse.error("没有可处理的数据！");
		}
		List<Long> ids = (List<Long>)data.get("ids");
		String state = (String)data.get("state");
		if(ListUtil.isEmpty(ids) || StringUtils.isEmpty(state)){
			return CommonResponse.error("没有可处理的数据！");
		}
		if(!(state.equals("0") || state.equals("1"))){
			return CommonResponse.error("合作状态不正确！");
		}
		data.put("tenantId", InvocationInfoProxy.getTenantid());
		data.put("ids",StringUtils.join(ids.toArray(), ","));
		supplierService.enableSupplierOrNot(data);
		return CommonResponse.success("处理成功！");
	}

	/**
	 *
	 * 供方协同(生成租户)
	 * */
	@RequestMapping(value = "/supplierCollaboration", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> supplierCollaboration(@RequestBody SupplierVO supplierVO){

		return supplierService.supplierCollaboration(supplierVO);
	}

	/**
	 * 获取供应商信息
	 *
	 * @param tenant
	 * @return
	 */
	@RequestMapping(value = "/querySupplierByTenantId", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<SupplierVO> querySupplierByTenantId(@RequestParam Long tenant) {
		SupplierVO supplierVo = supplierService.querySupplierByTenantId(tenant);
		return CommonResponse.success(supplierVo);
	}

	/**
	 * 根据code获取供应商信息
	 *
	 * @param tenant
	 * @return
	 */
	@RequestMapping(value = "/querySupplierByCode", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<SupplierVO> querySupplierByCode(@RequestParam String code) {
		SupplierVO supplierVo = new SupplierVO();
		QueryWrapper<SupplierEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("code", code);
		queryWrapper.eq("dr", 0);
		List<SupplierEntity> list = supplierService.list(queryWrapper);
		if(list!=null&&list.size()>0){
			supplierVo = BeanMapper.map(list.get(0), SupplierVO.class);
			return CommonResponse.success(supplierVo);
		}
		return CommonResponse.success(null);
	}

	/**
	 * 根据sourceId获取供应商信息
	 *
	 * @param sourceId
	 * @return
	 */
	@RequestMapping(value = "/querySupplierBySourceId", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<SupplierVO> querySupplierBySourceId(@RequestParam String sourceId) {
		SupplierVO supplierVo = new SupplierVO();
		QueryWrapper<SupplierEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("source_id", sourceId);
		queryWrapper.eq("enabled", 1);
		queryWrapper.eq("dr", 0);
		List<SupplierEntity> list = supplierService.list(queryWrapper);
		if(list!=null&&list.size()>0){
			supplierVo = BeanMapper.map(list.get(0), SupplierVO.class);
			return CommonResponse.success(supplierVo);
		}
		return CommonResponse.error("未查询到对应供应商");
	}


	/**
	 * 根据供应商名称或者纳税人识别号查询供应商
	 * @param supplierName
	 * @param socialCreditCode
	 * @return
	 */
	@RequestMapping(value = "querySupplierByNameOrSocialCreditCode", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<JSONObject> querySupplierByNameOrSocialCreditCode(String supplierName, String socialCreditCode) {
		return CommonResponse.success("查询成功！", supplierService.querySupplierByNameOrSocialCreditCode(supplierName, socialCreditCode));
	}



	@GetMapping("syncSupplier")
	@ResponseBody
	public CommonResponse<String> syncSupplier(){
		JSONObject param = new JSONObject();
		JSONObject postData = new JSONObject();
		JSONObject ufinterface = new JSONObject();

		ufinterface.put("sender","pm");
		JSONObject data = new JSONObject();
		JSONArray pk_org = new JSONArray();
		pk_org.add(juliBipPkOrg);
		data.put("pk_org",pk_org);
		ufinterface.put("data",data);
		postData.put("ufinterface",ufinterface);
		param.put("url",SYNC_SUPPLY_URL);
		param.put("postData",postData.toJSONString());
		CommonResponse<String> res = juliApi.getDataFromBip(param);
		logger.info("同步供应商：请求地址：{}，请求参数：{}，响应：{}",SYNC_SUPPLY_URL,postData.toJSONString(),JSONObject.toJSONString(res.getData()));
		if(res.isSuccess()){
			JSONObject supplierResp = JSONObject.parseObject(res.getData());
			if(supplierResp.getBoolean("success")){
				JSONArray supplierList = supplierResp.getJSONArray("data");
				if(supplierList != null && !supplierList.isEmpty()){
					for (Object o : supplierList) {
						JSONObject supplierObject = (JSONObject) o;
						String pk = supplierObject.getString("pk_supplierclass");
						QueryParam param1 = QueryParam.getInstance();
						param1.getParams().put("sourceId",new Parameter(QueryParam.EQ,pk));
						List<SupplierEntity> supplierCategoryList = supplierService.queryList(param1,false);
						SupplierEntity supplierEntity;
						if(ListUtil.isEmpty(supplierCategoryList)){
							supplierEntity = new SupplierEntity();
							supplierEntity.setSourceId(pk);
							supplierEntity.setDescription("bip数据同步生成！"+ DateFormatUtil.formatDate(DateFormatUtil.PATTERN_DEFAULT_ON_SECOND,new Date()));
							supplierEntity.setTenantId(999999L);
						}else {
							supplierEntity = supplierCategoryList.get(0);
						}
						supplierEntity.setCode(supplierObject.getString("code"));
						supplierEntity.setName(supplierObject.getString("name"));
//						supplierService.saveOrUpdate(supplierEntity);
					}
				}
			}else {
				return CommonResponse.error("同步供应商失败！"+supplierResp.getString("message"));
			}
		}
		return CommonResponse.success("同步供应商成功！");
	}


}
