package com.ejianc.foundation.share.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.foundation.share.vo.ProjectArchiveVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.foundation.share.mapper.ProjectArchiveMapper;
import com.ejianc.foundation.share.bean.ProjectArchiveEntity;
import com.ejianc.foundation.share.service.IProjectArchiveService;

/**
 * 项目档案
 * 
 * @author generator
 * 
 */
@Service("projectArchiveService")
public class ProjectArchiveServiceImpl extends BaseServiceImpl<ProjectArchiveMapper, ProjectArchiveEntity> implements IProjectArchiveService{

    @Override
    public boolean checkSameBillCode(ProjectArchiveVO saveOrUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper<ProjectArchiveEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(ProjectArchiveEntity::getCode, saveOrUpdateVO.getCode());
        lambda.eq(ProjectArchiveEntity::getTenantId, tenantId);
        if (null != saveOrUpdateVO.getId() && saveOrUpdateVO.getId() > 0) {
            lambda.ne(ProjectArchiveEntity::getId, saveOrUpdateVO.getId());
        }
        return super.list(lambda).size() > 0;
    }
}
