/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.utils.EJCDateUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.bean.ProjectSetPoolEntity;
import com.ejianc.foundation.share.service.IProjectSetService;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.share.vo.ProjectSurveyVO;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/projectPool/"})
public class ProjectPoolApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProjectSetService projectSetService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOrgApi orgApi;

    @GetMapping(value={"queryProjectList"})
    public CommonResponse<List<ProjectSurveyVO>> queryProjectList(@RequestParam(value="projectStatus", required=false) String projectStatus, @RequestParam(value="dateIn", required=false) String dateIn, @RequestParam(value="orgId", required=false) Long orgId, @RequestParam(value="currentProvince", required=false) String currentProvince) {
        ArrayList resp = new ArrayList();
        QueryWrapper queryWrapper = new QueryWrapper();
        if (io.micrometer.core.instrument.util.StringUtils.isNotEmpty((String)projectStatus)) {
            queryWrapper.eq((Object)"project_status", (Object)projectStatus);
        }
        if (io.micrometer.core.instrument.util.StringUtils.isNotEmpty((String)dateIn)) {
            queryWrapper.eq((Object)"DATE_FORMAT(project_date,\"%Y\")", (Object)dateIn);
        }
        queryWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        Long _orgId = orgId == null ? InvocationInfoProxy.getOrgId() : orgId;
        List orgVOList = (List)this.getRespData(this.orgApi.findChildrenByParentId(_orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (commonOrgIds.size() != 0) {
            queryWrapper.in((Object)"org_id", commonOrgIds);
        } else if (departmentIds.size() != 0) {
            queryWrapper.in((Object)"project_department_id", departmentIds);
        }
        List projectSetPoolEntities = this.projectSetService.list((Wrapper)queryWrapper);
        ArrayList<ProjectSurveyVO> list = new ArrayList<ProjectSurveyVO>();
        if (CollectionUtils.isNotEmpty((Collection)projectSetPoolEntities)) {
            for (ProjectSetPoolEntity projectSetPoolEntity : projectSetPoolEntities) {
                ProjectSurveyVO projectSurveyVO = new ProjectSurveyVO();
                projectSurveyVO.setId(projectSetPoolEntity.getId());
                projectSurveyVO.setOrgId(projectSetPoolEntity.getOrgId());
                projectSurveyVO.setProjectName(projectSetPoolEntity.getName());
                projectSurveyVO.setParentProjectId(projectSetPoolEntity.getParentProjectId());
                if (io.micrometer.core.instrument.util.StringUtils.isNotEmpty((String)projectSetPoolEntity.getAreaName())) {
                    String areaName = null;
                    areaName = currentProvince.equals("henan") ? projectSetPoolEntity.getAreaName().replace("/", "") : projectSetPoolEntity.getAreaName().replace(",", "").replaceAll("\\/", "");
                    projectSurveyVO.setArea(areaName);
                } else {
                    projectSurveyVO.setArea(projectSetPoolEntity.getAreaName());
                }
                projectSurveyVO.setProjectDepartmentId(projectSetPoolEntity.getProjectDepartmentId());
                list.add(projectSurveyVO);
            }
        }
        return CommonResponse.success(list);
    }

    @PostMapping(value={"getProjectPoolList"})
    public CommonResponse<JSONArray> getProjectPoolList(@RequestBody QueryParam param) {
        if (!param.getParams().containsKey("tenantId") && !param.getParams().containsKey("tenant_id")) {
            param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        }
        List entities = this.projectSetService.queryList(param, false);
        return CommonResponse.success((Object)JSONArray.parseArray((String)JSONObject.toJSONString((Object)entities)));
    }

    @GetMapping(value={"queryProjectPoolList"})
    public CommonResponse<JSONArray> queryProjectPoolList(@RequestParam(value="projectStatus", required=false) String projectStatus, @RequestParam(value="dateIn", required=false) String dateIn, @RequestParam(value="orgId", required=false) Long orgId) {
        List resp = new ArrayList();
        QueryWrapper queryWrapper = new QueryWrapper();
        if (io.micrometer.core.instrument.util.StringUtils.isNotEmpty((String)projectStatus)) {
            queryWrapper.eq((Object)"project_status", (Object)projectStatus);
        }
        if (io.micrometer.core.instrument.util.StringUtils.isNotEmpty((String)dateIn)) {
            queryWrapper.eq((Object)"DATE_FORMAT(project_date,\"%Y\")", (Object)dateIn);
        }
        queryWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        Long _orgId = orgId == null ? InvocationInfoProxy.getOrgId() : orgId;
        List orgVOList = (List)this.getRespData(this.orgApi.findChildrenByParentId(_orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (commonOrgIds.size() != 0) {
            queryWrapper.in((Object)"org_id", commonOrgIds);
        } else if (departmentIds.size() != 0) {
            queryWrapper.in((Object)"project_department_id", departmentIds);
        }
        List projectSetPoolEntities = this.projectSetService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)projectSetPoolEntities)) {
            resp = BeanMapper.mapList((Iterable)projectSetPoolEntities, ProjectPoolSetVO.class);
        }
        return CommonResponse.success((Object)JSONArray.parseArray((String)JSONObject.toJSONString(resp)));
    }

    @GetMapping(value={"queryProjectPoolById"})
    public CommonResponse<JSONArray> queryProjectPoolById(@RequestParam(value="id") Long id) {
        List resp = new ArrayList();
        QueryWrapper queryWrapper = new QueryWrapper();
        if (null == id) {
            return CommonResponse.error((String)"\u8bf7\u68c0\u67e5\u53c2\u6570\u9879\u76eeid\u662f\u5426\u4e3a\u7a7a\uff01");
        }
        queryWrapper.eq((Object)"id", (Object)id);
        List projectSetPoolEntities = this.projectSetService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)projectSetPoolEntities)) {
            resp = BeanMapper.mapList((Iterable)projectSetPoolEntities, ProjectPoolSetVO.class);
        }
        return CommonResponse.success((Object)JSONArray.parseArray((String)JSONObject.toJSONString(resp)));
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @GetMapping(value={"queryProjectListByNameAndCodeAndTenantId"})
    public CommonResponse<List<ProjectPoolSetVO>> queryProjectListByNameAndCodeAndTenantId(@RequestParam(value="name") String name, @RequestParam(value="code") String code, @RequestParam(value="tenantId") Long tenantId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
        queryParam.getParams().put("name", new Parameter("eq", (Object)name));
        queryParam.getParams().put("code", new Parameter("eq", (Object)code));
        List projectSetPoolEntityList = this.projectSetService.queryList(queryParam);
        return CommonResponse.success((String)"\u6839\u636e\u9879\u76ee\u540d\u79f0\u3001\u9879\u76ee\u7f16\u7801\u3001\u79df\u6237id\u67e5\u8be2\u9879\u76ee\u6c60\u4e2d\u7684\u9879\u76ee\u6210\u529f", (Object)BeanMapper.mapList((Iterable)projectSetPoolEntityList, ProjectPoolSetVO.class));
    }

    @GetMapping(value={"queryProjectListByCodeAndTenantId"})
    public CommonResponse<List<ProjectPoolSetVO>> queryProjectListByCodeAndTenantId(@RequestParam(value="code") String code, @RequestParam(value="tenantId") Long tenantId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
        queryParam.getParams().put("code", new Parameter("eq", (Object)code));
        List projectSetPoolEntityList = this.projectSetService.queryList(queryParam);
        List poolSetVOList = BeanMapper.mapList((Iterable)projectSetPoolEntityList, ProjectPoolSetVO.class);
        this.logger.info("\u901a\u8fc7\u9879\u76ee\u7f16\u7801{}\uff0c\u67e5\u51fa\u9879\u76ee\u6c60\u4e2d\u6570\u636e{}", (Object)code, (Object)JSONObject.toJSONString((Object)poolSetVOList));
        if (CollectionUtils.isNotEmpty((Collection)poolSetVOList) && ((ProjectPoolSetVO)poolSetVOList.get(0)).getOrgId() != null && ((ProjectPoolSetVO)poolSetVOList.get(0)).getProjectDepartmentId() != null) {
            OrgVO orgVO = (OrgVO)this.getRespData(this.orgApi.getOneById(((ProjectPoolSetVO)poolSetVOList.get(0)).getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            ((ProjectPoolSetVO)poolSetVOList.get(0)).setOrgCode(orgVO.getCode());
            OrgVO projectDepartmentVO = (OrgVO)this.getRespData(this.orgApi.getOneById(((ProjectPoolSetVO)poolSetVOList.get(0)).getProjectDepartmentId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            ((ProjectPoolSetVO)poolSetVOList.get(0)).setProjectDepartmentCode(projectDepartmentVO.getCode());
        }
        return CommonResponse.success((String)"\u6839\u636e\u9879\u76ee\u7f16\u7801\u3001\u79df\u6237id\u67e5\u8be2\u9879\u76ee\u6c60\u4e2d\u7684\u9879\u76ee\u6210\u529f", (Object)poolSetVOList);
    }

    @GetMapping(value={"queryProjectListByNameAndTenantId"})
    public CommonResponse<List<ProjectPoolSetVO>> queryProjectListByNameAndTenantId(@RequestParam(value="name") String name, @RequestParam(value="tenantId") Long tenantId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
        queryParam.getParams().put("name", new Parameter("eq", (Object)name));
        List projectSetPoolEntityList = this.projectSetService.queryList(queryParam);
        return CommonResponse.success((String)"\u6839\u636e\u9879\u76ee\u540d\u79f0\u3001\u9879\u76ee\u7f16\u7801\u3001\u79df\u6237id\u67e5\u8be2\u9879\u76ee\u6c60\u4e2d\u7684\u9879\u76ee\u6210\u529f", (Object)BeanMapper.mapList((Iterable)projectSetPoolEntityList, ProjectPoolSetVO.class));
    }

    @GetMapping(value={"queryProjectListByProjectDepartmentId"})
    public CommonResponse<List<ProjectPoolSetVO>> queryProjectListByProjectDepartmentId(@RequestParam(value="projectDepartmentId") Long projectDepartmentId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectDepartmentId", new Parameter("eq", (Object)projectDepartmentId));
        List projectSetPoolEntityList = this.projectSetService.queryList(queryParam);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)BeanMapper.mapList((Iterable)projectSetPoolEntityList, ProjectPoolSetVO.class));
    }

    @PostMapping(value={"queryProjectIPage"})
    public CommonResponse<Page<ProjectPoolSetVO>> queryProjectIPage(@RequestBody QueryParam param) {
        this.logger.info("sssss" + JSONObject.toJSONString((Object)param));
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("name");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = null != param.getParams() && null != param.getParams().get("orgId") ? Long.valueOf(((Parameter)param.getParams().get("orgId")).getValue().toString()) : InvocationInfoProxy.getOrgId();
        param.getParams().remove("orgId");
        List orgVOList = (List)this.getRespData(this.orgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (commonOrgIds.size() != 0) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (departmentIds.size() != 0) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        } else {
            return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)new Page(1L, (long)param.getPageSize(), 0L));
        }
        IPage page = this.projectSetService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProjectPoolSetVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @GetMapping(value={"/queryProjectIdsByorgId"})
    @ResponseBody
    CommonResponse<List<Long>> queryProjectIdsByorgId(@RequestParam(value="orgId") Long orgId, @RequestParam(value="projectStatus", required=false) String projectStatus, @RequestParam(value="dateIn", required=false) String dateIn) {
        QueryWrapper queryWrapper = new QueryWrapper();
        Long _orgId = orgId == null ? InvocationInfoProxy.getOrgId() : orgId;
        List orgVOList = (List)this.getRespData(this.orgApi.findChildrenByParentId(_orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (commonOrgIds.size() != 0) {
            queryWrapper.in((Object)"org_id", commonOrgIds);
        } else if (departmentIds.size() != 0) {
            queryWrapper.in((Object)"project_department_id", departmentIds);
        }
        if (io.micrometer.core.instrument.util.StringUtils.isNotEmpty((String)projectStatus) && "building".equals(projectStatus)) {
            queryWrapper.in((Object)"project_status", new Object[]{1});
        }
        if (io.micrometer.core.instrument.util.StringUtils.isNotEmpty((String)dateIn) && "thisYear".equals(dateIn)) {
            dateIn = EJCDateUtil.getYear() + "";
            queryWrapper.eq((Object)"DATE_FORMAT(project_date,\"%Y\")", (Object)dateIn);
        }
        List projectSetPoolEntities = this.projectSetService.list((Wrapper)queryWrapper);
        List ids = projectSetPoolEntities.stream().map(BaseEntity::getId).collect(Collectors.toList());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", ids);
    }

    @GetMapping(value={"/queryProjectIdsByParentProjectId"})
    @ResponseBody
    CommonResponse<List<Long>> queryProjectIdsByParentProjectId(@RequestParam(value="parentProjectId", required=false) Long parentProjectId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("parentProjectId", new Parameter("eq", (Object)parentProjectId));
        List list = this.projectSetService.queryList(queryParam, false);
        List<Long> ids = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            ids = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        }
        ids.add(parentProjectId);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", ids);
    }

    @GetMapping(value={"queryDetailById"})
    public CommonResponse<ProjectVO> queryDetailById(@RequestParam(value="id") Long id) {
        ProjectSetPoolEntity entity = (ProjectSetPoolEntity)((Object)this.projectSetService.selectById(id));
        ProjectPoolSetVO vo = (ProjectPoolSetVO)BeanMapper.map((Object)((Object)entity), ProjectPoolSetVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)this.getProjectVO(vo));
    }

    @PostMapping(value={"queryProjectArray"})
    public CommonResponse<JSONArray> queryProjectArray(@RequestBody List<Long> ids) {
        ArrayList vos = new ArrayList();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.in((Object)"id", ids);
        List entitys = this.projectSetService.list((Wrapper)queryWrapper);
        List poolList = BeanMapper.mapList((Iterable)entitys, ProjectPoolSetVO.class);
        List<ProjectVO> voList = this.getProjectVOS(poolList);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)JSONArray.parseArray((String)JSONObject.toJSONString(voList)));
    }

    @PostMapping(value={"queryProjectByIds"})
    public CommonResponse<JSONArray> queryProjectByIds(@RequestBody List<Long> ids) {
        ArrayList vos = new ArrayList();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.in((Object)"id", ids);
        List entitys = this.projectSetService.list((Wrapper)queryWrapper);
        List poolList = BeanMapper.mapList((Iterable)entitys, ProjectPoolSetVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)JSONArray.parseArray((String)JSONObject.toJSONString((Object)poolList)));
    }

    @PostMapping(value={"queryProjectsByIds"})
    public CommonResponse<List<ProjectPoolSetVO>> queryProjectsByIds(@RequestBody List<Long> ids) {
        ArrayList vos = new ArrayList();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.in((Object)"id", ids);
        List entitys = this.projectSetService.list((Wrapper)queryWrapper);
        List poolList = BeanMapper.mapList((Iterable)entitys, ProjectPoolSetVO.class);
        return CommonResponse.success((Object)poolList);
    }

    @GetMapping(value={"queryProjectByProjectDepartmentId"})
    public CommonResponse<ProjectVO> queryProjectByProjectDepartmentId(@RequestParam(value="projectDepartmentId") Long projectDepartmentId) {
        ProjectSetPoolEntity entity = (ProjectSetPoolEntity)((Object)this.projectSetService.selectById(projectDepartmentId));
        if (entity == null) {
            QueryParam param = new QueryParam();
            param.getParams().put("project_department_id", new Parameter("eq", (Object)projectDepartmentId));
            List list = this.projectSetService.queryList(param, false);
            if (ListUtil.isNotEmpty((List)list)) {
                entity = (ProjectSetPoolEntity)((Object)list.get(0));
            }
        }
        if (entity == null) {
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", null);
        }
        ProjectPoolSetVO vo = (ProjectPoolSetVO)BeanMapper.map((Object)((Object)entity), ProjectPoolSetVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)this.getProjectVO(vo));
    }

    @PostMapping(value={"queryProjects"})
    @ResponseBody
    public CommonResponse<List<ProjectVO>> queryProjects(@RequestBody QueryParam param) {
        List orgIds = ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("project_department_id", new Parameter("in", orgIds));
        List list = this.projectSetService.queryList(param);
        List voList = BeanMapper.mapList((Iterable)list, ProjectPoolSetVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", this.getProjectVOS(voList));
    }

    @PostMapping(value={"queryArray"})
    @ResponseBody
    CommonResponse<JSONArray> queryArray(@RequestBody QueryParam param) {
        List orgIds = ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("project_department_id", new Parameter("in", orgIds));
        List list = this.projectSetService.queryList(param);
        List poolList = BeanMapper.mapList((Iterable)list, ProjectPoolSetVO.class);
        List<ProjectVO> voList = this.getProjectVOS(poolList);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)JSONArray.parseArray((String)JSONObject.toJSONString(voList)));
    }

    @GetMapping(value={"queryProjectsByOrgId"})
    @ResponseBody
    public CommonResponse<List<ProjectVO>> queryProjectsByOrgId(@RequestParam(value="orgId") Long orgId) {
        List orgIds = ((List)this.orgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryParam param = new QueryParam();
        param.getParams().put("project_status", new Parameter("eq", (Object)1));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("project_department_id", new Parameter("in", orgIds));
        List list = this.projectSetService.queryList(param);
        List voList = BeanMapper.mapList((Iterable)list, ProjectPoolSetVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", this.getProjectVOS(voList));
    }

    @GetMapping(value={"queryArrayByOrgId"})
    @ResponseBody
    CommonResponse<JSONArray> queryArrayByOrgId(@RequestParam(value="orgId") Long orgId) {
        List orgIds = ((List)this.orgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryParam param = new QueryParam();
        param.getParams().put("project_status", new Parameter("eq", (Object)1));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("project_department_id", new Parameter("in", orgIds));
        List list = this.projectSetService.queryList(param);
        List poolList = BeanMapper.mapList((Iterable)list, ProjectPoolSetVO.class);
        List<ProjectVO> voList = this.getProjectVOS(poolList);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)JSONArray.parseArray((String)JSONObject.toJSONString(voList)));
    }

    public ProjectVO getProjectVO(ProjectPoolSetVO projectSetVO) {
        ProjectVO map = (ProjectVO)BeanMapper.map((Object)projectSetVO, ProjectVO.class);
        map.setProjectName(projectSetVO.getName());
        map.setBillCode(projectSetVO.getCode());
        map.setLeader(projectSetVO.getProjectManagementId());
        map.setStartDate(projectSetVO.getPlanStartDate());
        map.setEndDate(projectSetVO.getPlanEndDate());
        map.setContractualModel(projectSetVO.getEngineeringType());
        return map;
    }

    public List<ProjectVO> getProjectVOS(List<ProjectPoolSetVO> projectSetVOS) {
        ArrayList<ProjectVO> list = new ArrayList<ProjectVO>();
        for (ProjectPoolSetVO projectSetVO : projectSetVOS) {
            ProjectVO projectVO = this.getProjectVO(projectSetVO);
            list.add(projectVO);
        }
        return list;
    }

    @GetMapping(value={"getOneByCode"})
    public CommonResponse<ProjectPoolSetVO> getOneByCode(@RequestParam String code) {
        ProjectPoolSetVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        query.eq((Object)"code", (Object)code);
        ProjectSetPoolEntity e = (ProjectSetPoolEntity)((Object)this.projectSetService.getOne((Wrapper)query));
        if (null != e) {
            resp = (ProjectPoolSetVO)BeanMapper.map((Object)((Object)e), ProjectPoolSetVO.class);
        }
        return CommonResponse.success(resp);
    }

    @GetMapping(value={"getOneBySourceId"})
    public CommonResponse<ProjectPoolSetVO> getOneBySourceId(@RequestParam String sourceId) {
        ProjectPoolSetVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        query.eq((Object)"source_id", (Object)sourceId);
        ProjectSetPoolEntity e = (ProjectSetPoolEntity)((Object)this.projectSetService.getOne((Wrapper)query));
        if (null != e) {
            resp = (ProjectPoolSetVO)BeanMapper.map((Object)((Object)e), ProjectPoolSetVO.class);
        }
        return CommonResponse.success(resp);
    }
}

