/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller.desktop;

import com.ejianc.business.contractbase.utils.EJCDateUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.consts.ProjectBusinessStatusEnum;
import com.ejianc.foundation.share.service.IProjectSetService;
import com.ejianc.foundation.share.vo.ProjectDesktopVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/projectDesktop/"})
public class ProjectDesktopController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProjectSetService projectSetService;

    @GetMapping(value={"businessStatusCount"})
    public CommonResponse<ProjectDesktopVO> businessStatusCount(@RequestParam(value="orgId", required=false) Long orgId) {
        Long _orgId = orgId == null ? InvocationInfoProxy.getOrgId() : orgId;
        List orgVOList = (List)this.getRespData(this.orgApi.findChildrenByParentId(_orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList<Long> commonOrgIds = new ArrayList<Long>();
        ArrayList<Long> departmentIds = new ArrayList<Long>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        ArrayList<String> businessStatusList = new ArrayList<String>();
        businessStatusList.add(ProjectBusinessStatusEnum.\u6b63\u5f0f\u5f00\u5de5.getBusinessStatus());
        businessStatusList.add(ProjectBusinessStatusEnum.\u5f00\u5de5\u51c6\u5907.getBusinessStatus());
        businessStatusList.add(ProjectBusinessStatusEnum.\u505c\u5de5.getBusinessStatus());
        businessStatusList.add(ProjectBusinessStatusEnum.\u5b8c\u5de5.getBusinessStatus());
        businessStatusList.add(ProjectBusinessStatusEnum.\u7ae3\u5de5.getBusinessStatus());
        ProjectDesktopVO projectDesktopVO = null;
        String thisYear = EJCDateUtil.getYear() + "";
        BigDecimal thisYearProjectNum = BigDecimal.ZERO;
        if (commonOrgIds.size() != 0) {
            projectDesktopVO = this.projectSetService.queryProjectBusinessStatusCount(commonOrgIds, null, businessStatusList);
            thisYearProjectNum = this.projectSetService.queryThisYearProjectNum(commonOrgIds, null, thisYear);
        } else if (departmentIds.size() != 0) {
            projectDesktopVO = this.projectSetService.queryProjectBusinessStatusCount(null, departmentIds, businessStatusList);
            thisYearProjectNum = this.projectSetService.queryThisYearProjectNum(null, departmentIds, thisYear);
        }
        if (projectDesktopVO == null) {
            projectDesktopVO = new ProjectDesktopVO(BigDecimal.ZERO, BigDecimal.ZERO);
        }
        projectDesktopVO.setThisYearProjectNum(ComputeUtil.nullToZero((BigDecimal)thisYearProjectNum));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)projectDesktopVO);
    }

    @GetMapping(value={"businessStatusCountParent"})
    public CommonResponse<ProjectDesktopVO> businessStatusCountParent(@RequestParam(value="orgId", required=false) Long orgId) {
        Long _orgId = orgId == null ? InvocationInfoProxy.getOrgId() : orgId;
        List orgVOList = (List)this.getRespData(this.orgApi.findChildrenByParentId(_orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList<Long> commonOrgIds = new ArrayList<Long>();
        ArrayList<Long> departmentIds = new ArrayList<Long>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        ArrayList<String> businessStatusList = new ArrayList<String>();
        businessStatusList.add(ProjectBusinessStatusEnum.\u6b63\u5f0f\u5f00\u5de5.getBusinessStatus());
        businessStatusList.add(ProjectBusinessStatusEnum.\u5f00\u5de5\u51c6\u5907.getBusinessStatus());
        businessStatusList.add(ProjectBusinessStatusEnum.\u505c\u5de5.getBusinessStatus());
        businessStatusList.add(ProjectBusinessStatusEnum.\u5b8c\u5de5.getBusinessStatus());
        businessStatusList.add(ProjectBusinessStatusEnum.\u7ae3\u5de5.getBusinessStatus());
        ProjectDesktopVO projectDesktopVO = null;
        if (commonOrgIds.size() != 0) {
            projectDesktopVO = this.projectSetService.queryProjectBusinessStatusCountParent(commonOrgIds, null, businessStatusList);
        } else if (departmentIds.size() != 0) {
            projectDesktopVO = this.projectSetService.queryProjectBusinessStatusCountParent(null, departmentIds, businessStatusList);
        }
        if (projectDesktopVO == null) {
            projectDesktopVO = new ProjectDesktopVO(BigDecimal.ZERO, BigDecimal.ZERO);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)projectDesktopVO);
    }

    @GetMapping(value={"businessStatusCountZzyj"})
    public CommonResponse<ProjectDesktopVO> businessStatusCountZzyj(@RequestParam(value="orgId", required=false) Long orgId) {
        Long _orgId = orgId == null ? InvocationInfoProxy.getOrgId() : orgId;
        List orgVOList = (List)this.getRespData(this.orgApi.findChildrenByParentId(_orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList<Long> commonOrgIds = new ArrayList<Long>();
        ArrayList<Long> departmentIds = new ArrayList<Long>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        ArrayList<String> businessStatusList = new ArrayList<String>();
        businessStatusList.add(ProjectBusinessStatusEnum.\u6b63\u5f0f\u5f00\u5de5.getBusinessStatus());
        businessStatusList.add(ProjectBusinessStatusEnum.\u5f00\u5de5\u51c6\u5907.getBusinessStatus());
        businessStatusList.add(ProjectBusinessStatusEnum.\u505c\u5de5.getBusinessStatus());
        businessStatusList.add(ProjectBusinessStatusEnum.\u5b8c\u5de5.getBusinessStatus());
        businessStatusList.add(ProjectBusinessStatusEnum.\u7ae3\u5de5.getBusinessStatus());
        ProjectDesktopVO projectDesktopVO = null;
        if (commonOrgIds.size() != 0) {
            projectDesktopVO = this.projectSetService.queryProjectBusinessStatusCountZzyj(commonOrgIds, null, businessStatusList);
        } else if (departmentIds.size() != 0) {
            projectDesktopVO = this.projectSetService.queryProjectBusinessStatusCountZzyj(null, departmentIds, businessStatusList);
        }
        if (projectDesktopVO == null) {
            projectDesktopVO = new ProjectDesktopVO(BigDecimal.ZERO, BigDecimal.ZERO);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)projectDesktopVO);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }
}

