/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.service.impl;

import com.ejianc.foundation.share.bean.EquipmentCategoryEntity;
import com.ejianc.foundation.share.bean.MaterialCategoryEntity;
import com.ejianc.foundation.share.mapper.EquipmentCategoryMapper;
import com.ejianc.foundation.share.mapper.MaterialCategoryMapper;
import com.ejianc.foundation.share.service.IEquipmentCategoryService;
import com.ejianc.foundation.share.service.IEquipmentService;
import com.ejianc.foundation.share.service.IMaterialService;
import com.ejianc.foundation.share.vo.EquipmentCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EquipmentCategoryServiceImpl
implements IEquipmentCategoryService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private EquipmentCategoryMapper equipmentCategoryMapper;
    @Autowired
    private MaterialCategoryMapper materialCategoryMapper;
    @Autowired
    private IMaterialService materialService;
    @Autowired
    private IEquipmentService equipmentService;

    @Override
    public List<EquipmentCategoryEntity> queryList(QueryParam queryParam) {
        Map paramMap = queryParam.getParams();
        HashMap<String, Object> condition = new HashMap<String, Object>();
        for (Map.Entry entry : paramMap.entrySet()) {
            condition.put((String)entry.getKey(), ((Parameter)entry.getValue()).getValue());
        }
        condition.put("tenantId", InvocationInfoProxy.getTenantid());
        List<EquipmentCategoryEntity> resultList = this.equipmentCategoryMapper.queryList(condition);
        return resultList;
    }

    @Override
    public EquipmentCategoryVO queryDetail(Long id) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        EquipmentCategoryEntity entity = this.equipmentCategoryMapper.queryDetail(tenantId, id);
        if (entity != null) {
            return (EquipmentCategoryVO)BeanMapper.map((Object)entity, EquipmentCategoryVO.class);
        }
        return null;
    }

    @Override
    @Transactional
    public void changeCategoryEnableState(Long id, Integer enabled) {
        EquipmentCategoryEntity entity = this.equipmentCategoryMapper.queryDetail(InvocationInfoProxy.getTenantid(), id);
        if (entity == null) {
            throw new BusinessException("\u8be5\u5206\u7c7b\u4e0d\u5b58\u5728\uff01");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("innerCode", entity.getInnerCode());
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        List<EquipmentCategoryEntity> categoryEntities = this.equipmentCategoryMapper.queryListByInnerCode(params);
        List<Long> categoryIds = categoryEntities.stream().map(EquipmentCategoryEntity::getId).collect(Collectors.toList());
        this.equipmentCategoryMapper.updateEnabled(enabled, InvocationInfoProxy.getTenantid(), entity.getInnerCode());
        this.equipmentService.updateStateByCategoryId(categoryIds, enabled, InvocationInfoProxy.getTenantid());
    }

    @Override
    public void update(EquipmentCategoryEntity entity) {
        this.equipmentCategoryMapper.update(entity);
        Long tenantId = InvocationInfoProxy.getTenantid();
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(entity.getId());
        List<MaterialCategoryEntity> materialCategoryEntities = this.materialCategoryMapper.queryByInnerCodes(tenantId, ids);
        ids.clear();
        materialCategoryEntities.forEach(item -> {
            ids.add(item.getId());
            this.materialService.updateByCategoryId(item.getId(), entity.getSubjectId(), entity.getSubjectName());
        });
        this.materialCategoryMapper.updateSubject(tenantId, entity.getSubjectId(), entity.getSubjectName(), ids);
    }

    @Override
    public void save(EquipmentCategoryEntity entity) {
        this.equipmentCategoryMapper.insert(entity);
    }

    @Override
    public void insertBatch(List<EquipmentCategoryEntity> categoryEntityList) {
        if (ListUtil.isNotEmpty(categoryEntityList)) {
            ArrayList<EquipmentCategoryEntity> toInsert = new ArrayList<EquipmentCategoryEntity>();
            for (EquipmentCategoryEntity entity : categoryEntityList) {
                if (toInsert.size() > 0 && toInsert.size() % 1000 == 0) {
                    this.equipmentCategoryMapper.insertBatch(InvocationInfoProxy.getTenantid(), toInsert);
                    toInsert = new ArrayList();
                }
                toInsert.add(entity);
            }
            if (toInsert.size() > 0) {
                this.equipmentCategoryMapper.insertBatch(InvocationInfoProxy.getTenantid(), toInsert);
            }
        }
    }

    @Override
    public List<EquipmentCategoryVO> queryListByPid(Long id) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<EquipmentCategoryEntity> EquipmentCategoryList = this.equipmentCategoryMapper.queryListByPid(tenantId, id);
        if (EquipmentCategoryList != null && EquipmentCategoryList.size() > 0) {
            return BeanMapper.mapList(EquipmentCategoryList, EquipmentCategoryVO.class);
        }
        return null;
    }

    @Override
    public void delete(Long id) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        this.equipmentCategoryMapper.delete(tenantId, id);
    }

    @Override
    public void updateEnabled(Integer enabled, Long tenantId, String innerCode) {
        this.equipmentCategoryMapper.updateEnabled(enabled, tenantId, innerCode);
    }

    @Override
    public List<EquipmentCategoryEntity> queryByCode(String code) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<EquipmentCategoryEntity> EquipmentCategoryVo = this.equipmentCategoryMapper.queryByCode(tenantId, code);
        return EquipmentCategoryVo;
    }

    @Override
    public List<EquipmentCategoryEntity> queryByName(String name) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        return this.equipmentCategoryMapper.queryByName(tenantId, name);
    }

    @Override
    public void insertCategoryListFromPlatform() {
        Long tenantId = InvocationInfoProxy.getTenantid();
        this.equipmentCategoryMapper.insertCategoryListFromPlatform(tenantId);
    }

    @Override
    public List<EquipmentCategoryVO> queryListTree(Map<String, Object> params) {
        List<EquipmentCategoryEntity> dataList = this.equipmentCategoryMapper.queryListTree(params);
        if (dataList != null && dataList.size() > 0) {
            return BeanMapper.mapList(dataList, EquipmentCategoryVO.class);
        }
        return null;
    }

    @Override
    public List<EquipmentCategoryVO> queryCategoryListByIds(List<Long> ids) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<EquipmentCategoryEntity> EquipmentCategoryList = this.equipmentCategoryMapper.queryCategoryListByIds(tenantId, ids);
        if (EquipmentCategoryList != null && EquipmentCategoryList.size() > 0) {
            return BeanMapper.mapList(EquipmentCategoryList, EquipmentCategoryVO.class);
        }
        return null;
    }

    @Override
    public void delete(List<Long> ids) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        for (Long id : ids) {
            this.equipmentCategoryMapper.delete(tenantId, id);
        }
    }
}

