/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.foundation.share.bean.ProjectArchiveEntity;
import com.ejianc.foundation.share.mapper.ProjectArchiveMapper;
import com.ejianc.foundation.share.service.IProjectArchiveService;
import com.ejianc.foundation.share.vo.ProjectArchiveVO;
import com.ejianc.foundation.usercenter.api.IJuliApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="projectArchiveService")
public class ProjectArchiveServiceImpl
extends BaseServiceImpl<ProjectArchiveMapper, ProjectArchiveEntity>
implements IProjectArchiveService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${juli.bip.pkOrg:101}")
    private String juliBipPkOrg;
    @Value(value="${juli.bip.pkGroup:0001}")
    private String juliBipPkGroup;
    @Value(value="${juli.bip.busiCenter:JL03}")
    private String busiCenter;
    private static final String SYNC_PROJECT_URL = "nccloud/api/uapbd/projectmanage/project/add";
    @Autowired
    private IJuliApi juliApi;

    @Override
    public boolean checkSameBillCode(ProjectArchiveVO saveOrUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(ProjectArchiveEntity::getCode, (Object)saveOrUpdateVO.getCode());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        if (null != saveOrUpdateVO.getId() && saveOrUpdateVO.getId() > 0L) {
            lambda.ne(BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        }
        return super.list((Wrapper)lambda).size() > 0;
    }

    @Override
    public String pushToBip(ProjectArchiveEntity entity) {
        JSONObject postData = new JSONObject();
        JSONObject ufinterface = new JSONObject();
        ufinterface.put("account", (Object)this.busiCenter);
        ufinterface.put("billtype", (Object)"project");
        ufinterface.put("groupcode", (Object)this.juliBipPkGroup);
        ufinterface.put("isexchange", (Object)"Y");
        ufinterface.put("replace", (Object)"Y");
        ufinterface.put("sender", (Object)"pm");
        ufinterface.put("id", (Object)entity.getId());
        JSONObject bill = new JSONObject();
        JSONObject billhead = new JSONObject();
        billhead.put("memo", (Object)("\u76ca\u4f01\u8054\u63a8\u9001\u9879\u76ee\u6570\u636e--" + DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date())));
        billhead.put("pk_group", (Object)this.juliBipPkGroup);
        billhead.put("pk_org", (Object)this.juliBipPkOrg);
        billhead.put("project_code", (Object)entity.getCode());
        billhead.put("project_name", (Object)entity.getName());
        billhead.put("pk_eps", (Object)"003001");
        billhead.put("pk_projectclass", (Object)"003001");
        billhead.put("enablestate", (Object)"2");
        billhead.put("pk_project", (Object)entity.getId());
        if (entity.getProjectDate() != null) {
            billhead.put("initiation_date", (Object)DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)entity.getProjectDate()));
        }
        bill.put("billhead", (Object)billhead);
        ufinterface.put("bill", (Object)bill);
        postData.put("ufinterface", (Object)ufinterface);
        JSONObject param = new JSONObject();
        param.put("url", (Object)SYNC_PROJECT_URL);
        param.put("postData", (Object)postData.toJSONString());
        CommonResponse res = this.juliApi.getDataFromBip(param);
        this.logger.info("\u540c\u6b65\u751f\u6210\u9879\u76ee\u4fe1\u606f\uff1a\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u54cd\u5e94\uff1a{}", new Object[]{SYNC_PROJECT_URL, postData.toJSONString(), JSONObject.toJSONString((Object)res.getData())});
        if (res.isSuccess()) {
            JSONObject projectResp = JSONObject.parseObject((String)((String)res.getData()));
            if (projectResp.getBoolean("success").booleanValue()) {
                JSONObject projectObject = projectResp.getJSONObject("data");
                this.logger.info("\u9879\u76ee\u7acb\u9879\u63a8\u9001\u54cd\u5e94\u6570\u636e\uff1a{}", (Object)projectObject.toJSONString());
                if (Objects.equals("Y", projectObject.getJSONObject("ufinterface").getString("successful"))) {
                    entity.setSourceBillCode(projectObject.getJSONObject("ufinterface").getJSONArray("sendresult").getJSONObject(0).getString("content"));
                    return projectObject.getJSONObject("ufinterface").getJSONArray("sendresult").getJSONObject(0).getString("content");
                }
                this.logger.error("\u9879\u76ee\u7acb\u9879\u63a8\u9001\u54cd\u5e94\u6570\u636e\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)projectObject.getJSONObject("ufinterface").getJSONArray("sendresult").getJSONObject(0).getString("resultdescription"));
            } else {
                this.logger.error("\u9879\u76ee\u7acb\u9879\u63a8\u9001\u63a5\u53e3\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)projectResp.getString("message"));
            }
        } else {
            this.logger.error("\u9879\u76ee\u7acb\u9879\u63a8\u9001\u5185\u90e8\u8c03\u7528\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)res.getMsg());
        }
        return null;
    }
}

