/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.utils.EJCDateUtil;
import com.ejianc.foundation.orgcenter.api.IOrgNoAuthApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.bean.ProjectSetPoolEntity;
import com.ejianc.foundation.share.consts.ProjectBusinessStatusEnum;
import com.ejianc.foundation.share.mapper.ProjectSetMapper;
import com.ejianc.foundation.share.service.IProjectSetService;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.share.vo.ProjectDesktopSubParentVO;
import com.ejianc.foundation.share.vo.ProjectDesktopSubVO;
import com.ejianc.foundation.share.vo.ProjectDesktopVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.usercenter.api.IJuliApi;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ProjectSetServiceImpl
extends BaseServiceImpl<ProjectSetMapper, ProjectSetPoolEntity>
implements IProjectSetService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ProjectSetMapper projectSetMapper;
    @Value(value="${juli.bip.pkOrg:101}")
    private String juliBipPkOrg;
    @Value(value="${juli.bip.pkGroup:0001}")
    private String juliBipPkGroup;
    @Value(value="${juli.bip.busiCenter:JL03}")
    private String busiCenter;
    private static final String SYNC_PROJECT_URL = "nccloud/api/uapbd/projectmanage/project/add";
    @Autowired
    private IJuliApi juliApi;
    @Autowired
    private IOrgNoAuthApi iOrgNoAuthApi;
    @Autowired
    private IDefdocApi iDefdocApi;

    @Override
    public OrgVO generateProjectDepartment(ProjectSetPoolEntity projectSetVO, boolean jt) {
        if (projectSetVO.getOrgId() == null) {
            this.logger.error("\u4fdd\u5b58\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u5b58\u5728\u3002");
            return null;
        }
        OrgVO parentOrg = new OrgVO();
        parentOrg.setId(projectSetVO.getOrgId());
        CommonResponse response = this.iOrgNoAuthApi.findOneByOrgVO(parentOrg);
        if (!response.isSuccess()) {
            this.logger.error("\u4fdd\u5b58\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u67e5\u8be2\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25: " + response.getMsg());
            return null;
        }
        parentOrg = (OrgVO)response.getData();
        if (null == parentOrg) {
            this.logger.error("\u4fdd\u5b58\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u5b58\u5728\u3002");
            return null;
        }
        OrgVO projectDepartment = new OrgVO();
        projectDepartment.setCode(projectSetVO.getCode());
        response = this.iOrgNoAuthApi.findOneByOrgVO(projectDepartment);
        if (response.isSuccess() && response.getData() != null) {
            projectDepartment = (OrgVO)response.getData();
            projectDepartment.setParentId(projectSetVO.getOrgId());
            projectDepartment.setEnterpriseId(parentOrg.getEnterpriseId());
            projectDepartment.setName(projectSetVO.getName());
            projectDepartment.setShortName(projectSetVO.getShortName());
            projectDepartment.setProjectState(Integer.valueOf(1));
        } else if (jt) {
            projectDepartment.setCode(projectSetVO.getCode() + "-EL");
            response = this.iOrgNoAuthApi.findOneByOrgVO(projectDepartment);
            if (response.isSuccess() && response.getData() != null) {
                projectDepartment = (OrgVO)response.getData();
                projectDepartment.setParentId(projectSetVO.getOrgId());
                projectDepartment.setEnterpriseId(parentOrg.getEnterpriseId());
                projectDepartment.setName(projectSetVO.getName());
                projectDepartment.setShortName(projectSetVO.getShortName());
                projectDepartment.setProjectState(Integer.valueOf(1));
            } else {
                projectDepartment.setId(Long.valueOf(IdWorker.getId()));
                projectDepartment.setParentId(projectSetVO.getOrgId());
                projectDepartment.setTenantId(parentOrg.getTenantId());
                projectDepartment.setEnterpriseId(parentOrg.getEnterpriseId());
                projectDepartment.setIsParent(Boolean.valueOf(false));
                projectDepartment.setName(projectSetVO.getName());
                projectDepartment.setShortName(projectSetVO.getShortName());
                projectDepartment.setState(Integer.valueOf(1));
                projectDepartment.setOrgType(OrgVO.ORG_TYPE_DEPARTMENT);
                projectDepartment.setProjectState(Integer.valueOf(1));
            }
        } else {
            projectDepartment.setId(Long.valueOf(IdWorker.getId()));
            projectDepartment.setParentId(projectSetVO.getOrgId());
            projectDepartment.setTenantId(parentOrg.getTenantId());
            projectDepartment.setEnterpriseId(parentOrg.getEnterpriseId());
            projectDepartment.setIsParent(Boolean.valueOf(false));
            projectDepartment.setName(projectSetVO.getName());
            projectDepartment.setShortName(projectSetVO.getShortName());
            projectDepartment.setState(Integer.valueOf(1));
            projectDepartment.setOrgType(OrgVO.ORG_TYPE_DEPARTMENT);
            projectDepartment.setProjectState(Integer.valueOf(1));
        }
        return projectDepartment;
    }

    @Override
    public ProjectDesktopVO queryProjectBusinessStatusCount(List<Long> commonOrgIds, List<Long> departmentIds, List<String> businessStatusList) {
        ProjectDesktopVO projectDesktopVO = null;
        List<ProjectDesktopSubVO> projectDesktopSubVOS = ((ProjectSetMapper)this.baseMapper).countBusinessStatus(commonOrgIds, departmentIds, businessStatusList);
        if (CollectionUtils.isNotEmpty(projectDesktopSubVOS)) {
            BigDecimal totalNum;
            projectDesktopVO = ((ProjectSetMapper)this.baseMapper).countProjectStatus(commonOrgIds, departmentIds, null);
            BigDecimal otherNum = totalNum = projectDesktopVO.getTotalNum();
            HashMap<String, ProjectDesktopSubVO> map = new HashMap<String, ProjectDesktopSubVO>();
            for (ProjectDesktopSubVO t : projectDesktopSubVOS) {
                map.put(t.getBusinessStatus(), t);
                otherNum = ComputeUtil.safeSub((BigDecimal)otherNum, (BigDecimal)t.getNum());
                t.setBusinessStatusName(ProjectBusinessStatusEnum.getNameByCode((String)t.getBusinessStatus()));
            }
            for (String businessStatus : businessStatusList) {
                ProjectDesktopSubVO projectDesktopSubVO = (ProjectDesktopSubVO)map.get(businessStatus);
                if (projectDesktopSubVO != null) continue;
                ProjectDesktopSubVO subVO = new ProjectDesktopSubVO();
                subVO.setBusinessStatus(businessStatus);
                subVO.setBusinessStatusName(ProjectBusinessStatusEnum.getNameByCode((String)businessStatus));
                subVO.setNum(BigDecimal.ZERO);
                map.put(businessStatus, subVO);
            }
            ProjectDesktopSubVO other = new ProjectDesktopSubVO();
            other.setBusinessStatus("99");
            other.setBusinessStatusName("\u5176\u4ed6");
            other.setNum(ComputeUtil.nullToZero((BigDecimal)otherNum));
            map.put(other.getBusinessStatus(), other);
            projectDesktopVO.setDetail(new ArrayList(map.values()));
        }
        return projectDesktopVO;
    }

    @Override
    public ProjectDesktopVO queryProjectBusinessStatusCountParent(List<Long> commonOrgIds, List<Long> departmentIds, List<String> businessStatusList) {
        ProjectDesktopVO projectDesktopVO = null;
        List projectDesktopSubVOSParent = new ArrayList();
        ArrayList<ProjectDesktopSubVO> desktopSubVOS = new ArrayList<ProjectDesktopSubVO>();
        String thisYear = EJCDateUtil.getYear() + "";
        List<ProjectDesktopSubParentVO> projectDesktopSubVOS = ((ProjectSetMapper)this.baseMapper).countBusinessStatusParent(commonOrgIds, departmentIds);
        if (CollectionUtils.isNotEmpty(projectDesktopSubVOS)) {
            BigDecimal totalNum;
            projectDesktopSubVOSParent = TreeNodeBUtil.buildTree(projectDesktopSubVOS);
            projectDesktopVO = new ProjectDesktopVO();
            BigDecimal otherNum = totalNum = new BigDecimal(projectDesktopSubVOSParent.size());
            projectDesktopVO.setTotalNum(totalNum);
            Long buildNum = projectDesktopSubVOSParent.stream().filter(e -> null != e.getProjectStatus() && "1".equals(e.getProjectStatus())).count();
            projectDesktopVO.setBuildNum(new BigDecimal(buildNum));
            Long thisYearProjectNum = projectDesktopSubVOSParent.stream().filter(e -> null != e.getProjectDate() && thisYear.equals(e.getProjectDate().substring(0, 4))).count();
            projectDesktopVO.setThisYearProjectNum(new BigDecimal(thisYearProjectNum));
            for (String businessStatus : businessStatusList) {
                ProjectDesktopSubVO projectDesktopSubVO = new ProjectDesktopSubVO();
                projectDesktopSubVO.setBusinessStatus(businessStatus);
                projectDesktopSubVO.setBusinessStatusName(ProjectBusinessStatusEnum.getNameByCode((String)businessStatus));
                Long num = projectDesktopSubVOSParent.stream().filter(e -> null != e.getBusinessStatus() && businessStatus.equals(e.getBusinessStatus())).count();
                if (null != num) {
                    projectDesktopSubVO.setNum(new BigDecimal(num));
                    otherNum = ComputeUtil.safeSub((BigDecimal)otherNum, (BigDecimal)new BigDecimal(num));
                }
                desktopSubVOS.add(projectDesktopSubVO);
            }
            ProjectDesktopSubVO other = new ProjectDesktopSubVO();
            other.setBusinessStatus("99");
            other.setBusinessStatusName("\u5176\u4ed6");
            other.setNum(ComputeUtil.nullToZero((BigDecimal)otherNum));
            desktopSubVOS.add(other);
            projectDesktopVO.setDetail(desktopSubVOS);
        }
        return projectDesktopVO;
    }

    @Override
    public ProjectDesktopVO queryProjectBusinessStatusCountZzyj(List<Long> commonOrgIds, List<Long> departmentIds, List<String> businessStatusList) {
        List<ProjectDesktopSubVO> projectDesktopSubList;
        ProjectDesktopVO projectDesktopVO = null;
        List projectDesktopSubVOSParent = new ArrayList();
        String thisYear = EJCDateUtil.getYear() + "";
        List<ProjectDesktopSubParentVO> projectDesktopSubVOS = ((ProjectSetMapper)this.baseMapper).countBusinessStatusParent(commonOrgIds, departmentIds);
        if (CollectionUtils.isNotEmpty(projectDesktopSubVOS)) {
            projectDesktopSubVOSParent = TreeNodeBUtil.buildTree(projectDesktopSubVOS);
            projectDesktopVO = new ProjectDesktopVO();
            BigDecimal totalNum = new BigDecimal(projectDesktopSubVOSParent.size());
            projectDesktopVO.setTotalNum(totalNum);
            Long buildNum = projectDesktopSubVOSParent.stream().filter(e -> null != e.getProjectStatus() && "1".equals(e.getProjectStatus())).count();
            projectDesktopVO.setBuildNum(new BigDecimal(buildNum));
            Long thisYearProjectNum = projectDesktopSubVOSParent.stream().filter(e -> null != e.getProjectDate() && thisYear.equals(e.getProjectDate().substring(0, 4))).count();
            projectDesktopVO.setThisYearProjectNum(new BigDecimal(thisYearProjectNum));
        }
        if (CollectionUtils.isNotEmpty(projectDesktopSubList = ((ProjectSetMapper)this.baseMapper).countBusinessStatus(commonOrgIds, departmentIds, businessStatusList))) {
            HashMap<String, ProjectDesktopSubVO> map = new HashMap<String, ProjectDesktopSubVO>();
            for (ProjectDesktopSubVO t : projectDesktopSubList) {
                map.put(t.getBusinessStatus(), t);
                t.setBusinessStatusName(ProjectBusinessStatusEnum.getNameByCode((String)t.getBusinessStatus()));
            }
            for (String businessStatus : businessStatusList) {
                ProjectDesktopSubVO projectDesktopSubVO = (ProjectDesktopSubVO)map.get(businessStatus);
                if (projectDesktopSubVO != null) continue;
                ProjectDesktopSubVO subVO = new ProjectDesktopSubVO();
                subVO.setBusinessStatus(businessStatus);
                subVO.setBusinessStatusName(ProjectBusinessStatusEnum.getNameByCode((String)businessStatus));
                subVO.setNum(BigDecimal.ZERO);
                map.put(businessStatus, subVO);
            }
            projectDesktopVO.setDetail(new ArrayList(map.values()));
        }
        return projectDesktopVO;
    }

    @Override
    public void deleteProjectById(List<Long> ids) {
        ((ProjectSetMapper)this.baseMapper).deleteProjectById(ids);
    }

    @Override
    public IPage<ProjectSetPoolEntity> queryMdmPage(QueryParam param) {
        HashMap<String, Object> condition = new HashMap<String, Object>();
        Parameter parameter = (Parameter)param.getParams().get("syncTime");
        if (parameter != null) {
            condition.put("syncTime", parameter.getValue());
        }
        condition.put("pageIndex", (param.getPageIndex() - 1) * param.getPageSize());
        condition.put("pageSize", param.getPageSize());
        List<ProjectSetPoolEntity> poolEntities = this.projectSetMapper.queryMdmPage(condition);
        Page page = new Page();
        page.setRecords(poolEntities);
        return page;
    }

    @Override
    public BigDecimal queryThisYearProjectNum(List<Long> commonOrgIds, List<Long> departmentIds, String thisYear) {
        return this.projectSetMapper.queryThisYearProjectNum(commonOrgIds, departmentIds, thisYear);
    }

    @Override
    public void pushToBip(ProjectSetPoolEntity entity) {
        JSONObject postData = new JSONObject();
        JSONObject ufinterface = new JSONObject();
        ufinterface.put("account", (Object)this.busiCenter);
        ufinterface.put("billtype", (Object)"project");
        ufinterface.put("groupcode", (Object)this.juliBipPkGroup);
        ufinterface.put("isexchange", (Object)"Y");
        ufinterface.put("replace", (Object)"Y");
        ufinterface.put("sender", (Object)"pm");
        ufinterface.put("id", (Object)entity.getId());
        JSONObject bill = new JSONObject();
        JSONObject billhead = new JSONObject();
        billhead.put("memo", (Object)(entity.getMemo() + "(\u76ca\u4f01\u8054\u63a8\u9001\u9879\u76ee\u6570\u636e--" + DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date()) + ")"));
        billhead.put("pk_group", (Object)this.juliBipPkGroup);
        billhead.put("pk_org", (Object)this.juliBipPkOrg);
        billhead.put("project_code", (Object)entity.getCode());
        billhead.put("project_name", (Object)entity.getName());
        billhead.put("pk_eps", (Object)"003001");
        billhead.put("pk_projectclass", (Object)"003001");
        billhead.put("enablestate", (Object)"2");
        billhead.put("pk_project", (Object)entity.getId());
        if (entity.getProjectDate() != null) {
            billhead.put("initiation_date", (Object)DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)entity.getProjectDate()));
        }
        if (entity.getPlanStartDate() != null) {
            billhead.put("plan_start_date", (Object)DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)entity.getPlanStartDate()));
        }
        if (entity.getPlanEndDate() != null) {
            billhead.put("plan_finish_date", (Object)DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)entity.getPlanEndDate()));
        }
        if (entity.getActualStartDate() != null) {
            billhead.put("actu_start_date", (Object)DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)entity.getActualStartDate()));
        }
        if (entity.getActualEndDate() != null) {
            billhead.put("actu_finish_date", (Object)DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)entity.getActualEndDate()));
        }
        if (entity.getPlanDateNum() != null) {
            billhead.put("planduration", (Object)entity.getPlanDateNum());
        }
        bill.put("billhead", (Object)billhead);
        ufinterface.put("bill", (Object)bill);
        postData.put("ufinterface", (Object)ufinterface);
        JSONObject param = new JSONObject();
        param.put("url", (Object)SYNC_PROJECT_URL);
        param.put("postData", (Object)postData.toJSONString());
        CommonResponse res = this.juliApi.getDataFromBip(param);
        this.logger.info("\u540c\u6b65\u751f\u6210\u9879\u76ee\u4fe1\u606f\uff1a\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u54cd\u5e94\uff1a{}", new Object[]{SYNC_PROJECT_URL, postData.toJSONString(), JSONObject.toJSONString((Object)res.getData())});
        if (res.isSuccess()) {
            JSONObject projectResp = JSONObject.parseObject((String)((String)res.getData()));
            if (projectResp.getBoolean("success").booleanValue()) {
                JSONObject projectObject = projectResp.getJSONObject("data");
                this.logger.info("\u9879\u76ee\u7acb\u9879\u63a8\u9001\u54cd\u5e94\u6570\u636e\uff1a{}", (Object)projectObject.toJSONString());
                if (Objects.equals("1", projectObject.getJSONObject("ufinterface").getJSONArray("sendresult").getJSONObject(0).getString("resultcode"))) {
                    entity.setSourceId(projectObject.getJSONObject("ufinterface").getJSONArray("sendresult").getJSONObject(0).getString("content"));
                } else {
                    this.logger.error("\u9879\u76ee\u7acb\u9879\u63a8\u9001\u54cd\u5e94\u6570\u636e\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)projectObject.getJSONObject("ufinterface").getJSONArray("sendresult").getJSONObject(0).getString("resultdescription"));
                }
            } else {
                this.logger.error("\u9879\u76ee\u7acb\u9879\u63a8\u9001\u63a5\u53e3\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)projectResp.getString("message"));
            }
        } else {
            this.logger.error("\u9879\u76ee\u7acb\u9879\u63a8\u9001\u5185\u90e8\u8c03\u7528\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)res.getMsg());
        }
    }
}

