/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.service.impl;

import com.ejianc.foundation.share.bean.StandardProcessCategoryEntity;
import com.ejianc.foundation.share.mapper.StandardProcessCategoryMapper;
import com.ejianc.foundation.share.service.IStandardProcessCategoryService;
import com.ejianc.foundation.share.service.IStandardProcessService;
import com.ejianc.foundation.share.vo.StandardProcessCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="standardProcessCategoryService")
public class StandardProcessCategoryServiceImpl
extends BaseServiceImpl<StandardProcessCategoryMapper, StandardProcessCategoryEntity>
implements IStandardProcessCategoryService {
    @Autowired
    private StandardProcessCategoryMapper standardProcessCategoryMapper;
    @Autowired
    private IStandardProcessService standardProcessService;

    @Override
    public List<StandardProcessCategoryVO> queryListByPid(Long id) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("parent_id", new Parameter("eq", (Object)id));
        List entityList = super.queryList(queryParam);
        if (entityList != null) {
            return BeanMapper.mapList((Iterable)entityList, StandardProcessCategoryVO.class);
        }
        return null;
    }

    @Override
    public List<StandardProcessCategoryEntity> queryByCode(String code, Long id) {
        List entityList;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("code", new Parameter("eq", (Object)code));
        if (null != id) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)id));
        }
        if ((entityList = super.queryList(queryParam)) != null) {
            return entityList;
        }
        return null;
    }

    @Override
    public void updateEnabled(Integer enabled, String innerCode) {
        this.standardProcessCategoryMapper.updateEnabled(enabled, innerCode);
    }

    @Override
    public void changeCategoryEnableState(Long id, Integer enabled) {
        StandardProcessCategoryEntity entity = (StandardProcessCategoryEntity)((Object)super.selectById((Serializable)id));
        if (entity == null) {
            throw new BusinessException("\u8be5\u5206\u7c7b\u4e0d\u5b58\u5728\uff01");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("innerCode", new Parameter("like", (Object)entity.getInnerCode()));
        List categoryEntities = super.queryList(queryParam);
        List<Long> categoryIds = categoryEntities.stream().map(BaseEntity::getId).collect(Collectors.toList());
        this.standardProcessCategoryMapper.updateEnabled(enabled, entity.getInnerCode());
        this.standardProcessService.updateStateByCategoryId(categoryIds, enabled);
    }

    @Override
    public List<StandardProcessCategoryEntity> queryListEntityTree(Map<String, Object> params) {
        return this.standardProcessCategoryMapper.queryListEntityTree(params);
    }

    @Override
    public List<StandardProcessCategoryEntity> queryProcessCategoryList(QueryParam queryParam) {
        Map paramMap = queryParam.getParams();
        HashMap<String, Object> condition = new HashMap<String, Object>();
        for (Map.Entry entry : paramMap.entrySet()) {
            condition.put((String)entry.getKey(), ((Parameter)entry.getValue()).getValue());
        }
        condition.put("tenantId", InvocationInfoProxy.getTenantid());
        List<StandardProcessCategoryEntity> resultList = this.standardProcessCategoryMapper.queryProcessCategoryList(condition);
        return resultList;
    }
}

