package com.ejianc.foundation.util;

import com.ejianc.foundation.share.bean.MaterialCategoryEntity;
import com.ejianc.foundation.share.bean.StandardProcessCategoryEntity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StandardProcessCategoryAsTree {
	
	public static List<StandardProcessCategoryEntity> createTreeData(List<StandardProcessCategoryEntity> list) {
		List<StandardProcessCategoryEntity> resp = new ArrayList<>();
		List<String> rootItems = new ArrayList<String>();
		Map<String, StandardProcessCategoryEntity> listMap = new HashMap<>();
		for(StandardProcessCategoryEntity StandardProcessCategoryEntity:list) {
			listMap.put(StandardProcessCategoryEntity.getId().toString(), StandardProcessCategoryEntity);
		}
        
        for(int i =0; i<list.size(); i++) {
        	StandardProcessCategoryEntity StandardProcessCategoryEntity = list.get(i);
        	String parentId = (StandardProcessCategoryEntity.getParentId() != null && StandardProcessCategoryEntity.getParentId() > 0) ? StandardProcessCategoryEntity.getParentId().toString():"";
        	StandardProcessCategoryEntity parent = listMap.get(parentId);
        	if(parent != null) {
        		List<StandardProcessCategoryEntity> child = parent.getChildren();
        		if(child != null) {
        			child.add(StandardProcessCategoryEntity);
        		}else{
        			List<StandardProcessCategoryEntity> children = new ArrayList<StandardProcessCategoryEntity>();
        			children.add(StandardProcessCategoryEntity);
        			parent.setChildren(children);
        		}
        	} else {
        		rootItems.add(StandardProcessCategoryEntity.getId().toString());
        	}
        }
        
        for(String rootId : rootItems) {
        	resp.add(listMap.get(rootId));
        }
        
		return resp;
	}

}
