/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.share.bean.ProjectArchiveEntity;
import com.ejianc.foundation.share.bean.ProjectWbsEntity;
import com.ejianc.foundation.share.bean.StandardProcessEntity;
import com.ejianc.foundation.share.mapper.ProjectWbsMapper;
import com.ejianc.foundation.share.service.IProjectWbsService;
import com.ejianc.foundation.share.service.IStandardProcessService;
import com.ejianc.foundation.share.vo.ProjectArchiveVO;
import com.ejianc.foundation.share.vo.ProjectWbsVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.foundation.util.ExcelImportUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="projectWbsService")
public class ProjectWbsServiceImpl
extends BaseServiceImpl<ProjectWbsMapper, ProjectWbsEntity>
implements IProjectWbsService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProjectWbsService service;
    @Autowired
    private ProjectWbsMapper projectWbsMapper;
    @Autowired
    private IStandardProcessService processService;
    @Autowired
    private IUserApi userApi;

    @Override
    public CommonResponse<ProjectWbsVO> saveOrUpdate(ProjectWbsVO projectWbsVO) {
        ProjectWbsEntity entity = new ProjectWbsEntity();
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("code", new Parameter("eq", (Object)projectWbsVO.getCode()));
        param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        param.getParams().put("projectId", new Parameter("eq", (Object)projectWbsVO.getProjectId()));
        List projectWbsEntities = this.service.queryList(param);
        if (null != projectWbsVO.getId()) {
            entity = (ProjectWbsEntity)((Object)this.service.getById(projectWbsVO.getId()));
            if (!entity.getCode().equals(projectWbsVO.getCode()) && CollectionUtils.isNotEmpty((Collection)projectWbsEntities)) {
                return CommonResponse.error((String)"\u5355\u636e\u7f16\u7801\u4e0d\u80fd\u91cd\u590d\uff01");
            }
            param.getParams().remove("code");
            param.getParams().put("parentId", new Parameter("eq", (Object)entity.getId()));
            List<ProjectWbsEntity> projectWbsEntityList = this.getChildrenByPid(entity.getId());
            for (ProjectWbsEntity projectWbsEntity : projectWbsEntityList) {
                projectWbsEntity.setEnabled(projectWbsVO.getEnabled());
            }
            for (ProjectWbsEntity projectWbsEntity : projectWbsEntityList) {
                if (!projectWbsEntity.getId().equals(entity.getId())) continue;
                projectWbsEntityList.remove((Object)projectWbsEntity);
                break;
            }
            if (CollectionUtils.isNotEmpty(projectWbsEntityList)) {
                this.saveOrUpdateBatch(projectWbsEntityList);
            }
        } else {
            if (CollectionUtils.isNotEmpty((Collection)projectWbsEntities)) {
                return CommonResponse.error((String)"\u5355\u636e\u7f16\u7801\u4e0d\u80fd\u91cd\u590d\uff01");
            }
            entity.setId(IdWorker.getId());
        }
        entity.setParentId(projectWbsVO.getParentId());
        entity.setOrgId(InvocationInfoProxy.getOrgId());
        entity.setProjectId(projectWbsVO.getProjectId());
        entity.setName(projectWbsVO.getName());
        entity.setCode(projectWbsVO.getCode());
        entity.setHeadId(projectWbsVO.getHeadId());
        entity.setHeadName(projectWbsVO.getHeadName());
        entity.setMemo(projectWbsVO.getMemo());
        entity.setEnabled(projectWbsVO.getEnabled());
        entity.setEmployeeId(projectWbsVO.getEmployeeId());
        entity.setEmployeeName(projectWbsVO.getEmployeeName());
        entity.setWbsType(projectWbsVO.getWbsType());
        entity.setProcessId(projectWbsVO.getProcessId());
        entity.setMaterial(projectWbsVO.getMaterial());
        if (entity.getParentId() != null && entity.getParentId() > 0L) {
            ProjectWbsEntity uniqueBean = (ProjectWbsEntity)((Object)((ProjectWbsMapper)this.baseMapper).selectById(entity.getParentId()));
            entity.setInnerCode(uniqueBean.getInnerCode() + "," + entity.getId());
        } else {
            entity.setInnerCode(entity.getId().toString());
        }
        this.service.saveOrUpdate((Object)entity, false);
        ProjectWbsVO vo = (ProjectWbsVO)((Object)BeanMapper.map((Object)((Object)entity), ProjectWbsVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response, Long projectId) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        List processList = this.processService.list();
        Map<String, StandardProcessEntity> processMap = processList.stream().collect(Collectors.toMap(x -> x.getName(), x -> x, (v1, v2) -> v2));
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            HashMap indexMap = new HashMap();
            ArrayList<ProjectWbsVO> projectWbsVOList = new ArrayList<ProjectWbsVO>();
            HashMap<String, String> tidMap = new HashMap<String, String>();
            ArrayList<String> excelCodeList = new ArrayList<String>();
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
            ArrayList<String> codeList = new ArrayList<String>();
            List oldList = this.service.queryList(queryParam);
            for (ProjectWbsEntity projectWbsEntity : oldList) {
                codeList.add(projectWbsEntity.getCode());
            }
            ProjectWbsEntity root = oldList.stream().filter(x -> null == x.getParentId()).findFirst().orElse(new ProjectWbsEntity());
            for (int i = 1; i < result.size(); ++i) {
                String wbsType;
                List datas = (List)result.get(i);
                ProjectWbsVO vo = new ProjectWbsVO();
                boolean flag = false;
                boolean parentWarn = false;
                String warnType = "";
                String code = (String)datas.get(0);
                vo.setCode(code);
                String parentCode = (String)datas.get(1);
                String id = UUID.randomUUID().toString().replaceAll("-", "");
                vo.setTid(id);
                tidMap.put(code, id);
                vo.setTpid(parentCode);
                if (StringUtils.isEmpty((CharSequence)code)) {
                    vo.setCode(null);
                    warnType = warnType + "\u7f16\u7801\u4e3a\u7a7a,";
                    flag = true;
                    parentWarn = true;
                } else {
                    if (codeList.contains(code)) {
                        vo.setCode(code);
                        warnType = warnType + "\u7f16\u7801\u91cd\u590d,";
                        flag = true;
                        parentWarn = true;
                    }
                    if (excelCodeList.contains(code)) {
                        vo.setCode(code);
                        warnType = warnType + "\u6587\u4ef6\u7f16\u7801\u91cd\u590d,";
                        flag = true;
                        parentWarn = true;
                    } else {
                        excelCodeList.add(code);
                    }
                    vo.setCode(code);
                }
                String name = (String)datas.get(2);
                if (StringUtils.isEmpty((CharSequence)name)) {
                    vo.setName(null);
                    warnType = warnType + "\u540d\u79f0\u4e3a\u7a7a,";
                    flag = true;
                    parentWarn = true;
                } else {
                    vo.setName(name);
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(1)))) {
                    vo.setParentId(root.getId());
                }
                if (StringUtils.isEmpty((CharSequence)(wbsType = (String)datas.get(3)))) {
                    vo.setWbsType(null);
                    warnType = warnType + "\u7c7b\u578b\u4e3a\u7a7a,";
                    flag = true;
                    parentWarn = true;
                } else if ("\u91cc\u7a0b\u7891".equals(wbsType)) {
                    vo.setWbsType(1);
                } else if ("\u5b50\u4efb\u52a1".equals(wbsType)) {
                    vo.setWbsType(2);
                } else if ("\u4ea7\u54c1".equals(wbsType)) {
                    vo.setWbsType(3);
                } else if ("\u6784\u4ef6".equals(wbsType)) {
                    vo.setWbsType(4);
                } else if ("\u5de5\u5e8f".equals(wbsType)) {
                    vo.setWbsType(5);
                } else {
                    warnType = warnType + "\u7c7b\u578b\u4e0d\u5b58\u5728,";
                    flag = true;
                }
                if (null != vo.getWbsType() && 5 == vo.getWbsType()) {
                    if (processMap.containsKey(vo.getName())) {
                        vo.setProcessId(processMap.get(vo.getName()).getId());
                    } else {
                        warnType = warnType + "\u5de5\u5e8f\u4e0d\u5b58\u5728,";
                        flag = true;
                    }
                }
                vo.setMemo((String)datas.get(4));
                String nameMobile = (String)datas.get(5);
                if (StringUtils.isNotEmpty((CharSequence)nameMobile)) {
                    String[] strs = StringUtils.split((String)nameMobile, (String)",");
                    ArrayList<Long> userIds = new ArrayList<Long>();
                    ArrayList<String> userNames = new ArrayList<String>();
                    for (String str : strs) {
                        CommonResponse userResp;
                        String[] mobiles = StringUtils.split((String)str, (String)"+");
                        if (mobiles.length > 1) {
                            userResp = this.userApi.findByUserMobile(mobiles[1]);
                            if (!userResp.isSuccess() || null == userResp.getData()) {
                                warnType = warnType + "\u672a\u67e5\u8be2\u5230\u3010" + str + "\u3011\u5bf9\u5e94\u8d23\u4efb\u4eba,";
                                flag = true;
                                break;
                            }
                        } else {
                            warnType = warnType + "\u8d23\u4efb\u4eba\u5bfc\u5165\u683c\u5f0f\u6709\u8bef,";
                            flag = true;
                            break;
                        }
                        UserVO user = (UserVO)userResp.getData();
                        userIds.add(user.getId());
                        userNames.add(user.getUserName());
                    }
                    if (CollectionUtils.isNotEmpty(userIds)) {
                        vo.setHeadId(StringUtils.join(userIds, (String)","));
                        vo.setHeadName(StringUtils.join(userNames, (String)","));
                    }
                }
                vo.setMaterial((String)datas.get(6));
                vo.setEnabled(1);
                vo.setImportFlag(!flag);
                vo.setParentWarn(parentWarn);
                if (flag) {
                    warnType = warnType.substring(0, warnType.length() - 1);
                }
                vo.setWarnType(warnType);
                vo.setRowState("add");
                vo.setShadowId(vo.getTid());
                vo.setProjectId(projectId);
                projectWbsVOList.add(vo);
            }
            for (ProjectWbsVO tVo : projectWbsVOList) {
                if (!StringUtils.isNotEmpty((CharSequence)((CharSequence)tidMap.get(tVo.getTpid())))) continue;
                tVo.setTpid((String)tidMap.get(tVo.getTpid()));
            }
            List<Map<String, Object>> deailTreeData = ExcelImportUtil.treeData(BeanMapper.mapList(projectWbsVOList, Map.class));
            List<Map<String, Object>> mapList = ExcelImportUtil.importFlag(deailTreeData);
            ArrayList<Map<String, Object>> falseList = new ArrayList<Map<String, Object>>();
            List<List<Map<String, Object>>> allList = ExcelImportUtil.separate(mapList, falseList);
            List<Map<String, Object>> errorList = ExcelImportUtil.treeToList(allList.get(1), true);
            List<Map<String, Object>> successList = ExcelImportUtil.treeToList(allList.get(0), false);
            resp.put("successList", successList);
            resp.put("errorList", errorList);
            resp.put("successNum", (Object)successList.size());
            resp.put("errorNum", (Object)errorList.size());
            return CommonResponse.success((Object)resp);
        }
        return CommonResponse.error((String)"Excel\u4e3a\u7a7a");
    }

    @Override
    public String saveImportExcel(HttpServletRequest request, List<ProjectWbsVO> importVOS) {
        if (ListUtil.isEmpty(importVOS)) {
            throw new BusinessException("\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        List saveOrUpldates = BeanMapper.mapList(importVOS, ProjectWbsEntity.class);
        this.service.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
        if (saveOrUpldates.size() > 0) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (ProjectWbsEntity cdEntity : saveOrUpldates) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (ProjectWbsEntity cdEntity : saveOrUpldates) {
                if (StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) {
                    if (idMap.get(cdEntity.getTpid()) == null) {
                        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
                        lambda.eq(ProjectWbsEntity::getProjectId, (Object)cdEntity.getProjectId());
                        lambda.eq(ProjectWbsEntity::getCode, (Object)cdEntity.getTpid());
                        ProjectWbsEntity projectWbsEntity = (ProjectWbsEntity)((Object)this.service.getOne((Wrapper)lambda));
                        if (projectWbsEntity != null) {
                            cdEntity.setParentId(projectWbsEntity.getId());
                        }
                    } else {
                        cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
                    }
                }
                cdEntity.setOrgId(InvocationInfoProxy.getOrgId());
            }
            for (ProjectWbsEntity projectWbsEntity : saveOrUpldates) {
                if (projectWbsEntity.getParentId() != null && projectWbsEntity.getParentId() > 0L) {
                    ProjectWbsEntity uniqueBean = (ProjectWbsEntity)((Object)((ProjectWbsMapper)this.baseMapper).selectById(projectWbsEntity.getParentId()));
                    projectWbsEntity.setInnerCode(uniqueBean.getInnerCode() + "," + projectWbsEntity.getId());
                } else {
                    projectWbsEntity.setInnerCode(projectWbsEntity.getId().toString());
                }
                this.service.saveOrUpdate((Object)projectWbsEntity);
            }
            this.service.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
        }
        return "\u4fdd\u5b58\u6210\u529f\uff01";
    }

    @Override
    public CommonResponse<List<Map<String, Object>>> queryWBSWholeTreeItemsById(String idStr) {
        this.logger.info("ProjectWbsServiceImpl***queryWBSWholeTreeItemsById()\u65b9\u6cd5***begin***param\uff1aid={}", (Object)idStr);
        List<Long> idList = Arrays.stream(idStr.split(",")).map(Long::parseLong).distinct().collect(Collectors.toList());
        List<ProjectWbsEntity> wbsEntityList = this.projectWbsMapper.queryWBSWholeTreeItemsById(idList);
        ArrayList resultMapList = new ArrayList();
        HashMap<String, Object> map = null;
        for (ProjectWbsEntity entity : wbsEntityList) {
            String name = entity.getName();
            if (null != entity.getWbsType() && (3 == entity.getWbsType() || 4 == entity.getWbsType())) {
                name = name + "\uff08" + (3 == entity.getWbsType() ? "\u4ea7\u54c1" : "\u6784\u4ef6") + "\uff09";
            }
            map = new HashMap<String, Object>();
            map.put("id", entity.getId());
            map.put("key", entity.getId());
            map.put("name", name);
            map.put("code", entity.getCode());
            map.put("parentId", entity.getParentId());
            map.put("memo", entity.getMemo());
            map.put("innerCode", entity.getInnerCode());
            map.put("wbsType", entity.getWbsType());
            resultMapList.add(map);
        }
        this.logger.info("ProjectWbsServiceImpl***queryWBSWholeTreeItemsById()\u65b9\u6cd5***end***\u67e5\u8be2\u6570\u636e\u6210\u529f\uff0c\u67e5\u8be2\u7ed3\u679c-{}", (Object)JSONObject.toJSONString(wbsEntityList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)ResultAsTree.createTreeData(resultMapList));
    }

    @Override
    public Page<ProjectArchiveVO> reportList(QueryParam param, boolean b) {
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = ProjectWbsServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<ProjectArchiveVO> archiveVOList = this.projectWbsMapper.queryReportList((Page<ProjectArchiveVO>)page, wrapper);
        page.setRecords(archiveVOList);
        return page;
    }

    @Override
    public List<ProjectArchiveVO> getProjectIdsNoWbs() {
        List<ProjectArchiveEntity> entityList = this.projectWbsMapper.getProjectIdsNoWbs();
        return BeanMapper.mapList(entityList, ProjectArchiveVO.class);
    }

    @Override
    public List<ProjectArchiveVO> getProjectIdsWbs(Long projectId) {
        return this.projectWbsMapper.getProjectIdsWbs(projectId);
    }

    @Override
    public List<ProjectWbsEntity> getChildrenByPid(Long id) {
        ProjectWbsEntity parent = (ProjectWbsEntity)((Object)this.selectById(id));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("innerCode", new Parameter("like_right", (Object)parent.getInnerCode()));
        List list = super.queryList(queryParam, false);
        return BeanMapper.mapList((Iterable)list, ProjectWbsEntity.class);
    }
}

